/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

public class UtilSocketDataProvider
implements UtilDataProvider {
    private static String footprint = "$Revision:   3.6.1.0  $";
    private Socket sourceSocket;
    private InputStream socketInputStream = null;
    private int timeoutPeriodForReads;

    public UtilSocketDataProvider(Socket socket) {
        this.sourceSocket = socket;
        this.timeoutPeriodForReads = 0;
    }

    private InputStream getSocketInputStream() throws IOException {
        if (this.socketInputStream == null) {
            this.socketInputStream = this.sourceSocket.getInputStream();
        }
        return this.socketInputStream;
    }

    public void setTimeoutValue(int n) {
        this.timeoutPeriodForReads = n;
    }

    public int getTimeoutValue() {
        return this.timeoutPeriodForReads;
    }

    public byte getByte() throws UtilException {
        try {
            int n = this.getSocketInputStream().read();
            if (n == -1) {
                throw new UtilException(1002);
            }
            return (byte)n;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new UtilException(1029);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
    }

    public int getArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 0) {
            return 0;
        }
        try {
            int n3 = this.getSocketInputStream().read(byArray, n, n2);
            if (n3 == -1) {
                throw new UtilException(1002);
            }
            return n3;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new UtilException(1029);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
    }

    public void empty() throws UtilException {
        byte[] byArray = new byte[1024];
        boolean bl = true;
        while (bl) {
            try {
                this.getArrayOfBytes(byArray, 0, byArray.length);
            }
            catch (UtilException utilException) {
                if (utilException.getReason() == 1001) {
                    bl = false;
                    continue;
                }
                throw utilException;
            }
        }
    }

    public void receive() throws UtilException {
    }

    public boolean moreUnbufferedDataToReturn() {
        return true;
    }
}

