/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.util.UtilTransliterator;
import java.net.Socket;
import java.sql.SQLException;

public class OracleNet8Communication {
    private static String footprint = "$Revision:   3.13.1.0  $";
    public Socket socket;
    public OracleImplConnection implConn;
    private OracleDataProvider reader;
    private OracleDataConsumer writer;
    public BaseExceptions exceptions;
    public UtilTransliterator transliterator;
    public UtilTransliterator transliteratorForNationalCharset;
    public int maxPacketSize = 2047;
    public int maxReceivedPacketSize = 2000;
    BaseWarnings warnings;

    public OracleNet8Communication(Socket socket, OracleImplConnection oracleImplConnection, BaseExceptions baseExceptions, BaseWarnings baseWarnings) throws SQLException {
        this.exceptions = baseExceptions;
        this.warnings = baseWarnings;
        this.implConn = oracleImplConnection;
        this.socket = socket;
        try {
            socket.setReceiveBufferSize(65536);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writer = new OracleDataConsumer(this);
        this.reader = new OracleDataProvider(this, oracleImplConnection.japaneseAsUTF8);
    }

    public OracleDataProvider getReader() {
        return this.reader;
    }

    public OracleDataProvider getNewReader() {
        return new OracleDataProvider(this, this.implConn.japaneseAsUTF8);
    }

    public OracleDataConsumer getWriter() {
        return this.writer;
    }

    public void setNSPTPacketType(int n) {
        this.writer.setNSPTPacketType(n);
    }

    public void close() throws SQLException {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            throw this.exceptions.getException(7001, "08001");
        }
    }
}

