/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.util.UtilDataConversions;
import com.metamatrix.util.UtilTransliterator;
import java.math.BigInteger;
import java.security.Key;
import java.sql.SQLException;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DRDACrypto {
    private static String footprint = "$Revision:   1.2.1.0  $";
    private static final byte[] b = new byte[]{-58, 33, 18, -41, 62, -26, 19, -16, -108, 122, -77, 31, 15, 104, 70, -95, -65, -11, -77, -92, -54, 13, 96, -68, 30, 76, 122, 13, -116, 22, -77, -29};
    private BigInteger largePrime = new BigInteger(1, b);
    private static final byte[] d = new byte[]{70, -112, -6, 31, 123, -98, 29, 68, 66, -56, 108, -111, 20, 96, 63, -34, -49, 7, 30, -36, -20, 95, 98, 110, 33, -30, 86, -82, -39, -22, 52, -28};
    private BigInteger generator = new BigInteger(1, d);
    public BigInteger serverPublicKey;
    private BigInteger clientPublicKey;
    private BigInteger clientPrivateKey;
    private BigInteger sharedSecret;
    private byte[] DESKey;
    private byte[] DESInitVector;
    public byte[] serverPubKeyBytes;
    Cipher encryptCipher;
    Cipher decryptCipher;
    IvParameterSpec initVectorSpec;
    SecretKeySpec secretkeyspec;
    private DRDACommunication comm;

    public DRDACrypto(DRDACommunication dRDACommunication) throws SQLException {
        try {
            this.comm = dRDACommunication;
            this.encryptCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            this.decryptCipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        }
        catch (SecurityException securityException) {
            throw dRDACommunication.exceptions.getException(securityException);
        }
        catch (Exception exception) {
            throw dRDACommunication.exceptions.getException(exception);
        }
    }

    public byte[] getConnectionKey() {
        BigInteger bigInteger = new BigInteger(80, new Random());
        byte[] byArray = new byte[32];
        while (bigInteger.toByteArray().length < 10) {
            bigInteger = new BigInteger(80, new Random());
        }
        System.arraycopy(bigInteger.toByteArray(), 0, byArray, 22, 10);
        this.clientPrivateKey = new BigInteger(1, byArray);
        this.clientPublicKey = this.generator.modPow(this.clientPrivateKey, this.largePrime);
        return this.getKeyBytes(this.clientPublicKey);
    }

    public byte[] getSharedSessionKey() {
        this.serverPublicKey = new BigInteger(1, this.serverPubKeyBytes);
        this.sharedSecret = this.serverPublicKey.modPow(this.clientPrivateKey, this.largePrime);
        return this.getKeyBytes(this.sharedSecret);
    }

    public byte[] deriveDESKey(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < 8) {
            byte by = byArray[n + 12];
            int n2 = 0;
            int n3 = 0;
            while (n3 < 7) {
                if ((byte)(by & 0xFFFFFF80) == -128) {
                    ++n2;
                }
                by = (byte)(by << 1);
                ++n3;
            }
            byte by2 = n2 & true ? (byte)0 : 1;
            byArray2[n] = (byte)((byte)(byArray[n + 12] & 0xFFFFFFFE) | by2);
            ++n;
        }
        this.DESKey = byArray2;
        this.secretkeyspec = new SecretKeySpec(this.DESKey, "DES");
        return this.DESKey;
    }

    public byte[] deriveDESInitVector(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        int n = byArray.length;
        if (n < 8) {
            int n2 = 0;
            while (n2 < 8) {
                byArray2[n2] = n2 <= n - 1 ? byArray[n2] : (byte)0;
                ++n2;
            }
        } else {
            int n3 = n / 2 - 4;
            int n4 = 0;
            while (n4 < 8) {
                byArray2[n4] = byArray[n4 + n3];
                ++n4;
            }
        }
        this.DESInitVector = byArray2;
        this.initVectorSpec = new IvParameterSpec(this.DESInitVector);
        return this.DESInitVector;
    }

    public byte[] DES_Encrypt(String string, UtilTransliterator utilTransliterator) throws SQLException {
        try {
            byte[] byArray = utilTransliterator.encode(string);
            this.encryptCipher.init(1, (Key)this.secretkeyspec, this.initVectorSpec);
            byte[] byArray2 = this.encryptCipher.doFinal(byArray);
            return byArray2;
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(7107);
        }
    }

    public String DES_Decrypt(byte[] byArray, UtilTransliterator utilTransliterator) throws SQLException {
        try {
            this.decryptCipher.init(2, (Key)this.secretkeyspec, this.initVectorSpec);
            byte[] byArray2 = this.decryptCipher.doFinal(byArray);
            return utilTransliterator.decode(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(7107);
        }
    }

    private String printBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(UtilDataConversions.byteToHex(byArray[n]));
            if (n != byArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private byte[] getKeyBytes(BigInteger bigInteger) {
        byte[] byArray = new byte[32];
        if (bigInteger.toByteArray().length > 32 && bigInteger.toByteArray()[0] == 0) {
            System.arraycopy(bigInteger.toByteArray(), 1, byArray, 0, 32);
        } else {
            byArray = bigInteger.toByteArray();
        }
        return byArray;
    }
}

