/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

public final class BaseResultSetFilterDescriptor {
    private static String footprint = "$Revision:   3.2.2.0  $";
    private int[] filterColumns;
    private Object[] filterValues;
    private boolean[] patterns;

    public BaseResultSetFilterDescriptor(int[] nArray, Object[] objectArray, boolean[] blArray, boolean bl) {
        this.filterColumns = nArray;
        this.filterValues = objectArray;
        this.patterns = blArray;
        if (bl) {
            this.stripDoubleQuotesFromValues();
        }
    }

    private void stripDoubleQuotesFromValues() {
        int n = this.filterValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = this.filterValues[n2];
            if (object instanceof String && object != null && ((String)object).length() > 0) {
                String string = (String)object;
                int n3 = string.length() - 1;
                if (string.charAt(0) == '\"' && string.charAt(n3) == '\"' && n3 > 0) {
                    string = string.substring(1, n3);
                    this.filterValues[n2] = string;
                }
            }
            ++n2;
        }
    }

    public int getRestrictionCount() {
        int n = 0;
        if (this.filterColumns != null) {
            n = this.filterColumns.length;
        }
        return n;
    }

    public boolean allRestrictionsSatified() {
        int n = this.getRestrictionCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.filterValues[n2] != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Object getRestriction(int n) {
        int n2 = this.getRestrictionCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.filterColumns[n3] == n) {
                return this.filterValues[n3];
            }
            ++n3;
        }
        return null;
    }

    public boolean isPattern(int n) {
        return this.patterns[this.getIndex(n)];
    }

    public Object getRestrictionByIndex(int n) {
        return this.filterValues[n];
    }

    public void setRestrictionByIndex(int n, Object object) {
        this.filterValues[n] = object;
    }

    public boolean isPatternByIndex(int n) {
        return this.patterns[n];
    }

    public int getRestrictionColumnByIndex(int n) {
        return this.filterColumns[n];
    }

    public void removeRestriction(int n) {
        this.filterValues[this.getIndex((int)n)] = null;
    }

    public void removeAllRestrictions() {
        int n = this.getRestrictionCount();
        int n2 = 0;
        while (n2 < n) {
            this.filterValues[n2] = null;
            ++n2;
        }
    }

    private int getIndex(int n) {
        int n2 = this.getRestrictionCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.filterColumns[n3] == n) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    public void setPattern(int n, boolean bl) {
        this.patterns[this.getIndex((int)n)] = bl;
    }
}

