/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplClobService;
import com.metamatrix.util.UtilDebug;
import java.sql.SQLException;

public class BaseImplClobCached
extends BaseImplClobService {
    private static String footprint = "$Revision:   3.0.6.0  $";
    private int cacheStartOffset = -1;
    private int cacheEndOffset = -1;
    private byte[] cachedData = null;
    private int bytesPerChar = BaseImplClob.getBytesPerChar(this);

    public BaseImplClobCached(BaseImplClob baseImplClob, BaseExceptions baseExceptions) {
        super(baseImplClob, baseExceptions);
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        this.fetchDataToCache(l, n2);
        int n3 = new Long(l).intValue() * this.bytesPerChar;
        int n4 = n2 * this.bytesPerChar;
        System.arraycopy(this.cachedData, n3, byArray, n, n4);
        return n4;
    }

    protected byte[] getCachedData() {
        return this.cachedData;
    }

    protected void fetchDataToCache(long l, int n) throws SQLException {
        UtilDebug.assert("clobOffset must be positive", l > 0L);
        UtilDebug.assert("numCharsToRead must be non-negative", n >= 0);
        this.createCacheBuffer();
        if (l + (long)n > (long)(Integer.MAX_VALUE / this.bytesPerChar)) {
            throw this.exceptions.getException(6066);
        }
        int n2 = new Long(l).intValue();
        int n3 = new Long(l + (long)n).intValue();
        int n4 = n2 * this.bytesPerChar;
        int n5 = n3 * this.bytesPerChar;
        if (this.cacheStartOffset == -1 || this.cacheEndOffset == -1) {
            UtilDebug.assert("Invalid Cache State", this.cacheStartOffset == -1 && this.cacheEndOffset == -1);
            int n6 = n3 - n2;
            if (n6 > 0) {
                this.subImplClob.readData(this.cachedData, n4, n2, n6);
                this.cacheStartOffset = n4;
                this.cacheEndOffset = n5 - 1;
            }
        } else {
            int n7;
            if (n4 < this.cacheStartOffset && (n7 = (this.cacheStartOffset - n4) / this.bytesPerChar) > 0) {
                this.subImplClob.readData(this.cachedData, n4, n2, n7);
                this.cacheStartOffset = n4;
            }
            if (n5 > this.cacheEndOffset) {
                n4 = this.cacheEndOffset + 1;
                n2 = n4 / this.bytesPerChar;
                n7 = (n5 - n4) / this.bytesPerChar;
                if (n7 > 0) {
                    this.subImplClob.readData(this.cachedData, n4, n2, n7);
                    this.cacheEndOffset = n5 - 1;
                }
            }
        }
    }

    private void createCacheBuffer() throws SQLException {
        if (this.cachedData == null) {
            int n;
            try {
                n = new Long(this.getLength()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6066);
            }
            this.cachedData = new byte[(n + 1) * this.bytesPerChar];
        }
    }
}

