/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.connector.jdbc.extension.FunctionModifier;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.language.IBulkInsert;
import com.metamatrix.data.language.IDelete;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.visitor.util.SQLStringVisitor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class SQLConversionVisitor
extends SQLStringVisitor {
    private static DecimalFormat decimalFormatter = new DecimalFormat("#############################0.0#############################");
    private static double SCIENTIC_LOW = Math.pow(10.0, -3.0);
    private static double SCIENTIC_HIGH = Math.pow(10.0, 7.0);
    private Map modifiers;
    private ExecutionContext context;
    private ILanguageFactory languageFactory;
    private TimeZone databaseTimeZone;
    private int execType = 0;
    private int stmtType = 0;
    private List preparedValues = new ArrayList();
    private List preparedTypes = new ArrayList();
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;

    public void visit(IInsert obj) {
        this.execType = 1;
        super.visit(obj);
    }

    public void visit(IBulkInsert obj) {
        this.stmtType = 1;
        super.visit(obj);
        for (int i = 0; i < obj.getElements().size(); ++i) {
            IElement element = (IElement)obj.getElements().get(i);
            this.preparedTypes.add(element.getType());
        }
        this.preparedValues = obj.getRows();
    }

    private void translateSQLType(Class type, Object obj, StringBuffer valuesbuffer) {
        if (obj == null) {
            valuesbuffer.append("NULL");
        } else if ((class$java$lang$Number == null ? (class$java$lang$Number = SQLConversionVisitor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type)) {
            boolean useFormatting = false;
            if ((class$java$lang$Double == null ? (class$java$lang$Double = SQLConversionVisitor.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type)) {
                double value = (Double)obj;
                useFormatting = value <= SCIENTIC_LOW || value >= SCIENTIC_HIGH;
            } else if ((class$java$lang$Float == null ? (class$java$lang$Float = SQLConversionVisitor.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type)) {
                float value = ((Float)obj).floatValue();
                boolean bl = useFormatting = (double)value <= SCIENTIC_LOW || (double)value >= SCIENTIC_HIGH;
            }
            if (useFormatting) {
                valuesbuffer.append(decimalFormatter.format(obj));
            } else {
                valuesbuffer.append(obj);
            }
        } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
            valuesbuffer.append(this.translateLiteralBoolean((Boolean)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            valuesbuffer.append(this.translateLiteralTimestamp((Timestamp)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            valuesbuffer.append(this.translateLiteralTime((Time)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            valuesbuffer.append(this.translateLiteralDate((Date)obj));
        } else {
            valuesbuffer.append("'").append(this.escapeString(obj.toString())).append("'");
        }
    }

    public void visit(IUpdate obj) {
        this.execType = 1;
        super.visit(obj);
    }

    public void visit(IQuery obj) {
        this.execType = 0;
        super.visit(obj);
    }

    public void visit(IProcedure obj) {
        this.execType = 2;
        this.stmtType = 2;
        this.preparedValues = obj.getParameters();
        this.buffer.append(this.generateSqlForStoredProcedure(obj));
    }

    public void visit(IDelete obj) {
        this.execType = 1;
        super.visit(obj);
    }

    public void visit(IFunction obj) {
        List parts;
        FunctionModifier functionModifier;
        if (this.modifiers != null && (functionModifier = (FunctionModifier)this.modifiers.get(obj.getName().toLowerCase())) != null && (parts = functionModifier.translate(obj)) != null) {
            Iterator iter = parts.iterator();
            while (iter.hasNext()) {
                Object part = iter.next();
                if (part instanceof String) {
                    this.buffer.append(part);
                    continue;
                }
                this.append((ILanguageObject)part);
            }
            return;
        }
        super.visit(obj);
    }

    public void visit(ILiteral obj) {
        if (this.stmtType == 1 && obj.isBindValue()) {
            this.buffer.append("?");
            this.preparedValues.add(obj.getValue());
            this.preparedTypes.add(obj.getType());
        } else {
            this.translateSQLType(obj.getType(), obj.getValue(), this.buffer);
        }
    }

    protected String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "1";
        }
        return "0";
    }

    protected String translateLiteralDate(Date dateValue) {
        return "{d'" + this.formatDateValue(dateValue) + "'}";
    }

    protected String translateLiteralTime(Time timeValue) {
        return "{t'" + this.formatDateValue(timeValue) + "'}";
    }

    protected String translateLiteralTimestamp(Timestamp timestampValue) {
        return "{ts'" + this.formatDateValue(timestampValue) + "'}";
    }

    protected String formatDateValue(Object dateObject) {
        if (this.databaseTimeZone == null) {
            return dateObject.toString();
        }
        if (dateObject instanceof Timestamp) {
            SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            timestampFormatter.setTimeZone(this.databaseTimeZone);
            Timestamp ts = (Timestamp)dateObject;
            String nanoStr = "" + (1000000000L + (long)ts.getNanos());
            while (nanoStr.length() > 2 && nanoStr.charAt(nanoStr.length() - 1) == '0') {
                nanoStr = nanoStr.substring(0, nanoStr.length() - 1);
            }
            String tsStr = timestampFormatter.format(ts) + "." + nanoStr.substring(1);
            return tsStr;
        }
        if (dateObject instanceof Date) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
            dateFormatter.setTimeZone(this.databaseTimeZone);
            return dateFormatter.format((Date)dateObject);
        }
        if (dateObject instanceof Time) {
            SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
            timeFormatter.setTimeZone(this.databaseTimeZone);
            return timeFormatter.format((Time)dateObject);
        }
        return dateObject.toString();
    }

    public void setFunctionModifiers(Map modifiers) {
        this.modifiers = modifiers;
    }

    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    protected ExecutionContext getExecutionContext() {
        return this.context;
    }

    public void setProperties(Properties props) {
        String useBindVariables = props.getProperty("UseBindVariables", Boolean.FALSE.toString());
        if (useBindVariables.equals(Boolean.TRUE.toString())) {
            this.stmtType = 1;
        }
    }

    protected String generateSqlForStoredProcedure(IProcedure exec) {
        StringBuffer prepareCallBuffer = new StringBuffer();
        prepareCallBuffer.append("{ ");
        List params = exec.getParameters();
        boolean needQuestionMark = false;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            IParameter param = (IParameter)iter.next();
            if (param.getDirection() != 3) continue;
            needQuestionMark = true;
            break;
        }
        if (needQuestionMark) {
            prepareCallBuffer.append("?=");
        }
        prepareCallBuffer.append(" call ");
        prepareCallBuffer.append(exec.getMetadataID() != null ? this.getName(exec.getMetadataID()) : exec.getProcedureName());
        prepareCallBuffer.append("(");
        int numberOfParameters = 0;
        iter = params.iterator();
        while (iter.hasNext()) {
            IParameter param = (IParameter)iter.next();
            if (param.getDirection() != 0 && param.getDirection() != 1 && param.getDirection() != 2) continue;
            if (numberOfParameters > 0) {
                prepareCallBuffer.append(",");
            }
            prepareCallBuffer.append("?");
            ++numberOfParameters;
        }
        prepareCallBuffer.append(")");
        prepareCallBuffer.append("}");
        return prepareCallBuffer.toString();
    }

    public void setLanguageFactory(ILanguageFactory factory) {
        this.languageFactory = factory;
    }

    public ILanguageFactory getLanguageFactory() {
        return this.languageFactory;
    }

    public void setDatabaseTimeZone(TimeZone zone) {
        this.databaseTimeZone = zone;
    }

    protected TimeZone getDatabaseTimeZone() {
        return this.databaseTimeZone;
    }

    protected int getExecType() {
        return this.execType;
    }

    List getPreparedValues() {
        return this.preparedValues;
    }

    List getPreparedTypes() {
        return this.preparedTypes;
    }

    int getStmtType() {
        return this.stmtType;
    }

    protected void setStmtType(int stmtType) {
        this.stmtType = stmtType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

