/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.webservice.lds;

import com.metamatrix.common.xml.XmlUtil;
import com.metamatrix.core.plugin.PluginUtilities;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.license.xml.LicenseReader;
import com.metamatrix.modeler.webservice.WebServicePlugin;
import com.metamatrix.modeler.webservice.lds.WebArchiveBuilder;
import com.metamatrix.modeler.webservice.util.AntTasks;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.validator.UrlValidator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class DefaultWebArchiveBuilderImpl
implements WebArchiveBuilder {
    private static final String I18N_PREFIX = "WebArchiveBuilder.";
    private static final String TASK_CREATE_DIRECTORIES = DefaultWebArchiveBuilderImpl.getString("taskCreateDirectory");
    private static final String TASK_COPYING_FILES = DefaultWebArchiveBuilderImpl.getString("taskCopyingFiles");
    private static final String TASK_CREATING_WAR_ARCHIVE = DefaultWebArchiveBuilderImpl.getString("taskCreatingWarArchive");
    private static final String TASK_COPYING_WAR_FILE = DefaultWebArchiveBuilderImpl.getString("taskCopyingWarFile");
    private static final String TASK_CREATING_EMBEDDED_JAR_FILE = DefaultWebArchiveBuilderImpl.getString("taskCreatingEmbeddedJar");
    private static final String TASK_CLEANUP = DefaultWebArchiveBuilderImpl.getString("taskCleanup");

    public IStatus validateContextName(String contextName) {
        try {
            String URL_BASE = "http://www.metamatrix.com/";
            UrlValidator urlValidator = new UrlValidator();
            String[] invalidChars = new String[]{"/", "\\", StringUtil.Constants.SPACE};
            String invalidChar = this.validateInvalidCharactersInContextName(contextName, invalidChars);
            if (invalidChar != null) {
                String msg = null;
                if (StringUtil.Constants.SPACE.equals(invalidChar)) {
                    msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed_InvalidSpace");
                } else {
                    Object[] params = new Object[]{invalidChar};
                    msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed_InvalidCharacter", params);
                }
                return new Status(4, "com.metamatrix.modeler.webservice", 1, msg, null);
            }
            if ("".equals(contextName)) {
                String msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed_Empty");
                return new Status(4, "com.metamatrix.modeler.webservice", 1, msg, null);
            }
            if (!urlValidator.isValid("http://www.metamatrix.com/" + contextName)) {
                String msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed");
                return new Status(4, "com.metamatrix.modeler.webservice", 1, msg, null);
            }
            String msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationSucceeded");
            return new Status(0, "com.metamatrix.modeler.webservice", 2, msg, null);
        }
        catch (Exception e) {
            String msg = DefaultWebArchiveBuilderImpl.getString("ContextNameValidationFailed");
            return new Status(4, "com.metamatrix.modeler.webservice", 1, msg, (Throwable)e);
        }
    }

    public IStatus validateLicenseFile(String path) {
        String licenseFileName = this.getLicenseFileName(path);
        try {
            FileInputStream stream = new FileInputStream(licenseFileName);
            LicenseReader reader = new LicenseReader((InputStream)stream);
            reader.init();
            reader.loadLicense();
        }
        catch (FileNotFoundException e) {
            String msg = DefaultWebArchiveBuilderImpl.getString("LicenseFileValidationFailed_FileNotFound");
            Status status = new Status(4, "com.metamatrix.modeler.webservice", 3, msg, (Throwable)e);
            WebServicePlugin.Util.log((IStatus)status);
            return status;
        }
        catch (Exception e) {
            String msg = DefaultWebArchiveBuilderImpl.getString("LicenseFileValidationFailed");
            Status status = new Status(4, "com.metamatrix.modeler.webservice", 3, msg, (Throwable)e);
            WebServicePlugin.Util.log((IStatus)status);
            return status;
        }
        String msg = DefaultWebArchiveBuilderImpl.getString("LicenseFileValidationSucceeded");
        Status status = new Status(0, "com.metamatrix.modeler.webservice", 4, msg, null);
        return status;
    }

    public IStatus createWebArchive(Map properties, IProgressMonitor monitor) {
        IStatus status;
        try {
            String contextName = (String)properties.get("ContextName");
            status = this.validateContextName(contextName);
            if (4 == status.getSeverity()) {
                throw new Exception(status.getException());
            }
            String path = (String)properties.get("LicenseFilePath");
            status = this.validateLicenseFile(path);
            if (4 == status.getSeverity()) {
                throw new Exception(status.getException());
            }
            String webServicePluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.modeler.webservice", (boolean)true);
            String buildDirectoryName = webServicePluginPath + File.separator + "lds_war_build";
            File buildDirectory = new File(buildDirectoryName);
            buildDirectory.mkdir();
            monitor.subTask(TASK_CREATE_DIRECTORIES);
            String workDirectoryName = buildDirectoryName + File.separator + "work";
            File workDirectory = new File(workDirectoryName);
            workDirectory.mkdir();
            FileUtils.removeChildrenRecursively((File)workDirectory);
            TempDirectory tempDir = TempDirectory.getTempDirectory((String)workDirectoryName);
            String tempDirectoryName = tempDir.getPath();
            String contextDirectoryName = tempDirectoryName + File.separator + contextName;
            File contextDirectory = new File(contextDirectoryName);
            contextDirectory.mkdir();
            String imagesDirectoryName = contextDirectoryName + File.separator + "images";
            File imagesDirectory = new File(imagesDirectoryName);
            imagesDirectory.mkdir();
            String webInfDirectoryName = contextDirectoryName + File.separator + "WEB-INF";
            File webInfDirectory = new File(webInfDirectoryName);
            webInfDirectory.mkdir();
            String webInfLibDirectoryName = webInfDirectoryName + File.separator + "lib";
            File webInfLibDirectory = new File(webInfLibDirectoryName);
            String webInfClassesDirectoryName = webInfDirectoryName + File.separator + "classes";
            File webInfClassesDirectory = new File(webInfClassesDirectoryName);
            webInfClassesDirectory.mkdir();
            webInfLibDirectory.mkdir();
            monitor.worked(10);
            monitor.subTask(TASK_COPYING_FILES);
            this.getWebFiles(contextDirectory, imagesDirectory, webInfDirectory);
            this.getLibFiles(webInfLibDirectory);
            this.replaceVariables(webInfDirectoryName, properties, contextName);
            this.getExternalFiles(webInfLibDirectoryName);
            this.copyLicenseFilesToClassesDirectory(webInfClassesDirectoryName, properties);
            monitor.worked(10);
            monitor.subTask(TASK_CREATING_EMBEDDED_JAR_FILE);
            this.createEmbeddedJar(buildDirectoryName, tempDirectoryName, properties, monitor);
            String embeddedJarFileName = File.separator + "embedded.jar";
            FileUtils.copyFile((String)tempDirectoryName, (String)webInfLibDirectoryName, (String)embeddedJarFileName);
            monitor.worked(5);
            monitor.subTask(TASK_CREATING_WAR_ARCHIVE);
            String warFileName = tempDirectoryName + File.separator + contextName + ".war";
            AntTasks.zip((String)contextDirectoryName, (String)warFileName);
            monitor.worked(20);
            String newWarFileDir = (String)properties.get("WARFileSaveLocation");
            File newWarDir = new File(newWarFileDir);
            if (!newWarDir.exists()) {
                newWarDir.mkdir();
            }
            monitor.subTask(TASK_COPYING_WAR_FILE);
            File warFile = new File(warFileName);
            String newWarFileName = this.getFileName((String)properties.get("WARFileSaveLocation"), contextName + ".war");
            File newWarFile = new File(newWarFileName);
            if (newWarFile.exists() && !newWarFile.delete()) {
                String msg = DefaultWebArchiveBuilderImpl.getString("WebArchiveCreationFailed_CouldNotDeleteExistingWARFile");
                throw new Exception(msg);
            }
            if (!warFile.renameTo(newWarFile)) {
                String msg = DefaultWebArchiveBuilderImpl.getString("WebArchiveCreationFailed_CouldNotSaveWARFile");
                throw new Exception(msg);
            }
            monitor.subTask(TASK_CLEANUP);
            tempDir.remove();
            monitor.worked(5);
        }
        catch (Exception e) {
            String msg = DefaultWebArchiveBuilderImpl.getString("WebArchiveCreationFailed");
            Status status2 = new Status(4, "com.metamatrix.modeler.webservice", 5, msg, (Throwable)e);
            WebServicePlugin.Util.log((IStatus)status2);
            return status2;
        }
        String msg = DefaultWebArchiveBuilderImpl.getString("WebArchiveCreationSucceeded");
        status = new Status(0, "com.metamatrix.modeler.webservice", 6, msg, null);
        return status;
    }

    public boolean targetWarFileExists(Map properties) {
        boolean fileExists = false;
        String contextName = (String)properties.get("ContextName");
        IStatus status = this.validateContextName(contextName);
        if (4 == status.getSeverity()) {
            fileExists = true;
            return fileExists;
        }
        String newWarFileName = this.getFileName((String)properties.get("WARFileSaveLocation"), contextName + ".war");
        fileExists = new File(newWarFileName).exists();
        return fileExists;
    }

    protected static String getString(String id) {
        return WebServicePlugin.Util.getString(I18N_PREFIX + id);
    }

    protected static String getString(String id, Object[] params) {
        return WebServicePlugin.Util.getString(I18N_PREFIX + id, params);
    }

    private String validateInvalidCharactersInContextName(String contextName, String[] invalidChars) {
        int numChars = invalidChars.length;
        for (int charCounter = 0; charCounter < numChars; ++charCounter) {
            String invalidChar = invalidChars[charCounter];
            if (contextName.indexOf(invalidChar) < 0) continue;
            return invalidChar;
        }
        return null;
    }

    private String getLicenseFileName(String path) {
        return this.getFileName(path, "MetaMatrixLicense.xml");
    }

    private String getFileName(String path, String name) {
        String fileName = path;
        if (!fileName.endsWith("/") && !fileName.endsWith("\\")) {
            fileName = fileName + File.separator;
        }
        fileName = fileName + name;
        return fileName;
    }

    private void getWebFiles(File contextDirectory, File imagesDirectory, File webInfDirectory) throws Exception {
        String webLibPath = this.getWebLibDirectoryPath();
        String webAppsDirectoryName = webLibPath + File.separator + "webapps";
        File webAppsDirectory = new File(webAppsDirectoryName);
        FileUtils.copyDirectoryContentsRecursively((File)webAppsDirectory, (File)contextDirectory);
    }

    private void replaceVariables(String webInfDirectoryName, Map properties, String contextName) {
        File webXmlFile = new File(webInfDirectoryName + File.separator + "web.xml");
        Properties addlProps = (Properties)properties.get("AdditionalProperties");
        String addlPropsString = "";
        if (addlProps != null) {
            addlPropsString = this.createAddlPropertiesString(addlProps);
        }
        String vdbFileName = (String)properties.get("VdbFileName");
        File vdbFile = new File(FileUtils.getFilenameWithoutExtension((String)vdbFileName));
        AntTasks.replace((File)webXmlFile, (String)"${vdb.name}", (String)vdbFile.getName());
        AntTasks.replace((File)webXmlFile, (String)"${mmquery.additional.properties}", (String)addlPropsString);
        String logFilePath = (String)properties.get("LogFilePath");
        AntTasks.replace((File)webXmlFile, (String)"${log.file.path}", (String)logFilePath);
        AntTasks.replace((File)webXmlFile, (String)"${log.file.prefix}", (String)contextName);
    }

    protected String createAddlPropertiesString(Properties props) {
        StringBuffer buf = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> i = props.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            if (!(entry.getValue() instanceof String)) continue;
            buf.append(entry.getKey()).append('=').append(entry.getValue()).append(';');
        }
        String urlString = buf.toString();
        urlString = XmlUtil.escapeCharacterData((String)urlString);
        return urlString;
    }

    private void getLibFiles(File webInfLibDirectory) throws Exception {
        String mmqueryApiPluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.mmquery.api", (boolean)true);
        FileUtils.copyFile((String)(mmqueryApiPluginPath + "/dqp"), (String)webInfLibDirectory.getPath(), (String)"mmquery-jdbc.jar");
        String bouncyCastlePluginPath = PluginUtilities.getPluginProjectLocation((String)"org.bouncycastle_1.4", (boolean)true);
        FileUtils.copyFile((String)bouncyCastlePluginPath, (String)webInfLibDirectory.getPath(), (String)"bcprov-jdk14-122.jar");
        String axisPluginPath = PluginUtilities.getPluginProjectLocation((String)"org.apache.axis", (boolean)true);
        FileUtils.copyFile((String)axisPluginPath, (String)webInfLibDirectory.getPath(), (String)"axis.jar");
        FileUtils.copyFile((String)axisPluginPath, (String)webInfLibDirectory.getPath(), (String)"commons-discovery.jar");
        FileUtils.copyFile((String)axisPluginPath, (String)webInfLibDirectory.getPath(), (String)"commons-logging.jar");
        FileUtils.copyFile((String)axisPluginPath, (String)webInfLibDirectory.getPath(), (String)"jaxrpc.jar");
        FileUtils.copyFile((String)axisPluginPath, (String)"saaj_Rename.jar", (String)webInfLibDirectory.getPath(), (String)"saaj.jar");
        FileUtils.copyFile((String)axisPluginPath, (String)webInfLibDirectory.getPath(), (String)"wsdl4j.jar");
        FileUtils.copyFile((String)axisPluginPath, (String)webInfLibDirectory.getPath(), (String)"log4j.jar");
        String mmCommonPluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.common", (boolean)true);
        FileUtils.copyFile((String)mmCommonPluginPath, (String)webInfLibDirectory.getPath(), (String)"common.jar");
        String mmCorePluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.core", (boolean)true);
        FileUtils.copyFile((String)mmCorePluginPath, (String)webInfLibDirectory.getPath(), (String)"core.jar");
        String mmCoreXmlPluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.core.xml", (boolean)true);
        FileUtils.copyFile((String)mmCoreXmlPluginPath, (String)webInfLibDirectory.getPath(), (String)"coreXml.jar");
        String mmLicensePluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.license", (boolean)true);
        FileUtils.copyFile((String)mmLicensePluginPath, (String)webInfLibDirectory.getPath(), (String)"license.jar");
        String webLibPath = this.getWebLibDirectoryPath();
        FileUtils.copyFile((String)webLibPath, (String)webInfLibDirectory.getPath(), (String)"lds.jar");
        String xercesPluginPath = PluginUtilities.getPluginProjectLocation((String)"org.apache.xerces", (String)"2.7.0");
        FileUtils.copyFile((String)xercesPluginPath, (String)webInfLibDirectory.getPath(), (String)"xercesImpl.jar");
        FileUtils.copyFile((String)xercesPluginPath, (String)webInfLibDirectory.getPath(), (String)"xml-apis.jar");
    }

    private String getWebLibDirectoryPath() throws Exception {
        String mmWebServicePluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.modeler.webservice", (boolean)true);
        String mmWebServiceLibFolder = mmWebServicePluginPath + File.separator + "dimension_war_resources";
        if (new File(mmWebServiceLibFolder).exists()) {
            return mmWebServiceLibFolder;
        }
        String msg = WebServicePlugin.Util.getString("DefaultWebArchiveBuilderImpl.web_lib_directory_does_not_exist", (Object)mmWebServiceLibFolder);
        WebServicePlugin.Util.log(4, msg);
        throw new FileNotFoundException(msg);
    }

    private String getUdfConfigDirectoryPath() throws Exception {
        String mmWebServicePluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.modeler.webservice", (boolean)true);
        Path mmWebServicePluginDirPath = new Path(mmWebServicePluginPath);
        IPath functionsFilePath = mmWebServicePluginDirPath.removeLastSegments(2).append("/config/FunctionDefinitions.xmi");
        File functionsFile = functionsFilePath.toFile();
        if (functionsFile != null && functionsFile.exists()) {
            return functionsFile.getParentFile().getCanonicalPath();
        }
        functionsFilePath = mmWebServicePluginDirPath.removeLastSegments(3).append("/config/FunctionDefinitions.xmi");
        functionsFile = functionsFilePath.toFile();
        if (functionsFile != null && functionsFile.exists()) {
            return functionsFile.getParentFile().getCanonicalPath();
        }
        return null;
    }

    private void createEmbeddedJar(String buildeDirectoryName, String workDirectoryName, Map properties, IProgressMonitor monitor) throws Exception {
        String orginVdbFileName = (String)properties.get("VdbFileName");
        File orginVdbFile = new File(orginVdbFileName);
        String vdbName = FileUtils.getFilenameWithoutExtension((String)orginVdbFile.getName());
        File embeddedJarRootDirectory = new File(workDirectoryName + File.separator + "/embedded");
        File vdbContextualEmbeddedDir = new File(embeddedJarRootDirectory.getPath() + File.separator + vdbName);
        File embeddedConfigDirectory = new File(vdbContextualEmbeddedDir.getPath() + File.separator + "/config");
        File embeddedExtensionsDirectory = new File(vdbContextualEmbeddedDir.getPath() + File.separator + "/extensions");
        File embeddedJdbcDirectory = new File(vdbContextualEmbeddedDir.getPath() + File.separator + "/jdbc");
        File embeddedLibDirectory = new File(vdbContextualEmbeddedDir.getPath() + File.separator + "/lib");
        File embeddedLogsDirectory = new File(vdbContextualEmbeddedDir.getPath() + File.separator + "/logs");
        embeddedJarRootDirectory.mkdir();
        vdbContextualEmbeddedDir.mkdir();
        embeddedConfigDirectory.mkdir();
        embeddedExtensionsDirectory.mkdir();
        embeddedJdbcDirectory.mkdir();
        embeddedLibDirectory.mkdir();
        embeddedLogsDirectory.mkdir();
        String dqpPluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.modeler.dqp", (boolean)true);
        IPath dqpStateLocation = WebServicePlugin.getInstance().getStateLocation().removeLastSegments(1).append("com.metamatrix.modeler.dqp");
        String mmqueryApiPluginPath = PluginUtilities.getPluginProjectLocation((String)"com.metamatrix.mmquery.api", (boolean)true);
        monitor.worked(5);
        IPath configFilePath = dqpStateLocation.append("DqpConfiguration/");
        FileUtils.copyFile((String)configFilePath.toOSString(), (String)"configuration.xml", (String)embeddedConfigDirectory.getPath(), (String)"ServerConfig.xml");
        IPath dqpExtensionPath = dqpStateLocation.append("DqpExtensions");
        File[] jarFiles = FileUtils.findAllFilesInDirectoryHavingExtension((String)dqpExtensionPath.toOSString(), (String)".jar");
        int numJarFiles = jarFiles.length;
        for (int jarFileCtr = 0; jarFileCtr < numJarFiles; ++jarFileCtr) {
            File jarFile = jarFiles[jarFileCtr];
            FileUtils.copyFile((String)dqpExtensionPath.toOSString(), (String)embeddedExtensionsDirectory.getPath(), (String)jarFile.getName());
        }
        monitor.worked(5);
        String udfFileNameValue = "";
        String udfClasspathValue = "";
        String udfConfigDirectoryPath = this.getUdfConfigDirectoryPath();
        if (udfConfigDirectoryPath != null) {
            FileUtils.copyFile((String)udfConfigDirectoryPath, (String)embeddedConfigDirectory.getPath(), (String)"FunctionDefinitions.xmi");
            jarFiles = FileUtils.findAllFilesInDirectoryHavingExtension((String)udfConfigDirectoryPath, (String)".jar");
            numJarFiles = jarFiles.length;
            for (int jarFileCtr = 0; jarFileCtr < numJarFiles; ++jarFileCtr) {
                File jarFile = jarFiles[jarFileCtr];
                FileUtils.copyFile((String)udfConfigDirectoryPath, (String)embeddedExtensionsDirectory.getPath(), (String)jarFile.getName());
            }
            udfFileNameValue = "./config/FunctionDefinitions.xmi";
            if (numJarFiles > 0) {
                StringBuffer sb = new StringBuffer();
                for (int jarFileCtr = 0; jarFileCtr < numJarFiles; ++jarFileCtr) {
                    sb.append("extensionjar:");
                    sb.append(jarFiles[jarFileCtr].getName());
                    sb.append(';');
                }
                sb.deleteCharAt(sb.length() - 1);
                udfClasspathValue = sb.toString();
            }
        }
        monitor.worked(5);
        FileUtils.copyFile((String)(mmqueryApiPluginPath + "/dqp"), (String)embeddedLibDirectory.getPath(), (String)"mmquery.jar");
        FileUtils.copyFile((String)dqpPluginPath, (String)embeddedLibDirectory.getPath(), (String)"metamatrixpki.keystore");
        FileUtils.copyFile((String)dqpPluginPath, (String)embeddedLibDirectory.getPath(), (String)"System.vdb");
        String destVdbFileName = embeddedConfigDirectory.getPath() + File.separator + orginVdbFile.getName();
        FileUtils.copy((String)orginVdbFileName, (String)destVdbFileName);
        FileUtils.copyFile((String)buildeDirectoryName, (String)vdbContextualEmbeddedDir.getPath(), (String)"embedded.properties");
        String passwordFile = dqpPluginPath + File.separator + "dqp.key";
        BufferedReader reader = new BufferedReader(new FileReader(passwordFile));
        String dqpKey = reader.readLine();
        reader.close();
        monitor.worked(5);
        File embeddedPropertiesFile = new File(vdbContextualEmbeddedDir.getPath() + File.separator + "embedded.properties");
        AntTasks.replace((File)embeddedPropertiesFile, (String)"${dqp.key}", (String)dqpKey);
        AntTasks.replace((File)embeddedPropertiesFile, (String)"${vdb.file.name}", (String)orginVdbFile.getName());
        AntTasks.replace((File)embeddedPropertiesFile, (String)"${dqp.udf.file}", (String)udfFileNameValue);
        AntTasks.replace((File)embeddedPropertiesFile, (String)"${dqp.udf.extensionjar}", (String)udfClasspathValue);
        String embeddedJarFileName = workDirectoryName + File.separator + "embedded.jar";
        AntTasks.zip((String)embeddedJarRootDirectory.getPath(), (String)embeddedJarFileName);
        monitor.worked(30);
    }

    private void getExternalFiles(String libDirectoryName) throws Exception {
        String pluginsDirectory = PluginUtilities.getPluginsLocation((boolean)true);
        FileUtils.copyFile((String)pluginsDirectory, (String)libDirectoryName, (String)"org.eclipse.core.runtime_3.1.0.jar");
        FileUtils.copyFile((String)pluginsDirectory, (String)libDirectoryName, (String)"org.eclipse.core.runtime.compatibility_3.1.0.jar");
        FileUtils.copyFile((String)pluginsDirectory, (String)libDirectoryName, (String)"org.eclipse.core.resources_3.1.0.jar");
        FileUtils.copyFile((String)pluginsDirectory, (String)libDirectoryName, (String)"org.eclipse.osgi_3.1.0.jar");
        FileUtils.copyFile((String)pluginsDirectory, (String)libDirectoryName, (String)"org.eclipse.osgi.services_3.1.0.jar");
        FileUtils.copyFile((String)pluginsDirectory, (String)libDirectoryName, (String)"org.eclipse.osgi.util_3.1.0.jar");
        String jdomDir = PluginUtilities.getPluginProjectLocation((String)"org.jdom", (boolean)true);
        FileUtils.copyFile((String)jdomDir, (String)libDirectoryName, (String)"jdom.jar");
        String oswegoDir = PluginUtilities.getPluginProjectLocation((String)"edu.oswego.util.concurrent", (boolean)true);
        FileUtils.copyFile((String)oswegoDir, (String)libDirectoryName, (String)"concurrent.jar");
    }

    private void copyLicenseFilesToClassesDirectory(String classesDirName, Map properties) throws Exception {
        String path = (String)properties.get("LicenseFilePath");
        FileUtils.copyFile((String)path, (String)classesDirName, (String)"MetaMatrixLicense.xml");
        FileUtils.copyFile((String)path, (String)classesDirName, (String)"metamatrix.cert");
    }
}

