/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.ui.actions;

import com.metamatrix.common.util.SqlUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.transformation.util.SqlConverter;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.transformation.ui.UiConstants;
import com.metamatrix.modeler.ui.actions.SortableSelectionAction;
import com.metamatrix.query.ui.UiPlugin;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportTransformationSqlToTextAction
extends SortableSelectionAction
implements UiConstants {
    private static final String EXPORT_PROBLEM = "ExportTransformationSqlToTextAction.exportProb";
    private static final String EXPORT_SQL_DIALOG_TITLE = "ExportTransformationSqlToTextAction.exportSqlDialog.title";
    private static final String EXPORT_DEFAULT_FILENAME = "ExportTransformationSqlToTextAction.exportDefaultFile.text";
    private static final String EXPORT_DEFAULT_FILEEXT = "ExportTransformationSqlToTextAction.exportDefaultExtension.text";
    private static final char DELIMETER = '|';

    public boolean isValidSelection(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    public void run() {
        Object selectedObj;
        ISelection cachedSelection = this.getSelection();
        if (cachedSelection != null && !cachedSelection.isEmpty() && (selectedObj = SelectionUtilities.getSelectedObject((ISelection)cachedSelection)) != null && selectedObj instanceof IFile) {
            ModelResource modelResource = null;
            try {
                String fileName;
                modelResource = ModelUtilities.getModelResource((IFile)((IFile)selectedObj), (boolean)false);
                if (modelResource != null && (fileName = this.askUserForOutputFilename()) != null) {
                    String fileOuputString = this.getSqlOutputString(modelResource);
                    this.exportSqlToFile(fileName, UiConstants.Util.getString(EXPORT_DEFAULT_FILEEXT), fileOuputString);
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log((Throwable)e);
            }
        }
        this.selectionChanged(null, (ISelection)new StructuredSelection());
    }

    public boolean isApplicable(ISelection selection) {
        return this.virtualModelSelected(selection);
    }

    private boolean virtualModelSelected(ISelection theSelection) {
        boolean result = false;
        List allObjs = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
        if (!allObjs.isEmpty() && allObjs.size() == 1) {
            Iterator iter = allObjs.iterator();
            result = true;
            Object nextObj = null;
            while (iter.hasNext() && result) {
                nextObj = iter.next();
                if (nextObj instanceof IFile) {
                    result = this.isRelationalViewModel(nextObj);
                    continue;
                }
                result = false;
            }
        }
        return result;
    }

    private boolean isRelationalViewModel(IFile file) {
        boolean isRelationalView = false;
        XMIHeader header = ModelUtil.getXmiHeader((IResource)file);
        if (header != null && ModelType.VIRTUAL_LITERAL.equals(ModelType.get((String)header.getModelType()))) {
            isRelationalView = true;
        }
        return isRelationalView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File exportSqlToFile(String fileNameString, String fileExtension, String fileOuputString) {
        block23: {
            PrintWriter printWriter;
            BufferedWriter outputBufferWriter;
            FileWriter fileWriter;
            block21: {
                ArgCheck.isNotNull((Object)fileNameString);
                ArgCheck.isNotNull((Object)fileExtension);
                ArgCheck.isNotNull((Object)fileOuputString);
                ArgCheck.isNotEmpty((String)fileNameString);
                ArgCheck.isNotEmpty((String)fileExtension);
                ArgCheck.isNotEmpty((String)fileOuputString);
                if (fileNameString.indexOf(46) == -1 && fileExtension != null) {
                    fileNameString = fileNameString + "." + fileExtension;
                }
                fileWriter = null;
                outputBufferWriter = null;
                printWriter = null;
                fileWriter = new FileWriter(fileNameString);
                outputBufferWriter = new BufferedWriter(fileWriter);
                printWriter = new PrintWriter(outputBufferWriter);
                printWriter.write(fileOuputString);
                Object var9_7 = null;
                if (printWriter == null) break block21;
                printWriter.close();
            }
            try {
                if (outputBufferWriter != null) {
                    outputBufferWriter.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
                break block23;
            }
            catch (IOException e2) {}
            break block23;
            {
                catch (Exception e) {
                    UiConstants.Util.log(4, (Throwable)e, UiConstants.Util.getString(EXPORT_PROBLEM));
                    Object var9_8 = null;
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    try {
                        if (outputBufferWriter != null) {
                            outputBufferWriter.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                        break block23;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                try {
                    if (outputBufferWriter != null) {
                        outputBufferWriter.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return new File(fileNameString);
    }

    public String askUserForOutputFilename() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dlg = new FileDialog(shell, 8192);
        dlg.setFilterExtensions(new String[]{"*.txt", "*.*"});
        dlg.setText(UiConstants.Util.getString(EXPORT_SQL_DIALOG_TITLE));
        dlg.setFileName(UiConstants.Util.getString(EXPORT_DEFAULT_FILENAME));
        return dlg.open();
    }

    public String getSqlOutputString(ModelResource modelResource) throws ModelWorkspaceException {
        List transformations = modelResource.getModelTransformations().getTransformations();
        int nTransforms = transformations.size();
        int initBufferSize = nTransforms * 200;
        StringBuffer sb = new StringBuffer(initBufferSize);
        String relativeTablePath = null;
        ArrayList<String> invalidQueries = new ArrayList<String>();
        Iterator iter = transformations.iterator();
        while (iter.hasNext()) {
            Collection eResources;
            String uuidString;
            boolean tableSupportsUpdates;
            String uuidString2;
            Object obj = iter.next();
            String rowString = null;
            if (!(obj instanceof SqlTransformationMappingRoot)) continue;
            EObject table = ((SqlTransformationMappingRoot)obj).getTarget();
            relativeTablePath = ModelerCore.getModelEditor().getModelRelativePath(table).toString();
            String userString = TransformationHelper.getSelectSqlString(obj);
            if (userString == null && (uuidString2 = TransformationHelper.getUUIDSqlString(obj, (int)0)) != null) {
                Collection eResources2 = this.getImportedResources(modelResource);
                userString = SqlConverter.convertUUIDsToFullNames((String)uuidString2, (Collection)eResources2);
            }
            if ((userString = SqlUtil.normalize((String)userString)) != null && relativeTablePath != null) {
                rowString = this.createRowForFile(0, relativeTablePath, userString);
                if (rowString != null && rowString.length() > 0) {
                    sb.append(rowString);
                }
            } else {
                invalidQueries.add(relativeTablePath);
            }
            if (!(tableSupportsUpdates = TransformationHelper.tableSupportsUpdate((EObject)table))) continue;
            if (TransformationHelper.supportsInsert((EObject)((EObject)obj), null)) {
                userString = TransformationHelper.getInsertSqlString(obj);
                if (userString == null && (uuidString = TransformationHelper.getUUIDSqlString(obj, (int)1)) != null) {
                    eResources = this.getImportedResources(modelResource);
                    userString = SqlConverter.convertUUIDsToFullNames((String)uuidString, (Collection)eResources);
                }
                if ((userString = SqlUtil.normalize((String)userString)) != null && relativeTablePath != null) {
                    rowString = this.createRowForFile(1, relativeTablePath, userString);
                    if (rowString != null && rowString.length() > 0) {
                        sb.append(rowString);
                    }
                } else {
                    invalidQueries.add(relativeTablePath);
                }
            }
            if (TransformationHelper.supportsUpdate((EObject)((EObject)obj), null)) {
                userString = TransformationHelper.getUpdateSqlString(obj);
                if (userString == null && (uuidString = TransformationHelper.getUUIDSqlString(obj, (int)2)) != null) {
                    eResources = this.getImportedResources(modelResource);
                    userString = SqlConverter.convertUUIDsToFullNames((String)uuidString, (Collection)eResources);
                }
                if ((userString = SqlUtil.normalize((String)userString)) != null && relativeTablePath != null) {
                    rowString = this.createRowForFile(2, relativeTablePath, userString);
                    if (rowString != null && rowString.length() > 0) {
                        sb.append(rowString);
                    }
                } else {
                    invalidQueries.add(relativeTablePath);
                }
            }
            if (!TransformationHelper.supportsDelete((EObject)((EObject)obj), null)) continue;
            userString = TransformationHelper.getDeleteSqlString(obj);
            if (userString == null && (uuidString = TransformationHelper.getUUIDSqlString(obj, (int)3)) != null) {
                eResources = this.getImportedResources(modelResource);
                userString = SqlConverter.convertUUIDsToFullNames((String)uuidString, (Collection)eResources);
            }
            if ((userString = SqlUtil.normalize((String)userString)) != null && relativeTablePath != null) {
                rowString = this.createRowForFile(3, relativeTablePath, userString);
                if (rowString == null || rowString.length() <= 0) continue;
                sb.append(rowString);
                continue;
            }
            invalidQueries.add(relativeTablePath);
        }
        if (!invalidQueries.isEmpty()) {
            UiConstants.Util.log(4, UiConstants.Util.getString("ExportTransformationSqlToTextAction.exportQueryProblem", (Object)modelResource.getItemName()));
        }
        return sb.toString();
    }

    private Collection getImportedResources(ModelResource modelResource) {
        return ModelUtilities.getResourcesUsedBy((ModelResource)modelResource);
    }

    private String createRowForFile(int sqlType, String relativeTablePath, String theSql) {
        StringBuffer sb = new StringBuffer(relativeTablePath.length() + theSql.length() + 20);
        sb.append(relativeTablePath).append('|').append(this.getSqlTypeString(sqlType)).append('|').append(theSql).append('\r');
        return sb.toString();
    }

    private String getSqlTypeString(int sqlType) {
        switch (sqlType) {
            case 0: {
                return "SELECT";
            }
            case 1: {
                return "INSERT";
            }
            case 2: {
                return "UPDATE";
            }
            case 3: {
                return "DELETE";
            }
        }
        return "UNKNOWN";
    }
}

