/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix.sqli;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.informix.InformixImplConnection;
import com.metamatrix.jdbc.informix.InformixLocalMessages;
import com.metamatrix.jdbc.informix.sqli.InformixSQLISmartLob;
import com.metamatrix.util.UtilBufferedDataConsumer;
import com.metamatrix.util.UtilBufferedDataProvider;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilDataConsumer;
import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSocketDataConsumer;
import com.metamatrix.util.UtilSocketDataProvider;
import com.metamatrix.util.UtilTransliterator;
import java.net.Socket;
import java.sql.SQLException;

public class InformixSQLICommunication {
    private static String footprint = "$Revision:   3.7.3.0  $";
    public Socket socket;
    UtilBufferedDataConsumer bufferedConsumer;
    private UtilByteOrderedDataReader reader;
    private UtilByteOrderedDataWriter writer;
    public UtilTransliterator backendTransliterator;
    public InformixSQLISmartLob smartLob = new InformixSQLISmartLob();
    private InformixImplConnection implConnection;
    public BaseExceptions exceptions;
    public BaseWarnings warnings;
    public boolean debugWireProtocol;

    public InformixSQLICommunication(Socket socket, InformixImplConnection informixImplConnection, boolean bl) throws SQLException {
        this.socket = socket;
        this.implConnection = informixImplConnection;
        this.debugWireProtocol = bl;
        this.exceptions = informixImplConnection.exceptions;
        this.warnings = informixImplConnection.warnings;
        UtilSocketDataProvider utilSocketDataProvider = new UtilSocketDataProvider(socket);
        UtilBufferedDataProvider utilBufferedDataProvider = new UtilBufferedDataProvider((UtilDataProvider)utilSocketDataProvider);
        this.reader = new UtilByteOrderedDataReader((UtilDataProvider)utilBufferedDataProvider);
        UtilSocketDataConsumer utilSocketDataConsumer = new UtilSocketDataConsumer(socket);
        this.bufferedConsumer = new UtilBufferedDataConsumer((UtilDataConsumer)utilSocketDataConsumer);
        this.writer = new UtilByteOrderedDataWriter((UtilDataConsumer)this.bufferedConsumer);
    }

    public InformixImplConnection getImplConnection() {
        return this.implConnection;
    }

    public void close() throws SQLException {
        try {
            this.socket.close();
            this.reader = null;
            this.writer = null;
        }
        catch (Exception exception) {
            throw this.exceptions.getException(InformixLocalMessages.CANNOT_CLOSE_SOCKET, null, "08001");
        }
    }

    String readNullTermString() throws UtilException {
        short s = this.reader.readInt16();
        String string = this.reader.readString((int)s);
        return s > 1 ? string.substring(0, s - 1) : "";
    }

    public void writeNullTermString(String string) throws UtilException {
        string = string + "\u0000";
        this.writer.writeStringWithLength16(string);
    }

    public String readString() throws UtilException {
        short s = this.reader.readInt16();
        String string = this.reader.readString((int)s);
        if (s % 2 == 1) {
            this.reader.readInt8();
        }
        return string;
    }

    public byte[] readBytesForString(int n) throws UtilException {
        byte[] byArray = new byte[n];
        this.reader.readBytes(byArray, 0, n);
        if (n % 2 == 1) {
            this.reader.readInt8();
        }
        return byArray;
    }

    public String readString(int n) throws UtilException {
        String string = this.reader.readString(n);
        if (n % 2 == 1) {
            this.reader.readInt8();
        }
        return string;
    }

    public void writeString(String string) throws UtilException {
        int n = this.writer.writeStringWithLength16(string);
        if (n % 2 == 1) {
            this.writer.writeInt8(0);
        }
    }

    public UtilByteOrderedDataReader getReader() {
        return this.reader;
    }

    public UtilByteOrderedDataWriter getWriter() {
        return this.writer;
    }

    public InformixSQLISmartLob getSmartLob() {
        return this.smartLob;
    }

    public void setBackendTransliterator(UtilTransliterator utilTransliterator) {
        utilTransliterator.setCacheSize(2000);
        this.writer.setTransliterator(utilTransliterator);
        this.reader.setTransliterator(utilTransliterator);
        this.backendTransliterator = utilTransliterator;
    }
}

