/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.dqp.ui.config;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.core.PluginUtil;
import com.metamatrix.modeler.dqp.DqpPlugin;
import com.metamatrix.modeler.internal.dqp.ui.config.DqpFileImporter;
import java.io.File;
import java.util.HashSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DqpCafFileImporter
extends DqpFileImporter {
    public DqpCafFileImporter(PluginUtil UTIL, Shell shell) {
        super(UTIL, shell);
    }

    public boolean importFile(File fileToImport) {
        return this.importCAF(fileToImport);
    }

    private boolean importCAF(File cafFile) {
        boolean bImported = false;
        ConnectorArchive archive = this.createConnectorArchive(cafFile);
        if (archive != null) {
            bImported = this.writeJarFilesToExtensionFolder(archive) && this.importCAFConnectorBindingType(archive);
        }
        return bImported;
    }

    private ExtensionModule[] getAllExtensionModules(ConnectorArchive archive) {
        HashSet<ExtensionModule> set = new HashSet<ExtensionModule>();
        ConnectorBindingType[] types = archive.getConnectorTypes();
        for (int i = 0; i < types.length; ++i) {
            ExtensionModule[] modules = archive.getExtensionModules(types[i]);
            for (int m = 0; m < modules.length; ++m) {
                set.add(modules[m]);
            }
        }
        return set.toArray(new ExtensionModule[set.size()]);
    }

    private boolean writeJarFilesToExtensionFolder(ConnectorArchive archive) {
        boolean bJarFilesMoved = true;
        ExtensionModule[] extModules = this.getAllExtensionModules(archive);
        for (int idx = 0; idx < extModules.length; ++idx) {
            boolean isJarReadyToWrite = this.isJarReadyToWrite(extModules[idx].getFullName());
            if (!isJarReadyToWrite) continue;
            try {
                DqpPlugin.getInstance().writeCAFJarFileToExtensionFolder(extModules[idx]);
                continue;
            }
            catch (Exception e) {
                this.UTIL.log((Throwable)e);
                String title = this.UTIL.getString("ImportAction.extensionFileCopyErrorTitle");
                String message = this.UTIL.getString("ImportAction.extensionFileCopyErrorMessage", (Object)extModules[idx].getFullName());
                MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
                bJarFilesMoved = false;
            }
        }
        return bJarFilesMoved;
    }

    private boolean isJarReadyToWrite(String jarName) {
        boolean isJarExist = true;
        File xFile = new File(jarName);
        if (DqpPlugin.getInstance().extensionsFileExists(xFile)) {
            String title = this.UTIL.getString("ImportAction.overwriteFileTitle");
            String message = this.UTIL.getString("ImportAction.overwriteFileMessage", (Object)xFile.getName());
            isJarExist = MessageDialog.openQuestion((Shell)this.shell, (String)title, (String)message);
        }
        return isJarExist;
    }

    private boolean importCAFConnectorBindingType(ConnectorArchive archive) {
        boolean bImported = false;
        try {
            ConnectorBindingType[] types = archive.getConnectorTypes();
            types = this.checkForOverwrites(types);
            this.getConfigMgr().addConnectorType((ComponentType[])types, true);
            bImported = true;
        }
        catch (Exception e) {
            this.UTIL.log((Throwable)e);
            String title = this.UTIL.getString("ImportAction.typeImportErrorTitle");
            String message = this.UTIL.getString("ImportAction.typeImportErrorMessage");
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
            bImported = false;
        }
        return bImported;
    }

    private ConnectorBindingType[] checkForOverwrites(ConnectorBindingType[] types) {
        ConnectorBindingType[] result = new ConnectorBindingType[types.length];
        int count = 0;
        for (int i = 0; i < types.length; ++i) {
            ConnectorBindingType type = types[i];
            boolean exists = this.getConfigMgr().getDefaultConfig().isConnectorTypeAlreadyExist((ComponentType)type);
            boolean doAdd = true;
            if (exists) {
                String title = this.UTIL.getString("ImportAction.overwriteTypeTitle");
                String message = this.UTIL.getString("ImportAction.overwriteTypeMessage", (Object)type.getName());
                doAdd = MessageDialog.openQuestion((Shell)this.shell, (String)title, (String)message);
            }
            if (!doAdd) continue;
            result[count++] = type;
        }
        return result;
    }
}

