/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.oracle.OracleColumn;
import com.metamatrix.jdbc.oracle.OracleConnection;
import com.metamatrix.jdbc.oracle.OracleImplBlob;
import com.metamatrix.jdbc.oracle.OracleImplClob;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.OracleImplStatement;
import com.metamatrix.jdbc.oracle.OracleVNU;
import com.metamatrix.util.UtilException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.sql.SQLException;

public class OracleImplResultset
extends BaseImplResultSet {
    private static String footprint = "$Revision:   3.40.1.7  $";
    private static int[] powersOfTen = new int[]{0, 0, 1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 100000000, 1000000000};
    private short ResultSetsOraCid = 0;
    private int RSIndex;
    private BaseData reusablebasedata;
    private char[] valueAsString = null;
    private long NUM_NANOSECONDS_IN_SECOND = 1000000000L;
    private double NUM_NANOSECONDS_IN_DAY = 86400L * this.NUM_NANOSECONDS_IN_SECOND;
    public OracleConnection connection;
    private boolean isJavaDoubleToString;

    public int getColumnAccess() {
        return 2;
    }

    public OracleImplResultset(OracleConnection oracleConnection) {
        this.reusablebasedata = new BaseData((BaseConnection)oracleConnection);
        this.isJavaDoubleToString = oracleConnection.getIsJavaDoubleToString();
    }

    public void reset() {
        super.reset();
    }

    public void initialize(short s, int n) {
        this.RSIndex = n;
        this.ResultSetsOraCid = s;
    }

    protected boolean setupForNextResultSetInMultipleResult(int n) throws SQLException {
        return true;
    }

    public void writeBlob(RandomAccessFile randomAccessFile, BaseImplBlob baseImplBlob) throws SQLException, IOException {
        randomAccessFile.write(((OracleImplBlob)baseImplBlob).bloblocator);
        randomAccessFile.writeBoolean(((OracleImplBlob)baseImplBlob).CheckIsBFILE());
    }

    public BaseImplBlob readBlob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        byte[] byArray = new byte[86];
        int n = randomAccessFile.read(byArray);
        return new OracleImplBlob(byArray, (OracleImplStatement)this.implStatement, randomAccessFile.readBoolean());
    }

    public void writeClob(RandomAccessFile randomAccessFile, BaseImplClob baseImplClob) throws SQLException, IOException {
        randomAccessFile.write(((OracleImplClob)baseImplClob).cloblocator);
    }

    public BaseImplClob readClob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        byte[] byArray = new byte[86];
        int n = randomAccessFile.read(byArray);
        int n2 = ((byArray[32] & 0xFF) << 8) + (byArray[33] & 0xFF);
        return new OracleImplClob(byArray, (OracleImplStatement)this.implStatement, n2);
    }

    public BaseData getData(int n, int n2) throws SQLException {
        OracleImplStatement oracleImplStatement = (OracleImplStatement)this.implStatement;
        OracleColumn oracleColumn = (OracleColumn)oracleImplStatement.CurrentRSDescriptions[this.RSIndex][n - 1];
        if (oracleColumn.indicator != 0) {
            if (oracleImplStatement.databaseMetaDataResultSet != 0) {
                if (n == 1 && (oracleImplStatement.databaseMetaDataResultSet == 1 || oracleImplStatement.databaseMetaDataResultSet == 2 || oracleImplStatement.databaseMetaDataResultSet == 5 || oracleImplStatement.databaseMetaDataResultSet == 6 || oracleImplStatement.databaseMetaDataResultSet == 16 || oracleImplStatement.databaseMetaDataResultSet == 9 || oracleImplStatement.databaseMetaDataResultSet == 14 || oracleImplStatement.databaseMetaDataResultSet == 12 || oracleImplStatement.databaseMetaDataResultSet == 11 || oracleImplStatement.databaseMetaDataResultSet == 10 || oracleImplStatement.databaseMetaDataResultSet == 8 || oracleImplStatement.databaseMetaDataResultSet == 13)) {
                    this.reusablebasedata.setString("");
                    return this.reusablebasedata;
                }
                if (n == 5 && (oracleImplStatement.databaseMetaDataResultSet == 12 || oracleImplStatement.databaseMetaDataResultSet == 11 || oracleImplStatement.databaseMetaDataResultSet == 10)) {
                    this.reusablebasedata.setString("");
                    return this.reusablebasedata;
                }
            }
            switch (oracleColumn.OCINativeType) {
                case 12: {
                    this.reusablebasedata.setNull(108);
                    break;
                }
                case 180: {
                    this.reusablebasedata.setNull(109);
                    break;
                }
                case 181: {
                    this.reusablebasedata.setNull(110);
                    break;
                }
                case 231: {
                    this.reusablebasedata.setNull(111);
                    break;
                }
                default: {
                    this.reusablebasedata.setNull(n2);
                }
            }
            return this.reusablebasedata;
        }
        if (n == 5 && oracleImplStatement.databaseMetaDataResultSet == 2) {
            long l = OracleVNU.convertVNUToLong(oracleColumn.data, oracleColumn.len, this.exceptions);
            if (l == 1111L) {
                OracleColumn oracleColumn2 = (OracleColumn)oracleImplStatement.CurrentRSDescriptions[this.RSIndex][5];
                String string = null;
                try {
                    string = oracleColumn2.transliterator.decode(oracleColumn2.data, 0, oracleColumn2.len);
                }
                catch (UtilException utilException) {
                    throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException((Exception)((Object)utilException));
                }
                if (string.indexOf("TIMESTAMP") != -1) {
                    this.reusablebasedata.setLong(93L);
                } else {
                    this.reusablebasedata.setLong(l);
                }
            } else {
                this.reusablebasedata.setLong(l);
            }
            return this.reusablebasedata;
        }
        int n3 = 0;
        block9 : switch (oracleColumn.OCINativeType) {
            case 2: 
            case 6: {
                switch (n2) {
                    case 8: {
                        n3 = oracleColumn.scale;
                        if (oracleColumn.type == 8) {
                            n3 = -1;
                        } else if (oracleColumn.precision == 38 && oracleColumn.scale == 127 && ((OracleImplConnection)this.implStatement.implConnection).getNumberPrecisionScaleOption() == 1) {
                            n3 = 0;
                        }
                        this.reusablebasedata.setBigDecimal(OracleVNU.convertVNUToBigDecimal(oracleColumn.data, 0, oracleColumn.len, n3, (OracleImplConnection)this.implStatement.implConnection));
                        break block9;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: {
                        this.reusablebasedata.setLong(OracleVNU.convertVNUToLong(oracleColumn.data, oracleColumn.len, this.exceptions));
                        break block9;
                    }
                    case 6: 
                    case 7: {
                        this.reusablebasedata.setDouble(OracleVNU.convertVNUToDouble(oracleColumn.data, oracleColumn.len));
                        break block9;
                    }
                }
                if (oracleColumn.type == 8 || oracleColumn.type == 6) {
                    if (this.isJavaDoubleToString) {
                        this.reusablebasedata.setString(Double.toString(OracleVNU.convertVNUToDouble(oracleColumn.data, oracleColumn.len)));
                        break;
                    }
                    this.reusablebasedata.setString(OracleVNU.convertVNUToIEEEString(oracleColumn.data, 0, oracleColumn.len, (OracleImplConnection)this.implStatement.implConnection));
                    break;
                }
                n3 = oracleColumn.scale;
                if (oracleColumn.precision == 38 && oracleColumn.scale == 127 && ((OracleImplConnection)this.implStatement.implConnection).getNumberPrecisionScaleOption() == 1) {
                    n3 = 0;
                }
                this.reusablebasedata.setString(OracleVNU.convertVNUToString(oracleColumn.data, 0, oracleColumn.len, n3, (OracleImplConnection)this.implStatement.implConnection));
                break;
            }
            case 1: 
            case 11: 
            case 96: 
            case 104: {
                try {
                    this.reusablebasedata.setString(oracleColumn.transliterator.decode(oracleColumn.data, 0, oracleColumn.len));
                    break;
                }
                catch (UtilException utilException) {
                    throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException((Exception)((Object)utilException));
                }
            }
            case 8: {
                try {
                    this.reusablebasedata.setCharacterStreamReader(oracleColumn.transliterator.decodeAsReader((InputStream)new ByteArrayInputStream(oracleColumn.data, 0, oracleColumn.len)));
                    break;
                }
                catch (UtilException utilException) {
                    throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException((Exception)((Object)utilException));
                }
            }
            case 12: {
                this.reusablebasedata.setNativeBytes(oracleColumn.data, oracleColumn.len, 108);
                break;
            }
            case 180: {
                this.reusablebasedata.setNativeBytes(oracleColumn.data, oracleColumn.len, 109);
                break;
            }
            case 231: {
                this.reusablebasedata.setNativeOracleTimestampWithLocalTimeZone(oracleColumn.data, oracleColumn.len, ((OracleImplConnection)this.implStatement.implConnection).getTimeZoneHours(), ((OracleImplConnection)this.implStatement.implConnection).getTimeZoneMinutes());
                break;
            }
            case 181: {
                boolean bl = ((OracleImplConnection)this.implStatement.implConnection).FetchTSWTZasTimestamp;
                n3 = oracleColumn.precision - 20 - (bl ? 0 : 7);
                if (n3 < 0) {
                    n3 = 0;
                }
                this.reusablebasedata.setNativeOracleTimestampWithTimeZone(oracleColumn.data, oracleColumn.len, n3, bl);
                break;
            }
            case 23: {
                byte[] byArray = new byte[oracleColumn.len];
                System.arraycopy(oracleColumn.data, 0, byArray, 0, oracleColumn.len);
                this.reusablebasedata.setBytes(byArray);
                break;
            }
            case 24: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(oracleColumn.data, 0, oracleColumn.len);
                this.reusablebasedata.setBinaryStream((InputStream)byteArrayInputStream);
                break;
            }
            case 112: {
                if (oracleColumn.charSetId == 0) {
                    oracleColumn.charSetId = oracleColumn.charSetForm == 1 ? (int)((OracleImplConnection)this.implStatement.implConnection).originalReportedOraCharset : (int)((OracleImplConnection)this.implStatement.implConnection).originalReportedOraNCharset;
                }
                OracleImplClob oracleImplClob = new OracleImplClob(oracleColumn.data, oracleImplStatement, oracleColumn.charSetId);
                this.reusablebasedata.setClob((BaseImplClob)oracleImplClob);
                break;
            }
            case 109: {
                if (oracleColumn.charSetId == 0) {
                    oracleColumn.charSetId = oracleColumn.charSetForm == 1 ? (int)((OracleImplConnection)this.implStatement.implConnection).originalReportedOraCharset : (int)((OracleImplConnection)this.implStatement.implConnection).originalReportedOraNCharset;
                }
                this.reusablebasedata.setClob((BaseImplClob)new OracleImplClob(oracleColumn.data, oracleImplStatement, ((OracleImplConnection)this.implStatement.implConnection).currentOraCharset));
                break;
            }
            case 113: {
                this.reusablebasedata.setBlob((BaseImplBlob)new OracleImplBlob(oracleColumn.data, oracleImplStatement));
                break;
            }
            case 114: {
                this.reusablebasedata.setBlob((BaseImplBlob)new OracleImplBlob(oracleColumn.data, oracleImplStatement, true));
                break;
            }
            case 100: {
                int n4 = oracleColumn.data[0];
                int n5 = oracleColumn.data[1];
                int n6 = oracleColumn.data[2];
                int n7 = oracleColumn.data[3];
                if ((n4 & 0x80) != 0) {
                    n4 &= 0x7F;
                    n5 &= 0xFF;
                    n6 &= 0xFF;
                    n7 &= 0xFF;
                } else {
                    n4 = ~n4 & 0xFF;
                    n5 = ~n5 & 0xFF;
                    n6 = ~n6 & 0xFF;
                    n7 = ~n7 & 0xFF;
                }
                int n8 = n4 << 24 | n5 << 16 | n6 << 8 | n7;
                this.reusablebasedata.setFloat(Float.intBitsToFloat(n8));
                break;
            }
            case 101: {
                int n9 = oracleColumn.data[0];
                int n10 = oracleColumn.data[1];
                int n11 = oracleColumn.data[2];
                int n12 = oracleColumn.data[3];
                int n13 = oracleColumn.data[4];
                int n14 = oracleColumn.data[5];
                int n15 = oracleColumn.data[6];
                int n16 = oracleColumn.data[7];
                if ((n9 & 0x80) != 0) {
                    n9 &= 0x7F;
                    n10 &= 0xFF;
                    n11 &= 0xFF;
                    n12 &= 0xFF;
                    n13 &= 0xFF;
                    n14 &= 0xFF;
                    n15 &= 0xFF;
                    n16 &= 0xFF;
                } else {
                    n9 = ~n9 & 0xFF;
                    n10 = ~n10 & 0xFF;
                    n11 = ~n11 & 0xFF;
                    n12 = ~n12 & 0xFF;
                    n13 = ~n13 & 0xFF;
                    n14 = ~n14 & 0xFF;
                    n15 = ~n15 & 0xFF;
                    n16 = ~n16 & 0xFF;
                }
                int n17 = n9 << 24 | n10 << 16 | n11 << 8 | n12;
                int n18 = n13 << 24 | n14 << 16 | n15 << 8 | n16;
                long l = (long)n17 << 32 | (long)n18 & 0xFFFFFFFFL;
                this.reusablebasedata.setDouble(Double.longBitsToDouble(l));
                break;
            }
            case 183: {
                int n19 = oracleColumn.data[0] & 0xFF;
                int n20 = oracleColumn.data[1] & 0xFF;
                int n21 = oracleColumn.data[2] & 0xFF;
                int n22 = oracleColumn.data[3] & 0xFF;
                int n23 = n19 << 24 | n20 << 16 | n21 << 8 | n22;
                n23 -= Integer.MIN_VALUE;
                int n24 = oracleColumn.data[4] - 60;
                int n25 = oracleColumn.data[5] - 60;
                int n26 = oracleColumn.data[6] - 60;
                int n27 = oracleColumn.data[7] & 0xFF;
                int n28 = oracleColumn.data[8] & 0xFF;
                int n29 = oracleColumn.data[9] & 0xFF;
                int n30 = oracleColumn.data[10] & 0xFF;
                int n31 = n27 << 24 | n28 << 16 | n29 << 8 | n30;
                long l = (long)(n24 * 60 * 60) * this.NUM_NANOSECONDS_IN_SECOND + (long)(n25 * 60) * this.NUM_NANOSECONDS_IN_SECOND + (long)n26 * this.NUM_NANOSECONDS_IN_SECOND + (long)(n31 -= Integer.MIN_VALUE);
                double d = (double)l / this.NUM_NANOSECONDS_IN_DAY;
                this.reusablebasedata.setBigDecimal(new BigDecimal((double)n23 + d));
                break;
            }
            case 182: {
                throw ((OracleImplStatement)this.implStatement).comm.exceptions.getException(7042);
            }
        }
        return this.reusablebasedata;
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        OracleImplStatement oracleImplStatement = (OracleImplStatement)this.implStatement;
        return oracleImplStatement.fetchNext2(false, this.RSIndex, null);
    }

    public void close() throws SQLException {
        OracleImplStatement oracleImplStatement = (OracleImplStatement)this.implStatement;
        if (this.ResultSetsOraCid != 0) {
            oracleImplStatement.closeResultset(this.ResultSetsOraCid, this.RSIndex);
            this.ResultSetsOraCid = 0;
        }
        super.close();
    }
}

