/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.jdbc.ui.wizards;

import com.metamatrix.core.event.IChangeListener;
import com.metamatrix.core.event.IChangeNotifier;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.Stopwatch;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.compare.ui.wizard.IDifferencingWizard;
import com.metamatrix.modeler.compare.ui.wizard.ShowDifferencesPage;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.notification.util.DefaultIgnorableNotificationSource;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.jdbc.relational.JdbcImporter;
import com.metamatrix.modeler.internal.jdbc.relational.util.JdbcRelationalUtil;
import com.metamatrix.modeler.internal.jdbc.ui.util.JdbcUiUtil;
import com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportMetadataPage;
import com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportObjectsPage;
import com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportOptionsPage;
import com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcSourceSelectionPage;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.relational.JdbcRelationalPlugin;
import com.metamatrix.modeler.jdbc.relational.RelationalModelProcessor;
import com.metamatrix.modeler.jdbc.relational.impl.RelationalModelProcessorImpl;
import com.metamatrix.modeler.jdbc.ui.ModelerJdbcUiConstants;
import com.metamatrix.modeler.jdbc.ui.wizards.IJdbcImportInfoProvider;
import com.metamatrix.modeler.jdbc.ui.wizards.IJdbcImportPostProcessor;
import com.metamatrix.modeler.ui.UiConstants;
import com.metamatrix.modeler.ui.UiPlugin;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.ui.internal.product.ProductCustomizerMgr;
import com.metamatrix.ui.internal.util.WidgetUtil;
import com.metamatrix.ui.internal.wizard.AbstractWizard;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class JdbcImportWizard
extends AbstractWizard
implements IDifferencingWizard,
IJdbcImportInfoProvider,
ModelerJdbcUiConstants,
ModelerJdbcUiConstants.Images,
UiConstants.ProductInfo,
UiConstants.ProductInfo.Capabilities {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportWizard == null ? (class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportWizard = JdbcImportWizard.class$("com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportWizard")) : class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportWizard));
    private static final String TITLE = JdbcImportWizard.getString("title");
    private static final String PAGE_TITLE = JdbcImportWizard.getString("pageTitle");
    private static final ImageDescriptor IMAGE = UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importDatabase.gif");
    private static final String COPY_ERROR_MESSAGE = JdbcImportWizard.getString("copyErrorMessage");
    private static final String IMPORT_ERROR_MESSAGE = JdbcImportWizard.getString("importErrorMessage");
    private static final String NOT_LICENSED_MSG = JdbcImportWizard.getString("notLicensedMessage");
    private static final String UNDERSCORE_ONE = "_";
    private static final String UNDERSCORE_TWO = "__";
    private static boolean importLicensed = false;
    private static boolean runOnce = false;
    private JdbcImporter importer;
    private IContainer folder;
    private String modelName;
    private IStatus status;
    private JdbcSourceSelectionPage srcPg;
    private JdbcImportOptionsPage optionsPg;
    private ShowDifferencesPage diffsPg;
    private DifferenceReport drDifferenceReport;
    private ProcessorPack ppProcessorPack;
    private boolean debugTimingEnabled = ModelerJdbcUiConstants.Util.isDebugEnabled("jdbcImportTiming");
    private boolean controlsHaveBeenCreated = false;
    private IJdbcImportPostProcessor[] postProcessors;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportWizard;

    private static String getString(String id) {
        return ModelerJdbcUiConstants.Util.getString(I18N_PREFIX + id);
    }

    public JdbcImportWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, IMAGE);
    }

    public boolean canFinish() {
        boolean bCanFinish = false;
        boolean bUpdateSelected = false;
        if (this.optionsPg != null) {
            bUpdateSelected = this.optionsPg.updateSelected();
        }
        boolean bDiffsDisplayed = false;
        if (this.diffsPg != null) {
            bDiffsDisplayed = this.diffsPg.isVisible();
        }
        boolean bUpdateStepsPending = false;
        if (bUpdateSelected && !bDiffsDisplayed) {
            bUpdateStepsPending = true;
        }
        bCanFinish = super.canFinish() && this.getFolder() != null && !bUpdateStepsPending;
        return bCanFinish;
    }

    protected void connectionEstablished() {
    }

    protected ShowDifferencesPage createDifferencesPage() {
        return new ShowDifferencesPage((IDifferencingWizard)this);
    }

    private Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    protected IWizardPage createMetadataPage() {
        return new JdbcImportMetadataPage();
    }

    protected IWizardPage createObjectsPage() {
        return new JdbcImportObjectsPage();
    }

    protected JdbcImportOptionsPage createOptionsPage() {
        return new JdbcImportOptionsPage();
    }

    public void createPageControls(Composite pageContainer) {
        if (importLicensed) {
            super.createPageControls(pageContainer);
        }
        this.controlsHaveBeenCreated = true;
    }

    public void dispose() {
        if (importLicensed) {
            try {
                this.importer.disconnect();
            }
            catch (SQLException err) {
                JdbcUiUtil.showAccessError((Throwable)err);
            }
        }
        super.dispose();
    }

    public boolean finish() {
        if (!this.srcPg.connect()) {
            return false;
        }
        boolean result = false;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Changing Sql Connections", (Object)new DefaultIgnorableNotificationSource((Object)JdbcImportWizard.this));
                boolean succeeded = false;
                try {
                    JdbcImportWizard.this.runFinish(monitor);
                    succeeded = true;
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            switch (this.status.getSeverity()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    ModelerJdbcUiConstants.Util.log(this.status);
                    WidgetUtil.showError((String)IMPORT_ERROR_MESSAGE);
                }
            }
            result = true;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            JdbcUiUtil.showError((Throwable)err, (String)IMPORT_ERROR_MESSAGE);
        }
        return result;
    }

    public JdbcDatabase getDatabase() {
        return this.importer.getDatabase();
    }

    public List getDifferenceReports() {
        ArrayList<DifferenceReport> result = new ArrayList<DifferenceReport>();
        if (this.drDifferenceReport == null) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        JdbcSource src = JdbcImportWizard.this.getSource();
                        RelationalModelProcessor processor = JdbcRelationalPlugin.createRelationalModelProcessor((JdbcSource)src);
                        processor.setMoveRatherThanCopyAdds(!JdbcImportWizard.this.isUpdatedModel());
                        IFile modelFile = JdbcImportWizard.this.getFolder().getFile((IPath)new Path(JdbcImportWizard.this.getModelName()));
                        ModelResource resrc = ModelerCore.create((IFile)modelFile);
                        ModelAnnotation modelAnnotation = resrc.getModelAnnotation();
                        modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                        modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
                        if (resrc instanceof ModelResourceImpl) {
                            ((ModelResourceImpl)resrc).setModelType(ModelType.PHYSICAL_LITERAL);
                        }
                        if (processor != null && processor instanceof RelationalModelProcessorImpl) {
                            JdbcImportWizard.this.drDifferenceReport = ((RelationalModelProcessorImpl)processor).generateDifferenceReport(resrc, JdbcImportWizard.this.getDatabase(), src.getImportSettings(), monitor);
                        }
                        JdbcImportWizard.this.ppProcessorPack = new ProcessorPack(processor, src, modelFile, resrc);
                    }
                    catch (OperationCanceledException err) {
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            }
            catch (Throwable err) {
                if (err instanceof InvocationTargetException) {
                    err = ((InvocationTargetException)err).getTargetException();
                }
                JdbcUiUtil.showError((Throwable)err, (String)IMPORT_ERROR_MESSAGE);
            }
        }
        if (this.drDifferenceReport != null) {
            result.add(this.drDifferenceReport);
        }
        return result;
    }

    IContainer getFolder() {
        return this.folder;
    }

    private IJdbcImportInfoProvider getImportInfoProvider() {
        return this;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getPassword() {
        String result = null;
        IWizardPage[] pages = this.getPages();
        if (pages != null) {
            for (int i = 0; i < pages.length; ++i) {
                if (!(pages[i] instanceof JdbcSourceSelectionPage)) continue;
                result = ((JdbcSourceSelectionPage)pages[i]).getPassword();
                break;
            }
        }
        return result;
    }

    private IJdbcImportPostProcessor[] getPostProcessors() {
        if (this.postProcessors == null) {
            String EXT_PT = "jdbcImportPostProcessor";
            String CLASS_ATTR = "name";
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ModelerJdbcUiConstants.PLUGIN_ID, "jdbcImportPostProcessor");
            if (extensionPoint == null) {
                ModelerJdbcUiConstants.Util.log(4, ModelerJdbcUiConstants.Util.getString(I18N_PREFIX + "noExtensionPointFound", (Object)"jdbcImportPostProcessor"));
                this.postProcessors = new IJdbcImportPostProcessor[0];
                return this.postProcessors;
            }
            try {
                IExtension[] extensions = extensionPoint.getExtensions();
                if (extensions.length != 0) {
                    ArrayList<Object> temp = new ArrayList<Object>(extensions.length);
                    for (int i = 0; i < extensions.length; ++i) {
                        IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                        for (int j = 0; j < elements.length; ++j) {
                            Object[] params;
                            try {
                                Object obj = elements[j].createExecutableExtension("name");
                                if (obj instanceof IJdbcImportPostProcessor) {
                                    temp.add(obj);
                                    continue;
                                }
                                params = new Object[]{obj.getClass(), elements[j].getDeclaringExtension().getUniqueIdentifier()};
                                ModelerJdbcUiConstants.Util.log(4, ModelerJdbcUiConstants.Util.getString(I18N_PREFIX + "incorrectClass", params));
                                continue;
                            }
                            catch (Exception theException) {
                                params = new Object[]{elements[j].getAttribute("name"), elements[j].getDeclaringExtension().getUniqueIdentifier()};
                                ModelerJdbcUiConstants.Util.log(4, ModelerJdbcUiConstants.Util.getString(I18N_PREFIX + "initError", params));
                            }
                        }
                    }
                    this.postProcessors = new IJdbcImportPostProcessor[temp.size()];
                    temp.toArray(this.postProcessors);
                } else {
                    this.postProcessors = new IJdbcImportPostProcessor[0];
                }
            }
            catch (Exception theException) {
                ModelerJdbcUiConstants.Util.log(4, (Throwable)theException, ModelerJdbcUiConstants.Util.getString(I18N_PREFIX + "unexpectedErrorProcessingExtensions", (Object)"jdbcImportPostProcessor"));
                this.postProcessors = new IJdbcImportPostProcessor[0];
            }
        }
        return this.postProcessors;
    }

    public JdbcSource getSource() {
        return this.importer.getSource();
    }

    public void init(IWorkbench workbench, IStructuredSelection inputSelection) {
        IStructuredSelection selection = inputSelection;
        if (ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            selection = new StructuredSelection((Object)ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject());
        }
        if (!runOnce) {
            runOnce = true;
            importLicensed = UiPlugin.getDefault().isModelerCapabilityLicensed("Importer/JDBC");
        }
        if (importLicensed) {
            block15: {
                this.importer = new JdbcImporter();
                if (selection != null && !selection.isEmpty()) {
                    Object obj = selection.getFirstElement();
                    IContainer folder = ModelUtil.getContainer((Object)obj);
                    try {
                        if (folder != null && folder.getProject().getNature("com.metamatrix.modeler.core.modelNature") != null) {
                            this.folder = folder;
                        }
                    }
                    catch (CoreException err) {
                        ModelerJdbcUiConstants.Util.log((Throwable)err);
                        WidgetUtil.showError((Throwable)err);
                    }
                    ModelResource model = null;
                    try {
                        model = JdbcRelationalUtil.getPhysicalModifiableRelationalModel((Object)obj);
                        if (model == null) break block15;
                        Iterator iter = model.getAllRootEObjects().iterator();
                        while (iter.hasNext()) {
                            if (!(iter.next() instanceof JdbcSource)) continue;
                            this.importer.setUpdatedModel(model);
                            String name = FileUtils.getFilenameWithoutExtension((String)model.getItemName());
                            String validName = CoreValidationRulesUtil.getValidString((String)name, null, (int)-1);
                            if (validName != null) {
                                name = validName;
                                while (name.indexOf(UNDERSCORE_TWO) > -1) {
                                    name = name.replaceAll(UNDERSCORE_TWO, UNDERSCORE_ONE);
                                }
                            }
                            this.modelName = validName;
                            break;
                        }
                    }
                    catch (ModelWorkspaceException err) {
                        if (model != null && !model.hasErrors()) {
                            ModelerJdbcUiConstants.Util.log((Throwable)err);
                        }
                        WidgetUtil.showError((Throwable)err);
                    }
                }
            }
            this.srcPg = new JdbcSourceSelectionPage(this.importer.getSource());
            this.srcPg.addChangeListener(new IChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(IChangeNotifier notifier) {
                    if (JdbcImportWizard.this.controlsHaveBeenCreated) {
                        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Changing Sql Connections", (Object)this);
                        boolean succeeded = false;
                        try {
                            JdbcImportWizard.this.sqlConnectionChanged(JdbcImportWizard.this.srcPg);
                            succeeded = true;
                        }
                        finally {
                            if (started) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                        }
                    }
                }
            });
            this.optionsPg = this.createOptionsPage();
            if (this.importer.getUpdatedModel() != null) {
                this.optionsPg.setPageComplete(false);
            }
            this.diffsPg = this.createDifferencesPage();
            this.addPage((IWizardPage)this.srcPg);
            this.addPage(this.createMetadataPage());
            this.addPage(this.createObjectsPage());
            this.addPage((IWizardPage)this.optionsPg);
            this.addPage((IWizardPage)this.diffsPg);
        } else {
            WizardPage page = new WizardPage(ClassUtil.getSimpleClassName((Class)(class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportWizard == null ? (class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportWizard = JdbcImportWizard.class$("com.metamatrix.modeler.internal.jdbc.ui.wizards.JdbcImportWizard")) : class$com$metamatrix$modeler$internal$jdbc$ui$wizards$JdbcImportWizard)), PAGE_TITLE, null){

                public void createControl(Composite parent) {
                    this.setControl((Control)JdbcImportWizard.this.createEmptyPageControl(parent));
                }
            };
            page.setMessage(NOT_LICENSED_MSG, 3);
            page.setPageComplete(false);
            this.addPage((IWizardPage)page);
        }
    }

    boolean isUpdatedModel() {
        return this.importer.getUpdatedModel() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runFinish(IProgressMonitor monitor) throws InvocationTargetException {
        Stopwatch totalWatch = new Stopwatch();
        totalWatch.start();
        Stopwatch sWatch = new Stopwatch();
        try {
            try {
                sWatch.start();
                if (this.ppProcessorPack == null) {
                    JdbcSource src = this.getSource();
                    RelationalModelProcessor processor = JdbcRelationalPlugin.createRelationalModelProcessor((JdbcSource)src);
                    processor.setDebugLogTiming(this.debugTimingEnabled);
                    processor.setMoveRatherThanCopyAdds(!this.isUpdatedModel());
                    IFile modelFile = this.getFolder().getFile((IPath)new Path(this.getModelName()));
                    ModelResource resrc = ModelerCore.create((IFile)modelFile);
                    ModelAnnotation modelAnnotation = resrc.getModelAnnotation();
                    modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                    modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
                    if (resrc instanceof ModelResourceImpl) {
                        ((ModelResourceImpl)resrc).setModelType(ModelType.PHYSICAL_LITERAL);
                    }
                    this.status = processor.execute(resrc, this.getDatabase(), src.getImportSettings(), monitor);
                    this.ppProcessorPack = new ProcessorPack(processor, src, modelFile, resrc);
                } else {
                    this.ppProcessorPack.getProcessor().setDebugLogTiming(this.debugTimingEnabled);
                    this.status = this.ppProcessorPack.getProcessor().execute(this.ppProcessorPack.getModelResource(), this.getDatabase(), this.ppProcessorPack.getJdbcSource().getImportSettings(), monitor);
                }
                sWatch.stop();
                if (this.debugTimingEnabled) {
                    Stopwatch.logTimedMessage((String)" JDBC Import Wizard:  Creating Model Processor - Delta ", (long)sWatch.getTotalDuration());
                }
                if (this.status.getSeverity() != 4) {
                    sWatch.start(true);
                    List objs = this.ppProcessorPack.getModelResource().getAllRootEObjects();
                    Iterator iter = objs.iterator();
                    while (iter.hasNext()) {
                        if (!(iter.next() instanceof JdbcSource)) continue;
                        iter.remove();
                        break;
                    }
                    this.ppProcessorPack.getJdbcSource().setJdbcDriver(null);
                    objs.add(this.ppProcessorPack.getJdbcSource());
                    sWatch.stop();
                    if (this.debugTimingEnabled) {
                        Stopwatch.logTimedMessage((String)" JDBC Import Wizard:  Updating Model Contents - Delta ", (long)sWatch.getTotalDuration());
                    }
                    sWatch.start(true);
                    this.ppProcessorPack.getModelResource().save(monitor, true);
                    sWatch.stop();
                    if (this.debugTimingEnabled) {
                        Stopwatch.logTimedMessage((String)" JDBC Import Wizard:  Saving Model - Delta ", (long)sWatch.getTotalDuration());
                    }
                    sWatch.start(true);
                    IResource resrc = this.folder.findMember(this.getModelName());
                    if (resrc != null) {
                        resrc.refreshLocal(2, monitor);
                    }
                    sWatch.stop();
                    if (this.debugTimingEnabled) {
                        Stopwatch.logTimedMessage((String)" JDBC Import Wizard:  Refreshing Local File - Delta ", (long)sWatch.getTotalDuration());
                    }
                    sWatch.start(true);
                    ModelEditorManager.activate((IFile)this.ppProcessorPack.getModelFile(), (boolean)true);
                    sWatch.stop();
                    if (this.debugTimingEnabled) {
                        Stopwatch.logTimedMessage((String)" JDBC Import Wizard:  Opening Model In Editor - Delta ", (long)sWatch.getTotalDuration());
                    }
                }
                if (this.status.getSeverity() != 4) {
                    IJdbcImportPostProcessor[] processors = this.getPostProcessors();
                    for (int i = 0; i < processors.length; ++i) {
                        try {
                            processors[i].postProcess(this.getImportInfoProvider());
                            continue;
                        }
                        catch (Exception theException) {
                            ModelerJdbcUiConstants.Util.log(4, ModelerJdbcUiConstants.Util.getString(I18N_PREFIX + "postProcessingError", processors[i].getClass()));
                        }
                    }
                }
                Object var10_13 = null;
            }
            catch (OperationCanceledException err) {
                Object var10_14 = null;
                monitor.done();
                this.ppProcessorPack = null;
                totalWatch.stop();
                if (!this.debugTimingEnabled) return;
                Stopwatch.logTimedMessage((String)" JDBC Import Wizard: finish() - Total ", (long)totalWatch.getTotalDuration());
                return;
            }
            catch (Exception err) {
                throw new InvocationTargetException(err);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            monitor.done();
            this.ppProcessorPack = null;
            totalWatch.stop();
            if (!this.debugTimingEnabled) throw throwable;
            Stopwatch.logTimedMessage((String)" JDBC Import Wizard: finish() - Total ", (long)totalWatch.getTotalDuration());
            throw throwable;
        }
        monitor.done();
        this.ppProcessorPack = null;
        totalWatch.stop();
        if (!this.debugTimingEnabled) return;
        Stopwatch.logTimedMessage((String)" JDBC Import Wizard: finish() - Total ", (long)totalWatch.getTotalDuration());
    }

    void setFolder(IContainer folder) {
        ArgCheck.isNotNull((Object)folder);
        this.folder = folder;
    }

    void setModelName(String name) {
        ArgCheck.isNotEmpty((String)name);
        this.modelName = name;
    }

    ModelResource getUpdatedModel() {
        return this.importer.getUpdatedModel();
    }

    void setUpdatedModel(ModelResource model) throws ModelWorkspaceException {
        this.importer.setUpdatedModel(model);
    }

    void sqlConnectionChanged(JdbcSourceSelectionPage page) {
        Connection sqlConnection = page.getConnection();
        if (sqlConnection == null) {
            this.importer.setDatabase(null);
            this.modelName = null;
        } else {
            try {
                JdbcSource src = (JdbcSource)ModelerCore.getModelEditor().copy((EObject)page.getSource());
                this.importer.setSource(src);
                JdbcDatabase db = JdbcPlugin.getJdbcDatabase((JdbcSource)src, (Connection)sqlConnection);
                JdbcPlugin.ensureNonNullImportSettings((JdbcSource)src);
                this.importer.setDatabase(db);
                if (this.getModelName() == null) {
                    String tempModelName = CoreValidationRulesUtil.getValidString((String)db.getName(), null, (int)-1);
                    if (tempModelName == null) {
                        tempModelName = db.getName();
                    }
                    String validName = tempModelName = FileUtils.toFileNameWithExtension((String)tempModelName, (String)".xmi");
                    while (validName.indexOf(UNDERSCORE_TWO) > -1) {
                        validName = validName.replaceAll(UNDERSCORE_TWO, UNDERSCORE_ONE);
                    }
                    tempModelName = validName;
                    if (!StringUtil.isEmpty((String)tempModelName) && ResourcesPlugin.getWorkspace().validateName(tempModelName, 1).isOK()) {
                        ModelResource model;
                        IResource resrc;
                        this.setModelName(tempModelName);
                        if (this.folder != null && (resrc = this.folder.findMember(tempModelName)) != null && (model = JdbcRelationalUtil.getPhysicalModifiableRelationalModel((Object)resrc)) != null) {
                            this.importer.setUpdatedModel(model);
                            this.optionsPg.setPageComplete(false);
                        }
                    }
                }
                this.connectionEstablished();
            }
            catch (Exception err) {
                JdbcUiUtil.showError((Throwable)err, (String)COPY_ERROR_MESSAGE);
            }
        }
        this.getContainer().updateButtons();
    }

    JdbcNode findNode(IPath path, JdbcNode parent) throws JdbcException {
        return this.importer.findNode(path, parent);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ProcessorPack {
        private RelationalModelProcessor rmpProcessor;
        private JdbcSource src;
        private IFile modelFile;
        private ModelResource resrc;

        public ProcessorPack() {
        }

        public ProcessorPack(RelationalModelProcessor rmpProcessor, JdbcSource src, IFile modelFile, ModelResource resrc) {
            this.rmpProcessor = rmpProcessor;
            this.src = src;
            this.modelFile = modelFile;
            this.resrc = resrc;
        }

        public void setProcessor(RelationalModelProcessor rmpProcessor) {
            this.rmpProcessor = rmpProcessor;
        }

        public RelationalModelProcessor getProcessor() {
            return this.rmpProcessor;
        }

        public void setJdbcSource(JdbcSource src) {
            this.src = src;
        }

        public JdbcSource getJdbcSource() {
            return this.src;
        }

        public void setModelFile(IFile modelFile) {
            this.modelFile = modelFile;
        }

        public IFile getModelFile() {
            return this.modelFile;
        }

        public void setModelResource(ModelResource resrc) {
            this.resrc = resrc;
        }

        public ModelResource getModelResource() {
            return this.resrc;
        }
    }
}

