/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix.sqli;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.jdbc.informix.InformixColumn;
import com.metamatrix.jdbc.informix.InformixColumns;
import com.metamatrix.jdbc.informix.InformixImplConnection;
import com.metamatrix.jdbc.informix.InformixImplStatement;
import com.metamatrix.jdbc.informix.InformixLocalMessages;
import com.metamatrix.jdbc.informix.InformixParameter;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIDefine;
import com.metamatrix.util.UtilByteArrayDataProvider;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class InformixSQLIRequest
extends InformixSQLIDefine {
    private static String footprint = "$Revision:   3.14.1.3  $";
    protected InformixSQLICommunication comm;
    protected InformixImplStatement statement = null;
    public UtilByteOrderedDataReader reader = null;
    public UtilByteOrderedDataWriter writer = null;
    protected UtilByteOrderedDataReader tupleReader;
    public byte[] tupleBuffer = null;
    public int tupleBufferSize = 0;
    public int[] tupleSizes = null;
    public int tupleWriteOffset;
    public int numRowsFetched = 0;
    public int numRowsProcessed = 0;
    public int rowsPositionInBuffer = 0;
    public int rowsInBuffer = 0;
    protected static final int defaultTupleBufferSize = 4096;
    public boolean rowIsBuilt;
    public BaseColumns columns = null;
    private int stmtId = -1;
    private int stmtType = 0;
    protected int fetchSize = 0;
    protected boolean hasError = false;
    protected int errCode = 0;
    protected String[] errArgs = null;
    protected String sqlState = null;
    String sql = null;
    protected int numColumns = 0;
    protected int numRows = 0;
    protected InformixParameter[] parameters;
    protected int numInputs = 0;
    protected boolean randomColumnAccess;
    protected boolean isAutoRelease = false;
    protected boolean isDone = false;
    protected boolean hasComplexTypes = false;
    public int token;
    protected boolean transactionLevelChanged = false;
    protected int transactionLevelEvent = 0;
    protected int transactionLevelNew = 0;
    protected int transactionLevelOld = 0;
    public int fastpathRoutineHandle;
    public int fastpathReturnParameter;

    public InformixSQLIRequest(InformixSQLICommunication informixSQLICommunication, InformixImplStatement informixImplStatement) {
        this.comm = informixSQLICommunication;
        this.statement = informixImplStatement;
        this.reader = informixSQLICommunication.getReader();
        this.writer = informixSQLICommunication.getWriter();
    }

    public void processReply() throws SQLException {
        block4: {
            boolean bl = true;
            try {
                while (bl) {
                    this.token = this.reader.readInt16();
                    bl = this.processReplyToken(this.token);
                }
            }
            catch (UtilException utilException) {
                if (utilException.getReason() == 1001) break block4;
                throw this.comm.exceptions.getException((Exception)((Object)utilException));
            }
        }
        if (this.hasError) {
            this.hasError = false;
            throw this.comm.exceptions.getException(this.errCode, this.errArgs, this.sqlState, this.errCode);
        }
    }

    private final void growTupleBuffer(int n) {
        int n2 = n + this.tupleWriteOffset;
        byte[] byArray = new byte[n2];
        if (this.tupleWriteOffset > 0) {
            System.arraycopy(this.tupleBuffer, 0, byArray, 0, this.tupleWriteOffset);
        }
        this.tupleBuffer = byArray;
        this.tupleBufferSize = n2;
    }

    private final void growTupleSizesArray() {
        int[] nArray = new int[this.tupleSizes.length + 256];
        if (this.rowsInBuffer > 0) {
            System.arraycopy(this.tupleSizes, 0, nArray, 0, this.rowsInBuffer);
        }
        this.tupleSizes = nArray;
    }

    protected boolean processReplyToken(int n) throws SQLException {
        try {
            switch (n) {
                case 73: {
                    short s = this.reader.readInt16();
                    break;
                }
                case 12: {
                    return false;
                }
                case 14: {
                    short s = this.reader.readInt16();
                    int n2 = this.reader.readInt32();
                    if (n2 + this.tupleWriteOffset + 1 > this.tupleBufferSize) {
                        this.growTupleBuffer(n2 + 1);
                    }
                    if (this.rowsInBuffer >= this.tupleSizes.length) {
                        this.growTupleSizesArray();
                    }
                    try {
                        if (n2 % 2 == 1) {
                            this.reader.readBytes(this.tupleBuffer, this.tupleWriteOffset, n2 + 1);
                        } else {
                            this.reader.readBytes(this.tupleBuffer, this.tupleWriteOffset, n2);
                        }
                    }
                    catch (Exception exception) {
                        throw this.comm.exceptions.getException(exception);
                    }
                    this.tupleSizes[this.rowsInBuffer] = n2;
                    this.tupleWriteOffset += n2;
                    ++this.numRowsFetched;
                    ++this.rowsInBuffer;
                    break;
                }
                case 8: {
                    this.handleDescribe();
                    break;
                }
                case 15: {
                    this.isDone = true;
                    short s = this.reader.readInt16();
                    this.numRows = this.reader.readInt32();
                    int n3 = this.reader.readInt32();
                    int n4 = this.reader.readInt32();
                    break;
                }
                case 55: {
                    int n5 = this.reader.readInt32();
                    int n6 = this.reader.readInt32();
                    break;
                }
                case 94: {
                    short s = this.reader.readInt16();
                    long l = this.reader.readInt64();
                    break;
                }
                case 99: {
                    this.transactionLevelEvent = this.reader.readInt16();
                    this.transactionLevelNew = this.reader.readInt16();
                    this.transactionLevelOld = this.reader.readInt16();
                    this.transactionLevelChanged = true;
                    break;
                }
                case 84: {
                    short s = this.reader.readInt16();
                    break;
                }
                case 101: {
                    this.fastpathRoutineHandle = this.reader.readInt32();
                    break;
                }
                case 103: {
                    this.fastpathReturnParameter = this.reader.readInt16();
                    return false;
                }
                case 97: {
                    return false;
                }
                case 56: {
                    break;
                }
                case 13: {
                    this.handleError();
                    break;
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        return true;
    }

    private void handleError() throws SQLException {
        try {
            this.errCode = this.reader.readInt16();
            short s = this.reader.readInt16();
            short s2 = this.reader.readInt16();
            this.errArgs = new String[1];
            this.errArgs[0] = this.comm.readString();
            if (this.errCode == 0 || this.errCode == -937) {
                this.reader.readAndDiscardBytes(6);
                short s3 = this.reader.readInt16();
                this.reader.readAndDiscardBytes((int)s3);
            }
            this.sqlState = "HY000";
            switch (this.errCode) {
                case 100: {
                    return;
                }
                case -580: {
                    this.sqlState = "01006";
                    break;
                }
                case -236: {
                    this.sqlState = "21S01";
                    break;
                }
                case -382: {
                    this.sqlState = "21S02";
                    break;
                }
                case -1213: {
                    this.sqlState = "22018";
                    break;
                }
                case -691: 
                case -391: 
                case -292: 
                case -239: {
                    this.sqlState = "23000";
                    break;
                }
                case -952: {
                    this.sqlState = "28000";
                    break;
                }
                case -201: {
                    this.sqlState = "42000";
                    break;
                }
                case -310: {
                    this.sqlState = "42S01";
                    break;
                }
                case -206: {
                    this.sqlState = "42S02";
                    break;
                }
                case -350: 
                case -316: {
                    this.sqlState = "42S11";
                    break;
                }
                case -319: {
                    this.sqlState = "42S12";
                    break;
                }
                case -328: {
                    this.sqlState = "42S21";
                    break;
                }
                case -352: 
                case -217: {
                    this.sqlState = "42S22";
                }
            }
            this.hasError = true;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    protected void handleTransactionChange() throws SQLException {
        boolean bl = this.comm.getImplConnection().isAnsiDatabase;
        boolean bl2 = this.comm.getImplConnection().isAutoCommit;
        if (bl && bl2 && this.transactionLevelChanged) {
            this.transactionLevelChanged = false;
            if (this.transactionLevelNew > this.transactionLevelOld) {
                this.commitTransaction();
            }
        }
    }

    private void handleDescribe() throws UtilException, SQLException {
        this.stmtType = this.reader.readInt16();
        this.stmtId = this.reader.readInt16();
        if (this.statement != null) {
            this.statement.setStatementType(this.stmtType);
            this.statement.setStatementId(this.stmtId);
        }
        int n = this.reader.readInt32();
        short s = this.reader.readInt16();
        this.numColumns = this.reader.readInt16();
        short s2 = this.reader.readInt16();
        int n2 = s == 0 ? 4096 : (this.fetchSize == 0 ? Math.max(this.tupleBufferSize, s) : this.fetchSize * s);
        if (n2 > Short.MAX_VALUE) {
            n2 = Short.MAX_VALUE;
        }
        if (n2 > this.tupleBufferSize) {
            this.tupleBuffer = new byte[n2];
            this.tupleSizes = new int[256];
            this.tupleBufferSize = n2;
        }
        this.tupleWriteOffset = 0;
        this.numRowsProcessed = 0;
        this.numRowsFetched = 0;
        this.rowsInBuffer = 0;
        this.rowsPositionInBuffer = 0;
        this.isDone = false;
        this.columns = new InformixColumns();
        InformixColumn informixColumn = null;
        InformixImplConnection informixImplConnection = this.comm.getImplConnection();
        int n3 = 1;
        while (n3 <= this.numColumns) {
            informixColumn = new InformixColumn();
            informixColumn.catalogName = informixImplConnection.database;
            informixColumn.schemaName = informixImplConnection.username;
            informixColumn.readColumnInfo(this.comm);
            informixColumn.analyzeTypeInfo();
            if (informixColumn.extId > 0) {
                this.hasComplexTypes = true;
            }
            this.columns.add((BaseColumn)informixColumn);
            ++n3;
        }
        byte[] byArray = this.comm.readBytesForString(s2);
        int n4 = 1;
        while (n4 <= this.numColumns) {
            informixColumn = (InformixColumn)this.columns.get(n4);
            informixColumn.extractColumnName(this.comm.backendTransliterator, byArray);
            ++n4;
        }
    }

    public void executeImmediate() throws SQLException {
        this.isAutoRelease = true;
        try {
            this.writePacket(2);
            this.writePacket(22);
            this.writePacket(49);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
            this.writePacket(4);
            this.writePacket(7);
            this.writePacket(11);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void executeSQL(String string) throws SQLException {
        this.isAutoRelease = true;
        this.sql = string;
        try {
            this.writePacket(1);
            this.writePacket(22);
            this.writePacket(7);
            this.writePacket(11);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
            this.handleTransactionChange();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void prepare() throws SQLException {
        this.isAutoRelease = false;
        try {
            this.writePacket(2);
            this.writePacket(22);
            this.writePacket(49);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void executePrepared() throws SQLException {
        this.isAutoRelease = false;
        try {
            if (this.numInputs > 0) {
                this.createSmartBlob();
            }
            this.writePacket(4);
            if (this.numInputs > 0) {
                this.writePacket(5);
            }
            this.writePacket(7);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
            this.handleTransactionChange();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void execute() throws SQLException {
        this.isAutoRelease = true;
        try {
            this.writePacket(1);
            this.writePacket(22);
            this.writePacket(7);
            this.writePacket(11);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
            int n = this.stmtType;
            this.handleTransactionChange();
            if (n == 1) {
                this.comm.getImplConnection().setupTransliteration();
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public boolean fetch() throws SQLException, UtilException {
        if (this.numRowsFetched != this.numRowsProcessed && !this.rowIsBuilt) {
            this.skipRow();
        }
        this.rowIsBuilt = false;
        if (this.numRowsProcessed < this.numRowsFetched) {
            return true;
        }
        this.tupleWriteOffset = 0;
        this.rowsInBuffer = 0;
        this.rowsPositionInBuffer = 0;
        this.writePacket(4);
        if (this.hasComplexTypes) {
            this.writeReturnType();
        }
        this.writePacket(9);
        this.writePacket(12);
        this.submitRequest();
        this.processReply();
        if (this.numRowsProcessed < this.numRowsFetched) {
            this.tupleReader = new UtilByteOrderedDataReader((UtilDataProvider)new UtilByteArrayDataProvider(this.tupleBuffer));
            if (this.comm.backendTransliterator != null) {
                this.tupleReader.setTransliterator(this.comm.backendTransliterator);
            }
        }
        if (this.numRowsProcessed < this.numRowsFetched) {
            return true;
        }
        return !this.isDone;
    }

    public void startTransaction() throws SQLException {
        try {
            this.writePacket(35);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void commitTransaction() throws SQLException {
        try {
            this.writePacket(19);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void rollbackTransaction() throws SQLException {
        try {
            this.writePacket(20);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void closeCursor() throws SQLException {
    }

    public void closeStatement() throws SQLException {
        block6: {
            this.closeCursor();
            if (this.isAutoRelease) {
                return;
            }
            if (this.statement != null ? this.statement.getStatementId() == -1 : this.stmtId == -1) {
                return;
            }
            try {
                this.writePacket(4);
                this.writePacket(11);
                this.writePacket(12);
                this.submitRequest();
                this.processReply();
            }
            catch (UtilException utilException) {
                throw this.comm.exceptions.getException((Exception)((Object)utilException));
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -258) break block6;
                throw sQLException;
            }
        }
        if (this.statement != null) {
            this.statement.setStatementId(-1);
        }
        this.stmtId = -1;
    }

    public void closeConnection() throws SQLException {
        try {
            this.writer.writeInt16(84);
            this.writer.writeInt16(12);
            this.submitRequest();
            this.processReply();
            this.writer.writeInt16(56);
            this.submitRequest();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private void bind() throws SQLException, UtilException {
        InformixParameter.writeAllParameters(this.parameters, this.comm);
    }

    private void createSmartBlob() throws SQLException, UtilException {
        InformixParameter.writeLobs(this.parameters, this.comm);
    }

    public void submitRequest() throws SQLException {
        try {
            this.writer.send();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void writePacket(int n) throws SQLException, UtilException {
        this.writer.writeInt16(n);
        switch (n) {
            case 4: {
                if (this.statement != null) {
                    this.writer.writeInt16(this.statement.getStatementId());
                    break;
                }
                this.writer.writeInt16(this.stmtId);
                break;
            }
            case 2: {
                this.writer.writeInt16(this.numInputs);
                this.comm.writeString(this.sql);
                break;
            }
            case 5: {
                this.bind();
                break;
            }
            case 9: {
                this.writer.writeInt16(this.tupleBufferSize);
                this.writer.writeInt16(0);
                break;
            }
            case 20: {
                this.writer.writeInt16(0);
                break;
            }
            case 1: {
                this.writer.writeInt16(0);
                this.comm.writeString(this.sql);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 35: 
            case 43: 
            case 49: 
            case 56: 
            case 84: 
            case 101: 
            case 102: {
                break;
            }
            case 3: {
                UtilDebug.assert((String)("writePacket: packet type " + n + " should be defined in sub class."), (boolean)false);
                break;
            }
            default: {
                UtilDebug.assert((String)("writePacket: packet type " + n + " is not recognized."), (boolean)false);
            }
        }
    }

    public void writeGetRoutine(String string, boolean bl) throws SQLException, UtilException {
        this.writer.writeInt16(101);
        int n = string.length();
        this.writer.writeInt16(n);
        this.writer.writeString(string);
        if (n % 2 == 1) {
            this.writer.writeInt8(0);
        }
        if (bl) {
            this.writer.writeInt16(1);
        } else {
            this.writer.writeInt16(0);
        }
    }

    public void writeExecuteFastPath(int n, int n2, boolean bl) throws SQLException, UtilException {
        this.writer.writeInt16(102);
        this.writer.writeInt32(n);
        this.writer.writeInt16(n2);
        if (bl) {
            this.writer.writeInt16(1);
        } else {
            this.writer.writeInt16(0);
        }
    }

    protected void writeReturnType() throws UtilException, SQLException {
        this.writePacket(100);
        this.writer.writeInt16(1);
        this.writer.writeInt16(this.numColumns);
        int n = 1;
        while (n <= this.numColumns) {
            InformixColumn informixColumn = (InformixColumn)this.columns.get(n);
            this.writer.writeInt16(informixColumn.nativeType);
            if (informixColumn.extId > 0) {
                this.writer.writeStringWithLength16(informixColumn.typeOwner);
                if (informixColumn.typeOwner.length() % 2 == 1) {
                    this.writer.writeInt8(0);
                }
                this.writer.writeStringWithLength16(informixColumn.typeName);
                if (informixColumn.typeName.length() % 2 == 1) {
                    this.writer.writeInt8(0);
                }
            }
            this.writer.writeInt32(informixColumn.qualifier);
            ++n;
        }
    }

    public void setInputParameterCount(int n) {
        this.numInputs = n;
    }

    public void setInputParameters(InformixParameter[] informixParameterArray) {
        this.parameters = informixParameterArray;
    }

    public int getRowsAffected() {
        return this.numRows;
    }

    public int getNumberOfColumns() {
        return this.numColumns;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public void buildRow() throws SQLException {
        if (this.rowIsBuilt) {
            return;
        }
        int n = 0;
        int n2 = this.tupleSizes[this.rowsPositionInBuffer];
        try {
            this.numColumns = this.columns.count(0);
            int n3 = 1;
            while (n3 <= this.numColumns) {
                InformixColumn informixColumn = (InformixColumn)this.columns.get(n3);
                switch (informixColumn.nativeType) {
                    case 0: 
                    case 15: {
                        String string = this.tupleReader.readString(informixColumn.qualifier);
                        informixColumn.data = string.charAt(0) == '\u0000' ? null : string;
                        n += informixColumn.qualifier;
                        break;
                    }
                    case 13: 
                    case 16: {
                        if (informixColumn.qualifier <= 0) break;
                        short s = this.tupleReader.readUnsignedInt8();
                        String string = this.tupleReader.readString((int)s);
                        this.tupleReader.readAndDiscardBytes(informixColumn.qualifier - s);
                        informixColumn.data = s == 0 ? "" : (s == 1 && string.charAt(0) == '\u0000' ? null : string);
                        n += informixColumn.qualifier + 1;
                        break;
                    }
                    case 43: {
                        byte by = this.tupleReader.readInt8();
                        int n4 = this.tupleReader.readInt32();
                        if (by == 1) {
                            informixColumn.data = null;
                            n += 5;
                            break;
                        }
                        informixColumn.data = this.tupleReader.readString(n4);
                        n += n4 + 5;
                        break;
                    }
                    case 1: {
                        short s = this.tupleReader.readInt16();
                        informixColumn.data = s == Short.MIN_VALUE ? null : new Short(s);
                        n += 2;
                        break;
                    }
                    case 2: 
                    case 6: {
                        int n5 = this.tupleReader.readInt32();
                        informixColumn.data = n5 == Integer.MIN_VALUE ? null : new Integer(n5);
                        n += 4;
                        break;
                    }
                    case 17: 
                    case 18: {
                        short s = this.tupleReader.readInt16();
                        long l = this.tupleReader.readUnsignedInt32();
                        informixColumn.data = s == 0 ? null : new Long((l += this.tupleReader.readUnsignedInt32() << 32) * (long)s);
                        n += 10;
                        break;
                    }
                    case 4: {
                        int n6 = this.tupleReader.readInt32();
                        informixColumn.data = n6 == -1 ? null : new Float(Float.intBitsToFloat(n6));
                        n += 4;
                        break;
                    }
                    case 3: {
                        long l = this.tupleReader.readInt64();
                        informixColumn.data = l == -1L ? null : new Double(Double.longBitsToDouble(l));
                        n += 8;
                        break;
                    }
                    case 5: 
                    case 8: {
                        int n7;
                        int n8;
                        int n9 = informixColumn.qualifier >> 8;
                        int n10 = informixColumn.qualifier & 0xFF;
                        int n11 = n10 % 2 == 1 ? (n9 + 4) / 2 : (n9 + 3) / 2;
                        int n12 = this.tupleReader.readUnsignedInt8();
                        ++n;
                        --n11;
                        if (n12 == 0) {
                            informixColumn.data = null;
                            this.tupleReader.readAndDiscardBytes(n11);
                            n += n11;
                            break;
                        }
                        int n13 = (n12 & 0x80) == 0 ? -1 : 1;
                        n12 &= 0x7F;
                        if (n13 < 0) {
                            n12 ^= 0x7F;
                        }
                        n12 -= 64;
                        StringBuffer stringBuffer = new StringBuffer(n11 * 2 + 1);
                        int n14 = 0;
                        int n15 = 0;
                        int n16 = 0;
                        int n17 = 0;
                        while (n17 < n11) {
                            n14 = this.tupleReader.readUnsignedInt8();
                            if (n13 < 0) {
                                n14 = 100 - n14 - 1;
                            }
                            n8 = n14 / 10;
                            n7 = n14 % 10;
                            if (n7 != 0) {
                                n15 = n17 * 2 + 1;
                                n16 = 1;
                            } else if (n8 != 0) {
                                n15 = n17 * 2;
                                n16 = 1;
                            }
                            stringBuffer.append(n8);
                            stringBuffer.append(n7);
                            ++n17;
                        }
                        n += n11;
                        BigDecimal bigDecimal = new BigDecimal(stringBuffer.toString());
                        if (n13 < 0) {
                            bigDecimal = bigDecimal.add(BigDecimal.valueOf(1L)).negate();
                        }
                        bigDecimal = bigDecimal.movePointLeft((n11 - n12) * 2);
                        if (n10 == 255) {
                            int n18 = n15 + 1 - n12 * 2;
                            if (n18 > 0 && n16 != 0) {
                                informixColumn.data = bigDecimal.setScale(n18, 3);
                                break;
                            }
                            informixColumn.data = bigDecimal.setScale(0, 3);
                            break;
                        }
                        informixColumn.data = bigDecimal.setScale(n10, 3);
                        break;
                    }
                    case 7: {
                        int n19 = this.tupleReader.readInt32();
                        if (n19 == Integer.MIN_VALUE) {
                            informixColumn.data = null;
                            break;
                        }
                        long l = (long)(n19 -= 25568) * 24L * 60L * 60L * 1000L;
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(new Date(l));
                        l -= (long)calendar.get(15);
                        informixColumn.data = new Date(l -= (long)calendar.get(16));
                        n += 4;
                        break;
                    }
                    case 10: {
                        int n20 = informixColumn.qualifier >> 8;
                        int n21 = 1 + (n20 + 1) / 2;
                        int n11 = this.tupleReader.readUnsignedInt8();
                        n += n21;
                        int n22 = 0;
                        int n13 = 0;
                        short s = 1;
                        int n14 = 0;
                        int n8 = 0;
                        int n7 = 0;
                        int n15 = 0;
                        if (n11 == 0) {
                            informixColumn.data = null;
                            this.tupleReader.readAndDiscardBytes(n21 - 1);
                            break;
                        }
                        int n16 = n11;
                        int n17 = 1;
                        while (n17 < n21) {
                            switch (n16) {
                                case 199: {
                                    n22 = this.tupleReader.readUnsignedInt8() * 100;
                                    break;
                                }
                                case 198: {
                                    n22 += this.tupleReader.readUnsignedInt8();
                                    break;
                                }
                                case 197: {
                                    n13 = this.tupleReader.readUnsignedInt8() - 1;
                                    break;
                                }
                                case 196: {
                                    s = this.tupleReader.readUnsignedInt8();
                                    break;
                                }
                                case 195: {
                                    n14 = this.tupleReader.readUnsignedInt8();
                                    break;
                                }
                                case 194: {
                                    n8 = this.tupleReader.readUnsignedInt8();
                                    break;
                                }
                                case 193: {
                                    n7 = this.tupleReader.readUnsignedInt8();
                                    break;
                                }
                                case 192: {
                                    n15 = this.tupleReader.readUnsignedInt8() * 10000000;
                                    break;
                                }
                                case 191: {
                                    n15 += this.tupleReader.readUnsignedInt8() * 100000;
                                    break;
                                }
                                case 190: {
                                    n15 += this.tupleReader.readUnsignedInt8() * 1000;
                                    break;
                                }
                                default: {
                                    this.tupleReader.readUnsignedInt8();
                                }
                            }
                            --n16;
                            ++n17;
                        }
                        if (informixColumn.baseDataType == 12 || n11 <= 195 && n11 - n21 + 1 >= 192) {
                            informixColumn.data = new Time(n14, n8, n7);
                            break;
                        }
                        informixColumn.data = new BaseTimestamp(n22, n13, (int)s, n14, n8, n7, n15, null);
                        break;
                    }
                    case 11: 
                    case 12: {
                        byte[] byArray = new byte[56];
                        this.tupleReader.readBytes(byArray, 0, 56);
                        informixColumn.data = byArray[0] == 0 && byArray[1] == 0 ? null : (Object)byArray;
                        n += 56;
                        break;
                    }
                    case 44: {
                        byte by = this.tupleReader.readInt8();
                        int n23 = this.tupleReader.readInt32();
                        if (by == 1) {
                            informixColumn.data = null;
                            n += 5;
                            break;
                        }
                        informixColumn.data = new byte[n23];
                        this.tupleReader.readBytes((byte[])informixColumn.data, 0, n23);
                        n += 5 + n23;
                        break;
                    }
                    case 45: {
                        byte by = this.tupleReader.readInt8();
                        int n24 = this.tupleReader.readInt32();
                        n += 5;
                        int n11 = 0;
                        if (n24 > 0) {
                            n11 = this.tupleReader.readInt8();
                            ++n;
                        }
                        if (by == 1) {
                            informixColumn.data = null;
                            break;
                        }
                        if (n11 == 0 || n11 == 70 || n11 == 102) {
                            informixColumn.data = Boolean.FALSE;
                            break;
                        }
                        informixColumn.data = Boolean.TRUE;
                        break;
                    }
                    case 9: {
                        informixColumn.data = null;
                        break;
                    }
                    default: {
                        throw this.comm.exceptions.getException(InformixLocalMessages.UNSUPPORTED_TYPE, null, "HY000");
                    }
                }
                if (n > n2) {
                    throw this.comm.exceptions.getException(InformixLocalMessages.ROW_TRUNCATED, null, "HY000");
                }
                ++n3;
            }
            this.rowIsBuilt = true;
            ++this.numRowsProcessed;
            ++this.rowsPositionInBuffer;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void skipRow() throws SQLException {
        try {
            int n = this.tupleSizes[this.rowsPositionInBuffer];
            this.tupleReader.readAndDiscardBytes(n);
            ++this.numRowsProcessed;
            ++this.rowsPositionInBuffer;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public InformixSQLICommunication getSQLICommunication() {
        return this.comm;
    }
}

