/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseCharStreamOnFileChunk;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSetService;
import com.metamatrix.jdbc.base.BaseInputStreamOnFileChunk;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;

public final class BaseImplResultSetClientSideInsensitive
extends BaseImplResultSetService {
    private static String footprint = "$Revision:   3.16.1.2  $";
    boolean tempFilesAreReady = false;
    private File longDataFileHandle;
    private RandomAccessFile longDataFile;
    UtilPagedTempBuffer rowDataBuff;
    UtilPagedTempBuffer rowPositionBuff;
    private int rowsFetchedFromSubResultSet = 0;
    private BaseData[] rowData;
    private boolean endOfResultSetReached = false;
    private int maxLongDataSize;
    byte[] byteArrayForReading;
    static int DEFAULT_BUFF_INCREMENT = 1024;
    int maxMem;
    BaseConnection connection;

    public BaseImplResultSetClientSideInsensitive(int n, BaseConnection baseConnection) {
        if (n == 0) {
            n = 0x200000;
        }
        this.maxMem = n;
        this.connection = baseConnection;
    }

    public BaseImplResultSetClientSideInsensitive(BaseConnection baseConnection) {
        this.maxMem = 2048;
        this.connection = baseConnection;
    }

    public void postSetupInitialize() throws SQLException {
        this.tempFilesAreReady = false;
        super.postSetupInitialize();
        this.fetchAtPosition(1);
    }

    void setMaxLongDataFieldCacheSize(int n) {
        this.maxLongDataSize = n;
    }

    private void setupTempFiles() throws SQLException {
        try {
            this.rowDataBuff = new UtilPagedTempBuffer(this.maxMem);
            this.rowPositionBuff = new UtilPagedTempBuffer(16);
            this.byteArrayForReading = new byte[DEFAULT_BUFF_INCREMENT];
            this.longDataFileHandle = UtilTempFile.createTempFile((String)"scb_");
            try {
                this.longDataFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new RandomAccessFile(BaseImplResultSetClientSideInsensitive.this.longDataFileHandle, "rw");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            this.tempFilesAreReady = true;
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038);
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.rowDataBuff.truncate();
            this.rowPositionBuff.truncate();
            this.longDataFile.close();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    BaseImplResultSetClientSideInsensitive.this.longDataFileHandle.delete();
                    return null;
                }
            });
        }
        catch (Exception exception) {}
    }

    public int getScrollType() {
        return 1004;
    }

    public int getColumnAccess() {
        return 2;
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        boolean bl = this.fetch(n);
        if (bl) {
            this.fetch(n + 1);
        }
        if (bl) {
            bl = n > this.rowsFetchedFromSubResultSet ? false : this.getCachedRow(n - 1);
        }
        return bl;
    }

    private boolean fetch(int n) throws SQLException {
        boolean bl = true;
        if (n > this.rowsFetchedFromSubResultSet) {
            bl = this.fetchAndCache(n - this.rowsFetchedFromSubResultSet, false, 0);
        }
        return bl;
    }

    boolean fetchAndCache(int n, boolean bl, int n2) throws SQLException {
        boolean bl2 = true;
        int n3 = 0;
        while (bl2 && n3 < n) {
            if (this.endOfResultSetReached) {
                bl2 = false;
            } else if (!bl) {
                bl2 = this.subImplResultSet.next();
            }
            if (bl2) {
                ++this.rowsFetchedFromSubResultSet;
                this.cacheCurrentRow(n2);
                bl = false;
                n2 = 0;
            } else {
                this.endOfResultSetReached = true;
                this.maxCursorPosition = this.rowsFetchedFromSubResultSet;
            }
            ++n3;
        }
        return bl2;
    }

    void cacheCurrentRow(int n) throws SQLException {
        try {
            if (!this.tempFilesAreReady) {
                this.setupTempFiles();
                this.tempFilesAreReady = true;
            }
            this.rowPositionBuff.writeLong(this.rowDataBuff.getSize());
            int n2 = n;
            while (n2 < this.columns.count(0)) {
                block14: {
                    BaseData baseData;
                    block15: {
                        block16: {
                            block13: {
                                BaseColumn baseColumn = this.columns.get(n2 + 1);
                                baseData = this.subImplResultSet.getData(n2 + 1, baseColumn.baseDataType);
                                if (!baseData.isNull()) break block13;
                                this.rowDataBuff.writeInt(baseData.getType());
                                this.rowDataBuff.writeInt(-1);
                                break block14;
                            }
                            if (baseData.getType() != 2 && (baseData.getType() <= 100 || baseData.getType() >= 200)) break block15;
                            byte[] byArray = baseData.getBytesNoConvert();
                            this.rowDataBuff.writeInt(baseData.getType());
                            this.rowDataBuff.writeInt(byArray.length);
                            this.rowDataBuff.write(this.rowDataBuff.getSize(), byArray);
                            if (baseData.getType() != 110) break block16;
                            this.rowDataBuff.writeInt(baseData.getOracleTZScale());
                            this.rowDataBuff.writeInt(baseData.getOracleFetchTSWTZasTimestamp() ? 1 : 0);
                            break block14;
                        }
                        if (baseData.getType() != 111) break block14;
                        this.rowDataBuff.writeInt(baseData.getOracleTZHours());
                        this.rowDataBuff.writeInt(baseData.getOracleTZMinutes());
                        break block14;
                    }
                    if (baseData.getType() == 15 || baseData.getType() == 14) {
                        this.cacheBinaryStream(baseData.getType(), (InputStream)baseData.getObject());
                    } else if (baseData.getType() == 19) {
                        this.cacheBlob((BaseImplBlob)baseData.getObject());
                    } else if (baseData.getType() == 18 || baseData.getType() == 17 || baseData.getType() == 16) {
                        this.cacheCharacterStream(18, (Reader)baseData.getObject());
                    } else if (baseData.getType() == 20) {
                        this.cacheClob((BaseImplClob)baseData.getObject());
                    } else {
                        this.rowDataBuff.writeInt(baseData.getType());
                        String string = baseData.getString(-1, this.implStatement.implConnection.exceptions);
                        int n3 = string.length();
                        this.rowDataBuff.writeInt(n3 * 2);
                        int n4 = 0;
                        while (n4 < n3) {
                            this.rowDataBuff.write(this.rowDataBuff.getSize(), (byte)(string.charAt(n4) >>> 8 & 0xFF));
                            this.rowDataBuff.write(this.rowDataBuff.getSize(), (byte)(string.charAt(n4++) >>> 0 & 0xFF));
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039);
        }
    }

    private void cacheBinaryStream(int n, InputStream inputStream) throws IOException, UtilException {
        this.rowDataBuff.writeInt(n);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n2 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        byte[] byArray = new byte[n2];
        int n3 = inputStream.read(byArray, 0, n2);
        while (n3 != -1) {
            this.longDataFile.write(byArray, 0, n3);
            l += (long)n3;
            if (this.maxLongDataSize != 0) {
                if (n3 >= n2) break;
                n2 = this.maxLongDataSize - (int)l;
            }
            n3 = inputStream.read(byArray, 0, n2);
        }
        this.rowDataBuff.writeLong(l);
    }

    private void cacheCharacterStream(int n, Reader reader) throws IOException, UtilException {
        this.rowDataBuff.writeInt(n);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n2 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        char[] cArray = new char[n2];
        int n3 = reader.read(cArray, 0, n2);
        while (n3 != -1) {
            int n4 = 0;
            while (n4 < n3) {
                this.longDataFile.writeChar(cArray[n4]);
                ++n4;
            }
            l += (long)(n3 * 2);
            if (this.maxLongDataSize != 0) {
                if (n3 >= n2) break;
                n2 = this.maxLongDataSize - (int)(l / 2L);
            }
            n3 = reader.read(cArray, 0, n2);
        }
        this.rowDataBuff.writeLong(l);
    }

    private void cacheBlob(BaseImplBlob baseImplBlob) throws SQLException, IOException, UtilException {
        this.rowDataBuff.writeInt(19);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeBlob(this.longDataFile, baseImplBlob);
    }

    private void cacheClob(BaseImplClob baseImplClob) throws SQLException, IOException, UtilException {
        this.rowDataBuff.writeInt(20);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeClob(this.longDataFile, baseImplClob);
    }

    boolean getCachedRow(int n) throws SQLException {
        boolean bl = false;
        try {
            long l = n * 8;
            long l2 = this.rowPositionBuff.readLong((long)((int)l));
            this.intializeRow();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.columns.count(0)) {
                int n3;
                int n4;
                int n5 = this.rowDataBuff.readInt(l2);
                int n6 = this.rowDataBuff.readInt(l2 += 4L);
                if (n6 == -1) {
                    l2 += 4L;
                    this.rowData[n2].setNull(n5);
                } else if (n5 == 2) {
                    this.rowData[n2].setBytes(this.rowDataBuff.read(l2 += 4L, n6));
                    l2 += (long)n6;
                } else if (n5 > 100 && n5 < 200) {
                    byte[] byArray = this.rowDataBuff.read(l2 += 4L, n6);
                    l2 += (long)n6;
                    if (n5 == 110) {
                        n4 = this.rowDataBuff.readInt(l2);
                        n3 = this.rowDataBuff.readInt(l2 += 4L) == 1 ? 1 : 0;
                        l2 += 4L;
                        this.rowData[n2].setNativeOracleTimestampWithTimeZone(byArray, byArray.length, n4, n3 != 0);
                    } else if (n5 == 111) {
                        n4 = this.rowDataBuff.readInt(l2);
                        n3 = this.rowDataBuff.readInt(l2 += 4L);
                        l2 += 4L;
                        this.rowData[n2].setNativeOracleTimestampWithLocalTimeZone(byArray, byArray.length, n4, n3);
                    } else {
                        this.rowData[n2].setNativeBytes(byArray, n6, n5);
                    }
                } else if (n5 == 15 || n5 == 14) {
                    this.getCachedBinaryStream(n5, l2, this.rowData[n2]);
                    l2 += 16L;
                } else if (n5 == 18) {
                    this.getCachedCharStream(n5, l2, this.rowData[n2]);
                    l2 += 16L;
                } else if (n5 == 19) {
                    this.getCachedBlob(this.rowDataBuff.readLong(l2), this.rowData[n2]);
                    l2 += 8L;
                } else if (n5 == 20) {
                    this.getCachedClob(this.rowDataBuff.readLong(l2), this.rowData[n2]);
                    l2 += 8L;
                } else {
                    l2 += 4L;
                    stringBuffer.setLength(0);
                    char c = '\u0000';
                    int n7 = 0;
                    while (n7 < n6) {
                        n4 = this.rowDataBuff.read(l2 + (long)n7++);
                        n3 = this.rowDataBuff.read(l2 + (long)n7++);
                        c = (char)(((n4 & 0xFF) << 8) + ((n3 & 0xFF) << 0));
                        stringBuffer.append(c);
                    }
                    l2 += (long)n6;
                    if (n5 > 200) {
                        this.rowData[n2].setNativeString(stringBuffer.toString(), n5);
                    } else {
                        this.rowData[n2].setString(stringBuffer.toString());
                    }
                    switch (n5) {
                        case 1: {
                            this.rowData[n2].setByte(this.rowData[n2].getByte(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 3: {
                            this.rowData[n2].setShort(this.rowData[n2].getShort(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 4: {
                            this.rowData[n2].setInteger(this.rowData[n2].getInteger(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 5: {
                            this.rowData[n2].setLong(this.rowData[n2].getLong(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 6: {
                            this.rowData[n2].setFloat(this.rowData[n2].getFloat(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 7: {
                            this.rowData[n2].setDouble(this.rowData[n2].getDouble(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 8: 
                        case 21: {
                            this.rowData[n2].setBigDecimal(this.rowData[n2].getBigDecimal(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 9: {
                            this.rowData[n2].setBoolean(this.rowData[n2].getBoolean(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 11: {
                            this.rowData[n2].setDate(this.rowData[n2].getDate(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 12: {
                            this.rowData[n2].setTime(this.rowData[n2].getTime(this.implStatement.implConnection.exceptions));
                            break;
                        }
                        case 13: {
                            this.rowData[n2].setTimestamp(this.rowData[n2].getTimestamp(this.implStatement.implConnection.exceptions));
                        }
                    }
                }
                ++n2;
            }
            bl = true;
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6040);
        }
        return bl;
    }

    private void getCachedBinaryStream(int n, long l, BaseData baseData) throws IOException, UtilException {
        long l2 = this.rowDataBuff.readLong(l);
        long l3 = this.rowDataBuff.readLong(l + 8L);
        BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = new BaseInputStreamOnFileChunk(this.longDataFile, l2, l3);
        baseData.setData(n, baseInputStreamOnFileChunk);
    }

    private void getCachedCharStream(int n, long l, BaseData baseData) throws IOException, UtilException {
        long l2 = this.rowDataBuff.readLong(l);
        long l3 = this.rowDataBuff.readLong(l + 8L);
        BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = new BaseCharStreamOnFileChunk(this.longDataFile, l2, l3);
        baseData.setData(n, baseCharStreamOnFileChunk);
    }

    private void getCachedBlob(long l, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l);
        baseData.setBlob(this.subImplResultSet.readBlob(this.longDataFile));
    }

    private void getCachedClob(long l, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l);
        baseData.setClob(this.subImplResultSet.readClob(this.longDataFile));
    }

    private void intializeRow() {
        if (this.rowData == null) {
            this.rowData = new BaseData[this.columns.count(0)];
            int n = 0;
            while (n < this.columns.count(0)) {
                BaseColumn baseColumn = this.columns.get(n + 1);
                this.rowData[n] = new BaseData(this.connection);
                ++n;
            }
        }
    }

    public BaseData getData(int n, int n2) throws SQLException {
        BaseData baseData = this.rowData[n - 1];
        Object object = baseData.getObject();
        if (object instanceof BaseInputStreamOnFileChunk) {
            BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = (BaseInputStreamOnFileChunk)object;
            baseData.setData(baseData.getType(), new BaseInputStreamOnFileChunk(baseInputStreamOnFileChunk.file, baseInputStreamOnFileChunk.offset, baseInputStreamOnFileChunk.length));
        } else if (object instanceof BaseCharStreamOnFileChunk) {
            BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = (BaseCharStreamOnFileChunk)object;
            baseData.setData(baseData.getType(), new BaseCharStreamOnFileChunk(baseCharStreamOnFileChunk.file, baseCharStreamOnFileChunk.offset, baseCharStreamOnFileChunk.length));
        }
        return baseData;
    }

    protected boolean setupForNextResultSetInMultipleResult(int n) throws SQLException {
        boolean bl = this.rowDataBuff == null;
        boolean bl2 = n == -1;
        boolean bl3 = false;
        if (n == -1) {
            n = 0;
        }
        if (bl) {
            this.tempFilesAreReady = false;
            if (!bl2) {
                bl3 = true;
            }
        }
        this.fetchAndCache(Integer.MAX_VALUE, bl3, n);
        if (bl && !bl2) {
            this.getCachedRow(0);
            this.cursorPosition = 1;
        }
        return true;
    }
}

