/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplBlobCached;
import com.metamatrix.util.UtilBoyerMooreSearchStrategy;
import com.metamatrix.util.UtilBruteForceSearchStrategy;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSearchStrategy;
import java.sql.SQLException;

public class BaseImplBlobSearchable
extends BaseImplBlobCached {
    private static String footprint = "$Revision:   3.0.6.0  $";
    private UtilSearchStrategy searchStrategy = new UtilBoyerMooreSearchStrategy();

    public BaseImplBlobSearchable(BaseImplBlob baseImplBlob, BaseExceptions baseExceptions) {
        super(baseImplBlob, baseExceptions);
    }

    public long find(byte[] byArray, long l) throws SQLException {
        UtilSearchStrategy utilSearchStrategy = this.searchStrategy;
        if (byArray.length == 1) {
            utilSearchStrategy = new UtilBruteForceSearchStrategy();
        }
        if (l > Integer.MAX_VALUE) {
            throw this.exceptions.getException(6068);
        }
        this.fetchDataToCache(l, new Long(this.getLength() - l - 1L).intValue());
        try {
            return utilSearchStrategy.find(this.getCachedData(), byArray, new Long(l).intValue());
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public boolean supportsSearch() {
        return true;
    }
}

