/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.dqp.internal.config;

import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.core.event.IChangeListener;
import com.metamatrix.core.event.IChangeNotifier;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.dqp.DqpPlugin;
import com.metamatrix.modeler.dqp.config.ConfigurationManager;
import com.metamatrix.modeler.dqp.internal.config.ConfigFileManager;
import com.metamatrix.modeler.dqp.internal.config.ConnectionManager;
import com.metamatrix.modeler.dqp.util.ModelerDqpUtils;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    private Map configList;
    private Collection listenerList = new ArrayList(39);
    private ConnectionManager defaultConnectionManager;
    private ConfigFileManager configFileManager;

    public ConfigurationManagerImpl(IPath configFilePath) throws Exception {
        this.configFileManager = new ConfigFileManager(configFilePath);
        this.init();
    }

    private void init() throws Exception {
        this.configList = this.configFileManager.loadConfigFiles();
        this.defaultConnectionManager = (ConnectionManager)((Object)this.configList.get("configuration.xml"));
    }

    public Collection getConfigurationsNameList() {
        return this.configList.keySet();
    }

    public void loadConfiguration(String newDefaultConfigName) {
        ConnectionManager newDefaultConnectionManager;
        this.defaultConnectionManager = newDefaultConnectionManager = (ConnectionManager)((Object)this.configList.get(newDefaultConfigName));
    }

    public ConnectionManager getDefaultConfig() {
        return this.defaultConnectionManager;
    }

    public boolean importConfig(File configFile) throws Exception {
        boolean status = this.getDefaultConfig().importConfig(this.configFileManager.importConfig(configFile));
        this.saveConfigLocal();
        return status;
    }

    public boolean saveConfig() throws Exception {
        return this.configFileManager.saveConfig((ConfigurationModelContainer)this.defaultConnectionManager.getCMContainerImpl(), this.defaultConnectionManager.getConfigurationName());
    }

    private boolean saveConfigLocal() {
        boolean isSaved = false;
        try {
            isSaved = this.configFileManager.saveConfig((ConfigurationModelContainer)this.defaultConnectionManager.getCMContainerImpl(), this.defaultConnectionManager.getConfigurationName());
            if (isSaved) {
                this.fireChangeEvent();
            }
        }
        catch (Exception e) {
            DqpPlugin.Util.log(4, (Throwable)e, "Error saving configuration file in ConfigurationManagerImpl");
            e.printStackTrace();
        }
        return isSaved;
    }

    public ComponentType getComponentType(ConnectorBinding binding) {
        return this.getDefaultConfig().getComponentType(binding);
    }

    public Collection getConnectorBindings() {
        return this.getConnectorBindings(true);
    }

    public Collection getConnectorBindings(boolean theFilterFlag) {
        ArrayList<ConnectorBinding> result = null;
        Collection temp = this.getDefaultConfig().getBinding();
        if (temp == null || temp.isEmpty()) {
            result = Collections.EMPTY_LIST;
        } else if (!theFilterFlag) {
            result = temp;
        } else {
            result = new ArrayList<ConnectorBinding>(temp.size());
            Iterator itr = temp.iterator();
            while (itr.hasNext()) {
                ConnectorBinding binding = (ConnectorBinding)itr.next();
                ConnectorBindingType type = (ConnectorBindingType)this.getComponentType(binding);
                if (!ModelerDqpUtils.isValidConnectorType((ConnectorBindingType)type)) continue;
                result.add(binding);
            }
        }
        return result;
    }

    public ConnectorBinding getBinding(String name) {
        return this.getDefaultConfig().getBinding(name);
    }

    public void addBinding(ConnectorBinding newBinding) {
        this.getDefaultConfig().addBinding(newBinding);
        this.saveConfigLocal();
    }

    public void addBinding(Map binding) {
        this.getDefaultConfig().addBinding(binding);
        this.saveConfigLocal();
    }

    public void removeBinding(ConnectorBinding existingBinding) {
        this.getDefaultConfig().removeBinding(existingBinding);
        this.saveConfigLocal();
    }

    public void addConnectorType(File filename) throws Exception {
        ComponentType componentType = this.configFileManager.loadConnectorType(filename);
        this.getDefaultConfig().overrideConnectorType(componentType);
        this.saveConfigLocal();
    }

    public boolean isConnectorTypeAlreadyExist(File filename) throws Exception {
        ComponentType componentType = this.configFileManager.loadConnectorType(filename);
        return this.getDefaultConfig().isConnectorTypeAlreadyExist(componentType);
    }

    public boolean isBindingAlreadyExist(ConnectorBinding newBinding) throws Exception {
        return this.getDefaultConfig().isBindingAlreadyExist(newBinding);
    }

    public void addConnectorType(ComponentType componentType) throws Exception {
        this.getDefaultConfig().addConnectorType(componentType);
        this.saveConfigLocal();
    }

    public void addConnectorType(ComponentType[] componentType) throws Exception {
        this.addConnectorType(componentType, false);
    }

    public void addConnectorType(ComponentType[] componentType, boolean doOverwrite) throws Exception {
        this.getDefaultConfig().addConnectorType(componentType, doOverwrite);
        this.saveConfigLocal();
    }

    public void removeConnectorType(ComponentType componentType) throws ConfigurationException {
        Collection bindingsForType = this.getDefaultConfig().getBindingsForType(componentType.getID());
        Iterator iter = bindingsForType.iterator();
        while (iter.hasNext()) {
            this.removeBinding((ConnectorBinding)iter.next());
        }
        this.getDefaultConfig().removeConnectorType(componentType);
        this.saveConfigLocal();
    }

    public Collection getConnectorTypes() {
        return this.getConnectorTypes(true);
    }

    public Collection getConnectorTypes(boolean theFilterFlag) {
        return this.getDefaultConfig().getConnectorTypes(theFilterFlag);
    }

    public ComponentType getConnectorType(Object typeId) {
        return this.getDefaultConfig().getConnectorType(typeId);
    }

    public Collection getConnectorTypeIds() {
        return this.getConnectorTypeIds(true);
    }

    public Collection getConnectorTypeIds(boolean theFilterFlag) {
        return this.getDefaultConfig().getConnectorTypeIds(theFilterFlag);
    }

    public Collection getBindingsForType(Object typeId) {
        return this.getDefaultConfig().getBindingsForType(typeId);
    }

    public Properties getDefaultBindingProperties(ComponentTypeID type) throws ConfigurationException {
        return this.getDefaultConfig().getDefaultBindingProperties(type);
    }

    public Collection getAllComponentTypeDefinitions(ComponentType type) {
        return this.getDefaultConfig().getAllComponentTypeDefinitions(type);
    }

    public BasicConfigurationObjectEditor getBasicConfigurationObjectEditor() {
        return this.configFileManager.getBasicConfigurationObjectEditor();
    }

    public void addChangeListener(IChangeListener theListener) {
        if (this.listenerList.contains(theListener)) {
            return;
        }
        this.listenerList.add(theListener);
    }

    public void removeChangeListener(IChangeListener theListener) {
        this.listenerList.remove(theListener);
    }

    protected void fireChangeEvent() {
        if (this.listenerList == null || this.listenerList.isEmpty()) {
            return;
        }
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            IChangeListener listerner = (IChangeListener)it.next();
            listerner.stateChanged((IChangeNotifier)this);
        }
    }

    public String toString() {
        return "From ConfigurationManagerImpl : " + this.getDefaultConfig().getConfigurationName();
    }

    public IPath getConfigurationPath() {
        return this.configFileManager.getPath();
    }

    public ConnectorBinding createConnectorBinding(ConnectorBinding theSourceBinding, String theNewBindingName) {
        ConfigurationObjectEditor coe = DqpPlugin.getInstance().getConfigurationObjectEditor();
        ConnectorBinding binding = coe.createConnectorComponent(Configuration.NEXT_STARTUP_ID, theSourceBinding, theNewBindingName, null);
        this.addBinding(binding);
        return binding;
    }

    public ConnectorBinding createConnectorBinding(ModelReference theModelReference, ConnectorBindingType theConnectorBindingType, String theNewBindingName) {
        ConfigurationObjectEditor coe = DqpPlugin.getInstance().getConfigurationObjectEditor();
        ConnectorBinding binding = coe.createConnectorComponent(Configuration.NEXT_STARTUP_ID, (ComponentTypeID)theConnectorBindingType.getID(), theNewBindingName, null);
        Properties bindingProps = this.getConnectorBindingProperties(theModelReference);
        Properties props = theConnectorBindingType.getDefaultPropertyValues();
        String bindingTypeClass = props.getProperty("Driver");
        String bindingClass = bindingProps.getProperty("Driver");
        if (StringUtil.isEmpty((String)bindingTypeClass) || StringUtil.isEmpty((String)bindingClass) || !bindingTypeClass.equalsIgnoreCase(bindingClass)) {
            return null;
        }
        binding = (ConnectorBinding)coe.modifyProperties((ComponentObject)binding, props, 1);
        binding = (ConnectorBinding)coe.modifyProperties((ComponentObject)binding, bindingProps, 1);
        this.addBinding(binding);
        return binding;
    }

    public ConnectorBinding createConnectorBinding(JdbcSource theSource, ComponentType theConnectorBindingType, String theNewBindingName) throws Exception {
        ConfigurationObjectEditor coe = DqpPlugin.getInstance().getConfigurationObjectEditor();
        ConnectorBinding binding = coe.createConnectorComponent(Configuration.NEXT_STARTUP_ID, (ComponentTypeID)theConnectorBindingType.getID(), theNewBindingName, null);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)theConnectorBindingType.getDefaultPropertyValues());
        if (!StringUtil.isEmpty((String)theSource.getDriverClass())) {
            props.setProperty("Driver", theSource.getDriverClass());
        }
        if (!StringUtil.isEmpty((String)theSource.getUrl())) {
            props.setProperty("URL", theSource.getUrl());
        }
        if (!StringUtil.isEmpty((String)theSource.getUsername())) {
            props.setProperty("User", theSource.getUsername());
        }
        binding = (ConnectorBinding)coe.modifyProperties((ComponentObject)binding, props, 1);
        this.addBinding(binding);
        return binding;
    }

    public ConnectorBinding createConnectorBinding(ComponentType theConnectorType, String theNewBindingName, boolean theAddToConfigurationFlag) throws Exception {
        ConfigurationObjectEditor coe = DqpPlugin.getInstance().getConfigurationObjectEditor();
        ConnectorBinding binding = coe.createConnectorComponent(Configuration.NEXT_STARTUP_ID, (ComponentTypeID)theConnectorType.getID(), theNewBindingName, null);
        Properties bindingProps = DqpPlugin.getInstance().getConfigurationManager().getDefaultBindingProperties(binding.getComponentTypeID());
        binding = (ConnectorBinding)coe.modifyProperties((ComponentObject)binding, bindingProps, 1);
        if (theAddToConfigurationFlag) {
            this.addBinding(binding);
        }
        return binding;
    }

    private Properties getConnectorBindingProperties(ModelReference reference) {
        Properties connectorProps = new Properties();
        Map jdbcProperties = ModelerDqpUtils.getModelJdbcProperties((ModelReference)reference);
        if (!jdbcProperties.isEmpty()) {
            String userName;
            String url;
            String driverClass = (String)jdbcProperties.get("com.metamatrix.modeler.jdbc.JdbcSource.driverClass");
            if (!StringUtil.isEmpty((String)driverClass)) {
                connectorProps.put("Driver", driverClass);
            }
            if (!StringUtil.isEmpty((String)(url = (String)jdbcProperties.get("com.metamatrix.modeler.jdbc.JdbcSource.url")))) {
                connectorProps.put("URL", url);
            }
            if (!StringUtil.isEmpty((String)(userName = (String)jdbcProperties.get("com.metamatrix.modeler.jdbc.JdbcSource.username")))) {
                connectorProps.put("User", userName);
            }
        }
        return connectorProps;
    }
}

