/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyConfigInterface;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Properties;

public class SpyConfig
implements SpyConfigInterface {
    Properties props;

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    public PrintWriter getLogWriter() {
        String string = this.props.getProperty("log");
        if (string == null) {
            return null;
        }
        if (string.startsWith("System.out")) {
            return new PrintWriter(System.out, true);
        }
        if (string.startsWith("(file)")) {
            return this.getFileLogWriter(string.substring(6));
        }
        if (string.startsWith("(socket)")) {
            return this.getSocketLogWriter(string.substring(8));
        }
        return null;
    }

    private PrintWriter getFileLogWriter(String string) {
        try {
            return new PrintWriter(new FileOutputStream(string, true));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private PrintWriter getSocketLogWriter(String string) {
        try {
            int n = string.indexOf(58);
            if (n == -1) {
                return null;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            int n2 = Integer.parseInt(string3);
            Socket socket = new Socket(string2, n2);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream());
            printWriter.println("#logserver#");
            return printWriter;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private PrintStream getFileLogStream(String string) {
        try {
            return new PrintStream(new FileOutputStream(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private PrintStream getSocketLogStream(String string) {
        try {
            int n = string.indexOf(58);
            if (n == -1) {
                return null;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            int n2 = Integer.parseInt(string3);
            Socket socket = new Socket(string2, n2);
            PrintStream printStream = new PrintStream(socket.getOutputStream());
            printStream.println("#logserver#");
            return printStream;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getClassnameToLoad() {
        return this.props.getProperty("load");
    }

    public Boolean getLogTimestamp() {
        String string = this.props.getProperty("timestamp");
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("no")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Integer getLogInputStreams() {
        String string = this.props.getProperty("logIS");
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("yes")) {
            return new Integer(1);
        }
        if (string.equalsIgnoreCase("no")) {
            return new Integer(2);
        }
        if (string.equalsIgnoreCase("NoSingleRead")) {
            return new Integer(3);
        }
        return null;
    }

    public Integer getLogLobs() {
        String string = this.props.getProperty("logLobs");
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("yes")) {
            return new Integer(1);
        }
        if (string.equalsIgnoreCase("no")) {
            return new Integer(2);
        }
        return null;
    }

    public boolean getLogThreadName() {
        return "YES".equalsIgnoreCase(this.props.getProperty("logTName"));
    }

    public Integer getLineLimit() {
        String string = this.props.getProperty("linelimit");
        if (string == null) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

