/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.util.UtilException;
import java.net.InetAddress;
import java.sql.SQLException;

public class TTIFUN_O3LOG
extends TTIFUNDataPacket {
    private static String footprint = "$Revision:   3.9.1.1  $";
    private String userName;
    private byte[] userNameEncoded;
    private byte[] passwordEncoded;
    private String sysUserName;
    private byte[] sysUserNameEncoded;
    private String terminal = "unknown";
    private byte[] terminalEncoded;
    private String localhost;
    private byte[] localhostEncoded;
    private String progName;
    private byte[] progNameEncoded;
    private byte[] encryptionKey;
    private boolean wireCSmatchesOracleCS = true;

    public TTIFUN_O3LOG(boolean bl, String string, byte[] byArray, boolean bl2) {
        this.wireCSmatchesOracleCS = bl2;
        this.TTCCode = 3;
        this.FUNCode = string == null || string.length() <= 0 ? 58 : (bl ? 81 : 82);
        this.userName = string;
        this.passwordEncoded = byArray == null ? new byte[0] : byArray;
        this.sysUserName = System.getProperty("user.name");
        try {
            this.localhost = InetAddress.getLocalHost().toString();
        }
        catch (Exception exception) {
            this.localhost = "unknownclient";
        }
        this.progName = "JDBC Connect Client";
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException {
        if (this.userName != null) {
            this.userNameEncoded = oracleDataConsumer.getTransliterator().encode(this.userName);
            oracleDataConsumer.writeBoolean(this.userNameEncoded.length > 0);
            if (this.wireCSmatchesOracleCS) {
                oracleDataConsumer.writeB4(this.userNameEncoded.length);
            } else {
                oracleDataConsumer.writeB4(this.userName.length());
            }
        }
        oracleDataConsumer.writeBoolean(this.passwordEncoded.length > 0);
        oracleDataConsumer.writeB4(this.passwordEncoded.length);
        oracleDataConsumer.writeByte((byte)0);
        oracleDataConsumer.writeByte((byte)0);
        oracleDataConsumer.writeByte((byte)0);
        oracleDataConsumer.writeByte((byte)0);
        this.terminalEncoded = oracleDataConsumer.getTransliterator().encode(this.terminal);
        oracleDataConsumer.writeBoolean(this.terminalEncoded.length > 0);
        oracleDataConsumer.writeB4(this.terminalEncoded.length);
        this.localhostEncoded = oracleDataConsumer.getTransliterator().encode(this.localhost);
        oracleDataConsumer.writeBoolean(this.localhostEncoded.length > 0);
        if (this.wireCSmatchesOracleCS) {
            oracleDataConsumer.writeB4(this.localhostEncoded.length);
        } else {
            oracleDataConsumer.writeB4(this.localhost.length());
        }
        this.sysUserNameEncoded = oracleDataConsumer.getTransliterator().encode(this.sysUserName);
        oracleDataConsumer.writeBoolean(this.sysUserNameEncoded.length > 0);
        if (this.wireCSmatchesOracleCS) {
            oracleDataConsumer.writeB4(this.sysUserNameEncoded.length);
        } else {
            oracleDataConsumer.writeB4(this.sysUserName.length());
        }
        oracleDataConsumer.writeB4(4096);
        oracleDataConsumer.writeByte((byte)0);
        oracleDataConsumer.writeByte((byte)0);
        this.progNameEncoded = oracleDataConsumer.getTransliterator().encode(this.progName);
        oracleDataConsumer.writeBoolean(this.progNameEncoded.length > 0);
        oracleDataConsumer.writeB4(this.progNameEncoded.length);
        oracleDataConsumer.writeByte((byte)0);
        oracleDataConsumer.writeByte((byte)0);
        oracleDataConsumer.writeByte((byte)0);
        oracleDataConsumer.writeByte((byte)0);
        oracleDataConsumer.writeBoolean(this.FUNCode == 82);
        oracleDataConsumer.writeB4(16);
        oracleDataConsumer.writeBoolean(this.FUNCode == 82);
        if (this.wireCSmatchesOracleCS) {
            oracleDataConsumer.writeBytes(this.userNameEncoded, 0, this.userNameEncoded.length);
            oracleDataConsumer.writeBytes(this.passwordEncoded, 0, this.passwordEncoded.length);
            oracleDataConsumer.writeBytes(this.terminalEncoded, 0, this.terminalEncoded.length);
            oracleDataConsumer.writeBytes(this.localhostEncoded, 0, this.localhostEncoded.length);
            oracleDataConsumer.writeBytes(this.sysUserNameEncoded, 0, this.sysUserNameEncoded.length);
            oracleDataConsumer.writeString("");
            oracleDataConsumer.writeBytes(this.progNameEncoded, 0, this.progNameEncoded.length);
        } else {
            if (this.userNameEncoded.length > 0) {
                oracleDataConsumer.writeCLR(this.userNameEncoded, 0, this.userNameEncoded.length);
            }
            if (this.passwordEncoded.length > 0) {
                oracleDataConsumer.writeCLR(this.passwordEncoded, 0, this.passwordEncoded.length);
            }
            oracleDataConsumer.writeCLR(this.terminalEncoded, 0, this.terminalEncoded.length);
            oracleDataConsumer.writeCLR(this.localhostEncoded, 0, this.localhostEncoded.length);
            oracleDataConsumer.writeCLR(this.sysUserNameEncoded, 0, this.sysUserNameEncoded.length);
            oracleDataConsumer.writeCLR(this.progNameEncoded, 0, this.progNameEncoded.length);
        }
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        short s = oracleDataProvider.readB2();
        if (this.wireCSmatchesOracleCS) {
            this.encryptionKey = new byte[s];
            oracleDataProvider.readBytes(this.encryptionKey, 0, s);
        } else {
            this.encryptionKey = new byte[16];
            oracleDataProvider.readCLRInBuf(this.encryptionKey, 0, 16);
        }
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }
}

