/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.oracle.net8.OracleNet8Communication;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class OracleDataConsumer {
    private static String footprint = "$Revision:   1.8.1.2  $";
    private OracleNet8Communication comm;
    private OutputStream socketOutputStream;
    public UtilTransliterator transliterator;
    public UtilTransliterator transliteratorForNationalCharset;
    private byte[] primaryPacketData;
    private static final int MAXSENDPACKETSIZE = 2048;
    private static final boolean ISFIRSTPACKET = true;
    private static final boolean ISNOTFIRSTPACKET = false;
    private static final boolean LASTPACKETOFREQUEST = true;
    private static final boolean MOREPACKETSTOCOME = false;
    private int numBytesInPrimaryPacketBuffer;
    private int NSPacketType;
    private byte[][] VariableLengthIntArrays;

    public OracleDataConsumer(OracleNet8Communication oracleNet8Communication) {
        this.comm = oracleNet8Communication;
        this.transliterator = this.comm.transliterator;
        this.transliteratorForNationalCharset = this.comm.transliteratorForNationalCharset;
        try {
            this.socketOutputStream = this.comm.socket.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.primaryPacketData = new byte[2048];
        this.numBytesInPrimaryPacketBuffer = 0;
        this.signalStartOfPacket(true);
        this.VariableLengthIntArrays = new byte[5][];
        this.VariableLengthIntArrays[1] = new byte[2];
        this.VariableLengthIntArrays[1][0] = 1;
        this.VariableLengthIntArrays[2] = new byte[3];
        this.VariableLengthIntArrays[2][0] = 2;
        this.VariableLengthIntArrays[3] = new byte[4];
        this.VariableLengthIntArrays[3][0] = 3;
        this.VariableLengthIntArrays[4] = new byte[5];
        this.VariableLengthIntArrays[4][0] = 4;
    }

    protected void signalStartOfPacket(boolean bl) {
        this.primaryPacketData[2] = 0;
        this.primaryPacketData[3] = 0;
        this.primaryPacketData[4] = (byte)this.NSPacketType;
        this.primaryPacketData[5] = 0;
        this.primaryPacketData[6] = 0;
        this.primaryPacketData[7] = 0;
        if (this.NSPacketType == 6 && !bl) {
            this.primaryPacketData[8] = 0;
            this.primaryPacketData[9] = 0;
            this.numBytesInPrimaryPacketBuffer = 10;
        } else {
            this.numBytesInPrimaryPacketBuffer = 8;
        }
    }

    public final void signalEndOfPacket(boolean bl) {
        this.primaryPacketData[0] = (byte)(this.numBytesInPrimaryPacketBuffer >> 8);
        this.primaryPacketData[1] = (byte)this.numBytesInPrimaryPacketBuffer;
        if (!bl) {
            this.primaryPacketData[8] = 0;
            this.primaryPacketData[9] = 32;
        }
    }

    public void setNSPTPacketType(int n) {
        this.NSPacketType = n;
        this.primaryPacketData[4] = (byte)this.NSPacketType;
    }

    public void writeBoolean(boolean bl) throws UtilException {
        if (bl) {
            this.writeByte((byte)1);
        } else {
            this.writeByte((byte)0);
        }
    }

    public void writeB2(short s) throws UtilException {
        if (s == 0) {
            this.writeZero();
        } else if (s < 256) {
            this.VariableLengthIntArrays[1][1] = (byte)s;
            this.writeBytes(this.VariableLengthIntArrays[1], 0, 2);
        } else {
            this.VariableLengthIntArrays[2][1] = (byte)(s >> 8);
            this.VariableLengthIntArrays[2][2] = (byte)s;
            this.writeBytes(this.VariableLengthIntArrays[2], 0, 3);
        }
    }

    public void writeB4(int n) throws UtilException {
        if (n == 0) {
            this.writeZero();
        } else if (n < 256) {
            this.VariableLengthIntArrays[1][1] = (byte)n;
            this.writeBytes(this.VariableLengthIntArrays[1], 0, 2);
        } else if (n < 65536) {
            this.VariableLengthIntArrays[2][1] = (byte)(n >> 8);
            this.VariableLengthIntArrays[2][2] = (byte)n;
            this.writeBytes(this.VariableLengthIntArrays[2], 0, 3);
        } else if (n < 0x1000000) {
            this.VariableLengthIntArrays[3][1] = (byte)(n >> 16);
            this.VariableLengthIntArrays[3][2] = (byte)(n >> 8);
            this.VariableLengthIntArrays[3][3] = (byte)n;
            this.writeBytes(this.VariableLengthIntArrays[3], 0, 4);
        } else {
            this.VariableLengthIntArrays[4][1] = (byte)(n >> 24);
            this.VariableLengthIntArrays[4][2] = (byte)(n >> 16);
            this.VariableLengthIntArrays[4][3] = (byte)(n >> 8);
            this.VariableLengthIntArrays[4][4] = (byte)n;
            this.writeBytes(this.VariableLengthIntArrays[4], 0, 5);
        }
    }

    public OutputStream getCLROutputStream(final OracleDataConsumer oracleDataConsumer, int n) throws UtilException {
        return new OutputStream(){
            private boolean flushed = false;
            private byte[] tempbuf = new byte[64];
            private int bytesintempbuf;
            private boolean firstchunk = true;
            private int totalwrittensofar = 0;
            private OracleDataConsumer thewriter = oracleDataConsumer;
            byte[] SingleByteBuffer;

            public void flush() throws IOException {
                if (!this.flushed) {
                    try {
                        this.thewriter.writeByte((byte)this.bytesintempbuf);
                        this.thewriter.writeBytes(this.tempbuf, 0, this.bytesintempbuf);
                        if (!this.firstchunk) {
                            this.thewriter.writeByte((byte)0);
                        }
                        this.flushed = true;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
            }

            public void write(int n) throws IOException {
                if (this.SingleByteBuffer == null) {
                    this.SingleByteBuffer = new byte[1];
                }
                this.SingleByteBuffer[0] = (byte)n;
                this.write(this.SingleByteBuffer, 0, 1);
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                int n3 = 64 - this.bytesintempbuf;
                try {
                    while (n2 > n3) {
                        System.arraycopy(byArray, n, this.tempbuf, this.bytesintempbuf, n3);
                        n2 -= n3;
                        n += n3;
                        n3 = 0;
                        this.bytesintempbuf = 64;
                        if (this.firstchunk) {
                            this.thewriter.writeByte((byte)-2);
                            this.firstchunk = false;
                        }
                        this.thewriter.writeByte((byte)this.bytesintempbuf);
                        this.thewriter.writeBytes(this.tempbuf, 0, this.bytesintempbuf);
                        n3 = 64;
                        this.bytesintempbuf = 0;
                    }
                    System.arraycopy(byArray, n, this.tempbuf, this.bytesintempbuf, n2);
                    this.bytesintempbuf += n2;
                    n3 -= n2;
                    n2 = 0;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }
        };
    }

    public int writeCLR(InputStream inputStream) throws UtilException {
        int n = 0;
        try {
            byte[] byArray = new byte[64];
            int n2 = inputStream.read(byArray);
            if (n2 < 64) {
                this.writeByte((byte)n2);
                this.writeBytes(byArray, 0, n2);
                n = n2;
            } else {
                byte[] byArray2 = new byte[64];
                n2 = inputStream.read(byArray2);
                if (n2 <= 0) {
                    this.writeByte((byte)64);
                    this.writeBytes(byArray, 0, 64);
                    n = 64;
                } else {
                    this.writeByte((byte)-2);
                    this.writeByte((byte)64);
                    this.writeBytes(byArray, 0, 64);
                    n = 64;
                    do {
                        this.writeByte((byte)n2);
                        this.writeBytes(byArray2, 0, n2);
                        n += n2;
                    } while ((n2 = inputStream.read(byArray2)) > 0);
                    this.writeByte((byte)0);
                }
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1002);
        }
        return n;
    }

    public int writeCLR(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 64) {
            if (this.numBytesInPrimaryPacketBuffer + n2 + 1 <= 2048) {
                this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)n2;
                System.arraycopy(byArray, n, this.primaryPacketData, this.numBytesInPrimaryPacketBuffer, n2);
                this.numBytesInPrimaryPacketBuffer += n2;
            } else {
                this.writeByte((byte)n2);
                this.writeBytes(byArray, n, n2);
            }
        } else {
            int n3;
            int n4 = 0;
            this.writeByte((byte)-2);
            do {
                int n5;
                n3 = (n5 = n2 - n4) <= 64 ? n5 : 64;
                this.writeByte((byte)n3);
                this.writeBytes(byArray, n + n4, n3);
            } while ((n4 += n3) < n2);
            this.writeByte((byte)0);
        }
        return n2;
    }

    public final void writeBigEndianInt16(int n) throws UtilException {
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(n >> 8);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)n;
    }

    public final void writeInt16(int n) throws UtilException {
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)n;
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(n >> 8);
    }

    public final void writeBigEndianInt32(int n) throws UtilException {
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(n >> 24);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(n >> 16);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(n >> 8);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)n;
    }

    public final void writeBigEndianInt64(long l) throws UtilException {
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(l >> 56);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(l >> 48);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(l >> 40);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(l >> 32);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(l >> 24);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(l >> 16);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(l >> 8);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)l;
    }

    public final void writeInt32(int n) throws UtilException {
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)n;
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(n >> 8);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(n >> 16);
        this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = (byte)(n >> 24);
    }

    public final void writeString(String string) throws UtilException {
        byte[] byArray;
        try {
            byArray = string.getBytes("Cp1252");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        this.writeBytes(byArray, 0, byArray.length);
    }

    public final void writeByte(byte by) throws UtilException {
        if (this.numBytesInPrimaryPacketBuffer < 2048) {
            this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = by;
        } else {
            this.signalEndOfPacket(false);
            this.mysend();
            this.signalStartOfPacket(false);
            this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = by;
        }
    }

    public final void writeBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (this.numBytesInPrimaryPacketBuffer + n2 <= 2048) {
            if (n2 < 15) {
                while (n2 > 0) {
                    this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = byArray[n++];
                    --n2;
                }
            } else {
                System.arraycopy(byArray, n, this.primaryPacketData, this.numBytesInPrimaryPacketBuffer, n2);
                this.numBytesInPrimaryPacketBuffer += n2;
            }
        } else {
            int n3 = 2048 - this.numBytesInPrimaryPacketBuffer;
            if (n3 < 15) {
                int n4 = n3;
                while (n4 > 0) {
                    this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = byArray[n++];
                    --n4;
                }
            } else {
                System.arraycopy(byArray, n, this.primaryPacketData, this.numBytesInPrimaryPacketBuffer, n3);
                this.numBytesInPrimaryPacketBuffer += n3;
                n += n3;
            }
            this.signalEndOfPacket(false);
            this.mysend();
            this.signalStartOfPacket(false);
            this.writeBytes(byArray, n, n2 -= n3);
        }
    }

    public final void writeZero() throws UtilException {
        if (this.numBytesInPrimaryPacketBuffer < 2048) {
            this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = 0;
        } else {
            this.signalEndOfPacket(false);
            this.mysend();
            this.signalStartOfPacket(false);
            this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = 0;
        }
    }

    public final void writeZeros(int n) throws UtilException {
        if (this.numBytesInPrimaryPacketBuffer + n <= 2048) {
            while (n > 0) {
                this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = 0;
                --n;
            }
        } else {
            int n2;
            int n3 = n2 = 2048 - this.numBytesInPrimaryPacketBuffer;
            while (n3 > 0) {
                this.primaryPacketData[this.numBytesInPrimaryPacketBuffer++] = 0;
                --n3;
            }
            this.signalEndOfPacket(false);
            this.mysend();
            this.signalStartOfPacket(false);
            this.writeZeros(n -= n2);
        }
    }

    private final void mysend() throws UtilException {
        try {
            this.socketOutputStream.write(this.primaryPacketData, 0, this.numBytesInPrimaryPacketBuffer);
            this.socketOutputStream.flush();
        }
        catch (InterruptedIOException interruptedIOException) {
            String string = UtilException.getLocalizedReason(1033, (String)null);
            throw new UtilException(1018, string);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
        this.numBytesInPrimaryPacketBuffer = 0;
    }

    public final void send() throws UtilException {
        this.signalEndOfPacket(true);
        this.mysend();
        this.signalStartOfPacket(true);
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public void setTransliteratorForNationalCharacterSet(UtilTransliterator utilTransliterator) {
        this.transliteratorForNationalCharset = utilTransliterator;
    }

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public UtilTransliterator getTransliteratorForNationalCharset() {
        return this.transliteratorForNationalCharset;
    }

    public int getPosition() throws UtilException {
        throw new UnsupportedOperationException("Method getPosition() not implemented.");
    }

    public void setPosition(int n) throws UtilException {
        throw new UnsupportedOperationException("Method setPosition() not implemented.");
    }
}

