/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.base.BaseTypeInfo;
import com.metamatrix.jdbc.base.BaseTypeInfos;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.util.UtilStringFunctions;

public class DB2MetaDataLibrary {
    private static String footprint = "$Revision:   3.55.1.4  $";
    public String catalogName = null;
    public static String UNION_ALL = " UNION ALL ";
    public static String UNION = " UNION ";
    public static boolean isUDBCompatible;
    private boolean useSort = false;
    private static DB2ImplConnection con;
    private String catalogSchema;
    private String catalogSchema2;
    private String restrictUser;

    DB2MetaDataLibrary(DB2ImplConnection dB2ImplConnection, String string, String string2) {
        con = dB2ImplConnection;
        isUDBCompatible = dB2ImplConnection.comm.serverOS != 3 && dB2ImplConnection.comm.serverOS != 8;
        this.catalogSchema = string;
        this.catalogSchema2 = string2;
        this.restrictUser = dB2ImplConnection.alternateID == null ? dB2ImplConnection.user.toUpperCase() : dB2ImplConnection.alternateID.toUpperCase();
    }

    public static BaseTypeInfos buildTypeInfo() {
        BaseTypeInfos baseTypeInfos = new BaseTypeInfos();
        String[][] stringArrayArray = isUDBCompatible ? (DB2MetaDataLibrary.con.comm.serverType == 9 ? new String[][]{{"BIGINT", "-5", "20", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32700", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32762", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"LONG VARCHAR", "-1", "32700", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32762", "'", "'", "(Max length)", "1", "1", "3", null, "0", null, "VARCHAR", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}, {"DBCLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "DBCLOB", null, null, null}} : new String[][]{{"BIGINT", "-5", "19", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32700", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32704", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"LONG VARCHAR", "-1", "32700", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32704", "'", "'", "(Max length)", "1", "1", "3", null, "0", null, "VARCHAR", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"CLOB", "2005", "32700", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}}) : (DB2MetaDataLibrary.con.comm.serverOS == 3 ? (DB2MetaDataLibrary.con.comm.serverType == 6 || DB2MetaDataLibrary.con.comm.serverType == 10 ? new String[][]{{"LONG VARCHAR FOR BIT DATA", "-4", "32698", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32698", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"ROWID", "-2", "40", null, null, "not null generated always", "0", "0", "2", "1", "0", "0", "ROWID", null, null, null}, {"LONG VARCHAR", "-1", "32704", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32698", "'", "'", "(Max length)", "1", "1", "1", null, "0", null, "VARCHAR", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}, {"DBCLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "DBCLOB", null, null, null}} : new String[][]{{"LONG VARCHAR FOR BIT DATA", "-4", "32698", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32698", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"ROWID", "-2", "40", null, null, "not null generated always", "0", "0", "2", "1", "0", "0", "ROWID", null, null, null}, {"LONG VARCHAR", "-1", "32704", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32698", "'", "'", "(Max length)", "1", "1", "1", null, "0", null, "VARCHAR", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}}) : (DB2MetaDataLibrary.con.comm.serverType == 3 || DB2MetaDataLibrary.con.comm.serverType == 11 ? new String[][]{{"BIGINT", "-5", "20", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32740", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32739", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "32765", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"ROWID", "-2", "40", null, null, "not null generated always", "0", "0", "2", "1", "0", "0", "ROWID", "0", "0", "10"}, {"LONG VARCHAR", "-1", "32700", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"CHAR", "1", "32765", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32739", "'", "'", "(Max length)", "1", "1", "1", null, "0", null, "VARCHAR", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"BLOB", "2004", "2147483647", null, null, "(length)", "1", "1", "1", null, "0", null, "BLOB", null, null, null}, {"CLOB", "2005", "2147483647", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}, {"DBCLOB", "2005", "2147483647", "'", "'", "(length) CCSID 13488", "1", "1", "1", null, "0", null, "DBCLOB", null, null, null}} : new String[][]{{"BIGINT", "-5", "20", null, null, null, "1", "0", "2", "0", "0", "0", "BIGINT", "0", "0", null}, {"LONG VARCHAR FOR BIT DATA", "-4", "32698", "X'", "'", null, "1", "0", "1", null, "0", null, "LONG VARCHAR FOR BIT DATA", null, null, null}, {"VARCHAR() FOR BIT DATA", "-3", "32698", "X'", "'", "(Max length)", "1", "0", "3", null, "0", null, "VARCHAR() FOR BIT DATA", null, null, null}, {"CHAR() FOR BIT DATA", "-2", "254", "X'", "'", "(length)", "1", "0", "3", null, "0", null, "CHAR() FOR BIT DATA", null, null, null}, {"LONG VARCHAR", "-1", "32698", "'", "'", null, "1", "1", "1", null, "0", null, "LONG VARCHAR", null, null, null}, {"CHAR", "1", "254", "'", "'", "(length)", "1", "1", "3", null, "0", null, "CHAR", null, null, null}, {"NUMERIC", "2", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "NUMERIC", "0", "31", "10"}, {"DECIMAL", "3", "31", null, null, "(Precision, scale)", "1", "0", "2", "0", "0", "0", "DECIMAL", "0", "31", "10"}, {"INTEGER", "4", "10", null, null, null, "1", "0", "2", "0", "0", "0", "INTEGER", "0", "0", "10"}, {"SMALLINT", "5", "5", null, null, null, "1", "0", "2", "0", "0", "0", "SMALLINT", "0", "0", "10"}, {"FLOAT", "6", "15", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT", null, null, "10"}, {"REAL", "7", "7", null, null, null, "1", "0", "2", "0", "0", "0", "FLOAT(4)", null, null, "10"}, {"DOUBLE", "8", "15", null, null, null, "1", "0", "2", "0", "0", "0", "DOUBLE", null, null, "10"}, {"VARCHAR", "12", "32698", "'", "'", "(Max length)", "1", "1", "1", null, "0", null, "VARCHAR", null, null, null}, {"DATE", "91", "10", "{d '", "'}", null, "1", "0", "2", null, "0", null, "DATE", null, null, null}, {"TIME", "92", "8", "{t '", "'}", null, "1", "0", "2", null, "0", null, "TIME", null, null, null}, {"TIMESTAMP", "93", "26", "{ts '", "'}", null, "1", "0", "2", null, "0", null, "TIMESTAMP", "6", "6", null}, {"CLOB", "2005", "32700", "'", "'", "(length)", "1", "1", "1", null, "0", null, "CLOB", null, null, null}}));
        int n = 0;
        while (n < stringArrayArray.length) {
            BaseTypeInfo baseTypeInfo = new BaseTypeInfo();
            baseTypeInfo.typeName = stringArrayArray[n][0];
            baseTypeInfo.dataType = Short.valueOf(stringArrayArray[n][1]);
            baseTypeInfo.maxPrecision = Integer.valueOf(stringArrayArray[n][2]);
            baseTypeInfo.literalPrefix = stringArrayArray[n][3];
            baseTypeInfo.literalSuffix = stringArrayArray[n][4];
            baseTypeInfo.createParams = stringArrayArray[n][5];
            baseTypeInfo.nullable = Short.valueOf(stringArrayArray[n][6]);
            baseTypeInfo.caseSensitive = stringArrayArray[n][7] != null ? (stringArrayArray[n][7].equals("1") ? Boolean.TRUE : Boolean.FALSE) : null;
            baseTypeInfo.searchable = Short.valueOf(stringArrayArray[n][8]);
            baseTypeInfo.unsignedAttribute = stringArrayArray[n][9] != null ? (stringArrayArray[n][9].equals("1") ? Boolean.TRUE : Boolean.FALSE) : null;
            baseTypeInfo.fixedPrecScale = stringArrayArray[n][10] != null ? (stringArrayArray[n][10].equals("1") ? Boolean.TRUE : Boolean.FALSE) : null;
            baseTypeInfo.autoIncrement = stringArrayArray[n][11] != null ? (stringArrayArray[n][11].equals("1") ? Boolean.TRUE : Boolean.FALSE) : null;
            baseTypeInfo.localTypeName = stringArrayArray[n][12];
            baseTypeInfo.minimumScale = stringArrayArray[n][13] == null ? null : Short.valueOf(stringArrayArray[n][13]);
            baseTypeInfo.maximumScale = stringArrayArray[n][14] == null ? null : Short.valueOf(stringArrayArray[n][14]);
            baseTypeInfo.numPrecRadix = stringArrayArray[n][15] == null ? null : Integer.valueOf(stringArrayArray[n][15]);
            baseTypeInfos.add(baseTypeInfo);
            ++n;
        }
        return baseTypeInfos;
    }

    public String[] getTableTypeNames() {
        String[] stringArray = null;
        if (isUDBCompatible) {
            String[] stringArray2 = new String[]{"ALIAS", "HIERARCHY TABLE", "NICKNAME", "SUMMARY TABLE", "SYNONYMS", "SYSTEM TABLE", "TABLE", "VIEW"};
            stringArray = stringArray2;
        } else {
            String[] stringArray3;
            stringArray = stringArray3 = new String[]{"ALIAS", "SYNONYM", "SYSTEM TABLE", "TABLE", "TEMPORARY TABLE", "VIEW"};
        }
        return stringArray;
    }

    public String getTableString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        String string;
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND TABSCHEMA ", " AND TABNAME "};
        String[] stringArray2 = new String[]{" AND CREATOR ", " AND NAME "};
        String[] stringArray3 = new String[]{" AND TABLE_SCHEMA ", " AND TABLE_NAME "};
        String string2 = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string2 != null && !this.catalogNameMatches(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string2 == null) {
            string2 = this.catalogName;
        }
        String[] stringArray4 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (isUDBCompatible) {
            string5 = "SELECT '" + string2 + "', TABSCHEMA, TABNAME,";
            string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray4, nArray);
        } else if (DB2MetaDataLibrary.con.comm.serverOS == 8) {
            string7 = "SELECT '" + string2 + "', TABLE_SCHEMA, TABLE_NAME,";
            string8 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray3, stringArray4, nArray);
        } else {
            string3 = "SELECT '" + string2 + "', CREATOR, NAME,";
            string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray4, nArray);
        }
        String string9 = " 'TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'T' AND NOT (CREATOR IN ('SYSIBM', 'SYSCAT', '" + this.catalogSchema + "'))";
        String string10 = " 'TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'T' AND TABSCHEMA <> 'SYSIBM' AND TABSCHEMA <> 'SYSCAT' AND TABSCHEMA <> '" + this.catalogSchema + "'";
        String string11 = " 'TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE (TYPE = 'T' OR TYPE = 'P') AND TABLE_SCHEMA <> 'QSYS2' AND TABLE_SCHEMA <> 'QSYS2' AND TABLE_SCHEMA <> '" + this.catalogSchema + "'";
        String string12 = " 'VIEW', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'V'";
        String string13 = " 'VIEW', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE (TYPE = 'V' OR TYPE = 'L') ";
        String string14 = " 'ALIAS', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'A'";
        String string15 = " 'SYNONYM', ' ',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE 1=1";
        String string16 = " 'HIERARCHY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'H'";
        String string17 = " 'NICKNAME', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'N'";
        String string18 = " 'SUMMARY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TYPE = 'S'";
        String string19 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE CREATOR = '" + this.catalogSchema + "'";
        String string20 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TABSCHEMA = '" + this.catalogSchema + "'";
        String string21 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM ? WHERE TABLE_SCHEMA = '" + this.catalogSchema + "'";
        String string22 = " ORDER BY 4, 2, 3 FOR FETCH ONLY";
        String[] stringArray5 = (String[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string23 = this.catalogSchema + ".TABLES";
        String string24 = string5;
        String string25 = string6;
        if (!isUDBCompatible) {
            if (DB2MetaDataLibrary.con.comm.serverOS == 8) {
                string23 = this.catalogSchema + ".SYSTABLES";
                string24 = string7;
                string25 = string8;
            } else {
                string23 = this.catalogSchema + ".SYSTABLES";
                string24 = string3;
                string25 = string4;
            }
        }
        if (string25.indexOf(" LIKE ") > 0) {
            string25 = string25 + " ESCAPE '\\'";
        }
        String[] stringArray6 = new String[]{"?", string23};
        String[] stringArray7 = new String[]{"?", this.catalogSchema + ".SYSSYNONYMS"};
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (stringArray5 == null) {
            stringArray5 = this.getTableTypeNames();
        }
        int n = 0;
        while (n < stringArray5.length) {
            string = null;
            if (stringArray5[n].equals("TABLE")) {
                string = isUDBCompatible ? string24 + string10 : (DB2MetaDataLibrary.con.comm.serverOS == 8 ? string24 + string11 : string24 + string9);
            }
            if (stringArray5[n].equals("VIEW")) {
                string = DB2MetaDataLibrary.con.comm.serverOS == 8 ? string24 + string13 : string24 + string12;
            }
            if (stringArray5[n].equals("ALIAS") && !bl) {
                string = string24 + string14;
                bl = true;
            }
            if (stringArray5[n].equals("SYNONYMS") || stringArray5[n].equals("SYNONYM")) {
                if (DB2MetaDataLibrary.con.comm.serverOS == 3) {
                    string = string24 + string15;
                } else if (!bl) {
                    string = string24 + string14;
                    bl = true;
                }
            }
            if (stringArray5[n].equals("NICKNAME")) {
                string = string24 + string17;
            }
            if (stringArray5[n].equals("SUMMARY TABLE")) {
                string = string24 + string18;
            }
            if (stringArray5[n].equals("HIERARCHY TABLE")) {
                string = string24 + string16;
            }
            if (stringArray5[n].equals("SYSTEM TABLE")) {
                string = isUDBCompatible ? string24 + string20 : (DB2MetaDataLibrary.con.comm.serverOS == 8 ? string24 + string21 : string24 + string19);
            }
            if (string != null) {
                StringBuffer stringBuffer2 = new StringBuffer();
                if ((stringArray5[n].equals("SYNONYMS") || stringArray5[n].equals("SYNONYM")) && DB2MetaDataLibrary.con.comm.serverOS == 3) {
                    UtilStringFunctions.replaceStringDelimiters(string, stringArray7, stringBuffer2, false);
                } else {
                    UtilStringFunctions.replaceStringDelimiters(string, stringArray6, stringBuffer2, false);
                }
                string = stringBuffer2.toString() + string25;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(UNION);
                }
                stringBuffer.append(string);
                stringBuffer2 = null;
            }
            ++n;
        }
        string = stringBuffer.toString();
        if (string != null && string.trim().length() > 0) {
            string = string + string22;
        }
        return string;
    }

    public String getUDBTableString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor, boolean bl) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND A.TABSCHEMA ", " AND A.TABNAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = null;
        String string3 = null;
        string2 = "SELECT DISTINCT '" + string + "', A.TABSCHEMA, A.TABNAME,";
        string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        if (bl) {
            string4 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A, " + this.catalogSchema + ".TABAUTH B WHERE A.TYPE = 'T'" + " AND A.TABNAME = B.TABNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')" + " AND A.TABSCHEMA <> 'SYSIBM' AND A.TABSCHEMA <> 'SYSCAT' AND A.TABSCHEMA <> '" + this.catalogSchema + "'";
            string5 = " 'VIEW', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A, " + this.catalogSchema + ".TABAUTH B WHERE A.TYPE = 'V' " + " AND A.TABNAME = B.TABNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string6 = " 'ALIAS', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A, " + this.catalogSchema + ".TABAUTH B WHERE A.TYPE = 'A' " + " AND A.BASE_TABNAME = B.TABNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string7 = " 'HIERARCHY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'H'";
            string8 = " 'NICKNAME', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'N'";
            string9 = " 'SUMMARY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'S'";
            string10 = " 'SYSTEM TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)  FROM " + this.catalogSchema + ".TABLES A WHERE A.TABSCHEMA = '" + this.catalogSchema + "'";
        } else {
            string4 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'T'" + " AND A.TABSCHEMA <> 'SYSIBM' AND A.TABSCHEMA <> 'SYSCAT' AND A.TABSCHEMA <> '" + this.catalogSchema + "'";
            string5 = " 'VIEW', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'V'";
            string6 = " 'ALIAS', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'A'";
            string7 = " 'HIERARCHY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'H'";
            string8 = " 'NICKNAME', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'N'";
            string9 = " 'SUMMARY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TYPE = 'S'";
            string10 = " 'SYSTEM TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".TABLES A WHERE A.TABSCHEMA = '" + this.catalogSchema + "'";
        }
        String string11 = " ORDER BY 4, 2, 3 FOR FETCH ONLY";
        String[] stringArray3 = (String[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string12 = string2;
        String string13 = string3;
        if (string13.indexOf(" LIKE ") > 0) {
            string13 = string13 + " ESCAPE '\\'";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if (stringArray3 == null) {
            stringArray3 = this.getTableTypeNames();
        }
        String string14 = null;
        int n = 0;
        while (n < stringArray3.length) {
            string14 = null;
            if (stringArray3[n].equals("TABLE")) {
                string14 = string12 + string4;
            } else if (stringArray3[n].equals("VIEW")) {
                string14 = string12 + string5;
            } else if (stringArray3[n].equals("ALIAS")) {
                if (!bl2) {
                    string14 = string12 + string6;
                    bl2 = true;
                }
            } else if (stringArray3[n].equals("SYNONYMS") || stringArray3[n].equals("SYNONYM")) {
                if (!bl2) {
                    string14 = string12 + string6;
                }
                bl2 = true;
            } else if (stringArray3[n].equals("NICKNAME")) {
                string14 = string12 + string8;
            } else if (stringArray3[n].equals("SUMMARY TABLE")) {
                string14 = string12 + string9;
            } else if (stringArray3[n].equals("HIERARCHY TABLE")) {
                string14 = string12 + string7;
            } else if (stringArray3[n].equals("SYSTEM TABLE")) {
                string14 = string12 + string10;
            }
            if (string14 != null) {
                string14 = string14 + string13;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(UNION);
                }
                stringBuffer.append(string14);
            }
            ++n;
        }
        String string15 = stringBuffer.toString();
        if (string15 != null && string15.trim().length() > 0) {
            string15 = string15 + string11;
        }
        return string15;
    }

    public String getUDBColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND TABSCHEMA ", " AND TABNAME ", " AND COLNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "', TABSCHEMA, TABNAME, COLNAME, 0, TYPENAME," + " LENGTH, 0, SCALE, 10, 1, REMARKS, DEFAULT, 0," + " 0, 0, COLNO+1, 'YES',nullif(1,1),nullif(1,1),nullif(1,1)" + ",nullif(1,1) FROM " + this.catalogSchema + ".COLUMNS" + " WHERE NULLS LIKE '%Y%'";
        String string3 = "SELECT '" + string + "', TABSCHEMA, TABNAME, COLNAME, 0, TYPENAME," + " LENGTH, 0, SCALE, 10, 0, REMARKS, DEFAULT, 0," + " 0, 0, COLNO+1, 'NO',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)" + " FROM " + this.catalogSchema + ".COLUMNS" + " WHERE NULLS LIKE '%N%'";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3, 17 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string4.indexOf(" LIKE ") > 0) {
            string4 = string4 + " ESCAPE '\\'";
        }
        String string6 = null;
        if (DB2MetaDataLibrary.con.catalogIncludesSynonyms) {
            String[] stringArray3 = new String[]{" AND B.TABSCHEMA ", " AND B.TABNAME ", " AND A.COLNAME "};
            String string7 = "SELECT '" + string + "', B.TABSCHEMA, B.TABNAME, A.COLNAME, 0, A.TYPENAME," + " A.LENGTH, 0, A.SCALE, 10, 1, A.REMARKS, A.DEFAULT, 0," + " 0, 0, A.COLNO+1, 'YES',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)" + " FROM " + this.catalogSchema + ".COLUMNS A, " + this.catalogSchema + ".TABLES B " + " WHERE NULLS LIKE '%Y%' AND B.BASE_TABNAME=A.TABNAME  AND A.TABSCHEMA=B.BASE_TABSCHEMA";
            String string8 = "SELECT '" + string + "', B.TABSCHEMA, B.TABNAME, A.COLNAME, 0, A.TYPENAME," + " A.LENGTH, 0, A.SCALE, 10, 0, A.REMARKS, A.DEFAULT, 0," + " 0, 0, A.COLNO+1, 'NO',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1)" + " FROM " + this.catalogSchema + ".COLUMNS A, " + this.catalogSchema + ".TABLES B " + " WHERE NULLS LIKE '%N%' AND B.BASE_TABNAME=A.TABNAME  AND A.TABSCHEMA=B.BASE_TABSCHEMA";
            String string9 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray3, stringArray2, nArray);
            string6 = string2 + string4 + UNION + string7 + string9 + UNION_ALL + string3 + string4 + UNION + string8 + string9 + string5;
        } else {
            string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        }
        return string6;
    }

    public String getUDBProcedureString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND PROCSCHEMA ", " AND PROCNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', PROCSCHEMA, PROCNAME, 0, 0, 0, REMARKS, " + 1 + " FROM " + this.catalogSchema + ".PROCEDURES WHERE RESULT_SETS = 0 ";
        String string3 = "SELECT '" + string + "', PROCSCHEMA, PROCNAME, 0, 0, 0, REMARKS, " + 2 + " FROM " + this.catalogSchema + ".PROCEDURES WHERE RESULT_SETS > 0 ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string4.indexOf(" LIKE ") > 0) {
            string4 = string4 + " ESCAPE '\\'";
        }
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getUDBProcedureColumnsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        Object object;
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String string2 = null;
        if (this.useSort && baseResultSetSortDescriptor.getSortCount() > 0) {
            string2 = " ORDER BY ";
            int n = 0;
            while (n < baseResultSetSortDescriptor.getSortCount()) {
                int n2 = baseResultSetSortDescriptor.getSortColumnOrdinal(n);
                if (n2 > 0) {
                    object = String.valueOf(n2);
                    if (n > 0) {
                        string2 = string2 + ",";
                    }
                    string2 = string2 + (String)object;
                }
                ++n;
            }
            string2 = string2 + " FOR FETCH ONLY";
        }
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND PROCSCHEMA ", " AND PROCNAME ", " AND PARMNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        object = new int[]{2, 3, 4};
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, (int[])object);
        String string4 = "SELECT '" + string + "', PROCSCHEMA, PROCNAME, PARMNAME, " + 1 + ", ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10," + 0 + ", ' '" + " FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%N%' AND PARM_MODE LIKE '%IN%' AND NOT (PARM_MODE IN ('INOUT'))";
        String string5 = "SELECT '" + string + "', PROCSCHEMA, PROCNAME, PARMNAME, " + 1 + ", ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10," + 1 + ", ' '" + " FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%Y%' AND PARM_MODE LIKE '%IN%' AND NOT (PARM_MODE IN ('INOUT'))";
        String string6 = "SELECT '" + string + "', PROCSCHEMA, PROCNAME, PARMNAME, " + 4 + ", ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10," + 0 + ", ' '" + " FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%N%' AND PARM_MODE LIKE 'OUT%'";
        String string7 = "SELECT '" + string + "', PROCSCHEMA, PROCNAME, PARMNAME, " + 4 + ", ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10," + 1 + ", ' '" + " FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%Y%' AND PARM_MODE LIKE 'OUT%'";
        String string8 = "SELECT '" + string + "', PROCSCHEMA, PROCNAME, PARMNAME, " + 2 + ", ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10," + 0 + ", ' '" + " FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%N%' AND PARM_MODE LIKE 'INOUT%'";
        String string9 = "SELECT '" + string + "', PROCSCHEMA, PROCNAME, PARMNAME, " + 2 + ", ORDINAL, TYPENAME, LENGTH, LENGTH, SCALE, 10," + 1 + ", ' '" + " FROM " + this.catalogSchema + ".PROCPARMS WHERE NULLS LIKE '%Y%' AND PARM_MODE LIKE 'INOUT%'";
        if (string2 == null) {
            string2 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        }
        if (string3.indexOf(" LIKE ") > 0) {
            string3 = string3 + " ESCAPE '\\'";
        }
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = string4 + string3 + UNION_ALL + string5 + string3 + UNION_ALL + string8 + string3 + UNION_ALL + string9 + string3 + UNION_ALL + string6 + string3 + UNION_ALL + string7 + string3 + string2;
        return string10;
    }

    public String getUDBSchemaString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "select rtrim(schemaname),nullif(1,1) from " + this.catalogSchema + ".schemata ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getUDBCatalogString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "SELECT DISTINCT '" + this.catalogName + "' FROM " + this.catalogSchema + ".TABLES ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getUDBColumnPrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND C.TABSCHEMA ", " AND C.TABNAME ", " AND T.COLNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'UPDATE', 'YES'" + " FROM " + this.catalogSchema + ".COLAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.COLNAME = T.COLNAME AND C.TABNAME = T.TABNAME AND C.PRIVTYPE = 'U' AND C.GRANTABLE = 'G'";
        String string3 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'UPDATE', 'NO'" + " FROM " + this.catalogSchema + ".COLAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.COLNAME = T.COLNAME AND C.TABNAME = T.TABNAME AND C.PRIVTYPE = 'U' AND C.GRANTABLE = 'N'";
        String string4 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'REFERENCE', 'YES'" + " FROM " + this.catalogSchema + ".COLAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.COLNAME = T.COLNAME AND C.TABNAME = T.TABNAME AND C.PRIVTYPE = 'R' AND C.GRANTABLE = 'G'";
        String string5 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'REFERENCE', 'NO'" + " FROM " + this.catalogSchema + ".COLAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.COLNAME = T.COLNAME AND C.TABNAME = T.TABNAME AND C.PRIVTYPE = 'R' AND C.GRANTABLE = 'N'";
        String string6 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'SELECT', 'YES'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.SELECTAUTH = 'G'";
        String string7 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'SELECT', 'NO'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.SELECTAUTH = 'Y'";
        String string8 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'INSERT', 'YES'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.INSERTAUTH = 'G'";
        String string9 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'INSERT', 'NO'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.INSERTAUTH = 'Y'";
        String string10 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'DELETE', 'YES'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.DELETEAUTH = 'G'";
        String string11 = "SELECT '" + string + "',C.TABSCHEMA, C.TABNAME, T.COLNAME, C.GRANTOR, C.GRANTEE, 'DELETE', 'NO'" + " FROM " + this.catalogSchema + ".TABAUTH C, " + this.catalogSchema + ".COLUMNS T WHERE C.TABSCHEMA = T.TABSCHEMA AND C.TABNAME = T.TABNAME AND C.DELETEAUTH = 'Y'";
        String string12 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string13 = " ORDER BY 4, 7 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string12.indexOf(" LIKE ") > 0) {
            string12 = string12 + " ESCAPE '\\'";
        }
        String string14 = string2 + string12 + UNION_ALL + string3 + string12 + UNION_ALL + string4 + string12 + UNION_ALL + string5 + string12 + UNION_ALL + string6 + string12 + UNION_ALL + string7 + string12 + UNION_ALL + string8 + string12 + UNION_ALL + string9 + string12 + UNION_ALL + string10 + string12 + UNION_ALL + string11 + string12 + string13;
        return string14;
    }

    public String getUDBTablePrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND TABSCHEMA ", " AND TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string3 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        String string4 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,' ',' ' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE LENGTH(TABNAME) > 0";
        String string5 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'ALTER','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE ALTERAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string6 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'ALTER','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE ALTERAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string7 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'DELETE','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE DELETEAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string8 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'DELETE','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE DELETEAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string9 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'INDEX','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE INDEXAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string10 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'INDEX','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE INDEXAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string11 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'INSERT','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE INSERTAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string12 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'INSERT','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE INSERTAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string13 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'REFERENCE','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE REFAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string14 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'REFERENCE','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE REFAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string15 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'SELECT','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE SELECTAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string16 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'SELECT','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE SELECTAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        String string17 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'UPDATE','YES' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE UPDATEAUTH LIKE '%Y%' AND CONTROLAUTH LIKE '%Y%'";
        String string18 = "SELECT '" + string + "',TABSCHEMA,TABNAME,GRANTOR,GRANTEE,'UPDATE','NO' FROM " + this.catalogSchema + ".TABAUTH" + " WHERE UPDATEAUTH LIKE '%G%' AND CONTROLAUTH LIKE '%N%'";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string2.indexOf(" LIKE ") > 0) {
            string2 = string2 + " ESCAPE '\\'";
        }
        String string19 = string4 + string2 + " UNION " + string5 + string2 + UNION_ALL + string6 + string2 + UNION_ALL + string7 + string2 + UNION_ALL + string8 + string2 + UNION_ALL + string9 + string2 + UNION_ALL + string10 + string2 + UNION_ALL + string11 + string2 + UNION_ALL + string12 + string2 + UNION_ALL + string13 + string2 + UNION_ALL + string14 + string2 + UNION_ALL + string15 + string2 + UNION_ALL + string16 + string2 + UNION_ALL + string17 + string2 + UNION_ALL + string18 + string2 + string3;
        return string19;
    }

    public String getUDBBestRowIdentifierString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" CT.TABSCHEMA ", " AND CT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        int n = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
        String string = "";
        String string2 = "";
        String string3 = "SELECT 0, CT.COLNAME, 0, CT.TYPENAME, CT.LENGTH, 0, CT.SCALE, 0 FROM  " + this.catalogSchema + ".COLUMNS CT WHERE ";
        String string4 = "SELECT 1, CT.COLNAME, 0, CT.TYPENAME, CT.LENGTH, 0, CT.SCALE, 0 FROM  " + this.catalogSchema + ".COLUMNS CT WHERE CT.NULLS = 'N' AND ";
        String string5 = "SELECT 1, CT.COLNAME, 0, CT.TYPENAME, CT.LENGTH, 0, CT.SCALE,1 FROM " + this.catalogSchema + ".COLUMNS CT, " + this.catalogSchema + ".KEYCOLUSE CU WHERE CU.TABSCHEMA = CT.TABSCHEMA AND CU.TABNAME = CT.TABNAME AND CU.COLNAME = CT.COLNAME AND ";
        String string6 = "SELECT 2, CT.COLNAME, 0, CT.TYPENAME, CT.LENGTH, 0, CT.SCALE, 1 FROM " + this.catalogSchema + ".INDEXES IT, " + this.catalogSchema + ".COLUMNS CT WHERE IT.TABSCHEMA = CT.TABSCHEMA AND IT.TABNAME = CT.TABNAME AND AND (IT.UNIQUERULE = 'P' OR IT.UNIQUERULE = 'U') AND ";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string8 = " ORDER BY 1 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string9 = null;
        string9 = bl && n == 0 ? string3 + string7 : string4 + string7;
        if (n == 1) {
            string9 = string9 + UNION_ALL + string5 + string7;
        }
        if (n == 2) {
            string9 = string9 + UNION_ALL + string6 + string7;
        }
        string9 = string9 + string8;
        return string9;
    }

    public String getUDBVersionColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND TABSCHEMA ", " AND TABNAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string3 = "SELECT 0, COLNAME, 0, TYPENAME, LENGTH, 0, SCALE, 0 FROM  " + this.catalogSchema + ".COLUMNS WHERE NULLS = 'N' AND GENERATED = 'A' ";
        String string4 = string3 + string2;
        return string4;
    }

    public String getUDBPrimaryKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND IT.TABSCHEMA ", " AND IT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT DISTINCT '" + string + "', IT.TABSCHEMA, IT.TABNAME, KT.COLNAME, KT.COLSEQ, IT.INDNAME" + " FROM " + this.catalogSchema + ".INDEXCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.INDSCHEMA = KT.INDSCHEMA AND KT.INDNAME = IT.INDNAME";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 4 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getUDBExportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND IT.DEFINER ", " AND IT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 3 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'A'";
        String string3 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 0 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'C'";
        String string4 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 2 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'N'";
        String string5 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 1 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'R'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string7 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = string2 + string6 + UNION_ALL + string3 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string5 + string6 + string7;
        return string8;
    }

    public String getUDBImportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND IT.DEFINER ", " AND FT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 6, 7);
        int[] nArray = new int[]{6, 7};
        String string2 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 3 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'A'";
        String string3 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 0 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'C'";
        String string4 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 2 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'N'";
        String string5 = "SELECT '" + string + "', PT.TABSCHEMA, PT.TABNAME, PT.COLNAME," + " '" + string + "', FT.TABSCHEMA, FT.TABNAME, FT.COLNAME, PT.COLSEQ," + 3 + ", " + 1 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE PT, " + this.catalogSchema + ".KEYCOLUSE FT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = PT.TABSCHEMA AND IT.TABNAME = PT.TABNAME" + " AND PT.TABSCHEMA = RT.REFTABSCHEMA AND PT.TABNAME = RT.REFTABNAME" + " AND FT.TABSCHEMA = RT.TABSCHEMA AND FT.TABNAME = RT.TABNAME" + " AND PT.COLSEQ = FT.COLSEQ" + " AND RT.DELETERULE = 'R'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string7 = " ORDER BY 2, 3, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = string2 + string6 + " UNION " + string3 + string6 + " UNION " + string4 + string6 + " UNION " + string5 + string6 + string7;
        return string8;
    }

    public String getUDBCrossReferenceString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        String string2 = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string) || !this.catalogNameMatches(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{"", " AND RT.REFTABSCHEMA ", " AND RT.REFTABNAME ", "", " AND RT.TABSCHEMA ", " AND RT.TABNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 0, 0);
        int[] nArray = new int[]{-1, 2, 3, -1, 6, 7};
        String string3 = "SELECT '" + string + "', RT.REFTABSCHEMA, RT.REFTABNAME, RT.PK_COLNAMES," + " '" + string + "', RT.TABSCHEMA, RT.TABNAME, RT.FK_COLNAMES, KT.COLSEQ," + 3 + ", " + 3 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = KT.TABSCHEMA AND IT.TABNAME = KT.TABNAME" + " AND KT.TABSCHEMA = RT.REFTABSCHEMA AND KT.TABNAME = RT.REFTABNAME" + " AND RT.DELETERULE = 'A'";
        String string4 = "SELECT '" + string + "', RT.REFTABSCHEMA, RT.REFTABNAME, RT.PK_COLNAMES," + " '" + string + "', RT.TABSCHEMA, RT.TABNAME, RT.FK_COLNAMES, KT.COLSEQ," + 3 + ", " + 0 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = KT.TABSCHEMA AND IT.TABNAME = KT.TABNAME" + " AND KT.TABSCHEMA = RT.REFTABSCHEMA AND KT.TABNAME = RT.REFTABNAME" + " AND RT.DELETERULE = 'C'";
        String string5 = "SELECT '" + string + "', RT.REFTABSCHEMA, RT.REFTABNAME, RT.PK_COLNAMES," + " '" + string + "', RT.TABSCHEMA, RT.TABNAME, RT.FK_COLNAMES, KT.COLSEQ," + 3 + ", " + 2 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = KT.TABSCHEMA AND IT.TABNAME = KT.TABNAME" + " AND KT.TABSCHEMA = RT.REFTABSCHEMA AND KT.TABNAME = RT.REFTABNAME" + " AND RT.DELETERULE = 'N'";
        String string6 = "SELECT '" + string + "', RT.REFTABSCHEMA, RT.REFTABNAME, RT.PK_COLNAMES," + " '" + string + "', RT.TABSCHEMA, RT.TABNAME, RT.FK_COLNAMES, KT.COLSEQ," + 3 + ", " + 1 + "," + " RT.CONSTNAME, IT.INDNAME, " + 7 + " FROM " + this.catalogSchema + ".REFERENCES RT, " + this.catalogSchema + ".KEYCOLUSE KT, " + this.catalogSchema + ".INDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.DEFINER = KT.TABSCHEMA AND IT.TABNAME = KT.TABNAME" + " AND KT.TABSCHEMA = RT.REFTABSCHEMA AND KT.TABNAME = RT.REFTABNAME" + " AND RT.DELETERULE = 'R'";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string8 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string9 = string3 + string7 + UNION_ALL + string4 + string7 + UNION_ALL + string5 + string7 + UNION_ALL + string6 + string7 + string8;
        return string9;
    }

    public String getUDBIndexInfoString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND IT.DEFINER ", " AND IT.TABNAME "};
        String[] stringArray2 = new String[]{" AND TABSCHEMA ", " AND TABNAME "};
        String[] stringArray3 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
        String string2 = "SELECT '" + string + "', IT.TABSCHEMA, IT.TABNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.INDNAME, " + 1 + "," + " IU.COLSEQ, IU.COLNAME, IU.COLORDER, IT.UNIQUE_COLCOUNT, IT.SEQUENTIAL_PAGES, ' '" + " FROM " + this.catalogSchema + ".INDEXCOLUSE IU, " + this.catalogSchema + ".INDEXES IT WHERE IU.INDNAME = IT.INDNAME" + " AND IU.INDSCHEMA = IT.INDSCHEMA AND IT.INDEXTYPE = 'CLUS'";
        String string3 = "SELECT '" + string + "', IT.TABSCHEMA, IT.TABNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.INDNAME, " + 1 + "," + " IU.COLSEQ, IU.COLNAME, IU.COLORDER, IT.UNIQUE_COLCOUNT, IT.SEQUENTIAL_PAGES , ' '" + " FROM " + this.catalogSchema + ".INDEXCOLUSE IU, " + this.catalogSchema + ".INDEXES IT WHERE IU.INDNAME = IT.INDNAME" + " AND IU.INDSCHEMA = IT.INDSCHEMA AND IT.INDEXTYPE = 'CLUS' AND IT.UNIQUERULE = 'U'";
        String string4 = "SELECT '" + string + "', IT.TABSCHEMA, IT.TABNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.INDNAME, " + 3 + "," + " IU.COLSEQ, IU.COLNAME, IU.COLORDER, IT.UNIQUE_COLCOUNT, IT.SEQUENTIAL_PAGES , ' '" + " FROM " + this.catalogSchema + ".INDEXCOLUSE IU, " + this.catalogSchema + ".INDEXES IT WHERE IU.INDNAME = IT.INDNAME" + " AND IU.INDSCHEMA = IT.INDSCHEMA AND IT.INDEXTYPE = 'REG'";
        String string5 = "SELECT '" + string + "', IT.TABSCHEMA, IT.TABNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.INDNAME, " + 3 + "," + " IU.COLSEQ, IU.COLNAME, IU.COLORDER, IT.UNIQUE_COLCOUNT, IT.SEQUENTIAL_PAGES , ' '" + " FROM " + this.catalogSchema + ".INDEXCOLUSE IU, " + this.catalogSchema + ".INDEXES IT WHERE IU.INDNAME = IT.INDNAME" + " AND IU.INDSCHEMA = IT.INDSCHEMA AND IT.INDEXTYPE = 'REG' AND IT.UNIQUERULE = 'U'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray3, nArray);
        String string7 = "SELECT '" + string + "', TABSCHEMA, TABNAME, 0," + " NULLIF('',''), NULLIF('',''), " + 0 + "," + " 0, NULLIF('',''), NULLIF('',''), 0, 0, NULLIF('','')" + " FROM " + this.catalogSchema + ".TABLES WHERE TABNAME <> ' '";
        String string8 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray3, nArray);
        String string9 = " ORDER BY 4, 7, 6, 8 FOR FETCH ONLY";
        StringBuffer stringBuffer = new StringBuffer();
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = null;
        if (bl) {
            string10 = string3 + string6 + UNION_ALL + string5 + string6 + UNION_ALL + string7 + string8;
        } else if (!bl) {
            string10 = string2 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string7 + string8;
        }
        string10 = string10 + string9;
        return string10;
    }

    public String getUDBsUDTsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 1, 3);
        int[] nArray = (int[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string2 = "SELECT '" + string + "', TYPESCHEMA, TYPENAME, REMOTE_TYPNAME, 0, REMARKS FROM " + this.catalogSchema + ".TYPEMAPPINGS";
        String string3 = " WHERE TYPESCHEMA LIKE ? AND TYPENAME LIKE ? ";
        String string4 = " AND TYPEID = ? ";
        String string5 = " ORDER BY 2, 3 FOR FETCH ONLY";
        String[] stringArray2 = new String[]{"?", stringArray[2], stringArray[3]};
        String[] stringArray3 = new String[]{"?", "0"};
        StringBuffer stringBuffer = new StringBuffer();
        UtilStringFunctions.replaceStringDelimiters(string3, stringArray2, stringBuffer, true);
        String string6 = stringBuffer.toString();
        stringBuffer.delete(0, stringBuffer.length());
        int n = 0;
        while (n < nArray.length) {
            String string7 = string2 + string6 + string4;
            stringArray3[1] = String.valueOf(nArray[n]);
            UtilStringFunctions.replaceStringDelimiters(string7, stringArray3, stringBuffer, false);
            if (stringBuffer.length() > 0) {
                UtilStringFunctions.replaceStringDelimiters(UNION_ALL, null, stringBuffer, true);
            }
            ++n;
        }
        if (stringBuffer != null && stringBuffer.length() > 20) {
            stringBuffer.append(string5);
            return stringBuffer.toString();
        }
        return null;
    }

    public String getMVSTableString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor, boolean bl) {
        String string;
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND A.CREATOR ", " AND A.NAME "};
        String string2 = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string2 != null && !this.catalogNameMatches(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string2 == null) {
            string2 = this.catalogName;
        }
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string3 = null;
        String string4 = null;
        string3 = "SELECT DISTINCT '" + string2 + "', A.CREATOR, A.NAME,";
        string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        if (bl) {
            string5 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A," + this.catalogSchema + ".SYSTABAUTH B WHERE A.TYPE IN ('T', 'G', 'X') " + " AND A.NAME = B.TTNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')" + " AND NOT (A.CREATOR IN ('SYSIBM', 'SYSCAT', '" + this.catalogSchema + "'))";
            string6 = " 'VIEW', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A," + this.catalogSchema + ".SYSTABAUTH B WHERE TYPE = 'V'" + " AND A.NAME = B.TTNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string7 = " 'ALIAS', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A," + this.catalogSchema + ".SYSTABAUTH B WHERE TYPE = 'A'" + " AND A.TBNAME = B.TTNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string8 = " 'SYNONYM', ' ',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSSYNONYMS A," + this.catalogSchema + ".SYSTABAUTH B " + " WHERE A.TBNAME = B.TTNAME AND B.GRANTEE IN ('" + this.restrictUser + "','PUBLIC','PUBLIC*') AND (B.SELECTAUTH = 'Y' OR B.SELECTAUTH = 'G')";
            string9 = " 'HIERARCHY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'H'";
            string10 = " 'NICKNAME', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'N'";
            string11 = " 'SUMMARY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'S'";
            string12 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE CREATOR = '" + this.catalogSchema + "'";
        } else {
            string5 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TYPE  IN ('T', 'G', 'X') " + " AND NOT (A.CREATOR IN ('SYSIBM', 'SYSCAT', '" + this.catalogSchema + "'))";
            string6 = " 'VIEW', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'V'";
            string7 = " 'ALIAS', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'A'";
            string8 = " 'SYNONYM', ' ',nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSSYNONYMS A WHERE 1=1";
            string9 = " 'HIERARCHY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'H'";
            string10 = " 'NICKNAME', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'N'";
            string11 = " 'SUMMARY', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE TYPE = 'S'";
            string12 = " 'SYSTEM TABLE', REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE CREATOR = '" + this.catalogSchema + "'";
        }
        String string13 = " ORDER BY 4, 2, 3 FOR FETCH ONLY";
        String[] stringArray3 = (String[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string14 = string3;
        String string15 = string4;
        StringBuffer stringBuffer = new StringBuffer();
        if (string15.indexOf(" LIKE ") > 0) {
            string15 = string15 + " ESCAPE '\\'";
        }
        boolean bl2 = false;
        if (stringArray3 == null) {
            stringArray3 = this.getTableTypeNames();
        }
        int n = 0;
        while (n < stringArray3.length) {
            string = null;
            if (stringArray3[n].equals("TABLE")) {
                string = string14 + string5;
            }
            if (stringArray3[n].equals("VIEW")) {
                string = string14 + string6;
            }
            if (stringArray3[n].equals("ALIAS") && !bl2) {
                string = string14 + string7;
                bl2 = true;
            }
            if (stringArray3[n].equals("SYNONYMS") || stringArray3[n].equals("SYNONYM")) {
                if (DB2MetaDataLibrary.con.comm.serverOS == 3) {
                    string = string14 + string8;
                } else if (!bl2) {
                    string = string14 + string7;
                    bl2 = true;
                }
            }
            if (stringArray3[n].equals("NICKNAME")) {
                string = string14 + string10;
            }
            if (stringArray3[n].equals("SUMMARY TABLE")) {
                string = string14 + string11;
            }
            if (stringArray3[n].equals("HIERARCHY TABLE")) {
                string = string14 + string9;
            }
            if (stringArray3[n].equals("SYSTEM TABLE")) {
                string = string14 + string12;
            }
            if (string != null) {
                string = string + string15;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(UNION);
                }
                stringBuffer.append(string);
            }
            ++n;
        }
        string = stringBuffer.toString();
        if (string != null && string.trim().length() > 0) {
            string = string + string13;
        }
        return string;
    }

    public String getMVSColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND TBCREATOR ", " AND TBNAME ", " AND NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "', TBCREATOR, TBNAME, NAME, 0, COLTYPE," + " LENGTH, 0, SCALE, 10, 1, REMARKS, DEFAULT, 0," + " 0, 0, COLNO, 'YES',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1) FROM " + this.catalogSchema + ".SYSCOLUMNS" + " WHERE NULLS LIKE '%Y%'";
        String string3 = "SELECT '" + string + "', TBCREATOR, TBNAME, NAME, 0, COLTYPE," + " LENGTH, 0, SCALE, 10, 0, REMARKS, DEFAULT, 0," + " 0, 0, COLNO, 'NO',nullif(1,1),nullif(1,1),nullif(1,1)" + ",nullif(1,1) FROM " + this.catalogSchema + ".SYSCOLUMNS" + " WHERE NULLS LIKE '%N%'";
        String string4 = " ORDER BY 2, 3, 17 FOR FETCH ONLY";
        String string5 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string6 = null;
        if (DB2MetaDataLibrary.con.catalogIncludesSynonyms) {
            String[] stringArray3 = new String[]{" AND B.CREATOR ", " AND B.NAME ", " AND A.NAME "};
            String string7 = "SELECT '" + string + "', B.CREATOR," + " B.NAME, A.NAME, 0, A.COLTYPE, A.LENGTH," + " 0, A.SCALE, 10, 1, A.REMARKS, A.DEFAULT, 0, 0, 0, A.COLNO," + " 'YES', nullif(1,1), nullif(1,1), nullif(1,1) ,nullif(1,1)" + " FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSSYNONYMS B" + " WHERE B.TBNAME=A.TBNAME  AND A.TBCREATOR=B.CREATOR" + " AND NULLS LIKE '%Y%'";
            String string8 = "SELECT '" + string + "', B.CREATOR," + " B.NAME, A.NAME, 0, A.COLTYPE, A.LENGTH," + " 0, A.SCALE, 10, 0, A.REMARKS, A.DEFAULT, 0, 0, 0, A.COLNO," + " 'NO', nullif(1,1), nullif(1,1), nullif(1,1) ,nullif(1,1)" + " FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSSYNONYMS B" + " WHERE B.TBNAME=A.TBNAME  AND A.TBCREATOR=B.CREATOR" + " AND NULLS LIKE '%N%'";
            String string9 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray3, stringArray2, nArray);
            String[] stringArray4 = new String[]{" AND B.CREATOR ", " AND B.NAME ", " AND A.NAME "};
            String string10 = "SELECT '" + string + "', B.CREATOR," + " B.NAME, A.NAME, 0, A.COLTYPE, A.LENGTH," + " 0, A.SCALE, 10, 1, A.REMARKS, A.DEFAULT, 0, 0, 0, A.COLNO," + " 'YES', nullif(1,1), nullif(1,1), nullif(1,1) ,nullif(1,1)" + " FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSTABLES B" + " WHERE B.TBNAME=A.TBNAME  AND A.TBCREATOR=B.CREATOR" + " AND NULLS LIKE '%Y%'";
            String string11 = "SELECT '" + string + "', B.CREATOR," + " B.NAME, A.NAME, 0, A.COLTYPE, A.LENGTH," + " 0, A.SCALE, 10, 0, A.REMARKS, A.DEFAULT, 0, 0, 0, A.COLNO," + " 'NO', nullif(1,1), nullif(1,1), nullif(1,1) ,nullif(1,1)" + " FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSTABLES B" + " WHERE B.TBNAME=A.TBNAME  AND A.TBCREATOR=B.CREATOR" + " AND NULLS LIKE '%N%'";
            String string12 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray4, stringArray2, nArray);
            baseResultSetFilterDescriptor.removeAllRestrictions();
            string6 = string2 + string5 + UNION + string3 + string5 + UNION + string7 + string9 + UNION + string8 + string9 + UNION + string10 + string12 + UNION + string11 + string12 + string4;
        } else {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            string6 = string2 + string5 + UNION_ALL + string3 + string5 + string4;
        }
        return string6;
    }

    public String getMVS5ProcedureString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND AUTHID ", " AND PROCEDURE "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', AUTHID, PROCEDURE, 0, 0, 0, ' ', " + 1 + " FROM " + this.catalogSchema + ".SYSPROCEDURES WHERE RESULT_SETS = 0 ";
        String string3 = "SELECT '" + string + "', AUTHID, PROCEDURE, 0, 0, 0, ' ', " + 2 + " FROM " + this.catalogSchema + ".SYSPROCEDURES WHERE RESULT_SETS > 0 ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getMVSProcedureString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        Object object;
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND SCHEMA ", " AND NAME "};
        if (DB2MetaDataLibrary.con.comm.serverOS == 3 && (String)baseResultSetFilterDescriptor.getRestrictionByIndex(2) != null && ((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2)).indexOf(95) != -1 && ((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2)).length() < 18) {
            object = new StringBuffer((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2));
            int n = ((String)baseResultSetFilterDescriptor.getRestriction(3)).length();
            while (n < 18) {
                ((StringBuffer)object).append(" ");
                ++n;
            }
            if ((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2) != null && ((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2)).indexOf("\\_") != -1) {
                ((StringBuffer)object).deleteCharAt(((String)baseResultSetFilterDescriptor.getRestrictionByIndex(2)).indexOf("\\_"));
                ((StringBuffer)object).append(" ");
            }
            baseResultSetFilterDescriptor.setRestrictionByIndex(2, ((StringBuffer)object).toString());
        }
        object = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', SCHEMA, rtrim(NAME), 0, 0, 0, REMARKS, " + 1 + " FROM " + this.catalogSchema + ".SYSROUTINES WHERE RESULT_SETS = 0 ";
        String string3 = "SELECT '" + string + "', SCHEMA, rtrim(NAME), 0, 0, 0, REMARKS, " + 2 + " FROM " + this.catalogSchema + ".SYSROUTINES WHERE RESULT_SETS > 0 ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, (String[])object, nArray);
        String string5 = " ORDER BY 2, 3 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getMVS5ProcedureColumnsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND AUTHID ", " AND PROCEDURE "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string3 = "SELECT '" + string + "', AUTHID, PROCEDURE, ' ', " + 0 + ", 0, PARMLIST, 0, 0, 0, 0," + 2 + ", ' '" + " FROM " + this.catalogSchema + ".SYSPROCEDURES WHERE ASUTIME >= 0";
        String string4 = " ORDER BY 2, 3 FOR FETCH ONLY";
        if (string2.indexOf(" LIKE ") > 0) {
            string2 = string2 + " ESCAPE '\\'";
        }
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string3 + string2 + string4;
        return string5;
    }

    public String getMVSProcedureColumnsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        Object object;
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String string2 = null;
        if (this.useSort && baseResultSetSortDescriptor.getSortCount() > 0) {
            string2 = " ORDER BY ";
            int n = 0;
            while (n < baseResultSetSortDescriptor.getSortCount()) {
                int n2 = baseResultSetSortDescriptor.getSortColumnOrdinal(n);
                if (n2 > 0) {
                    object = String.valueOf(n2);
                    if (n > 0) {
                        string2 = string2 + ",";
                    }
                    string2 = string2 + (String)object;
                }
                ++n;
            }
            string2 = string2 + " FOR FETCH ONLY";
        }
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND P.SCHEMA ", " AND P.NAME ", " AND P.PARMNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        object = new int[]{2, 3, 4};
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, (int[])object);
        String string4 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 1 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 0 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'N' AND P.ROWTYPE = 'P'" + " AND P.ROUTINETYPE = 'P'";
        String string5 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 1 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 1 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'Y' AND P.ROWTYPE = 'P'" + " AND P.ROUTINETYPE = 'P'";
        String string6 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 4 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 0 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'N' AND P.ROWTYPE = 'O'" + " AND P.ROUTINETYPE = 'P'";
        String string7 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 4 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 1 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'Y' AND P.ROWTYPE = 'O'" + " AND P.ROUTINETYPE = 'P'";
        String string8 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 2 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 0 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'N' AND P.ROWTYPE = 'B'" + " AND P.ROUTINETYPE = 'P'";
        String string9 = "SELECT '" + string + "', P.SCHEMA, P.NAME, P.PARMNAME, " + 2 + ", P.ORDINAL, P.TYPENAME, P.LENGTH, P.LENGTH, P.SCALE, 10," + 1 + ", NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSROUTINES R, " + this.catalogSchema + ".SYSPARMS P WHERE R.SCHEMA = P.SCHEMA AND R.NAME = P.NAME" + " AND R.ROUTINETYPE = P.ROUTINETYPE AND R.NULL_CALL = 'Y' AND P.ROWTYPE = 'B'" + " AND P.ROUTINETYPE = 'P'";
        if (string2 == null) {
            string2 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        }
        if (string3.indexOf(" LIKE ") > 0) {
            string3 = string3 + " ESCAPE '\\'";
        }
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = string4 + string3 + UNION_ALL + string5 + string3 + UNION_ALL + string8 + string3 + UNION_ALL + string9 + string3 + UNION_ALL + string6 + string3 + UNION_ALL + string7 + string3 + string2;
        return string10;
    }

    public String getMVSSchemaString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "select DISTINCT rtrim(schemaname),nullif(1,1) from " + this.catalogSchema + ".sysschemaauth" + UNION + "SELECT DISTINCT rtrim(CREATOR),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES" + UNION + "SELECT DISTINCT rtrim(SCHEMA),nullif(1,1) FROM " + this.catalogSchema + ".SYSROUTINES";
        return string;
    }

    public String getMVSCatalogString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "SELECT DISTINCT '" + this.catalogName + "' FROM SYSIBM.SYSDUMMY1 ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getMVSColumnPrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND CREATOR ", " AND TNAME ", " AND COLNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "', CREATOR, TNAME, COLNAME, GRANTOR, GRANTEE, 'UPDATE', 'YES'" + " FROM " + this.catalogSchema + ".SYSCOLAUTH WHERE PRIVILEGE = ' '";
        String string3 = "SELECT '" + string + "', CREATOR, TNAME, COLNAME, GRANTOR, GRANTEE, 'REFERENCE', 'YES'" + " FROM " + this.catalogSchema + ".SYSCOLAUTH WHERE PRIVILEGE = 'R'";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 4, 7 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getMVSTablePrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        String string2 = this.catalogName;
        if (string != null && !string.equals(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        String[] stringArray = new String[]{" AND TCREATOR ", " AND TTNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'ALTER','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE ALTERAUTH = 'G'";
        String string5 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'ALTER', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE ALTERAUTH = 'Y'";
        String string6 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'DELETE','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE DELETEAUTH = 'G'";
        String string7 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'DELETE', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE DELETEAUTH = 'Y'";
        String string8 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'INDEX','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE INDEXAUTH = 'G'";
        String string9 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'INDEX', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE INDEXAUTH = 'Y'";
        String string10 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'INSERT','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE INSERTAUTH = 'G'";
        String string11 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'INSERT', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE INSERTAUTH = 'Y'";
        String string12 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'REFERENCES','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE REFERENCESAUTH = 'G' AND REFCOLS <> '*'";
        String string13 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'REFERENCES', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE UPDATEAUTH = 'Y' AND REFCOLS <> '*'";
        String string14 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'SELECT','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE SELECTAUTH = 'G'";
        String string15 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'SELECT', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE SELECTAUTH = 'Y'";
        String string16 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'UPDATE','YES' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE UPDATEAUTH = 'G' AND UPDATECOLS <> '*'";
        String string17 = "SELECT '" + string + "',TCREATOR,TTNAME,GRANTOR,GRANTEE,'UPDATE', 'NO' FROM " + this.catalogSchema + ".SYSTABAUTH" + " WHERE UPDATEAUTH = 'Y' AND UPDATECOLS <> '*'";
        String string18 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string19 = string4 + string3 + UNION_ALL + string5 + string3 + UNION_ALL + string6 + string3 + UNION_ALL + string7 + string3 + UNION_ALL + string8 + string3 + UNION_ALL + string9 + string3 + UNION_ALL + string10 + string3 + UNION_ALL + string11 + string3 + UNION_ALL + string12 + string3 + UNION_ALL + string13 + string3 + UNION_ALL + string14 + string3 + UNION_ALL + string15 + string3 + UNION_ALL + string16 + string3 + UNION_ALL + string17 + string3 + string18;
        return string19;
    }

    public String getMVSBestRowIdentifierString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" CT.TBCREATOR ", " AND CT.TBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        int n = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
        String string = "";
        String string2 = "";
        String string3 = "SELECT 0, CT.NAME, 0, CT.COLTYPE, CT.LENGTH, 0, CT.SCALE, 0 FROM  " + this.catalogSchema + ".SYSCOLUMNS CT WHERE ";
        String string4 = "SELECT 1, CT.NAME, 0, CT.COLTYPE, CT.LENGTH, 0, CT.SCALE, 0 FROM  " + this.catalogSchema + ".SYSCOLUMNS CT WHERE CT.NULLS = 'N' AND ";
        String string5 = "SELECT 1, CT.NAME, 0, CT.COLTYPE, CT.LENGTH, 0, CT.SCALE,1 FROM " + this.catalogSchema + ".SYSCOLUMNS CT, " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXCREATOR = IT.CREATOR AND KT.IXNAME = IT.NAME AND KT.COLNAME = CT.NAME AND ";
        String string6 = "SELECT 2, CT.NAME, 0, CT.COLTYPE, CT.LENGTH, 0, CT.SCALE, 1 FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSCOLUMNS CT WHERE IT.TBCREATOR = CT.TBCREATOR AND IT.TBNAME = CT.TBNAME AND (IT.UNIQUERULE = 'P' OR IT.UNIQUERULE = 'U') AND";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string8 = " ORDER BY 1 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string9 = null;
        string9 = bl && n == 0 ? string3 + string7 : string4 + string7;
        if (n == 1) {
            string9 = string9 + UNION_ALL + string5 + string7;
        }
        if (n == 2) {
            string9 = string9 + UNION_ALL + string6 + string7;
        }
        string9 = string9 + string8;
        return string9;
    }

    public String getMVSVersionColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND TBCREATOR ", " AND TBNAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string3 = "SELECT 0, NAME, 0, COLTYPE, LENGTH, 0, SCALE, 0 FROM " + this.catalogSchema + ".SYSCOLUMNS WHERE NULLS = 'N' AND DEFAULT IN ('S', 'U')";
        String string4 = string3 + string2;
        return string4;
    }

    public String getMVSPrimaryKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND IT.TBCREATOR ", " AND IT.TBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT DISTINCT '" + string + "', IT.TBCREATOR, IT.TBNAME, KT.COLNAME, KT.COLSEQ, IT.NAME" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT" + " WHERE IT.UNIQUERULE = 'P' AND IT.CREATOR = KT.IXCREATOR AND KT.IXNAME = IT.NAME";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 4 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getMVSExportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND RT.REFTBCREATOR ", " AND RT.REFTBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 3 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'A'";
        String string3 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 0 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'C'";
        String string4 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 2 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'N'";
        String string5 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 1 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'R'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string7 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = string2 + string6 + UNION_ALL + string3 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string5 + string6 + string7;
        return string8;
    }

    public String getMVSImportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND RT.CREATOR ", " AND RT.TBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 6, 7);
        int[] nArray = new int[]{6, 7};
        String string2 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 3 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'A'";
        String string3 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 0 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'C'";
        String string4 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 2 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'N'";
        String string5 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 1 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'R'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string7 = " ORDER BY 2, 3, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = string2 + string6 + UNION_ALL + string3 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string5 + string6 + string7;
        return string8;
    }

    public String getMVSCrossReferenceString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        String string2 = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string) || !this.catalogNameMatches(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{"", " AND RT.REFTBCREATOR ", " AND RT.REFTBNAME ", "", " AND RT.CREATOR ", " AND RT.TBNAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 0, 0);
        int[] nArray = new int[]{-1, 2, 3, -1, 6, 7};
        String string3 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 3 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR AND FT.TBNAME = RT.TBNAME" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'A'";
        String string4 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 0 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR AND FT.TBNAME = RT.TBNAME" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'C'";
        String string5 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 2 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR AND FT.TBNAME = RT.TBNAME" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'N'";
        String string6 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, PT.COLNAME," + " '" + string + "', FT.CREATOR, FT.TBNAME, FT.COLNAME, FT.COLSEQ," + 3 + ", " + 1 + "," + " RT.RELNAME, IT.NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSKEYS PT, " + this.catalogSchema + ".SYSRELS RT, " + this.catalogSchema + ".SYSFOREIGNKEYS FT" + " WHERE IT.UNIQUERULE = 'P'" + " AND IT.CREATOR = PT.IXCREATOR AND IT.NAME = PT.IXNAME" + " AND IT.TBNAME = RT.REFTBNAME AND IT.TBCREATOR = RT.REFTBCREATOR" + " AND FT.RELNAME = RT.RELNAME AND FT.CREATOR = RT.CREATOR AND FT.TBNAME = RT.TBNAME" + " AND PT.COLSEQ = FT.COLSEQ AND RT.DELETERULE = 'R'";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string8 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string9 = string3 + string7 + UNION_ALL + string4 + string7 + UNION_ALL + string5 + string7 + UNION_ALL + string6 + string7 + string8;
        return string9;
    }

    public String getMVSIndexInfoString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND IT.CREATOR ", " AND IT.TBNAME "};
        String[] stringArray2 = new String[]{" AND CREATOR ", " AND NAME "};
        String[] stringArray3 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
        String string2 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.NAME, " + 1 + "," + " KT.COLSEQ, KT.COLNAME, KT.ORDERING, IT.COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXNAME = IT.NAME" + " AND KT.IXCREATOR = IT.CREATOR AND IT.CLUSTERED = 'Y'";
        String string3 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.NAME, " + 1 + "," + " KT.COLSEQ, KT.COLNAME, KT.ORDERING, IT.COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXNAME = IT.NAME" + " AND KT.IXCREATOR = IT.CREATOR AND IT.CLUSTERED = 'Y' AND IT.UNIQUERULE <> 'D'";
        String string4 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.NAME, " + 3 + "," + " KT.COLSEQ, KT.COLNAME, KT.ORDERING, IT.COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXNAME = IT.NAME" + " AND KT.IXCREATOR = IT.CREATOR AND IT.CLUSTERED <> 'Y'";
        String string5 = "SELECT '" + string + "', IT.TBCREATOR, IT.TBNAME, CASE IT.UNIQUERULE WHEN 'D' THEN 1 WHEN '1' THEN 0 WHEN '0' THEN 0 ELSE 0 END CASE," + " ' ', IT.NAME, " + 3 + "," + " KT.COLSEQ, KT.COLNAME, KT.ORDERING, IT.COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.IXNAME = IT.NAME" + " AND KT.IXCREATOR = IT.CREATOR AND IT.CLUSTERED <> 'Y' AND IT.UNIQUERULE <> 'D'";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray3, nArray);
        String string7 = "SELECT '" + string + "', CREATOR, NAME, 0," + " NULLIF('',''), NULLIF('',''), " + 0 + "," + " 0, NULLIF('',''), NULLIF('',''), 0, 0, NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSTABLES WHERE NAME <> ' '";
        String string8 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray3, nArray);
        String string9 = " ORDER BY 4, 7, 6, 8 FOR FETCH ONLY";
        StringBuffer stringBuffer = new StringBuffer();
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = null;
        if (bl) {
            string10 = string3 + string6 + UNION_ALL + string5 + string6 + UNION_ALL + string7 + string8;
        } else if (!bl) {
            string10 = string2 + string6 + UNION_ALL + string4 + string6 + UNION_ALL + string7 + string8;
        }
        string10 = string10 + string9;
        return string10;
    }

    public String getMVSsUDTsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        return null;
    }

    public String getAS400ColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND TABLE_SCHEMA ", " AND TABLE_NAME ", " AND COLUMN_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        int[] nArray = new int[]{2, 3, 4};
        String string2 = "SELECT '" + string + "', TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, 0, DATA_TYPE," + " LENGTH, IFNULL(NUMERIC_PRECISION, CHARACTER_MAXIMUM_LENGTH)," + " NUMERIC_SCALE, NUMERIC_PRECISION_RADIX, IS_NULLABLE, LONG_COMMENT, COLUMN_DEFAULT, 0," + " 0, 0, ORDINAL_POSITION, 'YES',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1), CCSID FROM " + this.catalogSchema + ".SYSCOLUMNS" + " WHERE NULLS = 'Y'";
        String string3 = "SELECT '" + string + "', TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, 0, DATA_TYPE," + " LENGTH, IFNULL(NUMERIC_PRECISION, CHARACTER_MAXIMUM_LENGTH)," + " NUMERIC_SCALE, NUMERIC_PRECISION_RADIX, IS_NULLABLE, LONG_COMMENT, COLUMN_DEFAULT, 0," + " 0, 0, ORDINAL_POSITION, 'NO',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1), CCSID FROM " + this.catalogSchema + ".SYSCOLUMNS" + " WHERE NULLS = 'N'";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3, 17 FOR FETCH ONLY";
        String string6 = null;
        if (DB2MetaDataLibrary.con.catalogIncludesSynonyms) {
            String[] stringArray3 = new String[]{" AND B.TABLE_SCHEMA ", " AND B.TABLE_NAME ", " AND A.COLUMN_NAME "};
            String string7 = "SELECT '" + string + "', B.TABLE_SCHEMA, B.TABLE_NAME, A.COLUMN_NAME, 0, A.DATA_TYPE," + " A.LENGTH, IFNULL(A.NUMERIC_PRECISION, A.CHARACTER_MAXIMUM_LENGTH)," + " A.NUMERIC_SCALE, A.NUMERIC_PRECISION_RADIX, A.IS_NULLABLE, A.LONG_COMMENT, A.COLUMN_DEFAULT, 0," + " 0, 0, A.ORDINAL_POSITION, 'YES',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1), CCSID FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSTABLES B" + " WHERE NULLS = 'Y' AND B.BASE_TABLE_NAME=A.TABLE_NAME AND A.TABLE_SCHEMA=B.BASE_TABLE_SCHEMA";
            String string8 = "SELECT '" + string + "', B.TABLE_SCHEMA, B.TABLE_NAME, A.COLUMN_NAME, 0, A.DATA_TYPE," + " A.LENGTH, IFNULL(A.NUMERIC_PRECISION, A.CHARACTER_MAXIMUM_LENGTH)," + " A.NUMERIC_SCALE, A.NUMERIC_PRECISION_RADIX, A.IS_NULLABLE, A.LONG_COMMENT, A.COLUMN_DEFAULT, 0," + " 0, 0, A.ORDINAL_POSITION, 'NO',nullif(1,1),nullif(1,1),nullif(1,1)" + " ,nullif(1,1), CCSID FROM " + this.catalogSchema + ".SYSCOLUMNS A, " + this.catalogSchema + ".SYSTABLES B" + " WHERE NULLS = 'N' AND B.BASE_TABLE_NAME=A.TABLE_NAME AND A.TABLE_SCHEMA=B.BASE_TABLE_SCHEMA";
            String string9 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray3, stringArray2, nArray);
            baseResultSetFilterDescriptor.removeAllRestrictions();
            string6 = string2 + string4 + UNION + string7 + string9 + UNION_ALL + string3 + string4 + UNION + string8 + string9 + string5;
        } else {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        }
        return string6;
    }

    public String getAS400ProcedureString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND SPECIFIC_SCHEMA ", " AND SPECIFIC_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT '" + string + "', SPECIFIC_SCHEMA, SPECIFIC_NAME, 0, 0, 0, LONG_COMMENT, " + 1 + " FROM " + this.catalogSchema + ".SYSPROCS WHERE RESULT_SETS = 0 ";
        String string3 = "SELECT '" + string + "', SPECIFIC_SCHEMA, SPECIFIC_NAME, 0, 0, 0, LONG_COMMENT, " + 2 + " FROM " + this.catalogSchema + ".SYSPROCS WHERE RESULT_SETS > 0 ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 2, 3 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string2 + string4 + UNION_ALL + string3 + string4 + string5;
        return string6;
    }

    public String getAS400ProcedureColumnsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        Object object;
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String string2 = null;
        if (this.useSort && baseResultSetSortDescriptor.getSortCount() > 0) {
            string2 = " ORDER BY ";
            int n = 0;
            while (n < baseResultSetSortDescriptor.getSortCount()) {
                int n2 = baseResultSetSortDescriptor.getSortColumnOrdinal(n);
                if (n2 > 0) {
                    object = String.valueOf(n2);
                    if (n > 0) {
                        string2 = string2 + ",";
                    }
                    string2 = string2 + (String)object;
                }
                ++n;
            }
            string2 = string2 + " FOR FETCH ONLY";
        }
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" WHERE SPECIFIC_SCHEMA ", " AND SPECIFIC_NAME ", " AND PARAMETER_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
        object = new int[]{2, 3, 4};
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, (int[])object);
        String string4 = "SELECT '" + this.catalogName + "', SPECIFIC_SCHEMA, SPECIFIC_NAME, PARAMETER_NAME, " + " PARAMETER_MODE , ORDINAL_POSITION, DATA_TYPE, IFNULL(NUMERIC_PRECISION, CHARACTER_MAXIMUM_LENGTH)," + " IFNULL(NUMERIC_PRECISION, CHARACTER_MAXIMUM_LENGTH)," + " NUMERIC_SCALE, NUMERIC_PRECISION_RADIX, IS_NULLABLE, NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSPARMS ";
        if (string2 == null) {
            string2 = " ORDER BY 2, 3, 6 FOR FETCH ONLY";
        }
        if (string3.indexOf(" LIKE ") > 0) {
            string3 = string3 + " ESCAPE '\\'";
        }
        baseResultSetFilterDescriptor.removeAllRestrictions();
        if (string3 == null || !string3.equals("")) {
            // empty if block
        }
        String string5 = string4 + string3 + string2;
        return string5;
    }

    public String getAS400SchemaString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "SELECT DISTINCT CREATOR,nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES " + "UNION SELECT DISTINCT TABLE_SCHEMA,nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES " + "ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getAS400CatalogString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = "SELECT DISTINCT '" + this.catalogName + "' FROM " + this.catalogSchema + ".SYSTABLES ORDER BY 1 FOR FETCH ONLY";
        return string;
    }

    public String getAS400ColumnPrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        baseResultSetFilterDescriptor.removeAllRestrictions();
        return null;
    }

    public String getAS400TableString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        String string;
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND A.TABLE_SCHEMA ", " AND A.TABLE_NAME "};
        String string2 = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string2 != null && !this.catalogNameMatches(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string2 == null) {
            string2 = this.catalogName;
        }
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string3 = null;
        String string4 = null;
        string3 = "SELECT '" + string2 + "', A.TABLE_SCHEMA, A.TABLE_NAME,";
        string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " 'TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A, " + this.catalogSchema2 + ".SQLTABLEPRIVILEGES B WHERE (A.TYPE = 'T' OR A.TYPE = 'P')" + " AND B.TABLE_NAME = A.TABLE_NAME AND B.GRANTEE = '" + this.restrictUser + "' AND B.PRIVILEGE = 'SELECT' " + " AND A.TABLE_SCHEMA <> 'QSYS2' AND A.TABLE_SCHEMA <> '" + this.catalogSchema + "' AND A.TABLE_SCHEMA <> '" + this.catalogSchema2 + "'";
        String string6 = " 'VIEW', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A, " + this.catalogSchema2 + ".SQLTABLEPRIVILEGES B WHERE (A.TYPE = 'V' OR A.TYPE = 'L') " + " AND B.TABLE_NAME = A.TABLE_NAME AND B.GRANTEE = '" + this.restrictUser + "' AND B.PRIVILEGE = 'SELECT' ";
        String string7 = " 'ALIAS', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A, " + this.catalogSchema2 + ".SQLTABLEPRIVILEGES B WHERE A.TYPE = 'A'" + " AND B.TABLE_NAME = A.TABLE_NAME AND B.GRANTEE = '" + this.restrictUser + "' AND B.PRIVILEGE = 'SELECT' ";
        String string8 = " 'HIERARCHY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TYPE = 'H'";
        String string9 = " 'NICKNAME', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TYPE = 'N'";
        String string10 = " 'SUMMARY', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TYPE = 'S'";
        String string11 = " 'SYSTEM TABLE', A.REMARKS,nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1),nullif(1,1) FROM " + this.catalogSchema + ".SYSTABLES A WHERE A.TABLE_SCHEMA = '" + this.catalogSchema + "'";
        String string12 = " ORDER BY 4, 2, 3 FOR FETCH ONLY";
        String[] stringArray3 = (String[])baseResultSetFilterDescriptor.getRestriction(4);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string13 = string3;
        String string14 = string4;
        if (string14.indexOf(" LIKE ") > 0) {
            string14 = string14 + " ESCAPE '\\'";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (stringArray3 == null) {
            stringArray3 = this.getTableTypeNames();
        }
        int n = 0;
        while (n < stringArray3.length) {
            string = null;
            if (stringArray3[n].equals("TABLE")) {
                string = string13 + string5;
            } else if (stringArray3[n].equals("VIEW")) {
                string = string13 + string6;
            } else if (stringArray3[n].equals("ALIAS")) {
                if (!bl) {
                    string = string13 + string7;
                    bl = true;
                }
            } else if (stringArray3[n].equals("SYNONYMS") || stringArray3[n].equals("SYNONYM")) {
                if (!bl) {
                    string = string13 + string7;
                    bl = true;
                }
            } else if (stringArray3[n].equals("NICKNAME")) {
                string = string13 + string9;
            } else if (stringArray3[n].equals("SUMMARY TABLE")) {
                string = string13 + string10;
            } else if (stringArray3[n].equals("HIERARCHY TABLE")) {
                string = string13 + string8;
            } else if (stringArray3[n].equals("SYSTEM TABLE")) {
                string = string13 + string11;
            }
            if (string != null) {
                string = string + string14;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(UNION);
                }
                stringBuffer.append(string);
            }
            ++n;
        }
        string = stringBuffer.toString();
        if (string != null && string.trim().length() > 0) {
            string = string + string12;
        }
        return string;
    }

    public String getAS400TablePrivilegeString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        String[] stringArray = new String[]{" AND TABLE_CAT ", " AND TABLE_SCHEM ", " AND TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 1, 3);
        int[] nArray = new int[]{1, 2, 3};
        String string = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string2 = "SELECT TABLE_CAT, TABLE_SCHEM, TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM " + this.catalogSchema + ".SQLTABLEPRIVILEGES " + "WHERE GRANTEE <> 'PUBLIC' " + string + "ORDER BY 1,2,3,6 FOR FETCH ONLY";
        return string2;
    }

    public String getAS400BestRowIdentifierString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" TABLE_SCHEMA ", " TABLE_NAME "};
        String[] stringArray2 = new String[]{" CT.TABLE_SCHEMA ", " CT.TABLE_NAME "};
        String[] stringArray3 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        int n = (Integer)baseResultSetFilterDescriptor.getRestriction(1);
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(12);
        String string = "";
        String string2 = "";
        String string3 = "SELECT 0, COLUMN_NAME, 0, DATA_TYPE, LENGTH, 0, NUMERIC_SCALE, 0 FROM  " + this.catalogSchema + ".SYSCOLUMNS WHERE ";
        String string4 = "SELECT 1, COLUMN_NAME, 0, DATA_TYPE, LENGTH, 0, NUMERIC_SCALE, 0 FROM  " + this.catalogSchema + ".SYSCOLUMNS WHERE IS_NULLABLE = 'N' AND ";
        String string5 = "SELECT 1, CT.COLUMN_NAME, 0, CT.DATA_TYPE, CT.LENGTH, 0, CT.NUMERIC_SCALE, 1 FROM " + this.catalogSchema + ".SYSCOLUMNS CT, " + this.catalogSchema + ".SYSKEYS KT, " + this.catalogSchema + ".SYSINDEXES IT WHERE KT.INDEX_OWNER = IT.INDEX_OWNER AND KT.INDEX_NAME = IT.INDEX_NAME AND KT.COLUMN_NAME = CT.COLUMN_NAME AND ";
        String string6 = "SELECT 2, CT.COLUMN_NAME, 0, CT.DATA_TYPE, CT.LENGTH, 0, CT.NUMERIC_SCALE, 1 FROM " + this.catalogSchema + ".SYSINDEXES IT, " + this.catalogSchema + ".SYSCOLUMNS CT WHERE IT.TABLE_SCHEMA = CT.TABLE_SCHEMA AND IT.TABLE_NAME = CT.TABLE_NAME AND ";
        String string7 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray3, nArray);
        String string8 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray3, nArray);
        String string9 = " ORDER BY 1 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string10 = null;
        string10 = bl && n == 0 ? string3 + string7 : string4 + string7;
        if (n == 1) {
            string10 = string10 + UNION_ALL + string5 + string8;
        }
        if (n == 2) {
            string10 = string10 + UNION_ALL + string6 + string8;
        }
        string10 = string10 + string9;
        return string10;
    }

    public String getAS400VersionColumnString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String[] stringArray = new String[]{" AND TABLE_SCHEMA ", " AND TABLE_NAME "};
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 10, 11);
        int[] nArray = new int[]{10, 11};
        String string2 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string3 = "SELECT 0, COLUMN_NAME, 0, DATA_TYPE, LENGTH, 0, NUMERIC_SCALE, 0 FROM " + this.catalogSchema + ".SYSCOLUMNS WHERE IS_NULLABLE = 'N' AND COLUMN_DEFAULT IN ('S', 'U')";
        String string4 = string3 + string2;
        return string4;
    }

    public String getAS400PrimaryKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND T1.TABLE_SCHEMA ", " AND T1.TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT DISTINCT '" + string + "', T1.TABLE_SCHEMA, T1.TABLE_NAME, T1.COLUMN_NAME, T1.ORDINAL_POSITION, " + " T1.CONSTRAINT_NAME FROM " + this.catalogSchema + ".SYSKEYCST T1, " + this.catalogSchema + ".SYSCST T2 WHERE " + " T1.CONSTRAINT_NAME = T2.CONSTRAINT_NAME AND T1.CONSTRAINT_SCHEMA = T2.CONSTRAINT_SCHEMA " + " AND T2.CONSTRAINT_TYPE = 'PRIMARY KEY' ";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 2,3,5 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getAS400ExportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND PK.TABLE_SCHEMA ", " AND PK.TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        String string2 = "SELECT DISTINCT '" + string + "', PK.TABLE_SCHEMA, PK.TABLE_NAME, PK.COLUMN_NAME, '" + string + "', FK.TABLE_SCHEMA, FK.TABLE_NAME, FK.COLUMN_NAME, " + " PK.ORDINAL_POSITION," + 3 + " , R.DELETE_RULE, " + " FK.CONSTRAINT_NAME, PK.CONSTRAINT_NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSCST C, " + this.catalogSchema + ".SYSKEYCST PK, " + this.catalogSchema + ".SYSREFCST R, " + this.catalogSchema + ".SYSKEYCST FK WHERE " + " C.CONSTRAINT_NAME = PK.CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND " + " C.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = R.UNIQUE_CONSTRAINT_SCHEMA AND" + " R.CONSTRAINT_NAME = FK.CONSTRAINT_NAME AND R.CONSTRAINT_SCHEMA = FK.CONSTRAINT_SCHEMA AND " + " PK.ORDINAL_POSITION = FK.ORDINAL_POSITION ";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getAS400ImportedKeysString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND FK.TABLE_SCHEMA ", " AND FK.TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 6, 7);
        int[] nArray = new int[]{6, 7};
        String string2 = "SELECT DISTINCT '" + string + "', PK.TABLE_SCHEMA, PK.TABLE_NAME, PK.COLUMN_NAME, '" + string + "', FK.TABLE_SCHEMA, FK.TABLE_NAME, FK.COLUMN_NAME, " + " FK.ORDINAL_POSITION," + 3 + " , R.DELETE_RULE, " + " FK.CONSTRAINT_NAME, PK.CONSTRAINT_NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSCST C, " + this.catalogSchema + ".SYSKEYCST PK, " + this.catalogSchema + ".SYSREFCST R, " + this.catalogSchema + ".SYSKEYCST FK WHERE " + " C.CONSTRAINT_NAME = PK.CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND " + " C.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = R.UNIQUE_CONSTRAINT_SCHEMA AND" + " R.CONSTRAINT_NAME = FK.CONSTRAINT_NAME AND R.CONSTRAINT_SCHEMA = FK.CONSTRAINT_SCHEMA AND " + " PK.ORDINAL_POSITION = FK.ORDINAL_POSITION ";
        String string3 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string4 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string5 = string2 + string3 + string4;
        return string5;
    }

    public String getAS400CrossReferenceString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        String string2 = (String)baseResultSetFilterDescriptor.getRestriction(5);
        if (string != null && !this.catalogNameMatches(string) || !this.catalogNameMatches(string2)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{"", " AND PK.TABLE_SCHEMA ", " AND PK.TABLE_NAME ", "", " AND FK.TABLE_SCHEMA ", " AND FK.TABLE_NAME "};
        String[] stringArray2 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 0, 0);
        int[] nArray = new int[]{-1, 2, 3, -1, 6, 7};
        String string3 = "SELECT DISTINCT '" + string + "', PK.TABLE_SCHEMA, PK.TABLE_NAME, PK.COLUMN_NAME, '" + string + "', FK.TABLE_SCHEMA, FK.TABLE_NAME, FK.COLUMN_NAME, " + " FK.ORDINAL_POSITION," + 3 + " , R.DELETE_RULE, " + " FK.CONSTRAINT_NAME, PK.CONSTRAINT_NAME, " + 7 + " FROM " + this.catalogSchema + ".SYSCST C, " + this.catalogSchema + ".SYSKEYCST PK, " + this.catalogSchema + ".SYSREFCST R, " + this.catalogSchema + ".SYSKEYCST FK WHERE " + " C.CONSTRAINT_NAME = PK.CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = PK.CONSTRAINT_SCHEMA AND " + " C.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME AND C.CONSTRAINT_SCHEMA = R.UNIQUE_CONSTRAINT_SCHEMA AND" + " R.CONSTRAINT_NAME = FK.CONSTRAINT_NAME AND R.CONSTRAINT_SCHEMA = FK.CONSTRAINT_SCHEMA AND " + " PK.ORDINAL_POSITION = FK.ORDINAL_POSITION ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray2, nArray);
        String string5 = " ORDER BY 6, 7, 9 FOR FETCH ONLY";
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string6 = string3 + string4 + string5;
        return string6;
    }

    public String getAS400IndexInfoString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        baseResultSetSortDescriptor.setSatisfied();
        String string = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string != null && !this.catalogNameMatches(string)) {
            baseResultSetFilterDescriptor.removeAllRestrictions();
            return null;
        }
        if (string == null) {
            string = this.catalogName;
        }
        String[] stringArray = new String[]{" AND TABLE_SCHEMA ", " AND TBNAME "};
        String[] stringArray2 = new String[]{" AND TABLE_SCHEMA ", " AND TABLE_NAME "};
        String[] stringArray3 = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
        int[] nArray = new int[]{2, 3};
        boolean bl = (Boolean)baseResultSetFilterDescriptor.getRestriction(4);
        String string2 = "SELECT '" + string + "', TABLE_SCHEMA, TBNAME, 1," + " ' ', NAME, " + 3 + "," + " COLSEQ, COLNAME, ORDERING, COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSINDEXES, " + this.catalogSchema + ".SYSKEYS WHERE CREATOR = IXCREATOR" + " AND NAME = IXNAME ";
        String string3 = "SELECT '" + string + "', TABLE_SCHEMA, TBNAME, 1," + " ' ', NAME, " + 3 + "," + " COLSEQ, COLNAME, ORDERING, COLCOUNT, 0, ' '" + " FROM " + this.catalogSchema + ".SYSINDEXES, " + this.catalogSchema + ".SYSKEYS WHERE CREATOR = IXCREATOR" + " AND NAME = IXNAME AND UNIQUERULE IN('U', 'P') ";
        String string4 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray, stringArray3, nArray);
        String string5 = "SELECT '" + string + "', TABLE_SCHEMA, NAME, 0," + " NULLIF('',''), NULLIF('',''), " + 0 + "," + " 0, NULLIF('',''), NULLIF('',''), 0, 0, NULLIF('','')" + " FROM " + this.catalogSchema + ".SYSTABLES WHERE NAME <> ' ' ";
        String string6 = DB2MetaDataLibrary.joinParameterSet(baseResultSetFilterDescriptor, stringArray2, stringArray3, nArray);
        String string7 = " ORDER BY 4, 7 , 6, 8 FOR FETCH ONLY";
        StringBuffer stringBuffer = new StringBuffer();
        baseResultSetFilterDescriptor.removeAllRestrictions();
        String string8 = null;
        if (bl) {
            string8 = string3 + string4 + UNION_ALL + string5 + string6;
        } else if (!bl) {
            string8 = string2 + string4 + UNION_ALL + string5 + string6;
        }
        string8 = string8 + string7;
        return string8;
    }

    public String getAS400sUDTsString(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        return null;
    }

    public static String[] buildParameterSet(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, int n, int n2) {
        int n3 = baseResultSetFilterDescriptor.getRestrictionCount();
        boolean bl = false;
        String[] stringArray = null;
        if (n2 > 0) {
            n3 = n2 - n + 1;
            stringArray = new String[n3];
            n3 = n2 + 1;
        } else if (n3 > 0) {
            stringArray = new String[n3];
            n = 0;
            bl = true;
        }
        int n4 = 0;
        int n5 = n;
        while (n5 < n3) {
            Object object = bl ? baseResultSetFilterDescriptor.getRestrictionByIndex(n5) : baseResultSetFilterDescriptor.getRestriction(n5);
            if (object instanceof String) {
                stringArray[n4] = (String)object;
            } else if (object instanceof Integer) {
                stringArray[n4] = Integer.toString((Integer)object);
            } else if (object instanceof Boolean) {
                stringArray[n4] = ((Boolean)object).toString();
            }
            if (baseResultSetFilterDescriptor.isPattern(n5) && stringArray[n4] != null) {
                String string = stringArray[n4].trim();
                int n6 = string.length();
                if (n6 <= 0) {
                    baseResultSetFilterDescriptor.setPattern(n5, false);
                } else {
                    int n7 = -1;
                    n7 = stringArray[n4].indexOf("\\");
                    if (n7 < 0) {
                        n7 = string.lastIndexOf("_");
                        if (n7 > 0 && n7 < n6 - 1) {
                            n7 = -1;
                        }
                    } else if (n7 + 1 < stringArray[n4].length() && stringArray[n4].charAt(n7 + 1) != '_' && stringArray[n4].charAt(n7 + 1) != '%' && stringArray[n4].charAt(n7 + 1) != '\\') {
                        StringBuffer stringBuffer = new StringBuffer(stringArray[n4]).deleteCharAt(n7);
                        stringArray[n4] = stringBuffer.toString();
                        n7 = -1;
                    }
                    if (n7 < 0) {
                        n7 = stringArray[n4].indexOf("%");
                    }
                    if (n7 >= 0) {
                        baseResultSetFilterDescriptor.setPattern(n5, true);
                    } else {
                        baseResultSetFilterDescriptor.setPattern(n5, false);
                    }
                }
            }
            ++n4;
            ++n5;
        }
        return stringArray;
    }

    public static String joinParameterSet(BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, String[] stringArray, String[] stringArray2, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] > 0) {
                boolean bl = baseResultSetFilterDescriptor.isPattern(nArray[n2]);
                if (stringArray2[n2] != null) {
                    String[] stringArray3 = new String[]{"?", stringArray2[n2]};
                    String string = null;
                    string = bl ? stringArray[n2] + " LIKE ? " : stringArray[n2] + " = ? ";
                    UtilStringFunctions.replaceStringDelimiters(string, stringArray3, stringBuffer, true);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    boolean catalogNameMatches(String string) {
        boolean bl = false;
        if (string != null && this.catalogName != null) {
            if (string.equals(this.catalogName)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void setUseSort(boolean bl) {
        this.useSort = bl;
    }
}

