/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseBatchUpdateException;
import com.metamatrix.jdbc.base.BaseBlob;
import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseClob;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import com.metamatrix.jdbc.base.BaseParameterMetaDataFactory;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BasePreparedStatementPoolable;
import com.metamatrix.jdbc.base.BaseResultSetMetaData;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseStatement;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.util.UtilVectorUnsynced;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public class BasePreparedStatement
extends BaseStatement
implements PreparedStatement {
    private static String footprint = "$Revision:   3.52.1.4  $";
    private UtilVectorUnsynced parameterSets;
    private int numParameterSets = 0;
    private UtilVectorUnsynced implParameterSets;
    BaseParameters currentParameters;
    boolean parametersDescribed = false;
    private boolean doingBatch = false;
    private boolean internalAddBatchForNonBatchExecution = false;
    BasePreparedStatementPoolable poolWrapper;
    int requestedResultSetType = -1;
    int requestedResultSetConcurrency = -1;
    private static final int EPMDS_START = 0;
    private static final int EPMDS_ERROR = 1;
    private static final int EPMDS_END = 2;
    private static final int EPMDS_INSERT = 3;
    private static final int EPMDS_INSERT_COLUMNS = 4;
    private static final int EPMDS_UPDATE = 5;
    private static final int EPMDS_INTO = 6;
    private static final int EPMDS_SET = 7;
    private static final int EPMDS_VALUES = 8;
    private static final int EPMDS_WHERE = 9;
    private static final int EPMDS_LEFT_PAREN = 10;
    private static final int EPMDS_RIGHT_PAREN = 11;
    private static final int EPMDS_TABLE = 12;

    public BasePreparedStatement(BaseConnection baseConnection, String string, int n, int n2, boolean bl) throws SQLException {
        super(baseConnection, n, n2);
        this.requestedResultSetType = n;
        this.requestedResultSetConcurrency = n2;
        this.implStatement.prepareExecuteMode = baseConnection.prepareExecuteMode;
        this.commonValidateSQL(string);
        this.setAutoGeneratedKeysRequested(bl);
        this.preProcessSQL(string);
        this.parameterSets = new UtilVectorUnsynced();
        this.resultSetConcurrency = this.concurrencyStrategy == 1 ? 1007 : 1008;
        this.resultSetScrollType = this.scrollingStrategy == 1 ? 1003 : (this.scrollingStrategy == 3 || this.scrollingStrategy == 2 ? 1004 : 1005);
    }

    final void prepareSQL(BaseSQL baseSQL, boolean bl) throws SQLException {
        this.commonTransitionToState(1);
        this.implStatement.setAutoGeneratedKeysRequested(this.autoGeneratedKeysRequested);
        this.implStatement.setSQL(baseSQL);
        if (this.currentParameters == null) {
            this.currentParameters = new BaseParameters(this.implStatement.sql.getParameterCount(), this.exceptions, this.connection);
        }
        this.implStatement.prepare(this.currentParameters);
        this.commonTransitionToState(2);
    }

    final PreparedStatement getExternalReference() {
        if (this.poolWrapper != null) {
            return this.poolWrapper;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state != 4) {
                this.clearParameters();
            }
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResultSet executeQuery() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.commonTransitionToState(2);
            return super.executeQueryInternal();
        }
    }

    void preImplExecute() throws SQLException {
        if (!this.doingBatch && this.numParameterSets != 1) {
            this.internalAddBatchForNonBatchExecution = true;
            this.addBatch();
            this.internalAddBatchForNonBatchExecution = false;
        }
        this.validateParameters();
        if (this.implParameterSets == null) {
            this.implParameterSets = new UtilVectorUnsynced(this.numParameterSets);
        } else {
            this.implParameterSets.clear();
        }
        int n = 0;
        while (n < this.numParameterSets) {
            this.implParameterSets.addElement(this.parameterSets.elementAt(n));
            ++n;
        }
        this.implStatement.setParameters(this.implParameterSets);
        super.preImplExecute();
    }

    final void postImplExecute(boolean bl) throws SQLException {
        super.postImplExecute(bl);
        this.clearBatchInternal();
    }

    public final ResultSet executeQuery(String string) throws SQLException {
        String[] stringArray = new String[]{"executeQuery(String sql)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    private void validateParameters() throws SQLException {
        int n = 0;
        while (n < this.numParameterSets) {
            BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(n);
            this.validateParameters(baseParameters);
            ++n;
        }
    }

    private void validateParameters(BaseParameters baseParameters) throws SQLException {
        if (baseParameters == null || !baseParameters.haveMinimalBindings()) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int executeUpdate() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.commonTransitionToState(2);
            return super.executeUpdateInternal();
        }
    }

    public final int executeUpdate(String string) throws SQLException {
        String[] stringArray = new String[]{"executeUpdate(String sql)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    public final int executeUpdate(String string, int n) throws SQLException {
        String[] stringArray = new String[]{"executeUpdate(String sql, int autoGeneratedKeys)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    final void validateSqlType(int n) throws SQLException {
        switch (n) {
            case 0: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                throw this.exceptions.getException(6022, "HY004");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] nArray = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.numParameterSets == 0) {
                return new int[0];
            }
            try {
                block14: {
                    try {
                        this.doingBatch = true;
                        if (this.implStatement.supportsBatchParameters() && !this.overrideNativeBatchSupport()) {
                            this.commonTransitionToState(1);
                            this.nativeBatchExecute = true;
                            try {
                                this.commonExecute();
                            }
                            catch (SQLException sQLException) {
                                this.postProcessExceptionFromCommonExecute(sQLException);
                                throw sQLException;
                            }
                            nArray = this.implStatement.getBatchRowsAffectedCount();
                            break block14;
                        }
                        nArray = this.executeBatchEmulation(this.parameterSets);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException instanceof BatchUpdateException) {
                            throw sQLException;
                        }
                        throw new BaseBatchUpdateException(sQLException, new int[0]);
                    }
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.clearBatchInternal();
                this.doingBatch = false;
                this.nativeBatchExecute = false;
                throw throwable;
            }
            this.clearBatchInternal();
            this.doingBatch = false;
            this.nativeBatchExecute = false;
        }
        if (nArray == null) {
            throw new BaseBatchUpdateException(this.exceptions.getException(6090), new int[0]);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int[] executeAllStatementsAtOnce() throws SQLException {
        int[] nArray;
        Object object;
        BaseParameters baseParameters = this.currentParameters;
        String string = this.implStatement.sql.getOriginal();
        BaseParameters baseParameters2 = null;
        int n = this.implStatement.sql.getParameterCount();
        int n2 = this.numParameterSets * n;
        BaseParameters baseParameters3 = new BaseParameters(n2, this.exceptions, this.connection);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < this.numParameterSets) {
            baseParameters2 = (BaseParameters)this.parameterSets.elementAt(n3);
            object = null;
            int n4 = 1;
            while (n4 <= baseParameters2.count()) {
                object = baseParameters2.get(n4, 1);
                if (object == null) {
                    throw this.exceptions.getException(6010, "07009");
                }
                baseParameters3.set(n3 * baseParameters2.count() + n4, 1, (BaseParameter)object);
                ++n4;
            }
            if (n3 != 0) {
                stringBuffer.append(this.implStatement.getStatementSeparator());
            }
            stringBuffer.append(this.implStatement.sql.getOriginal());
            ++n3;
        }
        try {
            object = new UtilVectorUnsynced();
            ((UtilVectorUnsynced)object).addElement(baseParameters3);
            this.commonTransitionToState(1);
            this.implStatement.setParameters((UtilVectorUnsynced)object);
            String string2 = stringBuffer.toString();
            BaseSQL baseSQL = new BaseSQL(string2, this.implStatement.getRequiredSQLProcessing(string2), this.connection.implConnection.quotingChar, this.connection.getEscapeTranslator(), this.exceptions);
            this.implStatement.setSQL(baseSQL);
            try {
                super.preImplExecute();
                this.implStatement.execute();
                super.postImplExecute(true);
            }
            catch (SQLException sQLException) {
                this.postProcessExceptionFromCommonExecute(sQLException);
                throw sQLException;
            }
            nArray = this.constructUpdateCountArray(this.numParameterSets);
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.preProcessSQL(string);
            this.commonTransitionToState(1);
            this.currentParameters = baseParameters;
            throw throwable;
        }
        this.preProcessSQL(string);
        this.commonTransitionToState(1);
        this.currentParameters = baseParameters;
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    protected final int[] executeOneStatementAtATime() throws SQLException {
        var1_1 = new int[this.numParameterSets];
        var2_2 = this.parameterSets;
        this.parameterSets = new UtilVectorUnsynced();
        var3_3 = this.currentParameters;
        var4_4 = this.numParameterSets;
        var5_5 = 0;
        while (var5_5 < var4_4) {
            block14: {
                try {
                    try {
                        this.currentParameters = (BaseParameters)var2_2.elementAt(var5_5);
                        this.internalAddBatchForNonBatchExecution = true;
                        this.addBatch();
                        this.internalAddBatchForNonBatchExecution = false;
                        this.commonTransitionToState(1);
                        try {
                            this.commonExecute();
                        }
                        catch (SQLException var6_7) {
                            this.postProcessExceptionFromCommonExecute(var6_7);
                            throw var6_7;
                        }
                        switch (this.currentResultType) {
                            case 3: {
                                var1_1[var5_5] = this.implStatement.getNextRowsAffectedCount();
                                break;
                            }
                            case 0: {
                                var1_1[var5_5] = -2;
                                break;
                            }
                            case 1: {
                                var1_1[var5_5] = 0;
                                break;
                            }
                            case 2: {
                                throw this.exceptions.getException(6053);
                            }
                        }
                    }
                    catch (SQLException var6_8) {
                        var7_9 = null;
                        var7_9 = new int[var5_5];
                        var8_10 = 0;
                        ** while (var8_10 < var5_5)
                    }
                    var10_6 = null;
                    this.currentParameters = var3_3;
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        var7_9[var8_10] = var1_1[var8_10];
                        ++var8_10;
                        continue;
                    }
lbl46:
                    // 1 sources

                    this.parameterSets = var2_2;
                    throw new BaseBatchUpdateException(var6_8, var7_9);
                }
                catch (Throwable var9_11) {
                    var10_6 = null;
                    this.currentParameters = var3_3;
                    throw var9_11;
                }
            }
            ++var5_5;
        }
        this.parameterSets = var2_2;
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setNull(int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n, null, BaseData.mapJDBCTypeToJavaObjectType(n2), n2, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBoolean(int n, boolean bl) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n);
            baseParameter.setBoolean(bl);
            baseParameter.sqlType = -7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setByte(int n, byte by) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n);
            baseParameter.setByte(by);
            baseParameter.sqlType = -6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setShort(int n, short s) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n);
            baseParameter.setShort(s);
            baseParameter.sqlType = 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInt(int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n);
            if (baseParameter == null) {
                this.currentParameters.parametersIn[n - 1] = baseParameter = new BaseParameter(this.connection);
            }
            baseParameter.setInteger(n2);
            baseParameter.sqlType = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLong(int n, long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n);
            baseParameter.setLong(l);
            baseParameter.sqlType = -5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFloat(int n, float f) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n);
            baseParameter.setFloat(f);
            baseParameter.sqlType = 7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDouble(int n, double d) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.currentParameters.getParameter(n);
            baseParameter.setDouble(d);
            baseParameter.sqlType = 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n, bigDecimal, 8, 2, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setString(int n, String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n, string, 10, 12, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBytes(int n, byte[] byArray) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n, byArray, 2, -3, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDate(int n, Date date) throws SQLException {
        if (date != null) {
            date = (Date)date.clone();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n, date, 11, 91, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTime(int n, Time time) throws SQLException {
        if (time != null) {
            time = (Time)time.clone();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n, time, 12, 92, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (timestamp == null) {
                this.setObjectInternal(n, null, 13, 93, -1);
            } else {
                this.setObjectInternal(n, new BaseTimestamp(timestamp, null), 13, 93, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (inputStream != null) {
                BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n2, this.connection, this.exceptions);
                baseInputStreamWrapper.setIsInputStream();
                this.setObjectInternal(n, baseInputStreamWrapper, 15, -1, -1);
            } else {
                this.setObjectInternal(n, null, 15, -1, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.connection.implConnection.shouldExposeGetSetUnicodeStream()) {
                String[] stringArray = new String[]{"PreparedStatement.setUnicodeStream"};
                throw this.connection.exceptions.getException(6003, stringArray);
            }
            if (inputStream != null) {
                BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n2, this.connection, this.exceptions);
                baseInputStreamWrapper.setIsInputStream();
                this.setObjectInternal(n, baseInputStreamWrapper, 17, -1, -1);
            } else {
                this.setObjectInternal(n, null, 17, -1, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (inputStream != null) {
                BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n2, this.connection, this.exceptions);
                baseInputStreamWrapper.setIsInputStream();
                this.setObjectInternal(n, baseInputStreamWrapper, 14, -4, -1);
            } else {
                this.setObjectInternal(n, null, 14, -4, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.currentParameters.clearInput();
        }
    }

    private final void setObjectInternal(int n, Object object, int n2, int n3, int n4) throws SQLException {
        BaseData baseData;
        if (this.state == 4 || this.connection.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.validateSqlType(n3);
        if (n4 != -1 && (n3 == 3 || n3 == 2)) {
            baseData = new BaseData(n2, object, this.connection);
            object = baseData.getBigDecimal(n4, this.exceptions);
            n2 = 8;
            n4 = -1;
        }
        baseData = this.currentParameters.getParameter(n);
        ((BaseParameter)baseData).sqlType = n3;
        baseData.setData(n2, object);
        ((BaseParameter)baseData).scale = n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(int n, Object object, int n2, int n3) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            int n4 = BaseData.getJavaObjectType(object, n2);
            if (n4 == 0) {
                throw this.exceptions.getException(6069);
            }
            if (!(n4 != 20 || object instanceof BaseClob && ((BaseClob)object).connection == this.connection)) {
                this.setCharacterStream(n, ((Clob)object).getCharacterStream(), (int)((Clob)object).length());
            } else if (!(n4 != 19 || object instanceof BaseBlob && ((BaseBlob)object).connection == this.connection)) {
                this.setBinaryStream(n, ((Blob)object).getBinaryStream(), (int)((Blob)object).length());
            } else {
                if (n4 == 13) {
                    if (object != null) {
                        object = new BaseTimestamp((Timestamp)object, null);
                    }
                } else {
                    object = this.wrapStreamFromSetObject(object);
                }
                this.setObjectInternal(n, object, n4, n2, n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(int n, Object object, int n2) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            int n3 = BaseData.getJavaObjectType(object, n2);
            if (n3 == 0) {
                throw this.exceptions.getException(6033);
            }
            if (!(n3 != 20 || object instanceof BaseClob && ((BaseClob)object).connection == this.connection)) {
                this.setCharacterStream(n, ((Clob)object).getCharacterStream(), (int)((Clob)object).length());
            } else if (!(n3 != 19 || object instanceof BaseBlob && ((BaseBlob)object).connection == this.connection)) {
                this.setBinaryStream(n, ((Blob)object).getBinaryStream(), (int)((Blob)object).length());
            } else {
                if (n3 == 13) {
                    if (object != null) {
                        object = new BaseTimestamp((Timestamp)object, null);
                    }
                } else {
                    object = this.wrapStreamFromSetObject(object);
                }
                this.setObjectInternal(n, object, n3, n2, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(int n, Object object) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            int n2 = BaseData.getJavaObjectType(object, 0);
            if (n2 == 0) {
                throw this.exceptions.getException(6033);
            }
            if (!(n2 != 20 || object instanceof BaseClob && ((BaseClob)object).connection == this.connection)) {
                this.setCharacterStream(n, ((Clob)object).getCharacterStream(), (int)((Clob)object).length());
            } else if (!(n2 != 19 || object instanceof BaseBlob && ((BaseBlob)object).connection == this.connection)) {
                this.setBinaryStream(n, ((Blob)object).getBinaryStream(), (int)((Blob)object).length());
            } else {
                object = n2 == 13 ? new BaseTimestamp((Timestamp)object, null) : this.wrapStreamFromSetObject(object);
                this.setObjectInternal(n, object, n2, this.implStatement.implConnection.mapJavaTypeToSQLType(n2), -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean execute() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.commonTransitionToState(2);
            return super.executeInternal();
        }
    }

    public final boolean execute(String string) throws SQLException {
        String[] stringArray = new String[]{"execute(String sql)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    public final boolean execute(String string, int n) throws SQLException {
        String[] stringArray = new String[]{"execute(String sql, int autoGeneratedKeys)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBatch() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.internalAddBatchForNonBatchExecution) {
                if (this.parameterSets.size() == 0) {
                    this.parameterSets.add(this.currentParameters);
                } else {
                    this.parameterSets.setElementAt(this.currentParameters, 0);
                }
                this.numParameterSets = 1;
            } else {
                BaseParameters baseParameters;
                if (this.parameterSets.size() <= this.numParameterSets) {
                    this.parameterSets.add(this.currentParameters);
                    baseParameters = new BaseParameters(this.currentParameters, this.exceptions, this.connection);
                } else {
                    baseParameters = (BaseParameters)this.parameterSets.get(this.numParameterSets);
                    if (baseParameters == this.currentParameters) {
                        baseParameters = new BaseParameters(this.currentParameters, this.exceptions, this.connection);
                    } else {
                        baseParameters.copy(this.currentParameters, this.exceptions, this.connection);
                    }
                    this.parameterSets.setElementAt(this.currentParameters, this.numParameterSets);
                }
                this.currentParameters = baseParameters;
                ++this.numParameterSets;
            }
        }
    }

    public final void addBatch(String string) throws SQLException {
        String[] stringArray = new String[]{"addBatch(String sql)"};
        throw this.exceptions.getException(6011, stringArray);
    }

    void clearBatchInternal() throws SQLException {
        this.numParameterSets = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (reader != null) {
                BaseCharacterStreamWrapper baseCharacterStreamWrapper = new BaseCharacterStreamWrapper(reader, n2, this.connection, this.exceptions);
                baseCharacterStreamWrapper.setIsInputStream();
                this.setObjectInternal(n, baseCharacterStreamWrapper, 18, -1, -1);
            } else {
                this.setObjectInternal(n, null, 18, -1, -1);
            }
        }
    }

    public final void setRef(int n, Ref ref) throws SQLException {
        String[] stringArray = new String[]{"PreparedStatement.setRef"};
        throw this.exceptions.getException(6003, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBlob(int n, Blob blob) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!(blob == null || blob instanceof BaseBlob && ((BaseBlob)blob).connection == this.connection)) {
                this.setBinaryStream(n, blob.getBinaryStream(), (int)blob.length());
            } else {
                this.setObjectInternal(n, blob, 19, 2004, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setClob(int n, Clob clob) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!(clob == null || clob instanceof BaseClob && ((BaseClob)clob).connection == this.connection)) {
                this.setCharacterStream(n, clob.getCharacterStream(), (int)clob.length());
            } else {
                this.setObjectInternal(n, clob, 20, 2005, -1);
            }
        }
    }

    public final void setArray(int n, Array array) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"PreparedStatement.setArray"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResultSetMetaData getMetaData() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.describeColumns();
            if (this.currentColumns == null) {
                return null;
            }
            return new BaseResultSetMetaData(this, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDate(int n, Date date, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n, BaseData.applyCalender(date, calendar, true), 11, 91, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTime(int n, Time time, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setObjectInternal(n, BaseData.applyCalender(time, calendar, true), 12, 92, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (timestamp == null) {
                this.setObjectInternal(n, null, 13, 93, -1);
            } else {
                this.setObjectInternal(n, new BaseTimestamp(timestamp, calendar), 13, 93, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setNull(int n, int n2, String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.setNull(n, n2);
        }
    }

    final Object wrapStreamFromSetObject(Object object) {
        if (object instanceof InputStream) {
            BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper((InputStream)object, -1L, this.connection, this.exceptions);
            baseInputStreamWrapper.setIsInputStream();
            object = baseInputStreamWrapper;
        } else if (object instanceof Reader) {
            BaseCharacterStreamWrapper baseCharacterStreamWrapper = new BaseCharacterStreamWrapper((Reader)object, -1L, this.connection, this.exceptions);
            baseCharacterStreamWrapper.setIsInputStream();
            object = baseCharacterStreamWrapper;
        }
        return object;
    }

    public final void setURL(int n, URL uRL) throws SQLException {
        String[] stringArray = new String[]{"PreparedStatement.setURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ParameterMetaData getParameterMetaData() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.parametersDescribed && this.currentParameters.count() > 0) {
                this.implStatement.describeParameters(this.currentParameters);
                if (this.currentParameters.parameterMetaData == null) {
                    if (this.implStatement.sql.getType() == 1) {
                        this.discoverSelectParamMetaData(this.currentParameters);
                    } else {
                        this.discoverNonSelectParamMetaData(this.currentParameters);
                    }
                }
                this.parametersDescribed = true;
            }
            if (this.numParameterSets > 0 && ((BaseParameters)this.parameterSets.elementAt((int)0)).parameterMetaData == null) {
                int n = 0;
                while (n < this.numParameterSets) {
                    ((BaseParameters)this.parameterSets.elementAt((int)n)).parameterMetaData = this.currentParameters.parameterMetaData;
                    ++n;
                }
            }
            return BaseParameterMetaDataFactory.getMetaData(this.currentParameters);
        }
    }

    private void discoverNonSelectParamMetaData(BaseParameters baseParameters) {
        BaseEPMDTokenizer baseEPMDTokenizer = new BaseEPMDTokenizer(this.implStatement.sql.getOriginal());
        int n = 0;
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n != 2 && n != 1) {
            int n3 = baseEPMDTokenizer.nextToken();
            block1 : switch (n) {
                case 0: {
                    switch (n3) {
                        case 0: {
                            n = 3;
                            break block1;
                        }
                        case 1: {
                            n = 5;
                            break block1;
                        }
                    }
                    n = 1;
                    break;
                }
                case 3: {
                    switch (n3) {
                        case 4: {
                            n = 6;
                            break block1;
                        }
                    }
                    n = 1;
                    break;
                }
                case 5: 
                case 6: {
                    switch (n3) {
                        case 14: {
                            string = baseEPMDTokenizer.getTokenValue();
                            n = 12;
                            break block1;
                        }
                    }
                    n = 1;
                    break;
                }
                case 12: {
                    switch (n3) {
                        case 5: {
                            n = 8;
                            break block1;
                        }
                        case 8: {
                            n = 4;
                            break block1;
                        }
                        case 3: {
                            n = 7;
                            break block1;
                        }
                    }
                    n = 1;
                    break;
                }
                case 4: {
                    switch (n3) {
                        case 14: {
                            arrayList.add(baseEPMDTokenizer.getTokenValue());
                            break block1;
                        }
                        case 10: {
                            break block1;
                        }
                        case 9: {
                            n = 12;
                            break block1;
                        }
                    }
                    n = 1;
                    break;
                }
                case 8: {
                    switch (n3) {
                        case 9: {
                            n = 2;
                            break block1;
                        }
                        case 11: {
                            ++n2;
                            break block1;
                        }
                        case 8: 
                        case 10: {
                            break block1;
                        }
                    }
                    n = 1;
                    break;
                }
                case 7: {
                    switch (n3) {
                        case 14: {
                            arrayList.add(baseEPMDTokenizer.getTokenValue());
                            break block1;
                        }
                        case 2: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            break block1;
                        }
                        case -1: {
                            n = 2;
                            break block1;
                        }
                    }
                    n = 1;
                }
            }
        }
        if (n != 1) {
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            int n4 = arrayList.size();
            if (n4 > 0) {
                int n5 = 0;
                while (n5 < n4) {
                    if (n5 != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append((String)arrayList.get(n5));
                    ++n5;
                }
            } else {
                stringBuffer.append("* ");
            }
            stringBuffer.append(" FROM ");
            stringBuffer.append(string);
            stringBuffer.append(" WHERE 0=1");
            try {
                BaseStatement baseStatement = new BaseStatement(this.connection, 1003, 1007);
                ResultSet resultSet = baseStatement.executeQuery(stringBuffer.toString());
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n6 = resultSetMetaData.getColumnCount();
                if (n6 != baseParameters.count()) {
                    return;
                }
                int n7 = 1;
                while (n7 <= n6) {
                    BaseParameterInfo baseParameterInfo = new BaseParameterInfo();
                    baseParameterInfo.nativeTypeName = resultSetMetaData.getColumnTypeName(n7);
                    baseParameterInfo.setType(resultSetMetaData.getColumnType(n7));
                    baseParameterInfo.mode = 0;
                    baseParameterInfo.nullable = resultSetMetaData.isNullable(n7);
                    baseParameterInfo.precision = resultSetMetaData.getPrecision(n7);
                    baseParameterInfo.scale = resultSetMetaData.getScale(n7);
                    baseParameterInfo.typeClassName = resultSetMetaData.getColumnClassName(n7);
                    baseParameterInfo.signed = resultSetMetaData.isSigned(n7);
                    baseParameters.setParameterInfo(n7 - 1, baseParameterInfo);
                    ++n7;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private void discoverSelectParamMetaData(BaseParameters baseParameters) {
        block14: {
            try {
                int n;
                BaseSQL baseSQL = new BaseSQL(this.implStatement.sql, 12);
                UtilVectorUnsynced utilVectorUnsynced = baseSQL.getPredicateParamColumnDefinitions();
                if (utilVectorUnsynced == null || (n = utilVectorUnsynced.size()) != baseSQL.getParameterCount()) break block14;
                int n2 = 0;
                while (n2 < n) {
                    Object object;
                    Object object2;
                    Object object3;
                    UtilVectorUnsynced utilVectorUnsynced2 = (UtilVectorUnsynced)utilVectorUnsynced.elementAt(n2);
                    int n3 = utilVectorUnsynced2.size();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int n4 = 0;
                    while (n4 < n3) {
                        block15: {
                            object3 = (String)utilVectorUnsynced2.get(n4);
                            if (((String)object3).equals("charish")) {
                                bl2 = true;
                            } else {
                                object2 = null;
                                try {
                                    object2 = this.connection.prepareStatement((String)object3);
                                }
                                catch (Exception exception) {
                                    break block15;
                                }
                                ResultSetMetaData resultSetMetaData = object2.getMetaData();
                                if (resultSetMetaData != null && resultSetMetaData.getColumnCount() == 1) {
                                    object = new BaseParameterInfo();
                                    ((BaseParameterInfo)object).nativeTypeName = resultSetMetaData.getColumnTypeName(1);
                                    ((BaseParameterInfo)object).setType(resultSetMetaData.getColumnType(1));
                                    ((BaseParameterInfo)object).mode = 0;
                                    ((BaseParameterInfo)object).nullable = resultSetMetaData.isNullable(1);
                                    ((BaseParameterInfo)object).precision = resultSetMetaData.getPrecision(1);
                                    ((BaseParameterInfo)object).scale = resultSetMetaData.getScale(1);
                                    ((BaseParameterInfo)object).typeClassName = resultSetMetaData.getColumnClassName(1);
                                    ((BaseParameterInfo)object).signed = resultSetMetaData.isSigned(1);
                                    baseParameters.setParameterInfo(n2, (BaseParameterInfo)object);
                                    if (((BaseParameterInfo)object).sqlType == 12 || ((BaseParameterInfo)object).sqlType == -9 || ((BaseParameterInfo)object).sqlType == 1 || ((BaseParameterInfo)object).sqlType == -8) {
                                        bl3 = true;
                                    }
                                    object2.close();
                                    bl = true;
                                    break;
                                }
                            }
                        }
                        ++n4;
                    }
                    if (bl2 && !bl3) {
                        object3 = this.connection.getMetaData().getTypeInfo();
                        object2 = null;
                        int n5 = 0;
                        while (object3.next()) {
                            int n6;
                            object = object3.getString(1);
                            if (object3.getInt(2) != 12 || (n6 = object3.getInt(3)) <= n5) continue;
                            n5 = n6;
                            if (object2 == null) {
                                object2 = new BaseParameterInfo();
                            }
                            ((BaseParameterInfo)object2).nativeTypeName = object;
                            ((BaseParameterInfo)object2).setType(12);
                            ((BaseParameterInfo)object2).mode = 0;
                            ((BaseParameterInfo)object2).precision = n6;
                            ((BaseParameterInfo)object2).nullable = object3.getInt(7);
                            ((BaseParameterInfo)object2).scale = object3.getInt(15);
                            ((BaseParameterInfo)object2).typeClassName = "java.lang.String";
                        }
                        baseParameters.setParameterInfo(n2, (BaseParameterInfo)object2);
                        bl = true;
                    }
                    if (!bl) {
                        return;
                    }
                    ++n2;
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    class BaseEPMDTokenizer {
        static final int TYPE_NONE = -2;
        static final int TYPE_END = -1;
        static final int TYPE_INSERT = 0;
        static final int TYPE_UPDATE = 1;
        static final int TYPE_WHERE = 2;
        static final int TYPE_SET = 3;
        static final int TYPE_INTO = 4;
        static final int TYPE_VALUES = 5;
        static final int TYPE_AND = 6;
        static final int TYPE_OR = 7;
        static final int TYPE_LEFT_PAREN = 8;
        static final int TYPE_RIGHT_PAREN = 9;
        static final int TYPE_COMMA = 10;
        static final int TYPE_QUESTION_MARK = 11;
        static final int TYPE_OP = 12;
        static final int TYPE_AND_OR = 13;
        static final int TYPE_UNKNOWN = 14;
        private static final int STATE_START = 0;
        private static final int STATE_BUILDING_MULTI_CHAR_TOKEN = 1;
        private static final int STATE_END = 2;
        private String sql;
        private int pos = 0;
        private StringBuffer valueBuffer = new StringBuffer();
        private String value;
        private int type = -2;

        BaseEPMDTokenizer(String string) {
            this.sql = string;
        }

        int nextToken() {
            this.value = null;
            this.valueBuffer.setLength(0);
            this.type = -2;
            int n = 0;
            boolean bl = false;
            char c = '\u0000';
            do {
                if (this.pos == this.sql.length()) {
                    bl = true;
                } else {
                    c = this.sql.charAt(this.pos++);
                }
                switch (n) {
                    case 0: {
                        if (bl) {
                            n = 2;
                            this.type = -1;
                            break;
                        }
                        if (this.whiteSpace(c)) break;
                        if (c == '(') {
                            n = 2;
                            this.type = 8;
                            break;
                        }
                        if (c == ')') {
                            n = 2;
                            this.type = 9;
                            break;
                        }
                        if (c == ',') {
                            n = 2;
                            this.type = 10;
                            break;
                        }
                        if (c == '?') {
                            n = 2;
                            this.type = 11;
                            break;
                        }
                        if (c == '=' || c == '<' || c == '>') {
                            n = 2;
                            this.type = 12;
                            break;
                        }
                        this.valueBuffer.append(c);
                        n = 1;
                        break;
                    }
                    case 1: {
                        if (bl || this.whiteSpace(c) || c == '(' || c == ')' || c == ',' || c == '?' || c == '=' || c == '<' || c == '>') {
                            n = 2;
                            if (!bl) {
                                --this.pos;
                            }
                            this.value = this.valueBuffer.toString();
                            if (this.value.equalsIgnoreCase("insert")) {
                                this.type = 0;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("update")) {
                                this.type = 1;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("where")) {
                                this.type = 2;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("set")) {
                                this.type = 3;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("into")) {
                                this.type = 4;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("values")) {
                                this.type = 5;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("and")) {
                                this.type = 13;
                                break;
                            }
                            if (this.value.equalsIgnoreCase("or")) {
                                this.type = 13;
                                break;
                            }
                            this.type = 14;
                            break;
                        }
                        this.valueBuffer.append(c);
                    }
                }
            } while (n != 2);
            return this.type;
        }

        String getTokenValue() {
            return this.value;
        }

        int getTokenType() {
            return this.type;
        }

        private boolean whiteSpace(char c) {
            return c <= ' ' && c != '\u0000';
        }
    }
}

