/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.columns;

import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumn;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import com.metamatrix.jdbc.sequelink.utilities.BooleanArray;
import com.metamatrix.jdbc.sequelink.utilities.DoubleArray;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.sql.SQLException;

public class SequeLinkDoubleColumn
extends SequeLinkColumn {
    private DoubleArray array = new DoubleArray();
    private BooleanArray isNull = new BooleanArray();

    public SequeLinkDoubleColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, n, 7);
    }

    protected void setBindInfo() {
        this.sqlnkType = 7;
        this.sqlnkSize = 8;
    }

    protected void readDataFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        this.array.add(sspInputStream.readSSPFloatType());
        this.isNull.add(false);
    }

    protected void readNull() {
        this.array.add(0.0);
        this.isNull.add(true);
    }

    public BaseData getData(int n, int n2, DiagnosticList diagnosticList) throws SQLException {
        if (this.isNull.get(n2)) {
            this.myBaseData.setNull(this.baseDataType);
        } else {
            this.myBaseData.setDouble(this.array.get(n2));
        }
        return this.myBaseData;
    }

    public void clearData() {
        this.array.reset();
        this.isNull.reset();
    }
}

