/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ssl;

import iaik.security.ssl.SSLTransport;
import iaik.security.ssl.SecurityProvider;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;

public class ChainVerifier {
    protected boolean checkServerName;
    protected Hashtable cachedCerts;
    protected boolean nullTrusted;
    protected Hashtable trustedCerts;
    private static final boolean a = false;

    protected boolean verifyServer(X509Certificate[] x509CertificateArray, SSLTransport sSLTransport) {
        if (!this.checkServerName) {
            return true;
        }
        String string = sSLTransport.getRemotePeerName();
        if (string == null) {
            return true;
        }
        String[] stringArray = SecurityProvider.getSecurityProvider().getTLSServerName(x509CertificateArray[0]);
        if (stringArray == null) {
            return true;
        }
        if (stringArray.length == 0) {
            sSLTransport.a("ChainVerifier: certificate does not contain a server name!");
            return false;
        }
        string = string.toLowerCase();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2].toLowerCase();
            if (string2.startsWith("*") ? (string2 = string2.substring(1)).length() == 0 || string.endsWith(string2) : string.equals(string2)) {
                return true;
            }
            ++n2;
        }
        sSLTransport.a("ChainVerifier: name mismatch: " + stringArray[0] + " != " + string);
        return false;
    }

    protected boolean verifyClient(X509Certificate[] x509CertificateArray, SSLTransport sSLTransport) {
        return true;
    }

    public boolean verifyChain(X509Certificate[] x509CertificateArray, SSLTransport sSLTransport) {
        if (x509CertificateArray == null) {
            sSLTransport.a("ChainVerifier: Empty peer certificate chain, " + (this.nullTrusted ? "OK" : "NOT OK"));
            return this.nullTrusted;
        }
        if (sSLTransport.getUseClientMode() ? !this.verifyServer(x509CertificateArray, sSLTransport) : !this.verifyClient(x509CertificateArray, sSLTransport)) {
            return false;
        }
        try {
            int n2 = x509CertificateArray.length;
            int n3 = 0;
            while (n3 < n2 - 1) {
                if (this.verifyCertificate(x509CertificateArray[n3], x509CertificateArray[n3 + 1])) {
                    this.cacheCertificates(x509CertificateArray, 0, n3);
                    ChainVerifier.a(sSLTransport);
                    return true;
                }
                ++n3;
            }
            X509Certificate x509Certificate = x509CertificateArray[n2 - 1];
            if (x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
                if (this.verifyCertificate(x509Certificate, x509Certificate)) {
                    this.cacheCertificates(x509CertificateArray, 0, n2 - 1);
                    ChainVerifier.a(sSLTransport);
                    return true;
                }
            } else {
                X509Certificate x509Certificate2 = this.getIssuerCertificate(x509Certificate);
                if (this.verifyCertificate(x509Certificate, x509Certificate2)) {
                    this.cacheCertificates(x509CertificateArray, 0, n2 - 1);
                    ChainVerifier.a(sSLTransport);
                    return true;
                }
                if (x509Certificate2 != null && this.isTrustedCertificate(x509Certificate2)) {
                    this.cacheCertificates(x509CertificateArray, 0, n2 - 1);
                    ChainVerifier.a(sSLTransport);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            sSLTransport.a("ChainVerifier: Error verifying certificate chain: " + exception);
            return false;
        }
        if (this.size() == 0) {
            sSLTransport.a("ChainVerifier: No trusted certificate found, OK anyway.");
            return true;
        }
        sSLTransport.a("ChainVerifier: No trusted certificate found, rejected.");
        return false;
    }

    protected boolean verifyCertificate(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws Exception {
        x509Certificate.checkValidity();
        if (this.isCachedCertificate(x509Certificate)) {
            return true;
        }
        if (this.isTrustedCertificate(x509Certificate)) {
            return true;
        }
        if (x509Certificate2 != null) {
            x509Certificate.verify(x509Certificate2.getPublicKey());
        }
        return false;
    }

    public int size() {
        return this.trustedCerts.size();
    }

    public void setCheckServerName(boolean bl) {
        this.checkServerName = bl;
    }

    public void removeTrustedCertificate(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            this.nullTrusted = false;
            return;
        }
        this.trustedCerts.remove(x509Certificate.getSubjectDN());
        this.clearCachedCertificates();
    }

    protected boolean isTrustedCertificate(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return this.nullTrusted;
        }
        X509Certificate x509Certificate2 = (X509Certificate)this.trustedCerts.get(x509Certificate.getSubjectDN());
        if (x509Certificate2 == null) {
            return false;
        }
        return x509Certificate.equals(x509Certificate2);
    }

    protected boolean isCachedCertificate(X509Certificate x509Certificate) {
        return this.cachedCerts.containsKey(x509Certificate);
    }

    public Principal[] getTrustedPrincipalsArray() {
        int n2 = this.size();
        Enumeration enumeration = this.getTrustedPrincipals();
        if (n2 <= 0 || enumeration == null) {
            return new Principal[0];
        }
        Principal[] principalArray = new Principal[n2];
        int n3 = 0;
        while (n3 < n2 && enumeration.hasMoreElements()) {
            principalArray[n3++] = (Principal)enumeration.nextElement();
        }
        return principalArray;
    }

    public Enumeration getTrustedPrincipals() {
        return this.trustedCerts.keys();
    }

    protected X509Certificate getIssuerCertificate(X509Certificate x509Certificate) {
        X509Certificate x509Certificate2 = (X509Certificate)this.trustedCerts.get(x509Certificate.getIssuerDN());
        return x509Certificate2;
    }

    public boolean getCheckServerName() {
        return this.checkServerName;
    }

    private static void a(SSLTransport sSLTransport) {
        sSLTransport.a("ChainVerifier: Found a trusted certificate, returning true");
    }

    public void clearTrustedCertificates() {
        this.trustedCerts.clear();
        this.clearCachedCertificates();
    }

    protected void clearCachedCertificates() {
        this.cachedCerts.clear();
    }

    protected void cacheCertificates(X509Certificate[] x509CertificateArray, int n2, int n3) {
        int n4 = n2;
        while (n4 <= n3) {
            this.cacheCertificate(x509CertificateArray[n4]);
            ++n4;
        }
    }

    protected void cacheCertificate(X509Certificate x509Certificate) {
        if (this.cachedCerts.size() >= 64) {
            this.clearCachedCertificates();
        }
        this.cachedCerts.put(x509Certificate, x509Certificate);
    }

    public void addTrustedCertificate(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            this.nullTrusted = true;
            return;
        }
        this.trustedCerts.put(x509Certificate.getSubjectDN(), x509Certificate);
    }

    protected ChainVerifier(int n2) {
    }

    public ChainVerifier() {
        this.trustedCerts = new Hashtable();
        this.nullTrusted = false;
        this.cachedCerts = new Hashtable();
        this.checkServerName = false;
    }
}

