/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.columns;

import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import com.metamatrix.jdbc.slbase.BaseColumn;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.sequelink.variables.Variable;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTransliterator;
import java.io.IOException;
import java.sql.SQLException;

public abstract class SequeLinkColumn
extends BaseColumn
implements Variable {
    protected int position;
    protected int sqlnkType;
    protected int sqlnkSize;
    protected UtilTransliterator ut;
    protected int maxFieldSize;
    protected StatementContext stmtCtxt;
    protected String encoding;
    private SequeLinkColumnDescribe describe;
    protected BaseData myBaseData;

    SequeLinkColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n2, int n3) throws SQLException {
        this.stmtCtxt = statementContext;
        this.describe = sequeLinkColumnDescribe;
        this.position = sequeLinkColumnDescribe.getPosition();
        this.maxFieldSize = n2;
        this.type = sequeLinkColumnDescribe.getType();
        this.baseDataType = n3;
        this.catalogName = sequeLinkColumnDescribe.getCatalogName();
        this.displaySize = sequeLinkColumnDescribe.getDisplaySize();
        this.label = sequeLinkColumnDescribe.getLabel();
        this.name = sequeLinkColumnDescribe.getName();
        this.typeName = sequeLinkColumnDescribe.getTypeName();
        this.precision = sequeLinkColumnDescribe.getPrecision();
        this.scale = sequeLinkColumnDescribe.getScale();
        this.schemaName = sequeLinkColumnDescribe.getSchemaName();
        this.tableName = sequeLinkColumnDescribe.getTableName();
        this.isAutoIncrement = sequeLinkColumnDescribe.isAutoIncrement();
        this.isCaseSensitive = sequeLinkColumnDescribe.isCaseSensitive();
        this.isCurrency = sequeLinkColumnDescribe.isCurrency();
        this.isDefinitelyWritable = sequeLinkColumnDescribe.isDefinitelyWritable();
        this.isNullable = sequeLinkColumnDescribe.isNullable();
        this.isReadOnly = sequeLinkColumnDescribe.isReadOnly();
        this.isWritable = sequeLinkColumnDescribe.isWritable();
        this.isSearchable = sequeLinkColumnDescribe.isSearchable();
        this.isSigned = sequeLinkColumnDescribe.isSigned();
        this.encoding = sequeLinkColumnDescribe.getEncoding();
        this.ut = this._getTransliterator();
        this.setBindInfo();
        this.myBaseData = new BaseData(n3, null);
    }

    public void setType(int n2) {
        this.type = n2;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isPseudo() {
        return false;
    }

    private UtilTransliterator _getTransliterator() throws SQLException {
        return this.stmtCtxt.getSsp().getTransliterator(this.encoding);
    }

    public UtilTransliterator getTransliterator() {
        return null;
    }

    protected abstract void setBindInfo() throws SQLException;

    public void writeDefinitionOn(SspOutputStream sspOutputStream) throws IOException, UtilException {
        sspOutputStream.writeSSPInt32(this.position);
        sspOutputStream.writeSSPEnum(this.sqlnkType);
        sspOutputStream.writeSSPEnum(0);
        sspOutputStream.writeSSPEnum(1);
        sspOutputStream.writeSSPInt32(this.sqlnkSize);
        sspOutputStream.writeSSPString("");
        sspOutputStream.writeSSPInt32(this.precision);
        sspOutputStream.writeSSPInt32(this.scale);
    }

    public void writeObjectAndIndicatorOn(SspOutputStream sspOutputStream) throws IOException {
        throw new InternalError(this.getClass().getName() + " writeObjectAndIndicatorOn");
    }

    public void readObjectAndIndicatorFrom(SspInputStream sspInputStream) throws IOException, UtilException {
        int n2 = sspInputStream.readSSPIndicator();
        if (n2 > -1 || n2 == -2) {
            this.readDataFromStream(sspInputStream);
        } else {
            this.readNull();
        }
    }

    protected abstract void readDataFromStream(SspInputStream var1) throws IOException, UtilException;

    protected abstract void readNull();

    public abstract BaseData getData(int var1, int var2, DiagnosticList var3) throws SQLException;

    public abstract void clearData();

    public void cacheData(int n2, DiagnosticList diagnosticList) throws SQLException {
    }

    public void clearCache() {
    }

    public void cleanUp() {
    }
}

