/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.command.CreateMappingCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;

public abstract class MatchMappingCommand
extends CompoundCommand {
    protected MappingDomain domain;
    protected Mapping mapping;
    protected Collection mappedInputs;
    protected static final String LABEL = MappingPlugin.IS_ECLIPSE_RUNNING ? MappingPlugin.getPlugin().getString("_UI_MatchMappingCommand_label") : MappingPlugin.INSTANCE.getString("_UI_MatchMappingCommand_label");
    protected static final String DESCRIPTION = MappingPlugin.IS_ECLIPSE_RUNNING ? MappingPlugin.getPlugin().getString("_UI_MatchMappingCommand_description") : MappingPlugin.INSTANCE.getString("_UI_MatchMappingCommand_description");

    public MatchMappingCommand(MappingDomain domain, Mapping mapping) {
        super(LABEL, DESCRIPTION);
        this.domain = domain;
        this.mapping = mapping;
    }

    protected boolean prepare() {
        if (this.domain != null && this.mapping != null) {
            ArrayList inputChildren = new ArrayList();
            Iterator inputs = this.mapping.getSenders().iterator();
            while (inputs.hasNext()) {
                inputChildren.addAll(this.domain.getChildren(inputs.next()));
            }
            ArrayList outputChildren = new ArrayList();
            Iterator outputs = this.mapping.getReceivers().iterator();
            while (outputs.hasNext()) {
                outputChildren.addAll(this.domain.getChildren(outputs.next()));
            }
            this.matchChildren(inputChildren, outputChildren);
        }
        boolean result = super.prepare();
        return result;
    }

    protected void matchChildren(Collection inputChildren, Collection outputChildren) {
        this.mappedInputs = new ArrayList();
        MappingRoot mappingRoot = this.domain.getMappingRoot();
        boolean multipleMatchesAllowed = (this.domain.getMappingEnablementFlags() & 4) != 0;
        Iterator childOutputs = outputChildren.iterator();
        while (childOutputs.hasNext()) {
            Object childOutput = childOutputs.next();
            if (!mappingRoot.getMappings(childOutput).isEmpty()) continue;
            ArrayList mappedObjects = new ArrayList();
            Iterator childInputs = inputChildren.iterator();
            while (childInputs.hasNext()) {
                Object childInput = childInputs.next();
                boolean canCreateMapping = multipleMatchesAllowed || !this.mappedInputs.contains(childInput) && mappingRoot.getMappings(childInput).isEmpty();
                if (!canCreateMapping || !this.match(childInput, childOutput, mappedObjects)) continue;
                break;
            }
            if (mappedObjects.isEmpty()) continue;
            this.mappedInputs.addAll(mappedObjects);
            mappedObjects.add(childOutput);
            Command mapCommand = CreateMappingCommand.create(this.domain, mappedObjects);
            this.appendIfCanExecute(mapCommand);
        }
    }

    protected abstract boolean match(Object var1, Object var2, Collection var3);

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (mapping: " + this.mapping + ")");
        return result.toString();
    }
}

