/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class StateReader {
    public static final String STATE_FILE = ".state";
    public static final String LAZY_FILE = ".lazy";
    private static final SecureAction secureAction = new SecureAction();
    protected Map objectTable = new HashMap();
    private File stateFile;
    private File lazyFile;
    private boolean lazyLoad = true;
    private int numBundles;
    public static final byte STATE_CACHE_VERSION = 21;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;
    private WeakHashMap stringCache = new WeakHashMap();

    public StateReader() {
        this.lazyLoad = false;
    }

    public StateReader(File stateDirectory) {
        if (!stateDirectory.exists()) {
            stateDirectory.mkdirs();
        }
        this.stateFile = new File(stateDirectory, STATE_FILE);
        this.lazyFile = new File(stateDirectory, LAZY_FILE);
        this.lazyLoad = false;
    }

    public StateReader(File stateFile, File lazyFile, boolean lazyLoad) {
        this.stateFile = stateFile;
        this.lazyFile = lazyFile;
        this.lazyLoad = lazyLoad;
    }

    private void addToObjectTable(Object object, int index) {
        this.objectTable.put(new Integer(index), object);
    }

    private Object getFromObjectTable(int index) {
        return this.objectTable.get(new Integer(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readState(StateImpl state, long expectedTimestamp) throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.stateFile), 65536));
        FilterInputStream lazyIn = null;
        try {
            int i;
            if (in.readByte() != 21) {
                boolean bl = false;
                return bl;
            }
            byte tag = this.readTag(in);
            if (tag != 1) {
                boolean e = false;
                return e;
            }
            int index = in.readInt();
            long timestampRead = in.readLong();
            if (expectedTimestamp >= 0L && timestampRead != expectedTimestamp) {
                boolean bl = false;
                return bl;
            }
            this.addToObjectTable(state, index);
            int numSets = in.readInt();
            Dictionary[] platformProps = new Dictionary[numSets];
            for (i = 0; i < numSets; ++i) {
                Hashtable<String, Object> props = new Hashtable<String, Object>(StateImpl.PROPS.length);
                int numProps = in.readInt();
                for (int j = 0; j < numProps; ++j) {
                    Object value = this.readPlatformProp(in);
                    if (value == null || j >= StateImpl.PROPS.length) continue;
                    props.put(StateImpl.PROPS[j], value);
                }
                platformProps[i] = props;
            }
            state.setPlatformProperties(platformProps);
            this.numBundles = in.readInt();
            if (this.numBundles == 0) {
                i = 1;
                return i != 0;
            }
            for (i = 0; i < this.numBundles; ++i) {
                BundleDescriptionImpl bundle = this.readBundleDescription(in);
                state.basicAddBundle(bundle);
                if (!bundle.isResolved()) continue;
                state.addResolvedBundle(bundle);
            }
            state.setTimeStamp(timestampRead);
            state.setResolved(in.readBoolean());
            if (this.lazyLoad) {
                i = 1;
                return i != 0;
            }
            lazyIn = new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.lazyFile), 65536));
            i = 0;
            while (i < this.numBundles) {
                this.readBundleDescriptionLazyData((DataInputStream)lazyIn, 0);
                ++i;
            }
            return true;
        }
        finally {
            in.close();
            if (lazyIn != null) {
                try {
                    lazyIn.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private boolean readStateDeprecated(StateImpl state, DataInputStream in, long expectedTimestamp) throws IOException {
        int i;
        if (in.readByte() != 21) {
            return false;
        }
        byte tag = this.readTag(in);
        if (tag != 1) {
            return false;
        }
        int index = in.readInt();
        long timestampRead = in.readLong();
        if (expectedTimestamp >= 0L && timestampRead != expectedTimestamp) {
            return false;
        }
        this.addToObjectTable(state, index);
        int numSets = in.readInt();
        Dictionary[] platformProps = new Dictionary[numSets];
        for (i = 0; i < numSets; ++i) {
            Hashtable<String, Object> props = new Hashtable<String, Object>(StateImpl.PROPS.length);
            int numProps = in.readInt();
            for (int j = 0; j < numProps; ++j) {
                Object value = this.readPlatformProp(in);
                if (value == null || j >= StateImpl.PROPS.length) continue;
                props.put(StateImpl.PROPS[j], value);
            }
            platformProps[i] = props;
        }
        state.setPlatformProperties(platformProps);
        this.numBundles = in.readInt();
        if (this.numBundles == 0) {
            return true;
        }
        for (i = 0; i < this.numBundles; ++i) {
            BundleDescriptionImpl bundle = this.readBundleDescription(in);
            state.basicAddBundle(bundle);
            if (!bundle.isResolved()) continue;
            state.addResolvedBundle(bundle);
        }
        state.setTimeStamp(timestampRead);
        state.setResolved(in.readBoolean());
        in.readInt();
        if (this.lazyLoad) {
            return true;
        }
        for (i = 0; i < this.numBundles; ++i) {
            this.readBundleDescriptionLazyData(in, 0);
        }
        return true;
    }

    private Object readPlatformProp(DataInputStream in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        int num = in.readInt();
        if (num == 1) {
            return this.readString(in, false);
        }
        String[] result = new String[num];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.readString(in, false);
        }
        return result;
    }

    private BundleDescriptionImpl readBundleDescription(DataInputStream in) throws IOException {
        BaseDescription[] hosts;
        HostSpecificationImpl hostSpec;
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        if (tag == 2) {
            return (BundleDescriptionImpl)this.getFromObjectTable(in.readInt());
        }
        BundleDescriptionImpl result = new BundleDescriptionImpl();
        this.addToObjectTable(result, in.readInt());
        result.setBundleId(in.readLong());
        this.readBaseDescription(result, in);
        result.setLazyDataOffset(in.readInt());
        result.setLazyDataSize(in.readInt());
        result.setStateBit(1, in.readBoolean());
        result.setStateBit(2, in.readBoolean());
        result.setStateBit(32, in.readBoolean());
        result.setStateBit(64, in.readBoolean());
        result.setStateBit(128, in.readBoolean());
        result.setHost(this.readHostSpec(in));
        int numDeps = in.readInt();
        if (numDeps > 0) {
            BaseDescription[] deps = new BundleDescription[numDeps];
            for (int i = 0; i < numDeps; ++i) {
                deps[i] = this.readBundleDescription(in);
            }
            result.addDependencies(deps);
        }
        if ((hostSpec = (HostSpecificationImpl)result.getHost()) != null && (hosts = hostSpec.getHosts()) != null) {
            for (int i = 0; i < hosts.length; ++i) {
                ((BundleDescriptionImpl)hosts[i]).addDependency(result);
            }
            result.addDependencies(hosts);
        }
        result.setFullyLoaded(false);
        return result;
    }

    private BundleDescriptionImpl readBundleDescriptionLazyData(DataInputStream in, int skip) throws IOException {
        int resolvedRequiredCount;
        int resolvedCount;
        int selectedCount;
        int requiredBundleCount;
        int importCount;
        int index;
        BundleDescriptionImpl result;
        if (skip > 0) {
            in.skipBytes(skip);
        }
        if ((result = (BundleDescriptionImpl)this.getFromObjectTable(index = in.readInt())).isFullyLoaded()) {
            in.skipBytes(result.getLazyDataSize() - 4);
            return result;
        }
        result.setLocation(this.readString(in, false));
        result.setPlatformFilter(this.readString(in, false));
        int exportCount = in.readInt();
        if (exportCount > 0) {
            ExportPackageDescription[] exports = new ExportPackageDescription[exportCount];
            for (int i = 0; i < exports.length; ++i) {
                exports[i] = this.readExportPackageDesc(in);
            }
            result.setExportPackages(exports);
        }
        if ((importCount = in.readInt()) > 0) {
            ImportPackageSpecification[] imports = new ImportPackageSpecification[importCount];
            for (int i = 0; i < imports.length; ++i) {
                imports[i] = this.readImportPackageSpec(in);
            }
            result.setImportPackages(imports);
        }
        if ((requiredBundleCount = in.readInt()) > 0) {
            BundleSpecification[] requiredBundles = new BundleSpecification[requiredBundleCount];
            for (int i = 0; i < requiredBundles.length; ++i) {
                requiredBundles[i] = this.readBundleSpec(in);
            }
            result.setRequiredBundles(requiredBundles);
        }
        if ((selectedCount = in.readInt()) > 0) {
            ExportPackageDescription[] selected = new ExportPackageDescription[selectedCount];
            for (int i = 0; i < selected.length; ++i) {
                selected[i] = this.readExportPackageDesc(in);
            }
            result.setSelectedExports(selected);
        }
        if ((resolvedCount = in.readInt()) > 0) {
            ExportPackageDescription[] resolved = new ExportPackageDescription[resolvedCount];
            for (int i = 0; i < resolved.length; ++i) {
                resolved[i] = this.readExportPackageDesc(in);
            }
            result.setResolvedImports(resolved);
        }
        if ((resolvedRequiredCount = in.readInt()) > 0) {
            BundleDescription[] resolved = new BundleDescription[resolvedRequiredCount];
            for (int i = 0; i < resolved.length; ++i) {
                resolved[i] = this.readBundleDescription(in);
            }
            result.setResolvedRequires(resolved);
        }
        result.setFullyLoaded(true);
        return result;
    }

    private BundleSpecificationImpl readBundleSpec(DataInputStream in) throws IOException {
        BundleSpecificationImpl result = new BundleSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setSupplier(this.readBundleDescription(in));
        result.setExported(in.readBoolean());
        result.setOptional(in.readBoolean());
        return result;
    }

    private ExportPackageDescriptionImpl readExportPackageDesc(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        if (tag == 2) {
            return (ExportPackageDescriptionImpl)this.getFromObjectTable(in.readInt());
        }
        ExportPackageDescriptionImpl exportPackageDesc = new ExportPackageDescriptionImpl();
        int tableIndex = in.readInt();
        this.addToObjectTable(exportPackageDesc, tableIndex);
        exportPackageDesc.setTableIndex(tableIndex);
        this.readBaseDescription(exportPackageDesc, in);
        exportPackageDesc.setRoot(in.readBoolean());
        exportPackageDesc.setAttributes(this.readMap(in));
        exportPackageDesc.setDirectives(this.readMap(in));
        return exportPackageDesc;
    }

    private Map readMap(DataInputStream in) throws IOException {
        int count = in.readInt();
        if (count == 0) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>(count);
        for (int i = 0; i < count; ++i) {
            String key = this.readString(in, false);
            Object value = null;
            byte type = in.readByte();
            if (type == 0) {
                value = this.readString(in, false);
            } else if (type == 1) {
                value = this.readList(in);
            } else if (type == 2) {
                value = new Boolean(in.readBoolean());
            }
            result.put(key, (String[])value);
        }
        return result;
    }

    private String[] readList(DataInputStream in) throws IOException {
        int count = in.readInt();
        if (count == 0) {
            return null;
        }
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readString(in, false);
        }
        return result;
    }

    private void readBaseDescription(BaseDescriptionImpl root, DataInputStream in) throws IOException {
        root.setName(this.readString(in, false));
        root.setVersion(this.readVersion(in));
    }

    private ImportPackageSpecificationImpl readImportPackageSpec(DataInputStream in) throws IOException {
        ImportPackageSpecificationImpl result = new ImportPackageSpecificationImpl();
        this.readVersionConstraint(result, in);
        result.setSupplier(this.readExportPackageDesc(in));
        result.setBundleSymbolicName(this.readString(in, false));
        result.setBundleVersionRange(this.readVersionRange(in));
        result.setAttributes(this.readMap(in));
        result.setDirectives(this.readMap(in));
        return result;
    }

    private HostSpecificationImpl readHostSpec(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        HostSpecificationImpl result = new HostSpecificationImpl();
        this.readVersionConstraint(result, in);
        int hostCount = in.readInt();
        if (hostCount > 0) {
            BundleDescription[] hosts = new BundleDescription[hostCount];
            for (int i = 0; i < hosts.length; ++i) {
                hosts[i] = this.readBundleDescription(in);
            }
            result.setHosts(hosts);
        }
        return result;
    }

    private void readVersionConstraint(VersionConstraintImpl version, DataInputStream in) throws IOException {
        version.setName(this.readString(in, false));
        version.setVersionRange(this.readVersionRange(in));
    }

    private Version readVersion(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return Version.emptyVersion;
        }
        int majorComponent = in.readInt();
        int minorComponent = in.readInt();
        int serviceComponent = in.readInt();
        String qualifierComponent = this.readString(in, false);
        Version result = new Version(majorComponent, minorComponent, serviceComponent, qualifierComponent);
        return result;
    }

    private VersionRange readVersionRange(DataInputStream in) throws IOException {
        byte tag = this.readTag(in);
        if (tag == 0) {
            return null;
        }
        return new VersionRange(this.readVersion(in), in.readBoolean(), this.readVersion(in), in.readBoolean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean loadStateDeprecated(StateImpl state, DataInputStream input, long expectedTimestamp) throws IOException {
        try {
            boolean bl = this.readStateDeprecated(state, input, expectedTimestamp);
            return bl;
        }
        finally {
            input.close();
        }
    }

    public final boolean loadState(StateImpl state, long expectedTimestamp) throws IOException {
        return this.readState(state, expectedTimestamp);
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        String result = intern ? in.readUTF().intern() : in.readUTF();
        WeakReference ref = (WeakReference)this.stringCache.get(result);
        if (ref != null) {
            String refString = (String)ref.get();
            if (refString != null) {
                result = refString;
            }
        } else {
            this.stringCache.put(result, new WeakReference<String>(result));
        }
        return result;
    }

    private byte readTag(DataInputStream in) throws IOException {
        return in.readByte();
    }

    private DataInputStream openLazyFile() throws IOException {
        if (this.lazyFile == null) {
            throw new IOException();
        }
        return new DataInputStream(new BufferedInputStream(secureAction.getFileInputStream(this.lazyFile), 65536));
    }

    boolean isLazyLoaded() {
        return this.lazyLoad;
    }

    synchronized void fullyLoad() {
        DataInputStream in = null;
        try {
            in = this.openLazyFile();
            for (int i = 0; i < this.numBundles; ++i) {
                this.readBundleDescriptionLazyData(in, 0);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void fullyLoad(BundleDescriptionImpl target) throws IOException {
        DataInputStream in = null;
        try {
            in = this.openLazyFile();
            ArrayList toLoad = new ArrayList();
            this.addDependencies(target, toLoad);
            int[] skipBytes = this.getSkipBytes(toLoad);
            for (int i = 0; i < skipBytes.length; ++i) {
                this.readBundleDescriptionLazyData(in, skipBytes[i]);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void addDependencies(BundleDescriptionImpl target, List toLoad) {
        if (toLoad.contains(target) || target.isFullyLoaded()) {
            return;
        }
        Iterator load = toLoad.iterator();
        int i = 0;
        while (load.hasNext()) {
            BundleDescriptionImpl bundle = (BundleDescriptionImpl)load.next();
            if (target.getLazyDataOffset() < bundle.getLazyDataOffset()) break;
            ++i;
        }
        if (i >= toLoad.size()) {
            toLoad.add(target);
        } else {
            toLoad.add(i, target);
        }
        List deps = target.getBundleDependencies();
        Iterator iter = deps.iterator();
        while (iter.hasNext()) {
            this.addDependencies((BundleDescriptionImpl)iter.next(), toLoad);
        }
    }

    private int[] getSkipBytes(ArrayList toLoad) {
        int[] skipBytes = new int[toLoad.size()];
        for (int i = 0; i < skipBytes.length; ++i) {
            BundleDescriptionImpl current = (BundleDescriptionImpl)toLoad.get(i);
            if (i == 0) {
                skipBytes[i] = current.getLazyDataOffset();
                continue;
            }
            BundleDescriptionImpl previous = (BundleDescriptionImpl)toLoad.get(i - 1);
            skipBytes[i] = current.getLazyDataOffset() - previous.getLazyDataOffset() - previous.getLazyDataSize();
        }
        return skipBytes;
    }
}

