/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;

public class ContextFinder
extends ClassLoader {
    static final Finder contextFinder = (Finder)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new Finder();
        }
    });

    public ContextFinder(ClassLoader contextClassLoader) {
        super(contextClassLoader);
    }

    ClassLoader basicFindClassLoader() {
        Class[] stack = contextFinder.getClassContext();
        ClassLoader result = null;
        for (int i = 1; i < stack.length; ++i) {
            ClassLoader tmp = stack[i].getClassLoader();
            if (stack[i] == ContextFinder.class || tmp == null) continue;
            result = tmp;
            break;
        }
        if (this.checkClassLoader(result)) {
            return result;
        }
        return null;
    }

    private boolean checkClassLoader(ClassLoader classloader) {
        if (classloader == null || classloader == this.getParent()) {
            return false;
        }
        for (ClassLoader parent = classloader.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            return false;
        }
        return true;
    }

    private ClassLoader findClassLoader() {
        if (System.getSecurityManager() == null) {
            return this.basicFindClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ContextFinder.this.basicFindClassLoader();
            }
        });
    }

    protected synchronized Class loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        ClassLoader toConsult;
        Class<?> result = null;
        try {
            result = super.loadClass(arg0, arg1);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (result == null && (toConsult = this.findClassLoader()) != null) {
            result = toConsult.loadClass(arg0);
        }
        if (result == null) {
            throw new ClassNotFoundException(arg0);
        }
        return result;
    }

    protected URL findResource(String arg0) {
        ClassLoader toConsult;
        URL result = super.findResource(arg0);
        if (result == null && (toConsult = this.findClassLoader()) != null) {
            result = toConsult.getResource(arg0);
        }
        return result;
    }

    protected Enumeration findResources(String arg0) {
        try {
            ClassLoader toConsult;
            Enumeration<URL> result = super.findResources(arg0);
            if (result == null && (toConsult = this.findClassLoader()) != null) {
                result = toConsult.getResources(arg0);
            }
            return result;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static final class Finder
    extends SecurityManager {
        private Finder() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

