/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionContext;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.client.ClientSideLogon;
import com.metamatrix.common.comm.platform.client.ClientSideLogonFactory;
import com.metamatrix.common.comm.platform.client.IConnectionInstanceMgr;
import com.metamatrix.common.comm.platform.socket.client.ClientHeartbeat;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionContext;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstance;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceContext;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstancePool;
import com.metamatrix.common.comm.service.SecureMessageClientInterceptor;
import com.metamatrix.common.comm.service.SocketService;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.proxy.ServiceEndpoint;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceProxyFactory;
import com.metamatrix.platform.security.api.FindResourcesRequest;
import com.metamatrix.platform.security.api.FindResourcesResult;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SocketServerConnection
implements ServerConnection {
    public static final String SOCKETS_PER_VM = "socketsPerVM";
    static final int DEFAULT_SOCKETS_PER_VM = 5;
    private static final String COMMA_DELIMITER = ",";
    public static final String SERVICE_TYPE_PROP = "serviceType";
    private static final String QUERY_SERVICE_PROP = "QueryService";
    private static Random random = new Random(System.currentTimeMillis());
    private static int MAX_RETRIES = 3;
    private ILogon logon = null;
    private ClientSideLogon clientSideLogon = null;
    private SocketServerInstancePool serverInstancePool = null;
    private boolean shuttingDown = false;
    private ClientHeartbeat heartbeat = null;
    boolean connected = false;
    private Properties connectionProperties = null;
    private String clusterName = "DEFAULT_CLUSTER";
    private String serviceType;
    private MetaMatrixSessionID sessionId = null;
    private ClientSideLogonFactory clientSideLogonFactory = null;
    private static int virtualSocketCounter = 0;
    private int virtualSocketId;
    private boolean ssl = false;
    private String startupClusterName = null;
    private ServiceProxyFactory serviceProxyFactory;
    private Collection startupHosts = null;
    private SocketServerInstance stickyInstance;
    private boolean autoFailover;

    protected SocketServerConnection(Properties connProperties, IConnectionInstanceMgr connMgr, ClientSideLogonFactory clientSideLogonFactory, ServiceProxyFactory serviceProxyFactory) throws CommunicationException {
        if (CommPlatformPlugin.DEBUG) {
            String message = CommPlatformPlugin.Util.getString("AbstractServerConnection.Created", this.getSessionId());
            CommPlatformPlugin.Util.log(1, message);
        }
        this.serverInstancePool = (SocketServerInstancePool)connMgr;
        this.connectionProperties = connProperties;
        this.clientSideLogonFactory = clientSideLogonFactory;
        this.serviceProxyFactory = serviceProxyFactory;
        this.serviceType = this.connectionProperties.getProperty(SERVICE_TYPE_PROP, QUERY_SERVICE_PROP);
        this.clusterName = "DEFAULT_CLUSTER_" + Math.abs(random.nextInt());
        this.virtualSocketId = this.getNextVirtualSocketId();
        this.serverInstancePool.addVirtualSocketID(this.virtualSocketId);
        this.init(this.connectionProperties);
    }

    protected SocketServerConnection(Properties connProperties, IConnectionInstanceMgr connMgr, ClientSideLogonFactory clientSideLogonFactory, ServiceProxyFactory serviceProxyFactory, ServerConnectionContext context) throws CommunicationException {
        if (CommPlatformPlugin.DEBUG) {
            String message = CommPlatformPlugin.Util.getString("AbstractServerConnection.Created", this.getSessionId());
            CommPlatformPlugin.Util.log(1, message);
        }
        this.serverInstancePool = (SocketServerInstancePool)connMgr;
        this.connectionProperties = connProperties;
        this.clientSideLogonFactory = clientSideLogonFactory;
        this.serviceProxyFactory = serviceProxyFactory;
        this.serviceType = this.connectionProperties.getProperty(SERVICE_TYPE_PROP, QUERY_SERVICE_PROP);
        SocketServerConnectionContext socketContext = (SocketServerConnectionContext)context;
        this.clusterName = socketContext.getClusterName();
        long pingInterval = socketContext.getPingInterval();
        int resourceAlgorithm = socketContext.getResourceAlgorithm();
        String userName = this.connectionProperties.getProperty("user");
        String vdbName = this.connectionProperties.getProperty("VirtualDatabaseName", "");
        String vdbVersion = this.connectionProperties.getProperty("VirtualDatabaseVersion", "");
        String[] productInfo = new String[]{vdbName, vdbVersion, "", ""};
        this.sessionId = new MetaMatrixSessionID(new Long(socketContext.getSessionID()), pingInterval, resourceAlgorithm, this.clusterName, userName, productInfo);
        this.virtualSocketId = this.getNextVirtualSocketId();
        this.serverInstancePool.addVirtualSocketID(this.virtualSocketId);
        this.init(this.connectionProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextVirtualSocketId() {
        Class<SocketServerConnection> clazz = SocketServerConnection.class;
        synchronized (SocketServerConnection.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return virtualSocketCounter++;
        }
    }

    private void init(Properties connectionProperties) {
        String hostString = connectionProperties.getProperty("host");
        String portString = connectionProperties.getProperty("port");
        StringTokenizer st = new StringTokenizer(hostString, COMMA_DELIMITER);
        StringTokenizer st2 = new StringTokenizer(portString, COMMA_DELIMITER);
        this.ssl = false;
        this.startupClusterName = this.getClusterName();
        String serverURL = connectionProperties.getProperty("serverURL");
        if (serverURL != null) {
            this.ssl = serverURL.toLowerCase().startsWith("mms://");
        }
        this.serverInstancePool.setSecureConnection(this.startupClusterName, this.ssl);
        this.startupHosts = new ArrayList(10);
        while (st.hasMoreTokens()) {
            String host = st.nextToken();
            String port = st2.nextToken();
            this.startupHosts.add(new StartupHost(host, Integer.parseInt(port)));
        }
        this.serverInstancePool.loadLogonServerInstances(this.startupHosts, this.getServiceType(), this.startupClusterName);
    }

    public void setSocketsPerVM(int socketsPerVM) {
        this.serverInstancePool.setSocketsPerVM(socketsPerVM);
    }

    public void connect(String productName) throws CommunicationException, ConnectionException {
        if (!this.connected) {
            this.getClientSideLogon();
            MetaMatrixCoreException firstException = null;
            FindResourcesResult logonResult = null;
            for (int retry = 1; retry <= MAX_RETRIES; ++retry) {
                SocketServerInstance si = null;
                try {
                    si = (SocketServerInstance)this.selectServerInstance(null);
                    String initialHostName = si.getHostInfo().getHostName();
                    FindResourcesRequest findResourcesRequest = new FindResourcesRequest(this.serviceType, new HashSet(0), initialHostName);
                    logonResult = this.clientSideLogon.logon(productName, findResourcesRequest);
                    this.sessionId = ((LogonResult)logonResult).getSessionID();
                    if (this.sessionId == null) continue;
                    break;
                }
                catch (CommunicationException e) {
                    if (firstException != null) continue;
                    firstException = e;
                    continue;
                }
                catch (ConnectionException e) {
                    if (firstException != null) continue;
                    firstException = e;
                    continue;
                }
                catch (MetaMatrixRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MetaMatrixRuntimeException(e);
                }
            }
            if (this.sessionId == null) {
                if (firstException instanceof CommunicationException) {
                    throw (CommunicationException)firstException;
                }
                if (firstException instanceof ConnectionException) {
                    throw (ConnectionException)firstException;
                }
                throw new MetaMatrixRuntimeException(firstException);
            }
            String clusterNameOld = this.clusterName;
            this.serverInstancePool.updateClusterName(clusterNameOld, this.sessionId.getClusterName());
            this.serverInstancePool.loadServerInstances(logonResult.getResources(), this.serviceType, this.sessionId.getClusterName());
            this.clusterName = this.sessionId.getClusterName();
            this.stickyInstance.disConnect(this.virtualSocketId);
            this.connected = true;
            this.startHeartbeat();
            this.serverInstancePool.setStartupHosts(this.clusterName, this.startupHosts);
            this.serverInstancePool.setSecureConnection(this.clusterName, this.ssl);
        }
    }

    protected synchronized void loadServerInstances(List resources) throws CommunicationException {
        this.serverInstancePool.loadServerInstances(resources, this.getServiceType(), this.getClusterName());
    }

    protected Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public MetaMatrixSessionID getSessionId() {
        return this.sessionId;
    }

    public ServerInstance selectServerInstance(String subSelector) throws CommunicationException {
        try {
            if (this.stickyInstance != null && this.stickyInstance.isConnected(this.virtualSocketId)) {
                return this.stickyInstance;
            }
            ServerInstance instance = this.serverInstancePool.getServerInstance(this.getClusterName(), this.getServiceType(), !this.connected, this.connected);
            if (instance == null) {
                String msg = CommPlatformPlugin.Util.getString("AbstractServerConnection.Lost_communication_with_server_-_shutting_down.");
                CommPlatformPlugin.Util.log(4, msg);
                this.shutdown();
                throw new CommunicationException(msg);
            }
            this.initializeServerInstanceForUse(instance);
            this.stickyInstance = (SocketServerInstance)instance;
            return this.stickyInstance;
        }
        catch (CommunicationException e) {
            this.connected = false;
            throw e;
        }
    }

    public void selectNewServerInstance() {
        this.stickyInstance.disConnect(this.virtualSocketId);
    }

    public ServerInstance reselectServerInstance(String contextPortableString) throws CommunicationException {
        try {
            SocketServerInstanceContext socketContext = new SocketServerInstanceContext(contextPortableString);
            HostInfo host = new HostInfo(socketContext.getHost(), socketContext.getPort());
            ServerInstance instance = this.serverInstancePool.findServerInstance(host, this.connected);
            if (instance == null) {
                String msg = CommPlatformPlugin.Util.getString("AbstractServerConnection.Lost_communication_with_server_-_shutting_down.");
                CommPlatformPlugin.Util.log(4, msg);
                this.shutdown();
                throw new CommunicationException(msg);
            }
            this.initializeServerInstanceForUse(instance);
            return instance;
        }
        catch (CommunicationException e) {
            this.connected = false;
            throw e;
        }
    }

    private void initializeServerInstanceForUse(ServerInstance instance) throws CommunicationException {
        SocketServerInstance serverInstance = (SocketServerInstance)instance;
        if (!serverInstance.isConnected(this.virtualSocketId)) {
            Properties clonedProperties = PropertiesUtils.clone(this.connectionProperties, false);
            MetaMatrixSessionID sessionID = this.getSessionId();
            if (sessionID != null) {
                clonedProperties.put("connectionID", Long.toString(sessionID.getValue()));
            }
            clonedProperties.remove("password");
            clonedProperties.remove("trustedPayload");
            serverInstance.connect(this.virtualSocketId, clonedProperties);
            this.serverInstancePool.setLogonProcess(serverInstance.getHostInfo(), this.getServiceType());
        }
    }

    public synchronized ClientSideLogon getClientSideLogon() {
        if (this.clientSideLogon == null) {
            ServiceInterceptor[] serviceInterceptor = new ServiceInterceptor[]{ServiceEndpoint.getAttributeSettingInterceptor(ILogon.class)};
            this.logon = (ILogon)this.serviceProxyFactory.create(ILogon.class, serviceInterceptor, new SecureMessageClientInterceptor(null, this));
            this.clientSideLogon = this.clientSideLogonFactory.createClientSideLogon(this.connectionProperties, this.logon);
        }
        return this.clientSideLogon;
    }

    public int getVirtualSocketID() {
        return this.virtualSocketId;
    }

    public ServerConnectionContext getContext() {
        MetaMatrixSessionID sessionID = this.getSessionId();
        return new SocketServerConnectionContext(sessionID.getValue(), this.virtualSocketId, this.getClusterName(), sessionID.getClientPingInterval(), sessionID.getResourceAlgorithm());
    }

    public void shutdown() throws CommunicationException {
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        CommunicationException firstException = null;
        if (CommPlatformPlugin.DEBUG) {
            String message = CommPlatformPlugin.Util.getString("AbstractServerConnection.Shutdown", this.getSessionId());
            CommPlatformPlugin.Util.log(1, message);
        }
        try {
            this.clientSideLogon = this.getClientSideLogon();
            this.clientSideLogon.logoff(this.sessionId);
            this.connected = false;
        }
        catch (InvalidSessionException e) {
            firstException = this.buildException(e);
        }
        catch (ComponentNotFoundException e) {
            firstException = this.buildException(e);
        }
        catch (RemoteException e) {
            firstException = this.buildException(e);
        }
        catch (Throwable e) {
            firstException = this.buildException(e);
        }
        ServerInstance[] instances = this.serverInstancePool.getServerInstances(this.clusterName, this.serviceType);
        for (int serverIndex = 0; serverIndex < instances.length; ++serverIndex) {
            try {
                this.postLogoffShuttingDownInstance(instances[serverIndex]);
                continue;
            }
            catch (CommunicationException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        this.stopHeartbeat();
        if (firstException != null) {
            throw firstException;
        }
    }

    private void postLogoffShuttingDownInstance(ServerInstance instance) throws CommunicationException {
        if (instance != null) {
            SocketServerInstance serverInstance = (SocketServerInstance)instance;
            serverInstance.close(this.virtualSocketId);
            this.serverInstancePool.removeServerInstance(instance);
        }
        this.serverInstancePool.removeVirtualSocketID(this.virtualSocketId);
    }

    private CommunicationException buildException(Throwable e) {
        String msg = CommPlatformPlugin.Util.getString("AbstractServerConnection.Error_attempting_server_connection_shutdown.");
        CommPlatformPlugin.Util.log(4, e, msg);
        CommunicationException error = new CommunicationException(e, msg);
        return error;
    }

    private void startHeartbeat() throws CommunicationException {
        if (this.connected) {
            this.heartbeat = new ClientHeartbeat(this.logon, this.sessionId, this.clusterName, this.serviceType, this.serverInstancePool, false);
            this.heartbeat.startHeartbeat();
        }
    }

    private void stopHeartbeat() {
        if (this.heartbeat != null) {
            this.heartbeat.stopHeartbeat();
        }
    }

    protected boolean connected() {
        return this.connected;
    }

    public void send(Message message, MessageListener listener, String messageKey, ServerInstance instance) throws CommunicationException {
        try {
            ((SocketServerInstance)instance).send(this.virtualSocketId, message, listener, messageKey);
        }
        catch (CommunicationException ce) {
            if (this.autoFailover) {
                ((SocketServerInstance)instance).shutdown();
            }
            throw ce;
        }
    }

    public Message send(Message message, ServerInstance instance) throws CommunicationException, ApplicationException {
        try {
            return ((SocketServerInstance)instance).send(this.virtualSocketId, message);
        }
        catch (CommunicationException ce) {
            if (this.autoFailover) {
                ((SocketServerInstance)instance).shutdown();
            }
            throw ce;
        }
    }

    public TimeZone getTimeZone() {
        if (this.sessionId != null) {
            return this.sessionId.getTimeZone();
        }
        return null;
    }

    public boolean isAutoFailover() {
        return this.autoFailover;
    }

    public void setAutoFailover(boolean transparentFailover) {
        this.autoFailover = transparentFailover;
    }

    static class StartupHost
    implements SocketService {
        String host;
        int port;
        InetAddress inetAddress;

        StartupHost(String h, int p) {
            this.host = h;
            this.port = p;
            try {
                this.inetAddress = InetAddress.getByName(this.host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }

        public String getHost() throws RemoteException {
            return this.host;
        }

        public int getPort() throws RemoteException {
            return this.port;
        }

        public InetAddress getInetAddress() throws RemoteException {
            return this.inetAddress;
        }
    }
}

