/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.Function;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class FunctionCollectorVisitor
extends LanguageVisitor {
    private Collection functions;
    private String functionName;

    public FunctionCollectorVisitor(Collection functions) {
        this(functions, null);
    }

    public FunctionCollectorVisitor(Collection functions, String functionName) {
        if (functions == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0022"));
        }
        this.functions = functions;
        this.functionName = functionName;
    }

    public Collection getFunctions() {
        return this.functions;
    }

    public void visit(Function obj) {
        if (this.functionName == null || obj.getName().equalsIgnoreCase(this.functionName)) {
            this.functions.add(obj);
        }
    }

    public static final void getFunctions(LanguageObject obj, Collection functions) {
        FunctionCollectorVisitor.getFunctions(obj, functions, false);
    }

    public static final void getFunctions(LanguageObject obj, Collection functions, boolean deep) {
        FunctionCollectorVisitor visitor = new FunctionCollectorVisitor(functions);
        if (!deep) {
            PreOrderNavigator.doVisit(obj, visitor);
        } else {
            DeepPreOrderNavigator.doVisit(obj, visitor);
        }
    }

    public static final Collection getFunctions(LanguageObject obj, boolean removeDuplicates) {
        return FunctionCollectorVisitor.getFunctions(obj, removeDuplicates, false);
    }

    public static final Collection getFunctions(LanguageObject obj, boolean removeDuplicates, boolean deep) {
        AbstractCollection functions = null;
        functions = removeDuplicates ? new HashSet() : new ArrayList();
        FunctionCollectorVisitor.getFunctions(obj, functions, deep);
        return functions;
    }
}

