/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.lob;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.lob.CharLobChunk;
import com.metamatrix.common.lob.ExceptionLobChunk;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkProducer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class LobChunkReader
extends Reader {
    LobChunkProducer reader;
    char[] charData = null;
    int currentCounter = 0;
    boolean lastChunk = false;
    int availableCounter = 0;
    boolean closed = false;
    private char[] contents;

    public LobChunkReader(LobChunkProducer reader) {
        this.reader = reader;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IllegalStateException(CommonPlugin.Util.getString("stream_closed"));
        }
        if (this.lastChunk && this.availableCounter == 0) {
            return -1;
        }
        if (!this.lastChunk && this.availableCounter == 0) {
            this.fetchNextChunk();
        }
        if (this.availableCounter > 0) {
            int copy = len;
            if (len > this.availableCounter) {
                copy = this.availableCounter;
            }
            this.availableCounter -= copy;
            System.arraycopy(this.charData, this.currentCounter, cbuf, off, copy);
            this.currentCounter += copy;
            return copy;
        }
        return -1;
    }

    private void fetchNextChunk() throws IOException {
        LobChunk value = null;
        while (value == null) {
            value = this.reader.getNextChunk();
            if (value != null && value instanceof CharLobChunk) {
                this.lastChunk = value.isLast();
                this.charData = ((CharLobChunk)value).getChars();
                this.currentCounter = 0;
                this.availableCounter = this.charData.length;
                continue;
            }
            if (value != null && value instanceof ExceptionLobChunk) {
                Throwable e = ((ExceptionLobChunk)value).getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e.getMessage());
            }
            throw new IOException(CommonPlugin.Util.getString("lob.invaliddata"));
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.reader.close();
    }

    public char[] getCharacterContents() throws SQLException {
        try {
            if (this.contents == null) {
                CharArrayWriter caw = new CharArrayWriter(102400);
                char[] cbuf = new char[102400];
                int read = this.read(cbuf);
                while (read != -1) {
                    caw.write(cbuf, 0, read);
                    read = this.read(cbuf);
                }
                this.close();
                this.contents = caw.toCharArray();
                caw.close();
            }
            return this.contents;
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }
}

