/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.api.security.SessionID;
import com.metamatrix.platform.PlatformPlugin;
import java.io.Serializable;
import java.util.TimeZone;

public final class MetaMatrixSessionID
implements SessionID,
Serializable,
Cloneable,
Comparable {
    public static final long serialVersionUID = -7872739911360962975L;
    public static final String NO_CLUSTER = "DEFAULT_CLUSTER";
    public static final long CLIENT_MONITOR_DEFAULT_PING_INTERVAL_VAL = 300000L;
    public static final int CLIENT_RESOURCE_ALGORITHM_DEFAULT_VAL = 1;
    public static final String DEFAULT_USER = "unknown";
    public static final String[] EMPTY_PRODUCT_INFO = new String[]{"", "", "", ""};
    private long id;
    private long pingInterval = 300000L;
    private int resourceAlgorithm = 1;
    private String userName;
    private String clusterName;
    public static final int MAX_PRODUCT_INFO = 4;
    private String[] productInfo = new String[4];
    private TimeZone timezone = TimeZone.getDefault();

    public MetaMatrixSessionID(long id) {
        this(new Long(id), 300000L, 1, NO_CLUSTER, EMPTY_PRODUCT_INFO);
    }

    public MetaMatrixSessionID(long id, String userName) {
        this(new Long(id), 300000L, 1, NO_CLUSTER, userName, EMPTY_PRODUCT_INFO);
    }

    public MetaMatrixSessionID(long id, String userName, String vdbName, String vdbVersion) {
        this(new Long(id), 300000L, 1, NO_CLUSTER, userName, new String[]{vdbName, vdbVersion, "", ""});
    }

    public MetaMatrixSessionID(Long id, long clientPingInterval, int clientResourceAlgorithm, String clusterName, String[] productInfo) {
        this.init(id, clientPingInterval, clientResourceAlgorithm, clusterName, this.userName, productInfo);
    }

    public MetaMatrixSessionID(Long id, long clientPingInterval, int clientResourceAlgorithm, String clusterName, String userName, String[] productInfo) {
        if (userName == null || userName.trim().length() == 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0061"));
        }
        if (userName.trim().length() > 1024) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0057", 1024));
        }
        this.userName = userName;
        this.init(id, clientPingInterval, clientResourceAlgorithm, clusterName, userName, productInfo);
    }

    private void init(Long id, long clientPingInterval, int clientResourceAlgorithm, String clusterName, String userName, String[] productInfo) {
        this.pingInterval = clientPingInterval;
        this.resourceAlgorithm = clientResourceAlgorithm;
        if (id == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0063"));
        }
        this.id = id;
        if (productInfo != null && productInfo.length > 4) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0062", 4));
        }
        this.productInfo = productInfo != null ? productInfo : new String[4];
        this.clusterName = clusterName != null ? clusterName : NO_CLUSTER;
    }

    public long getValue() {
        return this.id;
    }

    public int compareTo(Object obj) {
        MetaMatrixSessionID that = (MetaMatrixSessionID)obj;
        return (int)(this.id - that.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            MetaMatrixSessionID that = (MetaMatrixSessionID)obj;
            return this.id == that.id;
        }
        return false;
    }

    public final int hashCode() {
        return (int)this.id;
    }

    public final String toString() {
        return Long.toString(this.id);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getProductInfo(int index) {
        if (index >= 4 || index < 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0064", 4));
        }
        return this.productInfo[index];
    }

    public String[] getProductInfo() {
        return this.productInfo;
    }

    public long getClientPingInterval() {
        return this.pingInterval;
    }

    public int getResourceAlgorithm() {
        return this.resourceAlgorithm;
    }

    public String getUserName() {
        return this.userName;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }
}

