/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.util.Stopwatch;
import java.util.HashMap;
import java.util.Iterator;

public class PerformanceTracker {
    private String idOrTitle;
    private HashMap timingResultsMap = new HashMap(10);
    private HashMap watchMap = new HashMap(10);
    private boolean doTrackTime = true;
    private char RETURN_CHAR = (char)10;
    private char SPACE_CHAR = (char)32;

    public PerformanceTracker(String id) {
        this(id, true);
        this.idOrTitle = id;
    }

    public PerformanceTracker(String id, boolean doTime) {
        this.idOrTitle = id;
        this.doTrackTime = doTime;
    }

    public void reset() {
        this.timingResultsMap.clear();
        this.watchMap.clear();
    }

    public void start(String id) {
        if (this.doTrackTime) {
            Stopwatch newWatch = new Stopwatch();
            this.watchMap.put(id, newWatch);
            newWatch.start(true);
        }
    }

    public void stop(String id) {
        if (this.doTrackTime) {
            Stopwatch existingWatch = (Stopwatch)this.watchMap.get(id);
            if (existingWatch != null) {
                existingWatch.stop();
                this.track(id, existingWatch.getTotalDuration());
                this.watchMap.remove(id);
            }
        } else {
            this.track(id, 0L);
        }
    }

    public void setDoTrackTime(boolean doTime) {
        this.doTrackTime = doTime;
    }

    public String getID() {
        return this.idOrTitle;
    }

    private void track(String id, long increment) {
        TimingResult existingResult = (TimingResult)this.timingResultsMap.get(id);
        if (existingResult == null) {
            existingResult = new TimingResult(id);
            this.timingResultsMap.put(id, existingResult);
        }
        existingResult.add(increment);
    }

    public void print() {
        int maxLengthIDName = 0;
        for (String nextKey : this.timingResultsMap.keySet()) {
            maxLengthIDName = Math.max(maxLengthIDName, nextKey.length());
        }
        ++maxLengthIDName;
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(" >>> PERFORMANCE TRACKER FOR: " + this.idOrTitle);
        Iterator iter = this.timingResultsMap.keySet().iterator();
        while (iter.hasNext()) {
            TimingResult existingResult = (TimingResult)this.timingResultsMap.get(iter.next());
            buffer.append(this.RETURN_CHAR + existingResult.getSummary(maxLengthIDName));
        }
        System.out.println(buffer);
    }

    class TimingResult {
        private String id;
        private long totalTime;
        private int nCalls;
        private double average;

        public TimingResult(String id) {
            this.id = id;
        }

        public void add(long deltaTime) {
            this.totalTime += deltaTime;
            ++this.nCalls;
            this.average = (double)this.totalTime / (double)this.nCalls;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        private String getConstantLengthString(String theStr, int targetLength, boolean prepend) {
            int nSpaces = targetLength - theStr.length();
            if (nSpaces > 0) {
                StringBuffer spaces = new StringBuffer(nSpaces);
                for (int i = 0; i < nSpaces; ++i) {
                    spaces.append(PerformanceTracker.this.SPACE_CHAR);
                }
                if (prepend) {
                    return spaces.toString() + theStr;
                }
                return theStr + spaces;
            }
            return theStr;
        }

        public String getSummary(int maxNameLength) {
            String nCallsStr = "" + this.nCalls;
            String totalTimeStr = "" + this.totalTime;
            String averageStr = "" + this.average;
            StringBuffer buffer = new StringBuffer(150);
            buffer.append("    ID = ");
            buffer.append(this.getConstantLengthString(this.id, maxNameLength, false));
            buffer.append(" COUNT = [");
            buffer.append(this.getConstantLengthString(nCallsStr, 11, true));
            buffer.append(']');
            if (PerformanceTracker.this.doTrackTime) {
                buffer.append("   TOTAL TIME (ms) = [");
                buffer.append(this.getConstantLengthString(totalTimeStr, 11, true));
                buffer.append("]   AVERAGE TIME (ms) = [");
                buffer.append(averageStr + "]");
            }
            return buffer.toString();
        }
    }
}

