/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ChecksumUtil {
    protected static final int BUFFER_SIZE = 1024;

    public static Checksum computeChecksum(InputStream stream) throws IOException {
        CRC32 checksum = new CRC32();
        ChecksumUtil.computeChecksum(stream, checksum);
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long computeChecksum(InputStream stream, Checksum algorithm) throws IOException {
        byte[] buffer = new byte[1024];
        int n = 0;
        long sizeInBytes = 0L;
        IOException ioe = null;
        try {
            while ((n = stream.read(buffer)) > -1) {
                algorithm.update(buffer, 0, n);
                sizeInBytes += (long)n;
            }
        }
        catch (IOException e) {
            ioe = e;
        }
        finally {
            block14: {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    if (ioe != null) break block14;
                    ioe = e;
                }
            }
        }
        if (ioe != null) {
            throw ioe;
        }
        return sizeInBytes;
    }
}

