/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types.basic;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.AbstractTransform;
import com.metamatrix.common.types.TransformationException;

public class FloatToBooleanTransform
extends AbstractTransform {
    private static final Float FALSE = new Float(0.0f);
    private static final Float TRUE = new Float(1.0f);

    public Object transform(Object value) throws TransformationException {
        if (value == null) {
            return value;
        }
        if (value.equals(FALSE)) {
            return Boolean.FALSE;
        }
        if (value.equals(TRUE)) {
            return Boolean.TRUE;
        }
        throw new TransformationException(CommonPlugin.Util.getString("FloatToBooleanTransform.Failed_transform"));
    }

    public Class getSourceType() {
        return Float.class;
    }

    public Class getTargetType() {
        return Boolean.class;
    }

    public boolean isNarrowing() {
        return true;
    }
}

