/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import java.sql.SQLException;

public class BaseParameters {
    private static String footprint = "$Revision:   3.18.2.0  $";
    private BaseExceptions exceptions;
    BaseParameterInfo[] parameterMetaData;
    public BaseParameter[] parametersIn;
    public BaseParameter[] parametersOut;
    int nameIndex = 0;
    public static final int UNDETERMINED_ORDER = 0;
    public static final int NAME_ORDER = 1;
    public static final int POSITIONAL_ORDER = 2;
    public int parameterOrder = 0;
    boolean outputParamRegistered = false;
    public boolean newParameterBindings = true;
    public BaseConnection connection;

    public BaseParameters(int n, BaseExceptions baseExceptions, BaseConnection baseConnection) {
        this.parametersIn = new BaseParameter[n];
        this.parametersOut = new BaseParameter[n];
        this.exceptions = baseExceptions;
        this.connection = baseConnection;
    }

    public BaseParameters(BaseParameters baseParameters, BaseExceptions baseExceptions, BaseConnection baseConnection) {
        this.copy(baseParameters, baseExceptions, baseConnection);
    }

    public void copy(BaseParameters baseParameters, BaseExceptions baseExceptions, BaseConnection baseConnection) {
        this.nameIndex = baseParameters.nameIndex;
        this.parameterOrder = baseParameters.parameterOrder;
        this.newParameterBindings = baseParameters.newParameterBindings;
        if (this.parametersIn == null || this.parametersIn.length < baseParameters.parametersIn.length) {
            this.parametersIn = new BaseParameter[baseParameters.parametersIn.length];
        }
        if (this.parametersOut == null || this.parametersOut.length < baseParameters.parametersOut.length) {
            this.parametersOut = new BaseParameter[baseParameters.parametersOut.length];
        }
        this.exceptions = baseExceptions;
        this.connection = baseConnection;
        this.parameterMetaData = baseParameters.parameterMetaData;
        for (int i = 0; i < this.parametersIn.length; ++i) {
            if (baseParameters.parametersIn[i] != null) {
                if (this.parametersIn[i] == null) {
                    this.parametersIn[i] = new BaseParameter(baseParameters.parametersIn[i], baseConnection);
                } else {
                    this.parametersIn[i].copy(baseParameters.parametersIn[i], baseConnection);
                }
            }
            if (baseParameters.parametersOut[i] == null) continue;
            if (this.parametersOut[i] == null) {
                this.parametersOut[i] = new BaseParameter(baseParameters.parametersOut[i], baseConnection);
            } else {
                this.parametersOut[i].copy(baseParameters.parametersOut[i], baseConnection);
            }
            this.outputParamRegistered = true;
        }
    }

    public void set(int n, int n2, BaseParameter baseParameter) throws SQLException {
        if (this.parameterOrder == 0) {
            this.parameterOrder = 2;
        }
        if (this.parameterOrder == 1) {
            throw this.exceptions.getException(6010, "07009");
        }
        try {
            if (n2 == 1) {
                this.parametersIn[n - 1] = baseParameter;
            } else if (n2 == 2) {
                this.parametersOut[n - 1] = baseParameter;
                this.outputParamRegistered = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String string, int n, BaseParameter baseParameter) throws SQLException {
        if (this.parameterOrder == 0) {
            this.parameterOrder = 1;
        }
        if (this.parameterOrder == 2) {
            throw this.exceptions.getException(6010, "07009");
        }
        try {
            boolean bl = false;
            baseParameter.name = string;
            if (n == 1) {
                for (int i = 0; i < this.nameIndex && !bl; ++i) {
                    if (this.parametersIn[i] != null && this.parametersIn[i].name.equalsIgnoreCase(string)) {
                        this.parametersIn[i] = baseParameter;
                        bl = true;
                        continue;
                    }
                    if (this.parametersOut[i] == null || !this.parametersOut[i].name.equalsIgnoreCase(string)) continue;
                    this.parametersIn[i] = baseParameter;
                    bl = true;
                }
                if (bl) return;
                if (this.nameIndex >= this.parametersIn.length) throw this.exceptions.getException(6010, "07009");
                this.parametersIn[this.nameIndex++] = baseParameter;
                return;
            } else {
                if (n != 2) return;
                for (int i = 0; i < this.nameIndex && !bl; ++i) {
                    if (this.parametersOut[i] != null && this.parametersOut[i].name.equalsIgnoreCase(string)) {
                        this.parametersOut[i] = baseParameter;
                        bl = true;
                        continue;
                    }
                    if (this.parametersIn[i] == null || !this.parametersIn[i].name.equalsIgnoreCase(string)) continue;
                    this.parametersOut[i] = baseParameter;
                    bl = true;
                }
                if (!bl) {
                    if (this.nameIndex >= this.parametersOut.length) throw this.exceptions.getException(6010, "07009");
                    this.parametersOut[this.nameIndex++] = baseParameter;
                }
                this.outputParamRegistered = true;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getParameter(int n) throws SQLException {
        if (this.parameterOrder == 0) {
            this.parameterOrder = 2;
        }
        if (this.parameterOrder == 1) {
            throw this.exceptions.getException(6010, "07009");
        }
        try {
            BaseParameter baseParameter = this.parametersIn[n - 1];
            if (baseParameter == null) {
                this.parametersIn[n - 1] = baseParameter = new BaseParameter(this.connection);
            }
            return baseParameter;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getParameter(String string) throws SQLException {
        if (this.parameterOrder == 0) {
            this.parameterOrder = 1;
        }
        if (this.parameterOrder == 2) {
            throw this.exceptions.getException(6010, "07009");
        }
        BaseParameter baseParameter = null;
        boolean bl = false;
        for (int i = 0; i < this.nameIndex && !bl; ++i) {
            if (this.parametersIn[i] != null && this.parametersIn[i].name.equalsIgnoreCase(string)) {
                baseParameter = this.parametersIn[i];
                bl = true;
                continue;
            }
            if (this.parametersOut[i] == null || !this.parametersOut[i].name.equalsIgnoreCase(string)) continue;
            baseParameter = new BaseParameter(this.connection);
            baseParameter.name = string;
            this.parametersIn[i] = baseParameter;
            bl = true;
        }
        if (!bl) {
            if (this.nameIndex < this.parametersIn.length) {
                baseParameter = new BaseParameter(this.connection);
                baseParameter.name = string;
                this.parametersIn[this.nameIndex++] = baseParameter;
            } else {
                throw this.exceptions.getException(6010, "07009");
            }
        }
        return baseParameter;
    }

    public void clearInput() {
        int n = this.count();
        for (int i = 0; i < n; ++i) {
            if (this.parametersIn[i] == null) continue;
            this.parametersIn[i].setNull(0);
        }
        this.nameIndex = 0;
        this.parameterOrder = 0;
    }

    public void clearOutput(boolean bl) {
        int n = this.count();
        for (int i = 0; i < n; ++i) {
            if (this.parametersOut[i] == null) continue;
            if (bl) {
                this.outputParamRegistered = false;
                this.parametersOut[i] = null;
                continue;
            }
            this.parametersOut[i].setNull(0);
        }
    }

    public int count() {
        return this.parametersIn.length;
    }

    public boolean anyOutputParamsRegistered() {
        return this.outputParamRegistered;
    }

    public BaseParameter get(int n, int n2) throws SQLException {
        try {
            Object var3_3 = null;
            if (n2 == 1) {
                return this.parametersIn[n - 1];
            }
            if (n2 == 2) {
                return this.parametersOut[n - 1];
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter get(String string, int n) throws SQLException {
        try {
            Object var3_3 = null;
            if (n == 1) {
                for (int i = 0; i < this.nameIndex; ++i) {
                    if (this.parametersIn[i] == null || !this.parametersIn[i].name.equalsIgnoreCase(string)) continue;
                    return this.parametersIn[i];
                }
                return null;
            }
            if (n == 2) {
                for (int i = 0; i < this.nameIndex; ++i) {
                    if (this.parametersOut[i] == null || !this.parametersOut[i].name.equalsIgnoreCase(string)) continue;
                    return this.parametersOut[i];
                }
                return null;
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getInput(int n) {
        return this.parametersIn[n - 1];
    }

    public BaseParameter getOutput(int n) {
        return this.parametersOut[n - 1];
    }

    boolean isValidOrdinal(int n) {
        return n > 0 && n <= this.count();
    }

    protected boolean haveMinimalBindings() {
        boolean bl = true;
        int n = this.count();
        int n2 = 0;
        int n3 = 0;
        if (this.parameterOrder == 2) {
            for (int i = 0; i < n; ++i) {
                if (this.parametersIn[i] != null && this.parametersIn[i].type != 0) {
                    ++n2;
                    continue;
                }
                if (this.parametersOut[i] == null) continue;
                ++n3;
            }
            if (n2 + n3 < n) {
                bl = false;
            }
        } else if (this.nameIndex < n) {
            bl = false;
        }
        return bl;
    }

    public void setParameterInfo(int n, BaseParameterInfo baseParameterInfo) {
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new BaseParameterInfo[this.count()];
        }
        this.parameterMetaData[n] = baseParameterInfo;
    }

    public BaseParameterInfo getParameterInfoOrNull(int n) throws SQLException {
        try {
            if (this.parameterMetaData == null || n > this.parameterMetaData.length - 1 || this.parameterMetaData[n] == null) {
                return null;
            }
            return this.parameterMetaData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameterInfo getParameterInfo(int n) throws SQLException {
        try {
            if (this.parameterMetaData == null || n > this.parameterMetaData.length - 1 || this.parameterMetaData[n] == null) {
                throw this.exceptions.getException(6088);
            }
            return this.parameterMetaData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }
}

