/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Query
extends QueryCommand {
    private Select select;
    private From from;
    private Criteria criteria;
    private GroupBy groupBy;
    private Criteria having;
    private boolean isXML;
    private Into into;
    private List selectList;

    public Query() {
    }

    public Query(Select select, From from, Criteria criteria, OrderBy orderBy, Option option) {
        this.setSelect(select);
        this.setFrom(from);
        this.setCriteria(criteria);
        this.setOrderBy(orderBy);
        this.setOption(option);
    }

    public Query(Select select, From from, Criteria criteria, GroupBy groupBy, Criteria having, OrderBy orderBy, Option option) {
        this.setSelect(select);
        this.setFrom(from);
        this.setCriteria(criteria);
        this.setGroupBy(groupBy);
        this.setHaving(having);
        this.setOrderBy(orderBy);
        this.setOption(option);
    }

    public int getType() {
        return 1;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public boolean getIsXML() {
        return this.isXML;
    }

    public void setIsXML(boolean isXML) {
        this.isXML = isXML;
    }

    public From getFrom() {
        return this.from;
    }

    public void setFrom(From from) {
        this.from = from;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public void clearCriteria() {
        this.criteria = null;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public Criteria getHaving() {
        return this.having;
    }

    public void setHaving(Criteria having) {
        this.having = having;
    }

    public Into getInto() {
        return this.into;
    }

    public void setInto(Into into) {
        this.into = into;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List getProjectedSymbols() {
        if (!this.getIsXML()) {
            if (this.getSelect() != null) {
                if (this.getInto() != null) {
                    return Command.getUpdateCommandSymbol();
                }
                return this.getSelect().getProjectedSymbols();
            }
            return Collections.EMPTY_LIST;
        }
        if (this.selectList == null) {
            this.selectList = new ArrayList(1);
            ElementSymbol xmlElement = new ElementSymbol("xml");
            xmlElement.setType(DataTypeManager.DefaultDataClasses.XML);
            this.selectList.add(xmlElement);
        }
        return this.selectList;
    }

    public Object clone() {
        Query copy = new Query();
        if (this.select != null) {
            copy.setSelect((Select)this.select.clone());
        }
        if (this.from != null) {
            copy.setFrom((From)this.from.clone());
        }
        if (this.criteria != null) {
            copy.setCriteria((Criteria)this.criteria.clone());
        }
        if (this.groupBy != null) {
            copy.setGroupBy((GroupBy)this.groupBy.clone());
        }
        if (this.having != null) {
            copy.setHaving((Criteria)this.having.clone());
        }
        if (this.getOrderBy() != null) {
            copy.setOrderBy((OrderBy)this.getOrderBy().clone());
        }
        if (this.getLimit() != null) {
            copy.setLimit((Limit)this.getLimit().clone());
        }
        if (this.getOption() != null) {
            copy.setOption((Option)this.getOption().clone());
        }
        copy.setIsXML(this.getIsXML());
        if (this.selectList != null) {
            copy.selectList = new ArrayList();
            Iterator iter = this.selectList.iterator();
            while (iter.hasNext()) {
                copy.selectList.add(((SelectSymbol)iter.next()).clone());
            }
        }
        this.copyMetadataState(copy);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        return EquivalenceUtil.areEqual(this.getSelect(), other.getSelect()) && EquivalenceUtil.areEqual(this.getFrom(), other.getFrom()) && EquivalenceUtil.areEqual(this.getCriteria(), other.getCriteria()) && EquivalenceUtil.areEqual(this.getGroupBy(), other.getGroupBy()) && EquivalenceUtil.areEqual(this.getHaving(), other.getHaving()) && EquivalenceUtil.areEqual(this.getOrderBy(), other.getOrderBy()) && EquivalenceUtil.areEqual(this.getLimit(), other.getLimit()) && EquivalenceUtil.areEqual(this.getOption(), other.getOption()) && this.getIsXML() == other.getIsXML();
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.select);
        myHash = HashCodeUtil.hashCode(myHash, this.criteria);
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean areResultsCachable() {
        if (this.getInto() != null) {
            return false;
        }
        List projectedSymbols = this.getProjectedSymbols();
        for (int i = 0; i < projectedSymbols.size(); ++i) {
            SingleElementSymbol projectedSymbol = (SingleElementSymbol)projectedSymbols.get(i);
            if (!DataTypeManager.DefaultDataClasses.BLOB.equals(projectedSymbol.getType()) && !DataTypeManager.DefaultDataClasses.CLOB.equals(projectedSymbol.getType()) && !DataTypeManager.DefaultDataClasses.XML.equals(projectedSymbol.getType())) continue;
            return false;
        }
        return true;
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        if (this.isXML) {
            return 0;
        }
        if (this.into != null && !this.into.getGroup().isTempGroupSymbol()) {
            return 2;
        }
        return this.getSubCommandsUpdatingModelCount(metadata);
    }
}

