/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlpreprocessor;

import com.metamatrix.jdbc.sqlpreprocessor.MMPreProcessorImpl;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public class MMPreProcessorLoader {
    private ArrayList _preProcessorList = new ArrayList();
    private Properties preProcessorProperties = null;

    public MMPreProcessorLoader(Properties properties) throws SQLException {
        this.preProcessorProperties = properties;
        this.loadPreProcessors();
    }

    private void loadPreProcessors() throws SQLException {
        String keyStr;
        String preProcessorStr;
        this._preProcessorList.clear();
        int i = 0;
        while ((preProcessorStr = this.preProcessorProperties.getProperty(keyStr = Integer.toString(i))) != null) {
            boolean loaded = true;
            MMPreProcessorImpl preprocessClass = null;
            try {
                preprocessClass = (MMPreProcessorImpl)Class.forName(preProcessorStr).newInstance();
            }
            catch (Exception e) {
                loaded = false;
                throw new SQLException(e.getMessage());
            }
            if (loaded && preprocessClass != null) {
                this._preProcessorList.add(i, preprocessClass);
            }
            ++i;
        }
    }

    public String getPreProcessorString(String string) throws SQLException {
        PrintWriter out = null;
        try {
            String jdbclog;
            if (this.preProcessorProperties != null && (jdbclog = this.preProcessorProperties.getProperty("logFile")) != null) {
                out = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.preProcessorProperties.getProperty("logFile"), true)), true);
                out.close();
            }
        }
        catch (Exception ioe) {
            throw new SQLException(ioe.getMessage());
        }
        String preProcessedStr = string;
        if (!this._preProcessorList.isEmpty()) {
            for (int i = 0; i < this._preProcessorList.size(); ++i) {
                preProcessedStr = ((MMPreProcessorImpl)this._preProcessorList.get(i)).preprocessSQL(preProcessedStr);
            }
        }
        try {
            String jdbclog;
            if (this.preProcessorProperties != null && (jdbclog = this.preProcessorProperties.getProperty("logFile")) != null) {
                out = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.preProcessorProperties.getProperty("logFile"), true)), true);
                out.close();
            }
        }
        catch (Exception ioe) {
            throw new SQLException(ioe.getMessage());
        }
        return preProcessedStr;
    }
}

