/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlpreprocessor;

import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMDriver;
import com.metamatrix.jdbc.sqlpreprocessor.MMPreProcessorConnection;
import com.metamatrix.jdbc.transport.MultiTransportFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class MMPreProcessorDriver
implements BaseDriver {
    static final String MM_PREPROCESSOR_PROPSFILE = "propsFile";
    static final String MM_LOG_FILE = "logFile";
    static final String JDBC = "jdbc:";
    static final String URL_PREFIX = "jdbc:metamatrix";
    static final int MAJOR_VERSION = 5;
    static final int MINOR_VERSION = 0;
    static final String DRIVER_NAME = "GCSS Custom MetaMatrix JDBC Preprocessor Driver";
    static final String HOST_PORT_PATTERN = "[\\p{Alnum}\\.\\-]+:\\d+";
    static final String URL_PATTERN = "jdbc:metamatrix:(\\w+)@((mm[s]?://[\\p{Alnum}\\.\\-]+:\\d+(,[\\p{Alnum}\\.\\-]+:\\d+)*)[;]?){1}((.*)*)";
    static Pattern urlPattern;
    static MultiTransportFactory CONNECTION_FACTORY;
    private static MMPreProcessorDriver singleton;
    private MMDriver _realMMDriver = MMDriver.getInstance();
    private Properties preprocessorProps = null;

    public MMPreProcessorDriver() {
        try {
            DriverManager.deregisterDriver(this._realMMDriver);
        }
        catch (SQLException e) {
            String logMsg = JDBCPlugin.Util.getString("MMDriver.Err_registering", e.getMessage());
            DriverManager.println(logMsg);
        }
    }

    Properties getPreProcessorProperties() {
        return this.preprocessorProps;
    }

    public Connection connect(String arg0, Properties arg1) throws SQLException {
        return new MMPreProcessorConnection((MMConnection)this._realMMDriver.connect(arg0, arg1), this.parseURL(arg0, arg1));
    }

    static String setupTransport(Properties info) {
        return "Socket";
    }

    private Properties parseURL(String url, Properties info) throws SQLException {
        this.preprocessorProps = new Properties();
        try {
            StringTokenizer urlSt = new StringTokenizer(url, ";");
            boolean prepropsFound = false;
            while (urlSt.hasMoreTokens()) {
                String nextToken;
                StringTokenizer propsSt = new StringTokenizer(urlSt.nextToken(), "=");
                if (propsSt.countTokens() <= 1) continue;
                String prop = propsSt.nextToken();
                if (prop.equalsIgnoreCase(MM_PREPROCESSOR_PROPSFILE)) {
                    nextToken = propsSt.nextToken();
                    this.preprocessorProps.load(new FileInputStream(nextToken));
                    prepropsFound = true;
                    continue;
                }
                if (!prop.equalsIgnoreCase(MM_LOG_FILE)) continue;
                nextToken = propsSt.nextToken();
                this.preprocessorProps.setProperty(MM_LOG_FILE, nextToken);
            }
            if (!prepropsFound) {
                throw new SQLException("Pre-processor properties file not specified!");
            }
        }
        catch (SQLException e) {
            this.preprocessorProps = null;
            e.printStackTrace();
            throw e;
        }
        catch (IOException ioex) {
            this.preprocessorProps = null;
            ioex.printStackTrace();
            SQLException sqlex = new SQLException(ioex.getMessage());
            sqlex.setStackTrace(ioex.getStackTrace());
            throw sqlex;
        }
        return this.preprocessorProps;
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this._realMMDriver.acceptsURL(url);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this._realMMDriver.getPropertyInfo(url, info);
    }

    public int getMajorVersion() {
        return this._realMMDriver.getMajorVersion();
    }

    public int getMinorVersion() {
        return this._realMMDriver.getMinorVersion();
    }

    public String getDriverName() {
        return this._realMMDriver.getDriverName();
    }

    public boolean jdbcCompliant() {
        return this._realMMDriver.jdbcCompliant();
    }

    static {
        String logMsg;
        urlPattern = Pattern.compile(URL_PATTERN);
        CONNECTION_FACTORY = new MultiTransportFactory();
        singleton = new MMPreProcessorDriver();
        try {
            ApplicationInfo info = ApplicationInfo.getInstance();
            info.setMainComponent("metamatrix-prejdbc.jar");
            info.markUnmodifiable();
        }
        catch (Exception e) {
            logMsg = JDBCPlugin.Util.getString("MMDriver.Err_init_appinfo", e.getMessage());
            DriverManager.println(logMsg);
        }
        try {
            DriverManager.registerDriver(singleton);
        }
        catch (SQLException e) {
            logMsg = JDBCPlugin.Util.getString("MMDriver.Err_registering", e.getMessage());
            DriverManager.println(logMsg);
        }
    }
}

