/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.SqlUtil;
import com.metamatrix.core.log.Logger;
import com.metamatrix.dqp.message.CancelMessage;
import com.metamatrix.dqp.message.CloseMessage;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.AnnotationImpl;
import com.metamatrix.jdbc.CursorResultsImpl;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.PlanNodeImpl;
import com.metamatrix.jdbc.TimeoutException;
import com.metamatrix.jdbc.WarningUtil;
import com.metamatrix.jdbc.api.PlanNode;
import com.metamatrix.jdbc.api.Statement;
import com.metamatrix.jdbc.util.MessageHolderListener;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SQLQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;

public class MMStatement
implements Statement {
    protected static final int TIMED_OUT = 4;
    protected static final int CANCELLED = 3;
    protected static final int NO_TIMEOUT = 0;
    private static final int NO_LIMIT = 0;
    protected MMConnection driverConnection;
    private Properties execProps = null;
    private String styleSheet;
    private int fetchSize = 2000;
    private int fetchDirection = 1000;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private boolean isClosed = false;
    protected int commandStatus = -1;
    protected int queryTimeout = 0;
    protected long currentRequestID = -1L;
    private Map currentPlanDescription;
    private String debugLog;
    private List annotations;
    protected int rowsAffected;
    private MMResultSet resultSet;
    private MMSQLException serverException;
    private List serverWarnings;
    private Serializable payload;
    private List batchedUpdates;
    protected int[] updateCounts;
    private ExecutionStrategy queryStrategy;
    private ExecutionStrategy updateStrategy;
    private ExecutionStrategy batchedUpdateStrategy;
    private Calendar defaultCalendar;
    private int maxRows = 0;
    private static int SPIN_TIMEOUT = 500;
    Logger logger = null;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMStatement;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMConnection;

    static MMStatement newInstance(MMConnection driverConnection, int resultSetType, int resultSetConcurrency) {
        if (AOP.useproxy()) {
            return (MMStatement)ProxyFactory.extend(class$com$metamatrix$jdbc$MMStatement == null ? (class$com$metamatrix$jdbc$MMStatement = MMStatement.class$("com.metamatrix.jdbc.MMStatement")) : class$com$metamatrix$jdbc$MMStatement, new Class[]{class$com$metamatrix$jdbc$MMConnection == null ? (class$com$metamatrix$jdbc$MMConnection = MMStatement.class$("com.metamatrix.jdbc.MMConnection")) : class$com$metamatrix$jdbc$MMConnection, Integer.TYPE, Integer.TYPE}, new Object[]{driverConnection, new Integer(resultSetType), new Integer(resultSetConcurrency)});
        }
        return new MMStatement(driverConnection, resultSetType, resultSetConcurrency);
    }

    MMStatement(MMConnection driverConnection, int resultSetType, int resultSetConcurrency) {
        this.driverConnection = driverConnection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.execProps = PropertiesUtils.clone(this.getConnectionProperties());
        String fetchSizeStr = this.execProps.getProperty("fetchSize");
        if (fetchSizeStr != null) {
            try {
                this.fetchSize = Integer.parseInt(fetchSizeStr);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.logger = new RequestIdAwareLogger(this.driverConnection.getLogger());
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void resetExecutionState() throws SQLException {
        this.currentRequestID = -1L;
        this.currentPlanDescription = null;
        this.debugLog = null;
        this.annotations = null;
        this.rowsAffected = -1;
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.serverException = null;
        this.serverWarnings = null;
        this.batchedUpdates = null;
        this.updateCounts = null;
    }

    public void addBatch(String sql) throws SQLException {
        this.checkStatement();
        if (this.batchedUpdates == null) {
            this.batchedUpdates = new ArrayList();
        }
        this.batchedUpdates.add(sql);
    }

    public void cancel() throws SQLException {
        this.commandStatus = 3;
        this.cancelRequest();
    }

    public void clearWarnings() throws SQLException {
        this.checkStatement();
        this.serverWarnings = null;
    }

    public void clearBatch() throws SQLException {
        this.batchedUpdates.clear();
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.currentRequestID > -1L) {
            if (this.resultSet == null) {
                CloseMessage closeMsg = new CloseMessage();
                closeMsg.setRequestID(new RequestID(this.currentRequestID));
                this.executeAsynch(closeMsg);
            } else {
                this.resultSet.close();
                this.resultSet = null;
            }
        }
        this.isClosed = true;
        this.driverConnection.closeStatement(this);
        String logMsg = JDBCPlugin.Util.getString("MMStatement.Close_stmt_success");
        this.getLogger().log(4, logMsg);
        this.driverConnection = null;
    }

    protected void checkStatement() throws SQLException {
        if (this.isClosed) {
            String logMsg = JDBCPlugin.Util.getString("MMStatement.Stmt_closed");
            if (this.driverConnection != null) {
                this.getLogger().log(4, logMsg);
            }
            throw new MMSQLException(logMsg);
        }
    }

    protected void setResultSet(MMResultSet resultSet) {
        this.resultSet = resultSet;
        this.rowsAffected = -1;
    }

    protected void setUpdateCount(int updateCount) {
        this.resultSet = null;
        this.rowsAffected = updateCount;
    }

    protected void setException(Throwable exception) {
        if (exception == null) {
            return;
        }
        this.serverException = MMSQLException.create(exception);
        this.getLogger().log(2, exception, this.serverException.getMessage());
    }

    protected MMSQLException getException() {
        return this.serverException;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean execute(String sql, int[] columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public synchronized boolean execute(String sql) throws SQLException {
        this.checkStatement();
        if (this.isUpdateSql(sql)) {
            this.executeUpdate(sql);
        } else {
            this.executeQuery(sql);
        }
        return this.resultSet != null;
    }

    public int[] executeBatch() throws SQLException {
        if (this.batchedUpdates == null || this.batchedUpdates.isEmpty()) {
            return new int[0];
        }
        this.executeSql(this.batchedUpdates.toArray(new String[this.batchedUpdates.size()]), this.getBatchedUpdateStrategy(), true);
        return this.updateCounts;
    }

    private void processMessage(ExecutionStrategy deliverer, ResultsMessage resultsMsg) {
        try {
            deliverer.startMessageDelivery();
            List resultsWarning = resultsMsg.getWarnings();
            this.setAnalysisInfo(resultsMsg);
            if (resultsMsg.getException() != null) {
                this.setException(resultsMsg.getException());
                return;
            }
            if (resultsWarning != null) {
                this.setWarnings(resultsWarning);
            }
            deliverer.createResultSet(resultsMsg);
        }
        catch (Throwable e) {
            this.setException(e);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeSql(new String[]{sql}, this.getQueryStrategy(), false);
        return this.resultSet;
    }

    public int executeUpdate(String sql) throws SQLException {
        if (this.driverConnection.isReadOnly()) {
            String logMsg = JDBCPlugin.Util.getString("MMStatement.Operation_Not_Supported", sql);
            this.getLogger().log(2, logMsg);
            throw new MMSQLException(logMsg);
        }
        this.executeSql(new String[]{sql}, this.getUpdateStrategy(), false);
        return this.rowsAffected;
    }

    private void executeSql(String[] commands, ExecutionStrategy executionStrategy, boolean isBatchedCommand) throws SQLException, MMSQLException {
        this.checkStatement();
        this.resetExecutionState();
        this.processMessage(executionStrategy, this.internalExecute(commands, isBatchedCommand));
        if (this.serverException != null) {
            throw this.serverException;
        }
        executionStrategy.handleResults(commands);
        String logMsg = JDBCPlugin.Util.getString(executionStrategy.getLogKey(), commands[0]);
        this.getLogger().log(4, logMsg);
    }

    private void handleQueryResult() {
        if (this.resultSet == null) {
            if (this.commandStatus == 4) {
                String msg = JDBCPlugin.Util.getString("MMStatement.Timeout_before_execute");
                this.setException(new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Time_out_happened__n_1") + msg));
            } else if (this.commandStatus == 3) {
                String msg = JDBCPlugin.Util.getString("MMStatement.Cancel_before_execute");
                this.setException(new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Statement_is_cancelled__n_2") + msg));
            }
        }
    }

    private void handleUpdateResult(String[] commands, boolean isBatched) throws SQLException {
        if (this.commandStatus == 4) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Timeout_before_execute");
            this.setException(new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Time_out_happened__n_1") + msg));
        } else if (this.commandStatus == 3) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Cancel_before_execute");
            this.setException(new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Statement_is_cancelled__n_2") + msg));
        } else if (this.resultSet.next()) {
            try {
                if (isBatched) {
                    int commandIndex = 0;
                    this.updateCounts = new int[commands.length];
                    do {
                        this.updateCounts[commandIndex++] = this.resultSet.getInt(1);
                    } while (this.resultSet.next());
                } else {
                    this.rowsAffected = this.resultSet.getInt(1);
                }
                String logMsg = JDBCPlugin.Util.getString("MMStatement.Success_update", commands[0]);
                this.getLogger().log(4, logMsg);
            }
            catch (SQLException se) {
                String msg = JDBCPlugin.Util.getString("MMStatement.Err_getting_update_row");
                this.setException(MMSQLException.create(se, msg));
            }
        }
    }

    private ExecutionStrategy getUpdateStrategy() {
        if (this.updateStrategy == null) {
            this.updateStrategy = new UpdateStrategy(false);
        }
        return this.updateStrategy;
    }

    private ExecutionStrategy getBatchedUpdateStrategy() {
        if (this.batchedUpdateStrategy == null) {
            this.batchedUpdateStrategy = new UpdateStrategy(true);
        }
        return this.batchedUpdateStrategy;
    }

    private ExecutionStrategy getQueryStrategy() {
        if (this.queryStrategy == null) {
            this.queryStrategy = new ExecutionStrategy(){

                public void startMessageDelivery() {
                    MMStatement.this.resultSet = null;
                }

                public void createResultSet(ResultsMessage resultsMessage) {
                    MMStatement.this.resultSet = CursorResultsImpl.newInstance(resultsMessage, MMStatement.this);
                }

                public void handleResults(String[] commands) {
                    MMStatement.this.handleQueryResult();
                }

                public String getLogKey() {
                    return "MMStatement.Success_query";
                }
            };
        }
        return this.queryStrategy;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public int executeUpdate(String sql, int[] columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Connection getConnection() {
        return this.driverConnection;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        this.checkStatement();
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.rowsAffected = -1;
        return false;
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.checkStatement();
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkStatement();
        return this.queryTimeout;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkStatement();
        return this.resultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public int getUpdateCount() throws SQLException {
        this.checkStatement();
        return this.rowsAffected;
    }

    protected void setWarnings(List serverWarnings) {
        this.serverWarnings = serverWarnings;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkStatement();
        if (this.serverWarnings != null && this.serverWarnings.size() != 0) {
            return WarningUtil.convertWarnings(this.serverWarnings);
        }
        return null;
    }

    public void setCursorName(String cursorName) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkStatement();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkStatement();
        this.fetchDirection = direction;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkStatement();
        if (rows < 0) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Invalid_fetch_size");
            throw new MMSQLException(msg);
        }
        this.fetchSize = rows == 0 ? 2000 : rows;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setMaxRows(int maxRows) throws SQLException {
        this.checkStatement();
        this.maxRows = maxRows;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkStatement();
        if (seconds < 0) {
            throw new MMSQLException(JDBCPlugin.Util.getString("MMStatement.Bad_timeout_value"));
        }
        this.queryTimeout = seconds;
    }

    protected Message executeAsynchAndWait(Message reqMsg) throws SQLException {
        try {
            return this.executeAsynchAndWait(reqMsg, 0L);
        }
        catch (IOException e) {
            this.getLogger().log(e);
            throw MMSQLException.create(e, e.getMessage());
        }
    }

    protected Message executeAsynchAndWait(Message reqMsg, long timeout) throws IOException, SQLException {
        TimeOutMessageListener messageListener = new TimeOutMessageListener(timeout);
        this.executeAsynch(reqMsg, messageListener);
        return messageListener.conditionalWait();
    }

    protected void executeAsynch(Message reqMeg) throws SQLException {
        this.executeAsynch(reqMeg, null);
    }

    protected void executeAsynch(Message reqMsg, MessageListener listener) throws SQLException {
        try {
            ServerConnection conn = this.driverConnection.getServerConnection();
            String key = null;
            if (reqMsg instanceof DQPInboundMessage) {
                key = ((DQPInboundMessage)reqMsg).getMessageKey();
            }
            if (key == null) {
                key = Long.toString(this.currentRequestID);
            }
            if (listener != null) {
                conn.send(reqMsg, new MessageHolderListener(listener), key, conn.selectServerInstance(null));
            } else {
                conn.send(reqMsg, null, key, conn.selectServerInstance(null));
            }
        }
        catch (CommunicationException e) {
            this.getLogger().log(2, e, "Unable to communicate with server: " + e.getMessage());
            throw MMSQLException.create(e, JDBCPlugin.Util.getString("MMStatement.Unable_to_communicate_with_server_16"));
        }
    }

    protected Message executeSynch(Message reqMsg) throws SQLException {
        try {
            ServerConnection conn = this.driverConnection.getServerConnection();
            return conn.send(reqMsg, conn.selectServerInstance(null));
        }
        catch (CommunicationException e) {
            this.getLogger().log(2, e, "Unable to communicate with server: " + e.getMessage());
            throw MMSQLException.create(e, JDBCPlugin.Util.getString("MMStatement.Unable_to_communicate_with_server_16"));
        }
        catch (ApplicationException e) {
            this.getLogger().log(2, e, "Unable to communicate with server: " + e.getMessage());
            throw MMSQLException.create(e, JDBCPlugin.Util.getString("MMStatement.Unable_to_communicate_with_server_16"));
        }
    }

    protected ResultsMessage internalExecute(String[] commands, boolean isBatchedCommand) throws SQLException {
        try {
            return this.sendRequestMessageAndWait(commands, false, false, null, isBatchedCommand, false);
        }
        catch (Throwable ex) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Error_executing_stmt", isBatchedCommand ? "" : commands[0]);
            if (this.driverConnection != null) {
                this.getLogger().log(2, ex, msg);
            }
            throw MMSQLException.create(ex);
        }
    }

    protected Properties getConnectionProperties() {
        return this.driverConnection.propInfo;
    }

    protected void copyPropertiesToRequest(RequestMessage res, Properties props) {
        String partial = this.getExecutionProperty("partialResultsMode");
        res.setPartialResults(Boolean.valueOf(partial));
        res.setFetchSize(this.fetchSize);
        res.setCursorType(this.resultSetType);
        String validate = this.getExecutionProperty("XMLValidation");
        if (validate == null) {
            res.setValidationMode(false);
        } else {
            res.setValidationMode(Boolean.valueOf(validate));
        }
        String format = this.getExecutionProperty("XMLFormat");
        res.setXMLFormat(format);
        String txnAutoWrapMode = this.getExecutionProperty("txnAutoWrap");
        res.setTxnAutoWrapMode(txnAutoWrapMode);
        String rsCache = this.getExecutionProperty("resultSetCacheMode");
        res.setUseResultSetCache(Boolean.valueOf(rsCache));
    }

    protected void timeoutOccurred() {
        String logMsg = JDBCPlugin.Util.getString("MMStatement.Timeout_ocurred_in_Statement.");
        this.getLogger().log(3, logMsg);
        try {
            this.timeoutCancel();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException se) {
            logMsg = JDBCPlugin.Util.getString("MMStatement.Error_timing_out.");
            this.getLogger().log(2, se, logMsg);
        }
    }

    final void timeoutCancel() throws SQLException {
        this.cancel();
        this.commandStatus = 4;
        this.queryTimeout = 0;
    }

    protected void cancelRequest() throws SQLException {
        this.checkStatement();
        CancelMessage cancelMsg = new CancelMessage();
        cancelMsg.setRequestID(new RequestID(this.currentRequestID));
        cancelMsg.setMessageKey("cancel-" + this.currentRequestID);
        ResultsMessage msg = (ResultsMessage)this.executeSynch(cancelMsg);
        if (msg != null && msg.getException() != null) {
            throw new SQLException(msg.getException().getMessage());
        }
    }

    public void setPayload(Serializable payload) {
        this.payload = payload;
    }

    public void setExecutionProperty(String name, String value) {
        this.execProps.put(name, value);
    }

    public String getExecutionProperty(String name) {
        return (String)this.execProps.get(name);
    }

    protected ResultsMessage sendRequestMessageAndWait(String[] commands, boolean isPreparedStatement, boolean isCallableStatement, List paramValues, boolean isBatchedCommand, boolean isPreparedBatchUpdate) throws SQLException, IOException {
        Command command = null;
        this.currentRequestID = this.driverConnection.nextRequestID();
        if (isBatchedCommand) {
            SQLQuery[] sqls = new SQLQuery[commands.length];
            for (int i = 0; i < sqls.length; ++i) {
                sqls[i] = new SQLQuery(commands[i]);
            }
            command = new BatchedUpdateCommand(Arrays.asList(sqls));
        } else {
            command = new SQLQuery(commands[0]);
        }
        RequestMessage reqMsg = new RequestMessage(command);
        reqMsg.markSubmissionStart();
        reqMsg.setOriginalCommand((Command)command.clone());
        reqMsg.setUserName(this.driverConnection.getUserName());
        reqMsg.setExecutionPayload(this.payload);
        reqMsg.setDoubleQuotedVariableAllowed(Boolean.valueOf(this.getExecutionProperty("allowDoubleQuotedVariable")));
        String sqlOptions = this.getExecutionProperty("sqlOptions");
        if (sqlOptions != null && sqlOptions.toUpperCase().indexOf("SHOWPLAN".toUpperCase()) >= 0) {
            reqMsg.setShowPlan(true);
        }
        if (isPreparedStatement) {
            reqMsg.setPreparedStatement(true);
            reqMsg.setParameterValues(paramValues);
        } else if (isCallableStatement) {
            reqMsg.setCallableStatement(true);
            if (paramValues != null) {
                reqMsg.setParameterValues(paramValues);
            }
        }
        reqMsg.setPreparedBatchUpdate(isPreparedBatchUpdate);
        reqMsg.setRequestID(new RequestID(this.currentRequestID));
        reqMsg.setFetchSize(this.getFetchSize());
        reqMsg.setStyleSheet(this.styleSheet);
        reqMsg.setRowLimit(this.maxRows);
        this.copyPropertiesToRequest(reqMsg, this.getConnectionProperties());
        String profileProperty = this.getExecutionProperty("profile");
        if (profileProperty != null) {
            reqMsg.setProfile(Boolean.valueOf(profileProperty));
        }
        return (ResultsMessage)this.executeAsynchAndWait(reqMsg, this.queryTimeout * 1000);
    }

    long getCurrentRequestID() {
        return this.currentRequestID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachStylesheet(Reader reader) throws IOException {
        BufferedReader bufferedReader = null;
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        this.styleSheet = buffer.toString();
    }

    public void clearStylesheet() {
        this.styleSheet = null;
    }

    void setPlanDescription(Map planDescription) {
        this.currentPlanDescription = planDescription;
    }

    void setDebugLog(String debugLog) {
        this.debugLog = debugLog;
    }

    void setAnnotations(List annotations) {
        this.annotations = annotations;
    }

    public PlanNode getPlanDescription() {
        Map planDescription = null;
        if (this.resultSet != null) {
            planDescription = this.resultSet.getUpdatedPlanDescription();
        }
        if (planDescription != null) {
            this.currentPlanDescription = planDescription;
            return PlanNodeImpl.constructFromMap(this.currentPlanDescription);
        }
        if (this.currentPlanDescription != null) {
            return PlanNodeImpl.constructFromMap(this.currentPlanDescription);
        }
        return null;
    }

    public String getDebugLog() {
        return this.debugLog;
    }

    public Collection getAnnotations() {
        return this.annotations;
    }

    public void setPartialResults(boolean isPartialResults) {
        if (isPartialResults) {
            this.execProps.put("partialResultsMode", "true");
        }
    }

    public String getRequestIdentifier() {
        if (this.currentRequestID >= 0L) {
            return Long.toString(this.currentRequestID);
        }
        return null;
    }

    boolean isClosed() {
        return this.isClosed;
    }

    protected boolean isUpdateSql(String sql) throws SQLException {
        try {
            return SqlUtil.isUpdateSql(sql);
        }
        catch (IllegalArgumentException e) {
            String logMsg = JDBCPlugin.Util.getString("MMStatement.Invalid_query_type", sql);
            this.getLogger().log(2, logMsg);
            throw new MMSQLException(logMsg);
        }
    }

    protected void setAnalysisInfo(ResultsMessage resultsMsg) {
        this.debugLog = resultsMsg.getDebugLog();
        this.currentPlanDescription = resultsMsg.getPlanDescription();
        Collection serverAnnotations = resultsMsg.getAnnotations();
        if (serverAnnotations != null) {
            ArrayList<AnnotationImpl> annotations = new ArrayList<AnnotationImpl>(serverAnnotations.size());
            Iterator annIter = serverAnnotations.iterator();
            while (annIter.hasNext()) {
                String[] serverAnnotation = (String[])annIter.next();
                AnnotationImpl annotation = new AnnotationImpl(serverAnnotation);
                annotations.add(annotation);
            }
            this.annotations = annotations;
        }
    }

    Calendar getDefaultCalendar() {
        if (this.defaultCalendar == null) {
            this.defaultCalendar = Calendar.getInstance();
        }
        return this.defaultCalendar;
    }

    void setDefaultCalendar(Calendar cal) {
        this.defaultCalendar = cal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RequestIdAwareLogger
    implements Logger {
        Logger delegate = null;

        RequestIdAwareLogger(Logger sourcelogger) {
            this.delegate = sourcelogger;
        }

        public void log(IStatus status) {
            this.delegate.log(status);
        }

        public void log(int severity, String message) {
            this.delegate.log(severity, this.convert(message));
        }

        public void log(int severity, Throwable t, String message) {
            this.delegate.log(severity, t, this.convert(message));
        }

        public void log(Object obj) {
            this.delegate.log(4, this.convert(obj.toString()));
        }

        public void log(Throwable t) {
            this.delegate.log(2, t, this.convert(""));
        }

        String convert(String msg) {
            return "<Req=" + MMStatement.this.currentRequestID + "> " + msg;
        }
    }

    private class TimeOutMessageListener
    implements MessageListener {
        private long start;
        private long timeout;
        private Object lock = new Object();
        private Message message;

        public TimeOutMessageListener(long timeout) {
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deliverMessage(Message msg, String messageKey) {
            Object object = this.lock;
            synchronized (object) {
                this.start = System.currentTimeMillis();
                this.message = msg;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message conditionalWait() throws IOException, SQLException {
            this.start = System.currentTimeMillis();
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.timeout > 0L && System.currentTimeMillis() > this.start + this.timeout && MMStatement.this.commandStatus != 4) {
                        MMStatement.this.timeoutOccurred();
                    }
                    MMStatement.this.checkStatement();
                    if (this.message != null) {
                        if (MMStatement.this.commandStatus == 4) {
                            throw new TimeoutException(JDBCPlugin.Util.getString("MMStatement.Timeout_before_complete"));
                        }
                        return this.message;
                    }
                    try {
                        this.lock.wait(SPIN_TIMEOUT);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class UpdateStrategy
    implements ExecutionStrategy {
        private boolean isBatched = false;

        private UpdateStrategy(boolean batched) {
            this.isBatched = batched;
        }

        public void startMessageDelivery() {
        }

        public void createResultSet(ResultsMessage resultsMessage) {
            MMStatement.this.resultSet = CursorResultsImpl.newInstance(resultsMessage, MMStatement.this);
        }

        public void handleResults(String[] commands) throws SQLException {
            MMStatement.this.handleUpdateResult(commands, this.isBatched);
        }

        public String getLogKey() {
            return "MMStatement.Success_update";
        }
    }

    private static interface ExecutionStrategy {
        public void startMessageDelivery();

        public void createResultSet(ResultsMessage var1);

        public void handleResults(String[] var1) throws SQLException;

        public String getLogKey();
    }
}

