/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.xa.MMXid;
import com.metamatrix.core.log.FileLogWriter;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.DriverManagerLogger;
import com.metamatrix.jdbc.JDBCLogger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMCallableStatement;
import com.metamatrix.jdbc.MMDatabaseMetaData;
import com.metamatrix.jdbc.MMPreparedStatement;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.api.Connection;
import com.metamatrix.jdbc.api.DatabaseMetaData;
import com.metamatrix.jdbc.util.TransactionHelper;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.transaction.xa.Xid;

public abstract class MMConnection
implements Connection {
    private static final String DEFAULT_APP_NAME = "JDBC";
    private ServerConnection serverConn;
    private long requestIDGenerator;
    private String url;
    protected Properties propInfo;
    private int logLevel = 0;
    private FileLogWriter logWriter;
    private Logger logger;
    private String applicationName;
    private boolean closed = false;
    private boolean autoCommitFlag = true;
    private Collection statements = Collections.synchronizedList(new ArrayList());
    private DatabaseMetaData dbmm = null;
    private MMXid transactionXid;
    private boolean readOnly = false;
    private boolean disableLocalTransactions = false;

    MMConnection(ServerConnection serverConn, Properties info, String url) {
        String defaultFetchSize;
        this.url = url;
        this.serverConn = serverConn;
        String overrideProp = info.getProperty("txnAutoWrap");
        if (overrideProp == null || overrideProp.trim().length() == 0) {
            info.put("txnAutoWrap", "OPTIMISTIC");
        }
        this.applicationName = info.getProperty("ApplicationName");
        if (this.applicationName == null) {
            this.applicationName = DEFAULT_APP_NAME;
        }
        if ((defaultFetchSize = info.getProperty("fetchSize")) != null) {
            info.put("fetchSize", defaultFetchSize);
        } else {
            info.put("fetchSize", "2000");
        }
        String partialResultsMode = info.getProperty("partialResultsMode");
        if (partialResultsMode != null) {
            info.put("partialResultsMode", partialResultsMode);
        } else {
            info.put("partialResultsMode", "FALSE");
        }
        String resultSetCacheMode = info.getProperty("resultSetCacheMode");
        if (resultSetCacheMode != null) {
            info.put("resultSetCacheMode", resultSetCacheMode);
        } else {
            info.put("resultSetCacheMode", "TRUE");
        }
        String allowDblQuotes = info.getProperty("allowDoubleQuotedVariable");
        if (allowDblQuotes != null) {
            info.put("allowDoubleQuotedVariable", allowDblQuotes);
        } else {
            info.put("allowDoubleQuotedVariable", Boolean.FALSE.toString());
        }
        String logFile = info.getProperty("logFile");
        this.logLevel = MMConnection.readLoggingLevel(info, this.logLevel);
        if (logFile != null && this.logLevel > 0) {
            this.logWriter = new FileLogWriter(new File(logFile));
            this.logger = new JDBCLogger(this.logLevel, this.logWriter, Integer.parseInt(info.getProperty("connectionID")));
        } else {
            this.logger = new DriverManagerLogger(this.logLevel, DriverManager.getLogWriter());
        }
        if (this.logLevel >= 3) {
            AOP.enableProxies();
            AOP.enableTracing();
        } else {
            AOP.disableTracing();
        }
        String logMsg = JDBCPlugin.Util.getString("MMConnection.Session_success");
        this.logger.log(4, logMsg);
        if (this.logLevel >= 1) {
            this.logConnectionProperties(url, info);
        }
        this.propInfo = info;
        this.disableLocalTransactions = Boolean.valueOf(this.propInfo.getProperty("disableLocalTxn"));
    }

    private void logConnectionProperties(String connUrl, Properties info) {
        StringBuffer modifiedUrl = new StringBuffer();
        if (connUrl != null) {
            int startIndex = connUrl.indexOf("password=");
            if (startIndex != -1) {
                modifiedUrl.append(connUrl.substring(0, startIndex));
                modifiedUrl.append("password=***");
                int endIndex = connUrl.indexOf(";", startIndex + 9);
                if (endIndex != -1) {
                    modifiedUrl.append(";").append(connUrl.substring(endIndex));
                }
            }
            this.logger.log(4, "Connection Url=" + modifiedUrl);
        }
        if (info != null) {
            Enumeration<Object> enumeration = info.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object anObj = info.get(key);
                if ("password".equalsIgnoreCase(key) || "clientToken".equalsIgnoreCase(key)) continue;
                this.logger.log(4, key + "=" + anObj);
            }
        }
    }

    public static int readLoggingLevel(Properties info, int defaultValue) {
        String loggingLevel = info.getProperty("logLevel");
        if (loggingLevel != null) {
            return Integer.parseInt(loggingLevel);
        }
        return defaultValue;
    }

    public static boolean isLoggingOn(Properties info) {
        int logLevel = MMConnection.readLoggingLevel(info, 0);
        return logLevel > 0;
    }

    String getUrl() {
        return this.url;
    }

    public Logger getLogger() {
        return this.logger;
    }

    String getConnectionId() {
        if (this.propInfo != null) {
            return this.propInfo.getProperty("connectionID");
        }
        return "0";
    }

    long currentRequestId() {
        return this.requestIDGenerator;
    }

    synchronized long nextRequestID() {
        return this.requestIDGenerator++;
    }

    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws SQLException {
        SQLException firstException = null;
        if (this.closed) {
            return;
        }
        try {
            try {
                block14: {
                    block15: {
                        try {
                            try {
                                this.closeStatements();
                            }
                            catch (SQLException se) {
                                firstException = se;
                                Object var4_3 = null;
                                if (this.serverConn != null) {
                                    this.serverConn.shutdown();
                                }
                                if (firstException != null) {
                                    throw firstException;
                                }
                                break block14;
                            }
                            Object var4_2 = null;
                            if (this.serverConn == null) break block15;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            if (this.serverConn != null) {
                                this.serverConn.shutdown();
                            }
                            if (firstException == null) throw throwable;
                            throw firstException;
                        }
                        this.serverConn.shutdown();
                    }
                    if (firstException != null) {
                        throw firstException;
                    }
                }
                Object var6_12 = null;
                this.serverConn = null;
                String logMsg = JDBCPlugin.Util.getString("MMConnection.Connection_close_success");
                this.logger.log(4, logMsg);
                this.closed = true;
                if (this.logWriter == null) return;
                this.logWriter.shutdown();
                this.logWriter = null;
                return;
            }
            catch (SQLException se) {
                String logMsg = JDBCPlugin.Util.getString("MMConnection.Err_connection_close", se.getMessage());
                this.logger.log(2, se, logMsg);
                throw MMSQLException.create(se, logMsg);
            }
            catch (CommunicationException e) {
                String logMsg = JDBCPlugin.Util.getString("MMConnection.Err_connection_close", e.getMessage());
                this.logger.log(2, e, logMsg);
                String msg = JDBCPlugin.Util.getString("MMConnection.Err_closing_conn");
                throw MMSQLException.create(e, msg);
            }
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            this.serverConn = null;
            String logMsg = JDBCPlugin.Util.getString("MMConnection.Connection_close_success");
            this.logger.log(4, logMsg);
            this.closed = true;
            if (this.logWriter == null) throw throwable;
            this.logWriter.shutdown();
            this.logWriter = null;
            throw throwable;
        }
    }

    void closeStatements() throws SQLException {
        try {
            ArrayList statementsSafe = new ArrayList(this.statements);
            Iterator statementIter = statementsSafe.iterator();
            while (statementIter.hasNext()) {
                Statement statement = (Statement)statementIter.next();
                statement.close();
            }
        }
        catch (SQLException e) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Err_closing_stmts");
            throw MMSQLException.create(e, msg);
        }
        finally {
            this.statements = null;
        }
    }

    void closeStatement(Statement statement) {
        this.statements.remove(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        this.checkConnection();
        if (!this.autoCommitFlag) {
            try {
                this.directCommit();
            }
            finally {
                this.beginLocalTxn();
            }
        }
    }

    private void directCommit() throws MMSQLException, SQLException {
        TransactionHelper.commit(this.getServerConnection());
        this.logger.log(4, JDBCPlugin.Util.getString("MMConnection.Commit_success"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginLocalTxn() throws SQLException {
        if (this.transactionXid == null) {
            if (this.disableLocalTransactions) {
                this.autoCommitFlag = true;
                return;
            }
            boolean txnStarted = false;
            try {
                TransactionHelper.begin(this.getServerConnection());
                txnStarted = true;
            }
            finally {
                if (!txnStarted) {
                    this.autoCommitFlag = true;
                }
            }
        }
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        MMStatement newStatement = MMStatement.newInstance(this, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    private void validateResultSetType(int resultSetType) throws MMSQLException {
        if (resultSetType == 1005) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Scrollable_type_not_supported", "ResultSet.TYPE_SCROLL_SENSITIVE");
            throw new MMSQLException(msg);
        }
    }

    private void validateResultSetConcurrency(int resultSetConcurrency) throws MMSQLException {
        if (resultSetConcurrency == 1008) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Concurrency_type_not_supported", "ResultSet.CONCUR_UPDATABLE");
            throw new MMSQLException(msg);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        return this.autoCommitFlag;
    }

    public String getCatalog() throws SQLException {
        this.checkConnection();
        return null;
    }

    ServerConnection getServerConnection() throws SQLException {
        this.checkConnection();
        return this.serverConn;
    }

    String getSchema() throws SQLException {
        this.checkConnection();
        return (String)this.propInfo.get("VirtualDatabaseName");
    }

    String getVDBVersion() throws SQLException {
        this.checkConnection();
        if (this.propInfo.get("VirtualDatabaseVersion") != null) {
            return (String)this.propInfo.get("VirtualDatabaseVersion");
        }
        return null;
    }

    String getUserName() throws SQLException {
        this.checkConnection();
        return (String)this.propInfo.get("user");
    }

    String getPassword() throws SQLException {
        this.checkConnection();
        return (String)this.propInfo.get("password");
    }

    boolean supportsCatalog() throws SQLException {
        this.checkConnection();
        String supportsCatalog = (String)this.propInfo.get("supportsCatalog");
        if (supportsCatalog == null) {
            return false;
        }
        return Boolean.valueOf(supportsCatalog);
    }

    protected java.sql.DatabaseMetaData getMetaData(BaseDriver driver) throws SQLException {
        this.checkConnection();
        if (this.dbmm == null) {
            this.dbmm = MMDatabaseMetaData.newInstance(driver, this);
        }
        return this.dbmm;
    }

    abstract String getDatabaseName();

    public int getHoldability() throws SQLException {
        return 1;
    }

    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    public Map getTypeMap() throws SQLException {
        this.checkConnection();
        return new HashMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return null;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1004, 1007);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        CallableStatement newStatement = (CallableStatement)((Object)MMCallableStatement.newInstance(this, sql, resultSetType, resultSetConcurrency));
        this.statements.add(newStatement);
        return newStatement;
    }

    private void validateSQL(String sql) throws MMSQLException {
        if (sql == null) {
            String msg = JDBCPlugin.Util.getString("MMConnection.SQL_cannot_be_null");
            throw new MMSQLException(msg);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkConnection();
        this.validateResultSetType(resultSetType);
        this.validateResultSetConcurrency(resultSetConcurrency);
        this.validateSQL(sql);
        MMPreparedStatement newStatement = MMPreparedStatement.newInstance(this, sql, resultSetType, resultSetConcurrency);
        this.statements.add(newStatement);
        return newStatement;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void rollback() throws SQLException {
        this.rollback(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(boolean startTxn) throws SQLException {
        this.checkConnection();
        if (!this.autoCommitFlag) {
            try {
                TransactionHelper.rollback(this.getServerConnection());
                String logMsg = JDBCPlugin.Util.getString("MMConnection.Rollback_success");
                this.logger.log(4, logMsg);
            }
            finally {
                if (startTxn) {
                    this.beginLocalTxn();
                } else {
                    this.autoCommitFlag = true;
                }
            }
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkConnection();
        if (autoCommit == this.autoCommitFlag) {
            return;
        }
        this.autoCommitFlag = autoCommit;
        if (autoCommit) {
            this.directCommit();
        } else {
            this.beginLocalTxn();
        }
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public void setHoldability(int holdability) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.readOnly == readOnly) {
            return;
        }
        if (!this.autoCommitFlag || this.transactionXid != null) {
            String logMsg = JDBCPlugin.Util.getString("MMStatement.Invalid_During_Transaction", "setReadOnly(" + readOnly + ")");
            MMSQLException e = new MMSQLException(logMsg);
            this.logger.log(2, e, logMsg);
            throw e;
        }
        this.readOnly = readOnly;
    }

    void checkConnection() throws SQLException {
        if (this.closed) {
            String msg = JDBCPlugin.Util.getString("MMConnection.Cant_use_closed_connection");
            MMSQLException e = new MMSQLException(msg);
            this.logger.log(2, e, msg);
            throw e;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
    }

    public void setTypeMap(Map map) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void releaseSavepoint(Savepoint sp) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public void rollback(Savepoint sp) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    protected void commitTransaction(MMXid arg0, boolean arg1) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        this.autoCommitFlag = true;
        TransactionHelper.commitTransaction(this.serverConn, arg0, arg1);
    }

    protected void endTransaction(MMXid arg0, int arg1) throws SQLException {
        this.checkConnection();
        this.autoCommitFlag = true;
        TransactionHelper.endTransaction(this.serverConn, arg0, arg1);
    }

    protected void forgetTransaction(MMXid arg0) throws SQLException {
        this.checkConnection();
        TransactionHelper.forgetTransaction(this.serverConn, arg0);
    }

    protected int prepareTransaction(MMXid arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        return TransactionHelper.prepareTransaction(this.serverConn, arg0);
    }

    protected Xid[] recoverTransaction(int arg0) throws SQLException {
        this.checkConnection();
        return TransactionHelper.recoverTransaction(this.serverConn, arg0);
    }

    protected void rollbackTransaction(MMXid arg0) throws SQLException {
        this.checkConnection();
        this.transactionXid = null;
        this.autoCommitFlag = true;
        TransactionHelper.rollbackTransaction(this.serverConn, arg0);
    }

    protected void startTransaction(MMXid arg0, int arg1, int timeout) throws SQLException {
        this.checkConnection();
        TransactionHelper.startTransaction(this.serverConn, arg0, arg1, timeout);
        this.transactionXid = arg0;
        this.autoCommitFlag = false;
    }

    protected void selectNewServerInstance() throws CommunicationException, SQLException {
        this.transactionXid = null;
        this.autoCommitFlag = true;
        ServerConnection conn = this.getServerConnection();
        if (conn instanceof SocketServerConnection) {
            ((SocketServerConnection)conn).selectNewServerInstance();
        }
    }

    protected MMXid getTransactionXid() {
        return this.transactionXid;
    }
}

