/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.MetaMatrixExceptionUtil;
import com.metamatrix.core.util.MetaMatrixNestedException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;

public class MetaMatrixRuntimeException
extends RuntimeException
implements Serializable,
MetaMatrixNestedException {
    public static final long serialVersionUID = -4035276728007979320L;
    private static final String EMPTY_STRING = "";
    public static final String CAUSED_BY_STRING = CorePlugin.Util.getString("MetaMatrixRuntimeException.Caused_by");
    private int code;
    private Throwable child;
    private String msg;

    public static String getClassShortName(Class cls) {
        if (cls == null) {
            return EMPTY_STRING;
        }
        String className = cls.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public MetaMatrixRuntimeException() {
    }

    public MetaMatrixRuntimeException(String message) {
        this.setMessage(message);
    }

    public MetaMatrixRuntimeException(int code, String message) {
        this.setMessage(message);
        this.setCode(code);
    }

    public MetaMatrixRuntimeException(Throwable e) {
        this.msg = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().getMessage() : (e == null ? null : e.getMessage());
        this.setChild(e);
        if (e instanceof MetaMatrixRuntimeException) {
            this.setCode(((MetaMatrixRuntimeException)e).getCode());
        }
        if (e instanceof CoreException) {
            this.setCode(((CoreException)e).getStatus().getCode());
        }
    }

    public MetaMatrixRuntimeException(Throwable e, String message) {
        this(e, 0, message);
    }

    public MetaMatrixRuntimeException(Throwable e, int code, String message) {
        this.setChild(e);
        this.setMessage(message);
        this.setCode(code);
    }

    public Throwable getChild() {
        return this.child;
    }

    public Iterator getChildren() {
        return new MetaMatrixExceptionUtil.NestedExceptionIterator(this);
    }

    public int getCode() {
        return this.code;
    }

    public String getFormattedMessage(Throwable throwable, int level) {
        int code = 0;
        if (throwable instanceof CoreException) {
            code = ((CoreException)throwable).getStatus().getCode();
        } else if (throwable instanceof MetaMatrixRuntimeException) {
            code = ((MetaMatrixRuntimeException)throwable).getCode();
        }
        return (level != 0 ? "\n" + level + ' ' : EMPTY_STRING) + '[' + MetaMatrixRuntimeException.getClassShortName(throwable.getClass()) + ']' + (code != 0 ? 32 + code + ": " : EMPTY_STRING) + (throwable.getMessage() == null ? EMPTY_STRING : throwable.getMessage());
    }

    public String getFullMessage() {
        return MetaMatrixExceptionUtil.getFullMessage(this);
    }

    public String getMessage() {
        return this.msg;
    }

    protected void setMessage(String message) {
        this.msg = message;
    }

    public void setChild(Throwable child) {
        this.child = child instanceof InvocationTargetException ? ((InvocationTargetException)child).getTargetException() : child;
        if (child instanceof MetaMatrixRuntimeException) {
            this.setCode(((MetaMatrixRuntimeException)child).getCode());
        }
        if (child instanceof CoreException) {
            this.setCode(((CoreException)child).getStatus().getCode());
        }
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String toString() {
        return MetaMatrixExceptionUtil.getLinkedMessages(this);
    }

    public void printStackTrace() {
        MetaMatrixExceptionUtil.printStackTrace(this);
    }

    public void printStackTrace(PrintStream output) {
        MetaMatrixExceptionUtil.printStackTrace((MetaMatrixNestedException)this, output);
    }

    public void printStackTrace(PrintWriter output) {
        MetaMatrixExceptionUtil.printStackTrace((MetaMatrixNestedException)this, output);
    }

    public Throwable getNestedException() {
        return this.child;
    }

    public void superPrintStackTrace(PrintStream output) {
        super.printStackTrace(output);
    }

    public void superPrintStackTrace(PrintWriter output) {
        super.printStackTrace(output);
    }
}

