/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.client;

import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionHolder;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.proxy.SecurityContext;
import com.metamatrix.core.proxy.ServiceInvocation;
import com.metamatrix.core.proxy.ServiceInvocationStruct;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;
import java.io.IOException;
import java.io.Serializable;

public class SubSystemAdminAPIClientInterceptor
implements TerminalServiceInterceptor {
    private static final int MAX_RETRIES = 3;
    private String userName;
    private char[] password;
    private MMURL serverURL;
    private String applicationName;
    private Class serviceInterface;
    private SocketServerConnectionFactory serverConnectionFactory;
    private SocketServerConnectionHolder holder;
    static /* synthetic */ Class class$com$metamatrix$core$proxy$ServiceEndpoint;

    public SubSystemAdminAPIClientInterceptor(String userName, char[] password, String serverURL, String applicationName, Class serviceInterface, ServerConnectionFactory serverConnectionFactory, SocketServerConnectionHolder holder) {
        this.userName = userName;
        this.password = password;
        this.serverURL = new MMURL(serverURL);
        this.applicationName = applicationName;
        this.serviceInterface = serviceInterface;
        this.serverConnectionFactory = (SocketServerConnectionFactory)serverConnectionFactory;
        this.holder = holder;
    }

    public Object invoke(ServiceInvocation invocation) throws Throwable {
        Exception exception = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.doOneInvocation(invocation);
            }
            catch (IOException e) {
                exception = e;
                this.closeConnection();
                continue;
            }
            catch (MetaMatrixRuntimeException e) {
                exception = e;
                this.closeConnection();
                continue;
            }
            catch (CommunicationException e) {
                exception = e;
                this.closeConnection();
            }
        }
        throw exception;
    }

    private Object doOneInvocation(ServiceInvocation invocation) throws Throwable {
        SocketServerConnection serverConnection = this.getServerConnection();
        ServerInstance serverInstance = serverConnection.selectServerInstance(null);
        invocation.setAttribute((class$com$metamatrix$core$proxy$ServiceEndpoint == null ? (class$com$metamatrix$core$proxy$ServiceEndpoint = SubSystemAdminAPIClientInterceptor.class$("com.metamatrix.core.proxy.ServiceEndpoint")) : class$com$metamatrix$core$proxy$ServiceEndpoint).getName(), (Serializable)((Object)this.serviceInterface.getName()));
        SecurityContext securityContext = serverConnection.getClientSideLogon().getSecurityContext();
        invocation.setAttribute(securityContext.getClass().getName(), securityContext);
        MessageHolder requestMessage = this.createRequestMessage(invocation);
        MessageHolder responseMessage = (MessageHolder)serverConnection.send(requestMessage, serverInstance);
        Serializable result = this.getResult(responseMessage);
        if (result instanceof ExceptionHolder) {
            throw ((ExceptionHolder)result).exception;
        }
        return result;
    }

    private MessageHolder createRequestMessage(ServiceInvocation invocation) {
        ServiceInvocationStruct serializedInvocation = invocation.toStruct();
        MessageHolder message = new MessageHolder();
        message.contents = serializedInvocation;
        message.secure = true;
        return message;
    }

    private Serializable getResult(MessageHolder responseMessage) {
        return responseMessage.contents;
    }

    private synchronized void closeConnection() {
        if (this.holder.getServerConnection() != null) {
            try {
                this.holder.getServerConnection().shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.holder.setServerConnection(null);
        }
    }

    private synchronized SocketServerConnection getServerConnection() throws ConnectionException, CommunicationException {
        if (this.holder.getServerConnection() == null) {
            SocketServerConnection connection = (SocketServerConnection)this.serverConnectionFactory.establishConnection(this.serverURL, "Platform", this.applicationName, "SessionService", this.userName, this.password);
            this.holder.setServerConnection(connection);
        }
        return this.holder.getServerConnection();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

