/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.types.BlobImpl;
import com.metamatrix.common.types.ClobImpl;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.dqp.message.ParameterInfo;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.CursorResultsImpl;
import com.metamatrix.jdbc.DataTypeTransformer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMPreparedStatement;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.ResultsImpl;
import com.metamatrix.jdbc.StoredProcedureResultsImpl;
import com.metamatrix.jdbc.util.StoredProcedureCall;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.symbol.Constant;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;

public class MMCallableStatement
extends MMPreparedStatement
implements CallableStatement {
    private String procedureCall;
    private Map outParamIndexMap = new HashMap(3);
    private Object parameterValue;
    private MMResultSet resultSet;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMCallableStatement;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMConnection;
    static /* synthetic */ Class class$java$lang$String;

    static MMPreparedStatement newInstance(MMConnection connection, String procedureCall, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (AOP.useproxy()) {
            return (MMCallableStatement)ProxyFactory.extend(class$com$metamatrix$jdbc$MMCallableStatement == null ? (class$com$metamatrix$jdbc$MMCallableStatement = MMCallableStatement.class$("com.metamatrix.jdbc.MMCallableStatement")) : class$com$metamatrix$jdbc$MMCallableStatement, new Class[]{class$com$metamatrix$jdbc$MMConnection == null ? (class$com$metamatrix$jdbc$MMConnection = MMCallableStatement.class$("com.metamatrix.jdbc.MMConnection")) : class$com$metamatrix$jdbc$MMConnection, class$java$lang$String == null ? (class$java$lang$String = MMCallableStatement.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE}, new Object[]{connection, procedureCall, new Integer(resultSetType), new Integer(resultSetConcurrency)});
        }
        return new MMCallableStatement(connection, procedureCall, resultSetType, resultSetConcurrency);
    }

    MMCallableStatement(MMConnection connection, String procedureCall, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(connection, procedureCall, resultSetType, resultSetConcurrency);
        this.procedureCall = procedureCall;
    }

    public void close() throws SQLException {
        this.procedureCall = null;
        super.close();
    }

    public boolean execute() throws SQLException {
        this.checkStatement();
        if (this.isUpdateSql(this.procedureCall)) {
            String logMsg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
            MMSQLException e = new MMSQLException(logMsg);
            this.getLogger().log(2, e, logMsg);
            throw e;
        }
        this.executeQuery();
        return true;
    }

    private void processQueryMessage(ResultsMessage resultsMsg) {
        try {
            ResultsImpl resultsImpl = null;
            MetaMatrixException resultsExp = resultsMsg.getException();
            List resultsWarning = resultsMsg.getWarnings();
            this.setAnalysisInfo(resultsMsg);
            if (resultsExp != null) {
                this.setException(resultsExp);
            } else {
                List listOfParameters;
                if (resultsWarning != null) {
                    this.setWarnings(resultsWarning);
                }
                if ((listOfParameters = resultsMsg.getParameters()) != null && this.outParamIndexMap.isEmpty()) {
                    ParameterInfo parameter;
                    int resultSetSize = 0;
                    Iterator iteratorOfParameters = listOfParameters.iterator();
                    while (iteratorOfParameters.hasNext()) {
                        ParameterInfo parameter2 = (ParameterInfo)iteratorOfParameters.next();
                        if (parameter2.getType() != 5) continue;
                        resultSetSize = parameter2.getNumColumns();
                        break;
                    }
                    int index = 0;
                    int count = 0;
                    iteratorOfParameters = listOfParameters.iterator();
                    while (iteratorOfParameters.hasNext()) {
                        parameter = (ParameterInfo)iteratorOfParameters.next();
                        if (parameter.getType() != 4) continue;
                        this.outParamIndexMap.put(new Integer(++index), new Integer(resultSetSize + ++count));
                        break;
                    }
                    iteratorOfParameters = listOfParameters.iterator();
                    while (iteratorOfParameters.hasNext()) {
                        parameter = (ParameterInfo)iteratorOfParameters.next();
                        if (parameter.getType() == 4 || parameter.getType() == 5) continue;
                        ++index;
                        if (parameter.getType() != 2 && parameter.getType() != 3) continue;
                        this.outParamIndexMap.put(new Integer(index), new Integer(resultSetSize + ++count));
                    }
                }
                resultsImpl = CursorResultsImpl.newInstance(resultsMsg, this);
                if (!this.outParamIndexMap.isEmpty()) {
                    int columnCount = resultsImpl.getMetaData().getColumnCount();
                    resultsImpl = StoredProcedureResultsImpl.newInstance(this.driverConnection, resultsImpl, columnCount, this.outParamIndexMap.size(), resultsMsg, this);
                }
                this.resultSet = resultsImpl;
            }
        }
        catch (Throwable e) {
            this.setException(e);
        }
    }

    public ResultSet executeQuery() throws SQLException {
        String logMsg;
        this.checkStatement();
        this.resetExecutionState();
        StoredProcedureCall call = null;
        try {
            call = new StoredProcedureCall(this.procedureCall);
        }
        catch (IllegalArgumentException e) {
            throw MMSQLException.create(e, JDBCPlugin.Util.getString("MMCallableStatement.parse_error"));
        }
        if (!this.createExplicitTransaction()) {
            this.processQueryMessage(this.internalExecute(null, new String[]{call.getExecCommand()}, this.getQueryTimeout()));
        } else {
            UserTransaction tx = this.getUserTxn();
            this.processQueryMessage(this.internalExecute(tx, new String[]{call.getExecCommand()}, this.getQueryTimeout()));
            Collection<UserTransaction> values = new ArrayList<UserTransaction>();
            if (this.transactionMap.containsKey(this)) {
                values = (Collection)this.transactionMap.get(this);
            }
            values.add(tx);
            this.transactionMap.put(this, values);
        }
        MMSQLException ex = this.getException();
        if (ex != null) {
            this.endTransaction(false);
        } else if (this.resultSet != null) {
            this.endTransaction(true);
        } else {
            String msg;
            this.endTransaction(false);
            if (this.commandStatus == 4) {
                msg = JDBCPlugin.Util.getString("MMStatement.Timeout_before_execute");
                this.setException(new MMSQLException(msg));
            } else if (this.commandStatus == 3) {
                msg = JDBCPlugin.Util.getString("MMStatement.Cancel_before_execute");
                this.setException(new MMSQLException(msg));
            }
        }
        ex = this.getException();
        if (ex != null) {
            this.clearParameters();
            logMsg = JDBCPlugin.Util.getString("MMStatement.Err_query", this.procedureCall, ex.getMessage());
            this.getLogger().log(2, ex, logMsg);
            throw MMSQLException.create(ex, logMsg);
        }
        logMsg = JDBCPlugin.Util.getString("MMStatement.Success_query", this.procedureCall);
        this.getLogger().log(4, logMsg);
        super.setResultSet(this.resultSet);
        return this.resultSet;
    }

    protected void resetExecutionState() throws SQLException {
        super.resetExecutionState();
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    public int executeUpdate() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Array getArray(int parameterIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal bigDecimalParam = DataTypeTransformer.getBigDecimal(this.getObject(parameterIndex));
        bigDecimalParam.setScale(scale);
        return bigDecimalParam;
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBigDecimal(this.getObject(parameterIndex));
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBlob(this.getObject(parameterIndex));
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getBoolean(this.getObject(parameterIndex));
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getByte(this.getObject(parameterIndex));
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getClob(this.getObject(parameterIndex));
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDate(parameterIndex, null);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Date value = DataTypeTransformer.getDate(this.getObject(parameterIndex));
        if (value == null) {
            return null;
        }
        if (cal != null) {
            value = TimestampWithTimezone.createDate(value, this.getDefaultCalendar().getTimeZone(), cal);
        }
        return value;
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getDouble(this.getObject(parameterIndex));
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getFloat(this.getObject(parameterIndex)).floatValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getInteger(this.getObject(parameterIndex));
    }

    public long getLong(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getLong(this.getObject(parameterIndex));
    }

    public Object getObject(int parameterIndex) throws SQLException {
        Object indexInResults = this.outParamIndexMap.get(new Integer(parameterIndex));
        if (indexInResults == null) {
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("MMCallableStatement.Param_not_found", parameterIndex));
        }
        return ((StoredProcedureResultsImpl)this.getResultSet()).getOutputParamValue((Integer)indexInResults);
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        return this.getObject(parameterIndex);
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new MMSQLException(msg);
    }

    public short getShort(int parameterIndex) throws SQLException {
        return DataTypeTransformer.getShort(this.getObject(parameterIndex));
    }

    public String getString(int parameterIndex) throws SQLException {
        return this.getObject(parameterIndex).toString();
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTime(parameterIndex, null);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Time value = DataTypeTransformer.getTime(this.getObject(parameterIndex));
        if (value == null) {
            return null;
        }
        if (cal != null) {
            value = TimestampWithTimezone.createTime(value, this.getDefaultCalendar().getTimeZone(), cal);
        }
        return value;
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp(parameterIndex, null);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp value = DataTypeTransformer.getTimestamp(this.getObject(parameterIndex));
        if (value == null) {
            return null;
        }
        if (cal != null) {
            value = TimestampWithTimezone.createTimestamp(value, this.getDefaultCalendar().getTimeZone(), cal);
        }
        return value;
    }

    public void registerOutParameter(int parameterIndex, int jdbcSqlType) throws SQLException {
    }

    public void registerOutParameter(int parameterIndex, int jdbcSqlType, int scale) throws SQLException {
    }

    public void registerOutParameter(int parameterIndex, int jdbcSqlType, String typeName) throws SQLException {
    }

    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    public void setNull(int parameterIndex, int jdbcType) throws SQLException {
        if (jdbcType == 2006 && jdbcType == 2001 && jdbcType == 2002 && jdbcType == 2000) {
            String msg = JDBCPlugin.Util.getString("MMCallableStatement.SQL3_types_not_supported");
            throw new MMSQLException(msg);
        }
        this.setObject(parameterIndex, null);
    }

    public void setNull(int parameterIndex, int jdbcType, String typeName) throws SQLException {
        this.setNull(parameterIndex, jdbcType);
    }

    public void setObject(int parameterIndex, Object value, int targetJdbcType, int scale) throws SQLException {
        if (targetJdbcType != 3 || targetJdbcType != 2) {
            this.setObject(parameterIndex, value, targetJdbcType);
        } else {
            BigDecimal bigDecimalObject = DataTypeTransformer.getBigDecimal(value);
            bigDecimalObject.setScale(scale);
            this.setObject(parameterIndex, (Object)bigDecimalObject);
        }
    }

    public void setObject(int parameterIndex, Object value, int targetJdbcType) throws SQLException {
        super.setObject(parameterIndex, value, targetJdbcType);
    }

    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.setObject(parameterIndex, value, (Class)null);
    }

    private void setObject(int parameterIndex, Object value, Class dataType) throws SQLException {
        SPParameter parameter = null;
        parameter = dataType == null ? new SPParameter(parameterIndex, new Constant(value)) : new SPParameter(parameterIndex, new Constant(value, dataType));
        super.setObject(parameter.getIndex(), parameter);
    }

    public boolean wasNull() throws SQLException {
        this.checkStatement();
        return this.parameterValue == null;
    }

    protected void timeoutOccurred(Object ID) {
        String logMsg = JDBCPlugin.Util.getString("MMCallableStatement.Timeout_ocurred_in_CallableStatement.");
        this.getLogger().log(3, logMsg);
        try {
            this.timeoutCancel();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException se) {
            logMsg = JDBCPlugin.Util.getString("MMStatement.Error_timing_out.");
            this.getLogger().log(2, se, logMsg);
        }
    }

    protected ResultsMessage internalExecute(UserTransaction transaction, String[] commands, int timeout) throws SQLException {
        try {
            return this.sendRequestMessageAndWait(transaction, commands, timeout, false, true, this.getParameterValues(), false);
        }
        catch (Throwable ex) {
            String msg = JDBCPlugin.Util.getString("MMStatement.Error_executing_stmt", commands[0]);
            this.getLogger().log(2, ex, msg);
            throw MMSQLException.create(ex, msg);
        }
    }

    public Array getArray(String parameterName) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return null;
    }

    public Blob getBlob(String parameterName) throws SQLException {
        return null;
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        return false;
    }

    public byte getByte(String parameterName) throws SQLException {
        return 0;
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        return null;
    }

    public Clob getClob(String parameterName) throws SQLException {
        return null;
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return null;
    }

    public Date getDate(String parameterName) throws SQLException {
        return null;
    }

    public double getDouble(String parameterName) throws SQLException {
        return 0.0;
    }

    public float getFloat(String parameterName) throws SQLException {
        return 0.0f;
    }

    public int getInt(String parameterName) throws SQLException {
        return 0;
    }

    public long getLong(String parameterName) throws SQLException {
        return 0L;
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return null;
    }

    public Object getObject(String parameterName) throws SQLException {
        return null;
    }

    public Ref getRef(String parameterName) throws SQLException {
        return null;
    }

    public short getShort(String parameterName) throws SQLException {
        return 0;
    }

    public String getString(String parameterName) throws SQLException {
        return null;
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return null;
    }

    public Time getTime(String parameterName) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return null;
    }

    public URL getURL(int parameterIndex) throws SQLException {
        return null;
    }

    public URL getURL(String parameterName) throws SQLException {
        return null;
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
    }

    public void setByte(String parameterName, byte x) throws SQLException {
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
    }

    public void setDate(String parameterName, Date x) throws SQLException {
    }

    public void setDouble(String parameterName, double x) throws SQLException {
    }

    public void setFloat(String parameterName, float x) throws SQLException {
    }

    public void setInt(String parameterName, int x) throws SQLException {
    }

    public void setLong(String parameterName, long x) throws SQLException {
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
    }

    public void setObject(String parameterName, Object x) throws SQLException {
    }

    public void setShort(String parameterName, short x) throws SQLException {
    }

    public void setString(String parameterName, String x) throws SQLException {
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
    }

    public void setTime(String parameterName, Time x) throws SQLException {
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
    }

    public void setURL(String parameterName, URL val) throws SQLException {
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, DataTypeManager.DefaultDataClasses.CLOB);
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setObject(parameterIndex, (Object)x, DataTypeManager.DefaultDataClasses.BLOB);
    }

    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.setObject(parameterIndex, (Object)new BlobImpl(bytes), DataTypeManager.DefaultDataClasses.BLOB);
    }

    public void setAsciiStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setObject(parameterIndex, (Object)new ClobImpl(in, length), DataTypeManager.DefaultDataClasses.CLOB);
    }

    public void setBinaryStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setObject(parameterIndex, (Object)new BlobImpl(in, length), DataTypeManager.DefaultDataClasses.BLOB);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setObject(parameterIndex, (Object)new ClobImpl(reader, length), DataTypeManager.DefaultDataClasses.CLOB);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

