/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.symbol;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;

public class Constant
implements Expression,
Comparable {
    private Object value;
    private Class type;

    public Constant(Object value, Class type) {
        this.value = value;
        if (type == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0014"));
        }
        String typeName = DataTypeManager.getDataTypeName(type);
        if (!DataTypeManager.getAllDataTypes().contains(typeName)) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0015", type.getName()));
        }
        this.type = type;
    }

    public Constant(Object value) {
        this.value = value;
        this.type = DataTypeManager.determineDataTypeClass(value);
    }

    public Class getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isResolved() {
        return true;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Constant other = (Constant)obj;
        if (other.isNull() && this.isNull()) {
            return true;
        }
        if (!other.getType().equals(this.getType())) {
            return false;
        }
        if (other.isNull() || this.isNull()) {
            return false;
        }
        return other.getValue().equals(this.getValue());
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    public Object clone() {
        return new Constant(this.getValue(), this.getType());
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public int compareTo(Object o) throws ClassCastException {
        if (o instanceof Constant) {
            Constant compare = (Constant)o;
            if (this.type.equals(compare.type)) {
                if (compare.value == null) {
                    return 1;
                }
                if (this.value == null) {
                    return -1;
                }
                if (compare.value instanceof Comparable) {
                    return ((Comparable)this.value).compareTo(compare.value);
                }
            }
        }
        throw new ClassCastException();
    }
}

