/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.jdbc.ConnectionListener;
import com.metamatrix.jdbc.EmbeddedDriver;
import java.net.URL;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;

public class EmbeddedConnectionTracker
implements ConnectionListener {
    private URL dqpURL = null;
    private EmbeddedDriver dqpDriver = null;
    private Set connections = new HashSet();

    public EmbeddedConnectionTracker(URL dqpURL, EmbeddedDriver dqpDriver) {
        this.dqpURL = dqpURL;
        this.dqpDriver = dqpDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionAdded(String id, Connection connection) {
        Set set = this.connections;
        synchronized (set) {
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionRemoved(String id, Connection connection) {
        Set set = this.connections;
        synchronized (set) {
            this.connections.remove(connection);
            if (this.connections.size() == 0) {
                this.dqpDriver.shutdown(this.dqpURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getConnections() {
        HashSet tempSet = null;
        Set set = this.connections;
        synchronized (set) {
            tempSet = new HashSet(this.connections);
        }
        return tempSet;
    }
}

