/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.common.actions.AbstractObjectEditor;
import com.metamatrix.common.actions.BasicModificationActionQueue;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.api.PermissionTreeView;
import com.metamatrix.platform.security.api.AuthorizationModel;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissions;
import com.metamatrix.platform.security.api.AuthorizationPermissionsImpl;
import com.metamatrix.platform.security.api.AuthorizationPolicy;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.StandardAuthorizationActions;
import com.metamatrix.platform.security.util.RolePermissionFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractAuthorizationObjectEditor
extends AbstractObjectEditor {
    public static final long serialVersionUID = -3690038844414207808L;
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$AuthorizationPolicyID;
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$AuthorizationPolicy;
    static /* synthetic */ Class class$com$metamatrix$platform$security$api$AuthorizationRealm;

    public AbstractAuthorizationObjectEditor(boolean createActions) {
        super(createActions);
        if (this.doCreateActions()) {
            this.setDestination((ModificationActionQueue)new BasicModificationActionQueue());
        }
    }

    public AbstractAuthorizationObjectEditor() {
        this(true);
    }

    public AuthorizationPolicy createAuthorizationPolicy(AuthorizationPolicyID policyID) {
        if (policyID == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0001"));
        }
        AuthorizationPolicyID targetID = (AuthorizationPolicyID)this.verifyTargetClass(policyID, class$com$metamatrix$platform$security$api$AuthorizationPolicyID == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicyID = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicyID")) : class$com$metamatrix$platform$security$api$AuthorizationPolicyID);
        AuthorizationPolicy policy = new AuthorizationPolicy(targetID);
        this.createCreationAction(targetID, policy);
        return policy;
    }

    public void remove(AuthorizationPolicyID policyID) {
        if (policyID == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0001"));
        }
        AuthorizationPolicyID targetID = (AuthorizationPolicyID)this.verifyTargetClass(policyID, class$com$metamatrix$platform$security$api$AuthorizationPolicyID == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicyID = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicyID")) : class$com$metamatrix$platform$security$api$AuthorizationPolicyID);
        this.createDestroyAction(targetID, targetID);
    }

    public AuthorizationPolicy clonePermission(AuthorizationPolicy targetPolicy, AuthorizationPermission sourcePerm, AuthorizationRealm targetRealm) {
        if (targetPolicy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (sourcePerm == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0003"));
        }
        if (targetRealm == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0004"));
        }
        AuthorizationPolicy theTargetPolicy = (AuthorizationPolicy)this.verifyTargetClass(targetPolicy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationRealm newRealm = (AuthorizationRealm)this.verifyTargetClass(targetRealm, class$com$metamatrix$platform$security$api$AuthorizationRealm == null ? (class$com$metamatrix$platform$security$api$AuthorizationRealm = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationRealm")) : class$com$metamatrix$platform$security$api$AuthorizationRealm);
        AuthorizationPermission newPerm = null;
        try {
            newPerm = (AuthorizationPermission)sourcePerm.clone();
        }
        catch (CloneNotSupportedException e) {
            Object[] params = new Object[]{sourcePerm};
            String msg = PlatformPlugin.Util.getString("ERR.014.107.0005", params);
            LogManager.logError("AUTHORIZATION", (Throwable)e, msg);
        }
        newPerm.setRealm(newRealm);
        theTargetPolicy = this.addPermission(theTargetPolicy, newPerm);
        return theTargetPolicy;
    }

    public AuthorizationPolicy clonePolicyPrincipals(AuthorizationPolicy sourcePolicy, AuthorizationPolicy targetPolicy) {
        if (targetPolicy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (sourcePolicy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0006"));
        }
        AuthorizationPolicy theSourcePolicy = (AuthorizationPolicy)this.verifyTargetClass(sourcePolicy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationPolicy theTargetPolicy = (AuthorizationPolicy)this.verifyTargetClass(targetPolicy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        Set oldPrincipals = theTargetPolicy.getPrincipals();
        if (oldPrincipals.size() > 0) {
            theTargetPolicy = this.removeAllPrincipals(theTargetPolicy);
        }
        HashSet principals = new HashSet(theSourcePolicy.getPrincipals());
        theTargetPolicy = this.addAllPrincipals(theTargetPolicy, principals);
        return theTargetPolicy;
    }

    public AuthorizationPolicy setDescription(AuthorizationPolicy policy, String description) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationPolicyID policyID = thePolicy.getAuthorizationPolicyID();
        String oldDescription = policyID.getDescription();
        this.createExchangeAction(policyID, AuthorizationModel.Attribute.DESCRIPTION, oldDescription, description);
        policyID.setDescription(description);
        return thePolicy;
    }

    public AuthorizationPolicyID setDescription(AuthorizationPolicyID policyID, String description) {
        if (policyID == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0001"));
        }
        AuthorizationPolicyID thePolicyID = (AuthorizationPolicyID)this.verifyTargetClass(policyID, class$com$metamatrix$platform$security$api$AuthorizationPolicyID == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicyID = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicyID")) : class$com$metamatrix$platform$security$api$AuthorizationPolicyID);
        String oldDescription = thePolicyID.getDescription();
        this.createExchangeAction(thePolicyID, AuthorizationModel.Attribute.DESCRIPTION, oldDescription, description);
        thePolicyID.setDescription(description);
        return thePolicyID;
    }

    public AuthorizationPolicy addPrincipal(AuthorizationPolicy policy, MetaMatrixPrincipalName principal) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (principal == null) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        this.createAddAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_NAME, principal);
        thePolicy.addPrincipal(principal);
        return thePolicy;
    }

    public AuthorizationPolicy addAllPrincipals(AuthorizationPolicy policy, Set principals) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (principals == null || principals.size() == 0) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        this.createAddAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_SET, principals);
        thePolicy.addAllPrincipals(principals);
        return thePolicy;
    }

    public AuthorizationPolicy removePrincipal(AuthorizationPolicy policy, MetaMatrixPrincipalName principal) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (principal == null) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        Set principals = thePolicy.getPrincipals();
        if (!principals.contains(principal)) {
            return policy;
        }
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_NAME, principal);
        thePolicy.removePrincipal(principal);
        return thePolicy;
    }

    public AuthorizationPolicy removePrincipals(AuthorizationPolicy policy, Set principals) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (principals == null || principals.size() == 0) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        Set oldPrincipals = thePolicy.getPrincipals();
        oldPrincipals.removeAll(principals);
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_SET, principals);
        thePolicy.setPrincipals(oldPrincipals);
        return thePolicy;
    }

    public AuthorizationPolicy removeAllPrincipals(AuthorizationPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        Set oldPrincipals = thePolicy.getPrincipals();
        if (oldPrincipals.size() == 0) {
            return policy;
        }
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PRINCIPAL_SET, oldPrincipals);
        thePolicy.setPrincipals(Collections.EMPTY_SET);
        return thePolicy;
    }

    public abstract Collection modifyPermissions(PermissionTreeView var1, AuthorizationPolicy var2);

    public AuthorizationPolicy addPermission(AuthorizationPolicy policy, AuthorizationPermission permission) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (permission == null) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationRealm realm = permission.getRealm();
        if (realm.getRealmName().equals(RolePermissionFactory.getRealmName())) {
            return thePolicy;
        }
        String resourceToRemove = null;
        if (((Object)permission.getActions()).equals(StandardAuthorizationActions.NONE)) {
            resourceToRemove = permission.getResourceName();
        }
        Iterator itr = thePolicy.iterator();
        while (itr.hasNext()) {
            AuthorizationPermission tmpPerm = (AuthorizationPermission)itr.next();
            if (resourceToRemove != null && tmpPerm.getResourceName().equals(resourceToRemove)) {
                thePolicy = this.removePermission(thePolicy, tmpPerm);
                break;
            }
            if (!permission.equals(tmpPerm)) continue;
            return thePolicy;
        }
        this.createAddAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSION, permission);
        thePolicy.addPermission(permission);
        return thePolicy;
    }

    protected AuthorizationPolicy addAllPermissions(AuthorizationPolicy policy, Set permissions) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (permissions == null || permissions.size() == 0) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        HashSet<AuthorizationPermission> permsToRemove = new HashSet<AuthorizationPermission>();
        Iterator permItr = permissions.iterator();
        while (permItr.hasNext()) {
            AuthorizationRealm realm;
            AuthorizationPermission perm = (AuthorizationPermission)permItr.next();
            if (((Object)perm.getActions()).equals(StandardAuthorizationActions.NONE)) {
                permsToRemove.add(perm);
            }
            if (!(realm = perm.getRealm()).getRealmName().equals(RolePermissionFactory.getRealmName())) continue;
            return thePolicy;
        }
        if (permsToRemove.size() > 0) {
            thePolicy = this.removePermissions(thePolicy, permsToRemove);
        }
        AuthorizationPermissions oldPermissions = thePolicy.getAuthorizationPermissions();
        AuthorizationPermissionsImpl newPermissions = new AuthorizationPermissionsImpl();
        newPermissions.add(permissions);
        if (oldPermissions != null && oldPermissions.size() > 0) {
            newPermissions.removeAll(oldPermissions);
        }
        this.createAddAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSIONS, newPermissions);
        thePolicy.addAllPermissions(newPermissions);
        return thePolicy;
    }

    public AuthorizationPolicy removePermission(AuthorizationPolicy policy, AuthorizationPermission permission) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (permission == null) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationPermission oldPermission = null;
        AuthorizationPermissions oldPermissions = thePolicy.getAuthorizationPermissions();
        Iterator permissionItr = oldPermissions.iterator();
        while (permissionItr.hasNext()) {
            AuthorizationPermission tmpPermission = (AuthorizationPermission)permissionItr.next();
            if (!permission.equals(tmpPermission)) continue;
            oldPermission = tmpPermission;
            break;
        }
        if (oldPermission == null) {
            return policy;
        }
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSION, oldPermission);
        thePolicy.removePermission(permission);
        return thePolicy;
    }

    public AuthorizationPolicy removePermissions(AuthorizationPolicy policy, Set permissions) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (permissions == null || permissions.size() == 0) {
            return policy;
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationPermissions oldPermissions = thePolicy.getAuthorizationPermissions();
        oldPermissions.removeAll(permissions);
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSION_SET, permissions);
        thePolicy.setPermissions(oldPermissions);
        return thePolicy;
    }

    public AuthorizationPolicy removePermissions(AuthorizationPolicy policy, String resource, AuthorizationRealm realm) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        if (resource == null || resource.trim().length() == 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0007"));
        }
        if (realm == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0008"));
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationRealm theRealm = (AuthorizationRealm)this.verifyTargetClass(realm, class$com$metamatrix$platform$security$api$AuthorizationRealm == null ? (class$com$metamatrix$platform$security$api$AuthorizationRealm = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationRealm")) : class$com$metamatrix$platform$security$api$AuthorizationRealm);
        HashSet<AuthorizationPermission> removePerms = new HashSet<AuthorizationPermission>();
        Iterator permItr = thePolicy.iterator();
        while (permItr.hasNext()) {
            AuthorizationPermission perm = (AuthorizationPermission)permItr.next();
            if (!perm.getResourceName().equals(resource) || !perm.getRealm().equals(theRealm)) continue;
            removePerms.add(perm);
        }
        if (removePerms.size() > 0) {
            thePolicy = this.removePermissions(thePolicy, removePerms);
        }
        return thePolicy;
    }

    public AuthorizationPolicy removeAllPermissions(AuthorizationPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0002"));
        }
        AuthorizationPolicy thePolicy = (AuthorizationPolicy)this.verifyTargetClass(policy, class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AbstractAuthorizationObjectEditor.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        AuthorizationPermissionsImpl oldPermissions = new AuthorizationPermissionsImpl(thePolicy.getAuthorizationPermissions());
        if (oldPermissions.size() == 0) {
            return thePolicy;
        }
        this.createRemoveAction(thePolicy.getAuthorizationPolicyID(), AuthorizationModel.Attribute.PERMISSIONS, oldPermissions);
        thePolicy.removePermissions();
        return thePolicy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

