/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.MetaMatrixRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class StringUtilities {
    public static final String NEW_LINE = "\n";
    public static final String LINE_SEPARATOR_PROPERTY_NAME = "line.separator";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static String buildPath(String prefix, String suffix) {
        StringBuffer path = new StringBuffer(prefix);
        if (!prefix.endsWith(File.separator)) {
            path.append(File.separator);
        }
        if (suffix.startsWith(File.separator)) {
            path.append(suffix.substring(File.separator.length()));
        } else {
            path.append(suffix);
        }
        return path.toString();
    }

    public static String lowerCaseFirstChar(String value) {
        if (value == null) {
            return null;
        }
        String firstChar = new Character(value.charAt(0)).toString();
        firstChar = firstChar.toLowerCase();
        return firstChar + value.substring(1);
    }

    public static String upperCaseFirstChar(String value) {
        if (value == null) {
            return null;
        }
        String firstChar = new Character(value.charAt(0)).toString();
        firstChar = firstChar.toUpperCase();
        return firstChar + value.substring(1);
    }

    public static String getLastUpperCharToken(String value, String lastToken) {
        if (value == null || lastToken == null) {
            return value;
        }
        int index = value.lastIndexOf(lastToken);
        if (index == -1) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = index - 1; i >= 0; --i) {
            result.insert(0, value.charAt(i));
            if (!Character.isUpperCase(value.charAt(i))) continue;
            return result.toString() + lastToken;
        }
        return result.toString() + lastToken;
    }

    public static String getLastUpperCharToken(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = value.length() - 1; i >= 0; --i) {
            result.insert(0, value.charAt(i));
            if (!Character.isUpperCase(value.charAt(i))) continue;
            return result.toString();
        }
        return result.toString();
    }

    public static String[] getLines(String value) {
        StringReader stringReader = new StringReader(value);
        BufferedReader reader = new BufferedReader(stringReader);
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                result.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new MetaMatrixRuntimeException(e);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String removeChars(String value, char[] chars) {
        StringBuffer result = new StringBuffer();
        if (value != null && chars != null && chars.length > 0) {
            String removeChars = String.valueOf(chars);
            for (int i = 0; i < value.length(); ++i) {
                String character = value.substring(i, i + 1);
                if (removeChars.indexOf(character) != -1) continue;
                result.append(character);
            }
        } else {
            result.append(value);
        }
        return result.toString();
    }

    public static String replaceWhitespace(String value, boolean stripExtras) {
        return StringUtilities.replaceWhitespace(value, " ", stripExtras);
    }

    public static String replaceWhitespace(String value, String replaceWith, boolean stripExtras) {
        String rv = value.replaceAll("\\s+", replaceWith);
        if (stripExtras) {
            rv = StringUtilities.removeExtraWhitespace(rv);
        }
        return rv;
    }

    public static String removeExtraWhitespace(String value) {
        return value.replaceAll("\\s\\s+", " ");
    }
}

