/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.properties;

import com.metamatrix.common.util.LogCommonConstants;
import com.metamatrix.core.util.ArgCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class PropertyManager
implements LogCommonConstants {
    private static final Map loadedNamespaces = new HashMap();
    private List namespaces;

    public static Set getLoadedNamespaces() {
        return loadedNamespaces.keySet();
    }

    public static boolean isNamespaceLoaded(String namespace) {
        return loadedNamespaces.containsKey(namespace);
    }

    protected static void load(String name) {
        PropertyManager.load(name, false, null);
    }

    protected static void load(String name, Map propertyMap) {
        PropertyManager.load(name, false, propertyMap);
    }

    protected static void load(String name, boolean reload, Map propertyMap) {
        HashMap<String, UnevaluatedValue> propMap = (HashMap<String, UnevaluatedValue>)loadedNamespaces.get(name);
        if (!reload && propMap != null) {
            return;
        }
        if (propertyMap != null) {
            propMap = propertyMap;
        }
        if (propMap == null) {
            propMap = new HashMap<String, UnevaluatedValue>();
        } else if (reload) {
            propMap.clear();
        }
        ResourceBundle bundle = ResourceBundle.getBundle(name);
        Enumeration<String> iter = bundle.getKeys();
        while (iter.hasMoreElements()) {
            String key = iter.nextElement();
            String val = bundle.getString(key);
            propMap.put(key, new UnevaluatedValue(val));
        }
        loadedNamespaces.put(name, propMap);
    }

    public static void reload(String name) {
        PropertyManager.load(name, true, null);
    }

    public static void reload(String name, Map propertyMap) {
        PropertyManager.load(name, true, propertyMap);
    }

    public PropertyManager() {
        this.constructPropertyManager(null, null);
    }

    public PropertyManager(String namespace) {
        this(namespace, null);
    }

    public PropertyManager(String[] namespaces) {
        this(Arrays.asList(namespaces));
    }

    public PropertyManager(List namespaces) {
        this.constructPropertyManager(namespaces, null);
    }

    public PropertyManager(String namespace, Map propertyMap) {
        ArgCheck.isNotNull(namespace);
        this.constructPropertyManager(Arrays.asList(namespace), propertyMap);
    }

    public boolean addNamespace(String namespace) {
        return this.addNamespace(namespace, null);
    }

    public boolean addNamespace(String namespace, Map propertyMap) {
        if (this.namespaces.contains(namespace)) {
            return false;
        }
        try {
            PropertyManager.load(namespace, false, propertyMap);
            return this.namespaces.add(namespace);
        }
        catch (MissingResourceException err) {
            return false;
        }
    }

    public boolean addNamespaces(String[] namespaces) {
        return this.addNamespaces(Arrays.asList(namespaces));
    }

    public boolean addNamespaces(List namespaces) {
        Iterator iter = namespaces.iterator();
        boolean allAdded = true;
        while (iter.hasNext()) {
            if (this.addNamespace(iter.next().toString())) continue;
            allAdded = false;
        }
        return allAdded;
    }

    public void clearNamespaces() {
        this.namespaces.clear();
    }

    protected void constructPropertyManager(List namespaces, Map propertyMap) {
        this.namespaces = new ArrayList(namespaces == null ? 0 : namespaces.size());
        this.initializeNamespaces(namespaces, propertyMap);
    }

    protected Object evaluateValue(String key, String value) {
        return value;
    }

    public Object get(String key) {
        Iterator iter = this.namespaces.iterator();
        while (iter.hasNext()) {
            Map propMap = (Map)loadedNamespaces.get(iter.next());
            Object val = propMap.get(key);
            if (val == null) continue;
            if (val instanceof UnevaluatedValue) {
                val = this.evaluateValue(key, ((UnevaluatedValue)val).get());
                propMap.put(key, val);
            }
            return val;
        }
        return null;
    }

    public List getNamespaces() {
        return Collections.unmodifiableList(this.namespaces);
    }

    protected void initializeNamespaces(List namespaces, Map propertyMap) {
        if (propertyMap != null) {
            this.addNamespace(namespaces.get(0).toString(), propertyMap);
        } else if (namespaces != null) {
            this.addNamespaces(namespaces);
        }
    }

    public boolean isNamespaceRegistered(String namespace) {
        return this.namespaces.contains(namespace);
    }

    public boolean removeNamespace(String namespace) {
        return this.namespaces.remove(namespace);
    }

    private static class UnevaluatedValue {
        private String val;

        private UnevaluatedValue(String value) {
            this.val = value;
        }

        private String get() {
            return this.val;
        }
    }
}

