/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.informix.InformixLocalMessages;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.sql.SQLException;

public class InformixColumn
extends BaseColumn {
    private static String footprint = "$Revision:   3.8.1.1  $";
    public Object data;
    public BaseData baseData;
    public int nativeType;
    public int qualifier;
    public int extId;
    public String typeOwner;
    public int byValue;
    public int alignment;
    public int sourceType;
    public int columnNameOffset;
    public int dataOffset;
    public int length;
    public boolean allowRandomAccess = true;
    BaseExceptions exceptions;

    public void readColumnInfo(InformixSQLICommunication informixSQLICommunication) throws UtilException {
        UtilByteOrderedDataReader utilByteOrderedDataReader = informixSQLICommunication.getReader();
        this.columnNameOffset = utilByteOrderedDataReader.readInt16();
        this.dataOffset = utilByteOrderedDataReader.readInt32();
        this.nativeType = utilByteOrderedDataReader.readInt16() & 0xFF;
        this.extId = utilByteOrderedDataReader.readInt32();
        this.typeOwner = informixSQLICommunication.readString();
        this.typeName = informixSQLICommunication.readString();
        this.byValue = utilByteOrderedDataReader.readInt16();
        this.alignment = utilByteOrderedDataReader.readInt16();
        this.sourceType = utilByteOrderedDataReader.readInt32();
        this.qualifier = utilByteOrderedDataReader.readInt32();
        this.baseData = new BaseData(null, informixSQLICommunication.getImplConnection().connection);
        this.exceptions = informixSQLICommunication.exceptions;
    }

    public void readFParamColumnInfo(InformixSQLICommunication informixSQLICommunication) throws UtilException {
        UtilByteOrderedDataReader utilByteOrderedDataReader = informixSQLICommunication.getReader();
        this.isNullable = utilByteOrderedDataReader.readInt8();
        this.nativeType = utilByteOrderedDataReader.readInt16() & 0xFF;
        this.extId = utilByteOrderedDataReader.readInt32();
        this.length = utilByteOrderedDataReader.readInt32();
        this.precision = utilByteOrderedDataReader.readInt16();
        this.scale = utilByteOrderedDataReader.readInt16();
        this.baseData = new BaseData(null, informixSQLICommunication.getImplConnection().connection);
        this.exceptions = informixSQLICommunication.exceptions;
    }

    public void analyzeTypeInfo() throws SQLException {
        String string = null;
        switch (this.nativeType) {
            case 0: {
                this.typeName = "char";
                this.setType(1);
                this.displaySize = this.qualifier;
                this.precision = this.qualifier;
                this.isSigned = false;
                this.isCaseSensitive = true;
                break;
            }
            case 13: {
                this.typeName = "varchar";
                this.setType(12);
                this.displaySize = this.qualifier;
                this.precision = this.qualifier;
                this.isSigned = false;
                this.isCaseSensitive = true;
                break;
            }
            case 1: {
                this.typeName = "smallint";
                this.setType(5);
                break;
            }
            case 2: {
                this.typeName = "integer";
                this.setType(4);
                break;
            }
            case 6: {
                this.typeName = "serial";
                this.setType(4);
                this.isAutoIncrement = true;
                this.isWritable = false;
                this.isReadOnly = true;
                break;
            }
            case 18: {
                this.typeName = "serial8";
                this.setType(-5);
                this.isAutoIncrement = true;
                this.isWritable = false;
                this.isReadOnly = true;
                break;
            }
            case 17: {
                this.setType(-5);
                this.typeName = "INT8";
                break;
            }
            case 4: {
                this.typeName = "smallfloat";
                this.setType(7);
                break;
            }
            case 3: {
                this.typeName = "float";
                this.setType(6);
                break;
            }
            case 5: {
                this.typeName = "decimal";
                this.setType(3);
                this.precision = this.qualifier >> 8 & 0xFF;
                this.scale = this.qualifier & 0xFF;
                this.displaySize = this.precision + 3;
                break;
            }
            case 8: {
                this.typeName = "money";
                this.setType(3);
                this.precision = this.qualifier >> 8 & 0xFF;
                this.scale = this.qualifier & 0xFF;
                this.isCurrency = true;
                this.displaySize = this.precision + 3;
                break;
            }
            case 7: {
                this.typeName = "date";
                this.setType(91);
                this.isSigned = false;
                break;
            }
            case 10: {
                string = "datetime";
            }
            case 14: {
                if (string == null) {
                    String[] stringArray = new String[]{"interval"};
                    throw this.exceptions.getException(InformixLocalMessages.UNSUPPORTED_TYPE_WITH_NAME, stringArray);
                }
                int n = (this.qualifier & 0xFF) - (this.qualifier >> 8);
                int n2 = (this.qualifier & 0xFF) - n;
                switch (n) {
                    case -4: {
                        this.setType(93);
                        this.typeName = string + " year";
                        n2 += 0;
                        this.precision = 25;
                        break;
                    }
                    case 32: {
                        this.setType(93);
                        this.typeName = string + " month";
                        n2 += 4;
                        this.precision = 20;
                        break;
                    }
                    case 66: {
                        this.setType(93);
                        this.typeName = string + " day";
                        n2 += 6;
                        this.precision = 17;
                        break;
                    }
                    case 100: {
                        this.setType(92);
                        this.typeName = string + " hour";
                        n2 += 8;
                        this.precision = 14;
                        break;
                    }
                    case 134: {
                        this.setType(92);
                        this.typeName = string + " minute";
                        n2 += 10;
                        this.precision = 11;
                        break;
                    }
                    case 168: {
                        this.setType(92);
                        this.typeName = string + " second";
                        n2 += 12;
                        this.precision = 8;
                        break;
                    }
                    case 202: {
                        this.setType(92);
                        this.typeName = string + " fraction";
                        n2 += 14;
                        this.precision = 5;
                    }
                }
                switch (n2) {
                    case 4: {
                        this.typeName = this.typeName + " to year";
                        this.precision -= 21;
                        this.scale = 0;
                        break;
                    }
                    case 6: {
                        this.typeName = this.typeName + " to month";
                        this.precision -= 18;
                        this.scale = 0;
                        break;
                    }
                    case 8: {
                        this.typeName = this.typeName + " to day";
                        this.precision -= 15;
                        this.scale = 0;
                        break;
                    }
                    case 10: {
                        this.typeName = this.typeName + " to hour";
                        this.precision -= 12;
                        this.scale = 0;
                        break;
                    }
                    case 12: {
                        this.typeName = this.typeName + " to minute";
                        this.precision -= 9;
                        this.scale = 0;
                        break;
                    }
                    case 14: {
                        this.typeName = this.typeName + " to second";
                        this.precision -= 6;
                        this.scale = 0;
                        break;
                    }
                    case 15: {
                        this.typeName = this.typeName + " to fraction(1)";
                        this.precision -= 4;
                        this.scale = 1;
                        break;
                    }
                    case 16: {
                        this.typeName = this.typeName + " to fraction(2)";
                        this.precision -= 3;
                        this.scale = 2;
                        break;
                    }
                    case 17: {
                        this.typeName = this.typeName + " to fraction(3)";
                        this.precision -= 2;
                        this.scale = 3;
                        break;
                    }
                    case 18: {
                        this.typeName = this.typeName + " to fraction(4)";
                        --this.precision;
                        this.scale = 4;
                        break;
                    }
                    case 19: {
                        this.typeName = this.typeName + " to fraction(5)";
                        this.precision -= 0;
                        this.scale = 5;
                    }
                }
                this.isSigned = false;
                break;
            }
            case 12: {
                this.typeName = "text";
                this.setType(-1);
                this.isSearchable = 1;
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                this.isSigned = false;
                break;
            }
            case 11: {
                this.typeName = "byte";
                this.setType(-4);
                this.isSearchable = 1;
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                this.isSigned = false;
                break;
            }
            case 45: {
                this.typeName = "boolean";
                this.setType(-7);
                this.precision = 1;
                this.scale = 0;
                this.isSigned = false;
                break;
            }
            case 16: {
                this.typeName = "nvarchar";
                this.setType(12);
                this.displaySize = this.qualifier;
                this.precision = this.qualifier;
                this.isCaseSensitive = true;
                this.isSigned = false;
                break;
            }
            case 15: {
                this.typeName = "nchar";
                this.setType(1);
                this.displaySize = this.qualifier;
                this.precision = this.qualifier;
                this.isCaseSensitive = true;
                this.isSigned = false;
                break;
            }
            case 40: {
                if (this.extId != 1) break;
                this.typeName = "lvarchar";
                this.nativeType = 43;
                this.setType(-1);
                this.displaySize = 2048;
                this.baseDataType = 10;
                this.isSigned = false;
                break;
            }
            case 41: {
                if (this.extId == 5) {
                    this.typeName = "boolean";
                    this.nativeType = 45;
                    this.setType(-7);
                    this.precision = 1;
                    this.scale = 0;
                    this.isSigned = false;
                    break;
                }
                if (this.extId == 10) {
                    this.typeName = "blob";
                    this.nativeType = 44;
                    this.setType(2004);
                    this.precision = Integer.MAX_VALUE;
                    this.displaySize = Integer.MAX_VALUE;
                    this.isSigned = false;
                    break;
                }
                if (this.extId != 11) break;
                this.typeName = "clob";
                this.nativeType = 44;
                this.setType(2005);
                this.precision = Integer.MAX_VALUE;
                this.displaySize = Integer.MAX_VALUE;
                this.isSigned = false;
                break;
            }
            default: {
                UtilDebug.assert("Informix type " + this.nativeType + " not supported.", false);
            }
        }
    }

    public void extractColumnName(UtilTransliterator utilTransliterator, byte[] byArray) {
        this.name = "";
        this.label = "";
        int n = 0;
        for (int i = this.columnNameOffset; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            n = i;
            break;
        }
        try {
            this.label = this.name = utilTransliterator.decode(byArray, this.columnNameOffset, n - this.columnNameOffset);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.name.length() > 0 && this.name.charAt(0) == '(') {
            this.name = "";
            this.label = "";
        }
    }

    public void buildTypeInfo(String string) throws SQLException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if ((string = string.toLowerCase()).startsWith("char")) {
            n = string.indexOf(40);
            n2 = string.indexOf(41);
            this.qualifier = Integer.parseInt(string.substring(n + 1, n2));
            this.typeName = "char";
        } else if (string.startsWith("varchar")) {
            n = string.indexOf(40);
            n3 = string.indexOf(44);
            n2 = string.indexOf(41);
            this.qualifier = n3 == -1 ? Integer.parseInt(string.substring(n + 1, n2)) : Integer.parseInt(string.substring(n + 1, n3));
            this.typeName = "varchar";
        } else if (string.startsWith("decimal")) {
            n = string.indexOf(40);
            n3 = string.indexOf(44);
            n2 = string.indexOf(41);
            this.precision = 0;
            this.scale = 0;
            if (n != -1 || n2 != -1) {
                if (n3 == -1) {
                    this.precision = Integer.parseInt(string.substring(n + 1, n2));
                } else {
                    this.precision = Integer.parseInt(string.substring(n + 1, n3));
                    this.scale = Integer.parseInt(string.substring(n3 + 1, n2));
                }
            }
            this.qualifier = (this.precision << 8) + this.scale;
            this.typeName = "decimal";
        } else {
            int n4;
            this.typeName = string.startsWith("references") ? string.substring(10).trim().substring(0, 4) : ((n4 = string.indexOf(32)) == -1 ? string : string.substring(0, n4));
        }
        if (this.typeName.equals("char")) {
            this.nativeType = 0;
        } else if (this.typeName.equals("varchar")) {
            this.nativeType = 13;
        } else if (this.typeName.equals("nchar")) {
            this.nativeType = 16;
        } else if (this.typeName.equals("nvarchar")) {
            this.nativeType = 16;
        } else if (this.typeName.equals("smallint")) {
            this.nativeType = 1;
        } else if (this.typeName.equals("integer") || this.typeName.equals("int")) {
            this.nativeType = 2;
        } else if (this.typeName.equals("serial")) {
            this.nativeType = 6;
        } else if (this.typeName.equals("int8")) {
            this.nativeType = 17;
        } else if (this.typeName.equals("serial8")) {
            this.nativeType = 18;
        } else if (this.typeName.equals("smallint")) {
            this.nativeType = 4;
        } else if (this.typeName.equals("float")) {
            this.nativeType = 3;
        } else if (this.typeName.equals("decimal")) {
            this.nativeType = 5;
        } else if (this.typeName.equals("money")) {
            this.nativeType = 8;
        } else if (this.typeName.equals("text")) {
            this.nativeType = 12;
        } else if (this.typeName.equals("byte")) {
            this.nativeType = 11;
        } else if (this.typeName.equals("boolean")) {
            this.nativeType = 45;
        } else if (this.typeName.equals("clob")) {
            this.nativeType = 41;
            this.extId = 11;
        } else if (this.typeName.equals("blob")) {
            this.nativeType = 41;
            this.extId = 10;
        }
        this.analyzeTypeInfo();
    }
}

