/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.base.Executor;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.connector.xml.base.XMLExecution;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.license.exception.LicenseException;
import java.util.Properties;

public abstract class XMLConnectorState
implements Cloneable {
    private int m_cacheTimeout;
    private int m_maxMemoryCacheSize;
    private int m_maxInMemoryStringSize;
    private int m_maxFileCacheSize;
    private boolean m_preprocess;
    private boolean m_cacheEnabled;
    private String m_cacheLocation;
    private String m_saxProviderClass;
    private String m_queryPreprocessorClass;
    private boolean m_errorOnRecreateDoc;
    private boolean m_logRequestResponse;
    private static final int SECONDS_TO_MILLIS = 1000;
    private static final int KB_TO_BYTES = 1000;
    public static final String CACHE_TIMEOUT = "CacheTimeout";
    public static final String CACHE_ENABLED = "CacheEnabled";
    public static final String MAX_IN_MEMORY_STRING_SIZE = "MaxInMemoryStringSize";
    public static final String MAX_MEMORY_CACHE_SIZE = "MaxMemoryCacheSize";
    public static final String MAX_FILE_CACHE_SIZE = "MaxFileCacheSize";
    public static final String FILE_CACHE_LOCATION = "FileCacheLocation";
    public static final String STATE_CLASS_PROP = "ConnectorStateClass";
    public static final String THROW_ERROR_ON_RECREATE = "ExceptionOnIntraQueryCacheExpiration";
    public static final String LOG_REQUEST_RESPONSE_DOCS = "LogRequestResponseDocs";
    public static final String SAX_FILTER_PROVIDER_CLASS = "SaxFilterProviderClass";
    public static final String QUERY_PREPROCESS_CLASS = "QueryPreprocessorClass";
    public static final String INPUT_STREAM_FILTER_CLASS = "InputStreamFilterClass";
    public static final String SAX_FILTER_PROVIDER_CLASS_DEFAULT = "com.metamatrix.connector.xml.base.NoExtendedFilters";
    public static final String QUERY_PREPROCESS_CLASS_DEFAULT = "com.metamatrix.connector.xml.base.NoQueryPreprocessing";
    private static final String INPUT_STREAM_FILTER_CLASS_DEFAULT = "com.metamatrix.connector.xml.base.PluggableInputStreamFilterImpl";
    private String DQP_KEY = "MetaMatrix DQP";
    private String XML_CONNECTOR_KEY = "Connector/XML";
    private String VERSION_4_2 = "4.2";
    private String VERSION_4_3 = "4.3";
    private String VERSION_5_0 = "5.0";
    private String m_pluggableInputStreamFilterClass;

    public XMLConnectorState() {
        int defaultCacheTimeoutMillis = 60000;
        int defaultMemoryCacheSize = 512;
        int defaultFileCacheSize = -1;
        this.setCacheTimeoutMillis(60000);
        this.setMaxMemoryCacheSizeKB(512);
        this.setMaxInMemoryStringSize(131072);
        this.setMaxFileCacheSizeKB(-1);
        this.setCacheEnabled(true);
        this.setPreprocess(true);
        this.setErrorOnRecreateDoc(true);
        this.setLogRequestResponse(false);
        this.setSaxProviderClass(SAX_FILTER_PROVIDER_CLASS_DEFAULT);
        this.setQueryPreprocessorClass(QUERY_PREPROCESS_CLASS_DEFAULT);
        this.setPluggableInputStreamFilterClass(INPUT_STREAM_FILTER_CLASS_DEFAULT);
    }

    public void setState(Properties props) throws ConnectorException {
        String streamFilter;
        String preprocessor;
        String provider;
        String logReqRes;
        String throwError;
        String cacheLoc;
        String maxFCache;
        String maxStringSize;
        String maxMCache;
        String cache = props.getProperty(CACHE_TIMEOUT);
        if (cache != null) {
            this.setCacheTimeoutSeconds(Integer.parseInt(cache));
        }
        if ((maxMCache = props.getProperty(MAX_MEMORY_CACHE_SIZE)) != null) {
            this.setMaxMemoryCacheSizeKB(Integer.parseInt(maxMCache));
        }
        if ((maxStringSize = props.getProperty(MAX_IN_MEMORY_STRING_SIZE)) != null) {
            this.setMaxInMemoryStringSize(Integer.parseInt(maxStringSize) * 1024);
        }
        if ((maxFCache = props.getProperty(MAX_FILE_CACHE_SIZE)) != null) {
            this.setMaxFileCacheSizeKB(Integer.parseInt(maxFCache));
        }
        if ((cacheLoc = props.getProperty(FILE_CACHE_LOCATION)) != null) {
            this.setCacheLocation(cacheLoc);
        } else {
            String temp = System.getProperty("java.io.tmpdir");
            this.setCacheLocation(temp);
        }
        String reload = props.getProperty(CACHE_ENABLED);
        if (reload != null) {
            this.setCacheEnabled(Boolean.valueOf(reload));
        }
        if ((throwError = props.getProperty(THROW_ERROR_ON_RECREATE)) != null) {
            this.setErrorOnRecreateDoc(Boolean.valueOf(throwError));
        }
        if ((logReqRes = props.getProperty(LOG_REQUEST_RESPONSE_DOCS)) != null) {
            this.setLogRequestResponse(Boolean.valueOf(logReqRes));
        }
        if ((provider = props.getProperty(SAX_FILTER_PROVIDER_CLASS)) != null && !provider.equals("")) {
            this.setSaxProviderClass(provider);
        }
        if ((preprocessor = props.getProperty(QUERY_PREPROCESS_CLASS)) != null && !preprocessor.equals("")) {
            this.setQueryPreprocessorClass(preprocessor);
        }
        if ((streamFilter = props.getProperty(INPUT_STREAM_FILTER_CLASS)) != null && !streamFilter.equals("")) {
            this.setPluggableInputStreamFilterClass(streamFilter);
        }
    }

    public Properties getState() {
        Properties props = new Properties();
        props.setProperty(CACHE_TIMEOUT, Integer.toString(this.getCacheTimeoutSeconds()));
        props.setProperty(CACHE_ENABLED, Boolean.toString(this.isCacheEnabled()));
        props.setProperty(MAX_MEMORY_CACHE_SIZE, Integer.toString(this.getMaxMemoryCacheSizeKB()));
        props.setProperty(MAX_IN_MEMORY_STRING_SIZE, Integer.toString(this.getMaxInMemoryStringSize()));
        props.setProperty(MAX_FILE_CACHE_SIZE, Integer.toString(this.getMaxFileCacheSizeKB()));
        props.setProperty(LOG_REQUEST_RESPONSE_DOCS, Boolean.toString(this.isLogRequestResponse()));
        String location = this.getCacheLocation();
        if (location == null) {
            location = "";
        }
        props.setProperty(FILE_CACHE_LOCATION, location);
        props.setProperty(THROW_ERROR_ON_RECREATE, Boolean.toString(this.isErrorOnRecreateDoc()));
        props.setProperty(SAX_FILTER_PROVIDER_CLASS, this.getSaxProviderClass());
        props.setProperty(QUERY_PREPROCESS_CLASS, this.getQueryPreprocessorClass());
        return props;
    }

    public abstract Executor makeExecutor(XMLExecution var1);

    public final void setCacheTimeoutSeconds(int cacheTimeoutseconds) {
        this.m_cacheTimeout = cacheTimeoutseconds * 1000;
    }

    protected final void setCacheTimeoutMillis(int cacheTimeoutmillis) {
        this.m_cacheTimeout = cacheTimeoutmillis;
    }

    public final int getCacheTimeoutSeconds() {
        return this.m_cacheTimeout / 1000;
    }

    protected final int getCacheTimeoutMillis() {
        return this.m_cacheTimeout;
    }

    public void setPreprocess(boolean preprocess) {
        this.m_preprocess = preprocess;
    }

    public boolean isPreprocess() {
        return this.m_preprocess;
    }

    public void checkLicense() throws ConnectorException {
        try {
            LicenseChecker.checkProductLicense((String)this.XML_CONNECTOR_KEY, (String)this.VERSION_5_0, (boolean)false);
        }
        catch (LicenseException e) {
            try {
                LicenseChecker.checkProductLicense((String)this.DQP_KEY, (String)this.VERSION_4_2, (boolean)false);
            }
            catch (LicenseException ex) {
                try {
                    LicenseChecker.checkProductLicense((String)this.DQP_KEY, (String)this.VERSION_4_3, (boolean)false);
                }
                catch (LicenseException lie) {
                    Object[] params = new Object[]{"Connector/Custom"};
                    String msg = Messages.getString((String)"XMLConnector.NoLicense");
                    msg = msg.concat(" " + params);
                    ConnectorException ce = new ConnectorException((Throwable)ex, msg);
                    throw ce;
                }
            }
        }
    }

    public void setMaxMemoryCacheSizeKB(int maxMemoryCacheSizeKB) {
        this.m_maxMemoryCacheSize = maxMemoryCacheSizeKB * 1000;
    }

    protected void setMaxMemoryCacheSizeBytes(int maxMemoryCacheSizeByte) {
        this.m_maxMemoryCacheSize = maxMemoryCacheSizeByte;
    }

    protected int getMaxMemoryCacheSizeByte() {
        return this.m_maxMemoryCacheSize;
    }

    public int getMaxMemoryCacheSizeKB() {
        return this.m_maxMemoryCacheSize / 1000;
    }

    public void setMaxInMemoryStringSize(int maxInMemoryStringSize) {
        this.m_maxInMemoryStringSize = maxInMemoryStringSize;
    }

    public int getMaxInMemoryStringSize() {
        return this.m_maxInMemoryStringSize;
    }

    protected void setMaxFileCacheSizeByte(int maxFileCacheSize) {
        this.m_maxFileCacheSize = maxFileCacheSize;
    }

    public void setMaxFileCacheSizeKB(int maxFileCacheSize) {
        this.m_maxFileCacheSize = maxFileCacheSize * 1000;
    }

    public int getMaxFileCacheSizeKB() {
        return this.m_maxFileCacheSize / 1000;
    }

    protected int getMaxFileCacheSizeByte() {
        return this.m_maxFileCacheSize;
    }

    public void setCacheLocation(String cacheLocation) {
        this.m_cacheLocation = cacheLocation;
    }

    public String getCacheLocation() {
        return this.m_cacheLocation;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.m_cacheEnabled = cacheEnabled;
    }

    public boolean isCacheEnabled() {
        return this.m_cacheEnabled;
    }

    public void setErrorOnRecreateDoc(boolean errorOnRecreateDoc) {
        this.m_errorOnRecreateDoc = errorOnRecreateDoc;
    }

    public boolean isErrorOnRecreateDoc() {
        return this.m_errorOnRecreateDoc;
    }

    public void setLogRequestResponse(boolean logRequestResponse) {
        this.m_logRequestResponse = logRequestResponse;
    }

    public boolean isLogRequestResponse() {
        return this.m_logRequestResponse;
    }

    public void setSaxProviderClass(String m_saxProviderClass) {
        this.m_saxProviderClass = m_saxProviderClass;
    }

    public String getSaxProviderClass() {
        return this.m_saxProviderClass;
    }

    public void setQueryPreprocessorClass(String preprocessor) {
        this.m_queryPreprocessorClass = preprocessor;
    }

    public String getQueryPreprocessorClass() {
        return this.m_queryPreprocessorClass;
    }

    public void setPluggableInputStreamFilterClass(String filterClass) {
        this.m_pluggableInputStreamFilterClass = filterClass;
    }

    public String getPluggableInputStreamFilterClass() {
        return this.m_pluggableInputStreamFilterClass;
    }
}

